/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocaleListener;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.search.SearchLocale;

public class ElanLocale {
    private static Locale locale;
    private static ResourceBundle resourcebundle;
    private static HashMap listenerGroups;
    public static final Locale CUSTOM;
    public static final Locale DUTCH;
    public static final Locale ENGLISH;
    public static final Locale CATALAN;
    public static final Locale SPANISH;
    public static final Locale SWEDISH;
    public static final Locale GERMAN;
    public static final Locale PORTUGUESE;
    public static final Locale FRENCH;
    public static final Locale JAPANESE;
    public static final Locale CHINESE_SIMP;
    public static final Locale RUSSIAN;

    ElanLocale() {
        locale = Locale.getDefault();
        resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void setLocale(Locale locale_in) {
        File custFile;
        block12: {
            if (locale != null && locale.equals(locale_in)) {
                return;
            }
            locale = locale_in;
            if (locale.equals(CUSTOM)) {
                try {
                    custFile = new File(Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "ElanLanguage.properties");
                    if (custFile.exists()) {
                        resourcebundle = new PropertyResourceBundle(new FileInputStream(custFile));
                        break block12;
                    }
                    ClientLogger.LOG.warning("No custom localisation file found.");
                    resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage");
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not load custom localisation file: " + ex.getMessage());
                    resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage");
                }
            } else {
                resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
            }
        }
        ElanLocale.notifyListeners();
        try {
            if (!locale.equals(CUSTOM)) {
                SearchLocale.setLocale(locale);
            } else {
                custFile = new File(Constants.ELAN_DATA_DIR + Constants.FILESEPARATOR + "SearchLanguage.properties");
                if (custFile.exists()) {
                    PropertyResourceBundle resBundle = new PropertyResourceBundle(new FileInputStream(custFile));
                    SearchLocale.setResourceBundle(resBundle);
                } else {
                    ClientLogger.LOG.warning("No custom search localisation file found.");
                    SearchLocale.setLocale(locale);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getString(String str) {
        if (locale == null) {
            locale = Locale.getDefault();
            resourcebundle = ResourceBundle.getBundle("mpi.eudico.client.annotator.resources.ElanLanguage", locale);
        }
        try {
            return resourcebundle.getString(str);
        }
        catch (Exception ex) {
            return "";
        }
    }

    public static void addElanLocaleListener(Object key, ElanLocaleListener listener) {
        if (listenerGroups.containsKey(key)) {
            ((ArrayList)listenerGroups.get(key)).add(listener);
            listener.updateLocale();
        } else {
            ArrayList<ElanLocaleListener> list = new ArrayList<ElanLocaleListener>();
            list.add(listener);
            listenerGroups.put(key, list);
            listener.updateLocale();
        }
    }

    public static void removeElanLocaleListener(ElanLocaleListener listener) {
        ArrayList listeners;
        Iterator groupIt = listenerGroups.keySet().iterator();
        while (groupIt.hasNext() && !(listeners = (ArrayList)listenerGroups.get(groupIt.next())).remove(listener)) {
        }
    }

    public static void removeElanLocaleListener(Object key) {
        listenerGroups.remove(key);
    }

    private static void notifyListeners() {
        Iterator groupIt = listenerGroups.keySet().iterator();
        while (groupIt.hasNext()) {
            ArrayList listeners = (ArrayList)listenerGroups.get(groupIt.next());
            for (int i = 0; i < listeners.size(); ++i) {
                ((ElanLocaleListener)listeners.get(i)).updateLocale();
            }
        }
    }

    public static ResourceBundle getResourceBundle() {
        return resourcebundle;
    }

    static {
        listenerGroups = new HashMap();
        CUSTOM = new Locale("cu", "", "");
        DUTCH = new Locale("nl", "NL");
        ENGLISH = new Locale("", "");
        CATALAN = new Locale("ca");
        SPANISH = new Locale("es", "ES");
        SWEDISH = new Locale("sv", "SE");
        GERMAN = new Locale("de", "DE");
        PORTUGUESE = new Locale("pt");
        FRENCH = new Locale("fr");
        JAPANESE = new Locale("ja", "JP");
        CHINESE_SIMP = new Locale("zh", "CN");
        RUSSIAN = new Locale("ru", "RU");
    }
}

