/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.prefs.PrefKeyMapper;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class Preferences {
    private static final String GLOBAL_PREFS_KEY = "elan global prefs key";
    private static final String GLOBAL_PREFS_FILE_NAME = "elan.pfs";
    private static final String GLOBAL_PREFS_XML_FILE_NAME = "elan.pfsx";
    private static final String XML_EXT = "pfsx";
    private static HashMap preferences;
    private static HashMap listenerGroups;
    private static PreferencesReader xmlPrefsReader;
    private static PreferencesWriter xmlPrefsWriter;
    private static HashMap<Transcription, String> prefLocations;

    public static Object get(String key, Transcription document) {
        if (key == null) {
            return null;
        }
        Preferences.initPreferencesFor(document);
        Object result = ((Map)preferences.get(Preferences.documentKeyFor(document))).get(key);
        if (result != null) {
            return result;
        }
        return ((Map)preferences.get(GLOBAL_PREFS_KEY)).get(key);
    }

    public static void set(String key, Object value, Transcription document, boolean notify, boolean savePrefs) {
        if (key == null) {
            return;
        }
        Preferences.initPreferencesFor(document);
        ((Map)preferences.get(Preferences.documentKeyFor(document))).put(key, value);
        if (savePrefs) {
            Preferences.writePreferencesFor(document);
        }
        if (notify) {
            if (document != null) {
                Preferences.notifyListeners(document);
            } else {
                Preferences.notifyAllListeners();
            }
        }
    }

    public static void set(String key, Object value, Transcription document, boolean notify) {
        Preferences.set(key, value, document, notify, true);
    }

    public static void set(String key, Object value, Transcription document) {
        Preferences.set(key, value, document, false);
    }

    public static void set(String key, int value, Transcription document) {
        Preferences.set(key, new Integer(value), document);
    }

    public static void set(String key, long value, Transcription document) {
        Preferences.set(key, new Long(value), document);
    }

    public static void set(String key, float value, Transcription document) {
        Preferences.set(key, new Float(value), document);
    }

    public static void set(String key, double value, Transcription document) {
        Preferences.set(key, new Double(value), document);
    }

    public static void removeDocument(Transcription document) {
        if (preferences != null) {
            preferences.remove(document);
        }
        prefLocations.remove(document);
        listenerGroups.remove(document);
    }

    public static void addPreferencesListener(Transcription document, PreferencesListener listener) {
        if (listenerGroups.containsKey(document)) {
            ArrayList listeners = (ArrayList)listenerGroups.get(document);
            if (!listeners.contains(listener)) {
                listeners.add(listener);
            }
        } else {
            ArrayList<PreferencesListener> list = new ArrayList<PreferencesListener>();
            list.add(listener);
            listenerGroups.put(document, list);
        }
    }

    public static void removePreferencesListener(Transcription document, PreferencesListener listener) {
        if (listenerGroups.containsKey(document)) {
            ((ArrayList)listenerGroups.get(document)).remove(listener);
        }
    }

    public static void exportPreferences(Transcription document, String filePath) {
        if (document == null || filePath == null) {
            return;
        }
        xmlPrefsWriter.encodeAndSave((Map)preferences.get(Preferences.documentKeyFor(document)), filePath);
    }

    public static void importPreferences(Transcription document, String filePath) {
        if (document == null) {
            return;
        }
        Map loadedPrefs = xmlPrefsReader.parse(filePath);
        if (loadedPrefs.size() == 0) {
            return;
        }
        if (preferences == null) {
            preferences = new HashMap();
        }
        if (preferences.get(Preferences.documentKeyFor(document)) == null) {
            preferences.put(Preferences.documentKeyFor(document), loadedPrefs);
        } else {
            ((Map)preferences.get(Preferences.documentKeyFor(document))).putAll(loadedPrefs);
        }
        Preferences.writePreferencesFor(document);
        Preferences.notifyListeners(document);
    }

    public static Map loadPreferencesForFile(String filePath) {
        Object val;
        if (filePath == null) {
            return null;
        }
        String prefFileName = filePath.replace('\\', '/');
        if (prefFileName.length() > 3) {
            prefFileName = prefFileName.substring(0, prefFileName.length() - 3) + XML_EXT;
        }
        if ((val = Preferences.get("DefaultPreferencesLocation", null)) instanceof String) {
            String genPrefsLocation = ((String)val).replace('\\', '/');
            String fileName = prefFileName;
            int lastSep = fileName.lastIndexOf(47);
            if (lastSep > -1) {
                fileName = fileName.substring(lastSep);
            }
            prefFileName = genPrefsLocation + fileName;
        }
        if (prefFileName.startsWith("file:")) {
            prefFileName = prefFileName.substring(5);
        }
        try {
            if (new File(prefFileName).exists()) {
                return xmlPrefsReader.parse(prefFileName);
            }
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load preferences file: " + ex.getMessage());
        }
        return null;
    }

    public static void notifyListeners(Transcription document) {
        ArrayList listeners = (ArrayList)listenerGroups.get(document);
        if (listeners != null) {
            for (int i = 0; i < listeners.size(); ++i) {
                ((PreferencesListener)listeners.get(i)).preferencesChanged();
            }
        }
    }

    private static void notifyAllListeners() {
        ArrayList listeners2 = null;
        for (ArrayList listeners2 : listenerGroups.values()) {
            if (listeners2 == null) continue;
            for (int i = 0; i < listeners2.size(); ++i) {
                ((PreferencesListener)listeners2.get(i)).preferencesChanged();
            }
        }
    }

    private static void initPreferencesFor(Transcription document) {
        if (preferences == null) {
            preferences = new HashMap();
        }
        if (!preferences.containsKey(Preferences.documentKeyFor(document))) {
            Map documentPreferences = Preferences.readPreferencesFor(document);
            preferences.put(Preferences.documentKeyFor(document), documentPreferences);
        }
    }

    private static Map readPreferencesFor(Transcription document) {
        Map preferencesHashtable = null;
        String xmlPath = "";
        try {
            xmlPath = Preferences.preferenceXmlFilePathFor(document);
            if (new File(xmlPath).exists()) {
                preferencesHashtable = xmlPrefsReader.parse(xmlPath);
            } else if (new File(Preferences.preferenceFilePathFor(document)).exists()) {
                FileInputStream fileIn = new FileInputStream(Preferences.preferenceFilePathFor(document));
                ObjectInputStream objectIn = new ObjectInputStream(fileIn);
                preferencesHashtable = (Hashtable)objectIn.readObject();
                preferencesHashtable = Preferences.convertPreferencesTable(preferencesHashtable);
                objectIn.close();
                fileIn.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (preferencesHashtable != null) {
            return preferencesHashtable;
        }
        return new HashMap();
    }

    private static void writePreferencesFor(Transcription document) {
        try {
            if (document != null && document.getName().equals("aishug294879ryshfda9763afo8947a5gf")) {
                return;
            }
            xmlPrefsWriter.encodeAndSave((Map)preferences.get(Preferences.documentKeyFor(document)), Preferences.preferenceXmlFilePathFor(document));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object documentKeyFor(Transcription document) {
        if (document == null) {
            return GLOBAL_PREFS_KEY;
        }
        return document;
    }

    private static String preferenceFilePathFor(Transcription document) throws Exception {
        if (document == null) {
            return Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + GLOBAL_PREFS_FILE_NAME;
        }
        String prefFileName = "";
        if (document instanceof TranscriptionImpl) {
            prefFileName = ((TranscriptionImpl)document).getPathName();
        }
        if (prefFileName.length() > 3) {
            prefFileName = prefFileName.substring(0, prefFileName.length() - 3) + "pfs";
        }
        return prefFileName;
    }

    private static String preferenceXmlFilePathFor(Transcription document) throws Exception {
        Object val;
        if (document == null) {
            return Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + GLOBAL_PREFS_XML_FILE_NAME;
        }
        if (prefLocations.containsKey(document)) {
            return prefLocations.get(document);
        }
        String prefFileName = "";
        if (document instanceof TranscriptionImpl) {
            prefFileName = ((TranscriptionImpl)document).getPathName();
        }
        if (prefFileName.length() > 3) {
            prefFileName = prefFileName.substring(0, prefFileName.length() - 3) + XML_EXT;
        }
        if ((val = Preferences.get("DefaultPreferencesLocation", null)) instanceof String) {
            String genPrefsLocation = ((String)val).replace('\\', '/');
            String fileName = prefFileName.replace('\\', '/');
            int lastSep = fileName.lastIndexOf(47);
            if (lastSep > -1) {
                fileName = fileName.substring(lastSep);
            }
            if ((genPrefsLocation = genPrefsLocation + fileName).startsWith("file:")) {
                genPrefsLocation = genPrefsLocation.substring(5);
            }
            try {
                if (new File(genPrefsLocation).exists()) {
                    prefFileName = genPrefsLocation;
                    prefLocations.put(document, prefFileName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return prefFileName;
    }

    private static Map convertPreferencesTable(Map oldPrefs) {
        Map viewersState;
        Object to;
        if (oldPrefs == null) {
            return null;
        }
        HashMap<String, ArrayList<Object>> nextMap = new HashMap<String, ArrayList<Object>>();
        oldPrefs.remove("LastUsedShoeboxMarkers");
        Object tierOrder = oldPrefs.remove("TierOrder");
        if (tierOrder instanceof Vector) {
            ArrayList al = new ArrayList((Vector)tierOrder);
            nextMap.put("MultiTierViewer.TierOrder", al);
        }
        if ((to = oldPrefs.remove("Interlinear.VisibleTiers")) instanceof String[]) {
            String[] visb = (String[])to;
            ArrayList<String> vtList = new ArrayList<String>(visb.length);
            for (int i = 0; i < visb.length; ++i) {
                vtList.add(visb[i]);
            }
            nextMap.put("Interlinear.VisibleTiers", vtList);
        }
        if ((viewersState = (Map)oldPrefs.remove("LayoutManagerState")) != null) {
            for (String key : viewersState.keySet()) {
                String newKey;
                if (key.equals("TimeSeriesPanelMap")) {
                    Map tsMap = (Map)viewersState.get(key);
                    if (tsMap == null) continue;
                    for (Object tsKey : tsMap.keySet()) {
                        if (!(tsKey instanceof Integer)) continue;
                        Object tsVal = tsMap.get(tsKey);
                        newKey = "TimeSeriesViewer.Panel-" + (Integer)tsKey;
                        if (!(tsVal instanceof String[])) continue;
                        String[] names = (String[])tsVal;
                        ArrayList<String> namesList = new ArrayList<String>(names.length);
                        for (int i = 0; i < names.length; ++i) {
                            namesList.add(names[i]);
                        }
                        nextMap.put(newKey, namesList);
                    }
                    continue;
                }
                newKey = (String)PrefKeyMapper.keyMapper.get(key);
                if (newKey != null) {
                    if (key.startsWith("SubTitleTierName") && key.length() > 16) {
                        newKey = newKey + key.substring(16);
                    } else if (key.startsWith("SubTitleFontSize") && key.length() > 16) {
                        newKey = newKey + key.substring(16);
                    }
                    nextMap.put(newKey, (ArrayList<Object>)viewersState.get(key));
                    continue;
                }
                nextMap.put(key, (ArrayList<Object>)viewersState.get(key));
            }
        }
        nextMap.putAll(oldPrefs);
        return nextMap;
    }

    private static void printPrefs(Object prefs) {
        if (prefs == null || !(prefs instanceof Map)) {
            return;
        }
        Map prf = (Map)prefs;
        for (Object ke : prf.keySet()) {
            Object val = prf.get(ke);
            if (ke == null) {
                System.out.println("Entry: key is null...");
                continue;
            }
            System.out.println("K: " + ke + " (" + ke.getClass() + ")");
            if (val == null) {
                System.out.println("Entry: value is null...");
                continue;
            }
            System.out.println("V: " + val + " (" + val.getClass() + ")");
            if (val instanceof Object[]) {
                val = Arrays.asList((Object[])val);
            }
            if (val instanceof List) {
                List li = (List)val;
                for (int i = 0; i < li.size(); ++i) {
                    Object vv = li.get(i);
                    if (vv == null) continue;
                    System.out.println("\tentry: " + vv.toString());
                }
                continue;
            }
            if (!(val instanceof Map)) continue;
            Map mm = (Map)val;
            for (Object kk : mm.keySet()) {
                Object vv = mm.get(kk);
                if (kk != null) {
                    System.out.println("\tK: " + kk + " (" + kk.getClass() + ")");
                    if (vv != null) {
                        System.out.println("\tV: " + vv + " (" + vv.getClass() + ")");
                        continue;
                    }
                    System.out.println("\tvalue is null");
                    continue;
                }
                System.out.println("\tkey is null");
            }
        }
    }

    static {
        listenerGroups = new HashMap();
        xmlPrefsReader = new PreferencesReader();
        xmlPrefsWriter = new PreferencesWriter();
        prefLocations = new HashMap();
    }
}

