/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.TierOrderListener;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class TierOrder
implements ACMEditListener {
    private Vector listeners = new Vector();
    private List tierOrder = null;
    private Transcription transcripton;

    public TierOrder(Transcription trans) {
        this.transcripton = trans;
    }

    public void setTierOrder(List tierOrderList) {
        this.tierOrder = tierOrderList;
        this.notifyListeners();
    }

    public List getTierOrder() {
        return this.tierOrder;
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((TierOrderListener)this.listeners.elementAt(i)).updateTierOrder(this.tierOrder);
        }
    }

    public void addTierOrderListener(TierOrderListener listener) {
        this.listeners.add(listener);
        listener.updateTierOrder(this.tierOrder);
    }

    public void removeTierorderListener(TierOrderListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        switch (e.getOperation()) {
            case 1: {
                String tierName;
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl) || !this.tierOrder.contains(tierName = ((TierImpl)obj).getName())) break;
                this.tierOrder.remove(tierName);
                break;
            }
            case 0: {
                String tierName;
                Object obj = e.getModification();
                if (!(obj instanceof TierImpl) || this.tierOrder.contains(tierName = ((TierImpl)obj).getName())) break;
                this.tierOrder.add(tierName);
                break;
            }
            case 2: {
                int i;
                Object obj = e.getSource();
                if (!(obj instanceof TierImpl)) break;
                String tierName = ((TierImpl)obj).getName();
                Vector tiers = this.transcripton.getTiers();
                Vector<String> tierNames = new Vector<String>();
                for (i = 0; i < tiers.size(); ++i) {
                    String name = ((TierImpl)tiers.get(i)).getName();
                    tierNames.add(name);
                }
                for (i = 0; i < this.tierOrder.size(); ++i) {
                    if (tierNames.contains(this.tierOrder.get(i))) continue;
                    this.tierOrder.remove(i);
                    this.tierOrder.add(i, tierName);
                }
                break;
            }
        }
    }
}

