/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.client.annotator.ActiveAnnotation;
import mpi.eudico.client.annotator.ActiveAnnotationListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ElanMediaPlayerController;
import mpi.eudico.client.annotator.MediaPlayerControlSlider;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.PreferencesListener;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.TierOrder;
import mpi.eudico.client.annotator.TimePanel;
import mpi.eudico.client.annotator.TimeScale;
import mpi.eudico.client.annotator.TimeScaleListener;
import mpi.eudico.client.annotator.TimeScaleUser;
import mpi.eudico.client.annotator.grid.GridViewer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.client.annotator.recognizer.gui.AudioRecognizerPanel;
import mpi.eudico.client.annotator.recognizer.gui.VideoRecognizerPanel;
import mpi.eudico.client.annotator.search.result.viewer.ElanResultViewer;
import mpi.eudico.client.annotator.svg.GlassPaneSVGViewer;
import mpi.eudico.client.annotator.svg.JMFSVGViewer;
import mpi.eudico.client.annotator.svg.QTSVGViewer;
import mpi.eudico.client.annotator.transcriptionMode.TranscriptionViewer;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.AbstractViewer;
import mpi.eudico.client.annotator.viewer.AnnotationDensityViewer;
import mpi.eudico.client.annotator.viewer.GestureDispatcher;
import mpi.eudico.client.annotator.viewer.GestureMacDispatcher;
import mpi.eudico.client.annotator.viewer.GesturesListener;
import mpi.eudico.client.annotator.viewer.InterlinearViewer;
import mpi.eudico.client.annotator.viewer.LexiconEntryViewer;
import mpi.eudico.client.annotator.viewer.MetadataViewer;
import mpi.eudico.client.annotator.viewer.MultiTierControlPanel;
import mpi.eudico.client.annotator.viewer.MultiTierViewer;
import mpi.eudico.client.annotator.viewer.SegmentationViewer2;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.client.annotator.viewer.SingleTierViewerPanel;
import mpi.eudico.client.annotator.viewer.SubtitleViewer;
import mpi.eudico.client.annotator.viewer.TextViewer;
import mpi.eudico.client.annotator.viewer.TimeLineViewer;
import mpi.eudico.client.annotator.viewer.TimeSeriesViewer;
import mpi.eudico.client.annotator.viewer.Viewer;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.PeriodicUpdateController;
import mpi.eudico.client.mediacontrol.TimeEvent;
import mpi.eudico.client.mediacontrol.TimeLineController;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.event.ACMEditListener;

public class ViewerManager2 {
    private static final long SIGNAL_VIEWER_PERIOD = 50L;
    private static final long TIME_LINE_VIEWER_PERIOD = 50L;
    private static final long INTERLINEAR_VIEWER_PERIOD = 100L;
    private static final long MEDIA_CONTROL_PANEL_PERIOD = 100L;
    private ElanMediaPlayer masterMediaPlayer;
    private ElanMediaPlayer signalSourcePlayer;
    private SignalViewer signalViewer;
    private AudioRecognizerPanel audioRecognizerPanel;
    private VideoRecognizerPanel videoRecognizerPanel;
    private Transcription transcription;
    private Selection selection;
    private TimeScale timeScale;
    private ActiveAnnotation activeAnnotation;
    private TierOrder tierOrder;
    private ElanMediaPlayerController mediaPlayerController;
    private AnnotationDensityViewer annotationDensityViewer;
    private MediaPlayerControlSlider mediaPlayerControlSlider;
    private TimePanel timePanel;
    private MultiTierControlPanel multiTierControlPanel;
    private Vector slaveMediaPlayers;
    private Vector disabledMediaPlayers;
    private Hashtable controllers;
    private Vector viewers;
    private Vector enabledViewers;
    private Vector disabledViewers;
    private Tier emptyTier;
    private MetadataViewer metadataViewer;
    private Map<AbstractViewer, GestureDispatcher> gestureMap;
    private GridViewer gridViewer;
    private TimeLineViewer timeLineViewer;
    private TextViewer textViewer;
    private LexiconEntryViewer lexiconViewer;
    private Vector<SubtitleViewer> subtitleViewers;
    private InterlinearViewer interlinearViewer;
    private TranscriptionViewer transcriptionViewer;
    private String signalMediaURL;
    private ArrayList<String> audioPaths;
    private ArrayList<String> videoPaths;
    public static final int MAX_NUM_VIDEO_PLAYERS = 2;
    public static final int MAX_NUM_AUDIO_PLAYERS = 1;

    public ViewerManager2(Transcription transcription) {
        this.transcription = transcription;
        this.masterMediaPlayer = new EmptyMediaPlayer(Integer.MAX_VALUE);
        this.selection = new Selection();
        this.timeScale = new TimeScale();
        this.activeAnnotation = new ActiveAnnotation();
        this.createTierOrderObject();
        this.slaveMediaPlayers = new Vector();
        this.disabledMediaPlayers = new Vector();
        this.controllers = new Hashtable();
        this.viewers = new Vector();
        this.subtitleViewers = new Vector();
        this.enabledViewers = new Vector();
        this.disabledViewers = new Vector();
        this.gestureMap = new HashMap<AbstractViewer, GestureDispatcher>();
        this.audioPaths = new ArrayList();
        this.videoPaths = new ArrayList();
        try {
            this.emptyTier = new TierImpl(null, null, null, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void createTierOrderObject() {
        this.tierOrder = new TierOrder(this.transcription);
        this.connectListener(this.tierOrder);
        Vector tiers = this.transcription.getTiers();
        ArrayList<String> tierOrderList = (ArrayList<String>)Preferences.get("MultiTierViewer.TierOrder", this.transcription);
        if (tierOrderList != null) {
            Tier t;
            int i;
            for (i = 0; i < tierOrderList.size(); ++i) {
                t = this.transcription.getTierWithId((String)tierOrderList.get(i));
                if (t != null) continue;
                tierOrderList.remove(i);
                --i;
            }
            for (i = 0; i < tiers.size(); ++i) {
                t = (Tier)tiers.get(i);
                if (tierOrderList.contains(t.getName())) continue;
                tierOrderList.add(t.getName());
            }
        } else {
            tierOrderList = new ArrayList<String>();
            for (int i = 0; i < tiers.size(); ++i) {
                tierOrderList.add(((TierImpl)tiers.get(i)).getName());
            }
        }
        if (tierOrderList instanceof ArrayList) {
            this.tierOrder.setTierOrder(tierOrderList);
        } else {
            this.tierOrder.setTierOrder(new ArrayList(tierOrderList));
        }
    }

    public Transcription getTranscription() {
        return this.transcription;
    }

    public Selection getSelection() {
        return this.selection;
    }

    public TimeScale getTimeScale() {
        return this.timeScale;
    }

    public ActiveAnnotation getActiveAnnotation() {
        return this.activeAnnotation;
    }

    public TierOrder getTierOrder() {
        return this.tierOrder;
    }

    public void setMasterMediaPlayer(ElanMediaPlayer player) {
        if (player == this.masterMediaPlayer) {
            return;
        }
        float volume = this.masterMediaPlayer.getVolume();
        float rate = this.masterMediaPlayer.getRate();
        for (int i = 0; i < this.slaveMediaPlayers.size(); ++i) {
            this.masterMediaPlayer.removeController((Controller)this.slaveMediaPlayers.elementAt(i));
        }
        Enumeration en = this.controllers.elements();
        while (en.hasMoreElements()) {
            this.masterMediaPlayer.removeController((Controller)en.nextElement());
        }
        this.slaveMediaPlayers.remove(player);
        this.disabledMediaPlayers.remove(player);
        this.slaveMediaPlayers.add(this.masterMediaPlayer);
        this.masterMediaPlayer = player;
        for (int i = 0; i < this.slaveMediaPlayers.size(); ++i) {
            this.masterMediaPlayer.addController((Controller)this.slaveMediaPlayers.elementAt(i));
        }
        Enumeration<Object> en2 = this.controllers.elements();
        while (en2.hasMoreElements()) {
            this.masterMediaPlayer.addController((Controller)en2.nextElement());
        }
        en2 = this.viewers.elements();
        while (en2.hasMoreElements()) {
            ((AbstractViewer)en2.nextElement()).setPlayer(this.masterMediaPlayer);
        }
        this.masterMediaPlayer.setVolume(volume);
        this.masterMediaPlayer.setRate(rate);
        for (int i = 0; i < this.slaveMediaPlayers.size(); ++i) {
            ((ElanMediaPlayer)this.slaveMediaPlayers.elementAt(i)).setVolume(0.0f);
        }
    }

    public ElanMediaPlayer createMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        ElanMediaPlayer player = PlayerFactory.createElanMediaPlayer(mediaDescriptor);
        if (player == null) {
            return null;
        }
        ElanLocale.addElanLocaleListener(this.transcription, player);
        player.setRate(this.masterMediaPlayer.getRate());
        player.setVolume(0.0f);
        this.masterMediaPlayer.addController(player);
        this.slaveMediaPlayers.add(player);
        return player;
    }

    public ElanMediaPlayer createMediaPlayer(MediaDescriptor mediaDescriptor, String preferredMediaFramework) throws NoPlayerException {
        StringBuilder errors;
        ElanMediaPlayer player;
        block14: {
            if (preferredMediaFramework == null) {
                return this.createMediaPlayer(mediaDescriptor);
            }
            player = null;
            errors = new StringBuilder();
            try {
                if (preferredMediaFramework.equals("QT")) {
                    player = PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                    break block14;
                }
                if (preferredMediaFramework.equals("JMF")) {
                    player = PlayerFactory.createJMFMediaPlayer(mediaDescriptor);
                    break block14;
                }
                if (preferredMediaFramework.equals("NativeWindows")) {
                    player = PlayerFactory.createNativeMediaPlayerDS(mediaDescriptor);
                    break block14;
                }
                if (preferredMediaFramework.equals("CocoaQT")) {
                    try {
                        player = PlayerFactory.createCocoaQTMediaPlayer(mediaDescriptor);
                    }
                    catch (Exception ex) {
                        errors.append(ex.getMessage() + "\n");
                        player = PlayerFactory.createQTMediaPlayer(mediaDescriptor);
                    }
                    break block14;
                }
                try {
                    return this.createMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException np) {
                    errors.append(np.getMessage() + "\n");
                }
            }
            catch (NoPlayerException npe) {
                errors.append(npe.getMessage() + "\n");
                try {
                    return this.createMediaPlayer(mediaDescriptor);
                }
                catch (NoPlayerException np) {
                    errors.append(np.getMessage() + "\n");
                }
            }
        }
        if (player == null) {
            throw new NoPlayerException(errors.toString());
        }
        ElanLocale.addElanLocaleListener(this.transcription, player);
        player.setRate(this.masterMediaPlayer.getRate());
        player.setVolume(0.0f);
        this.masterMediaPlayer.addController(player);
        this.slaveMediaPlayers.add(player);
        return player;
    }

    public void addMediaPlayer(ElanMediaPlayer player) {
        if (player == null || this.slaveMediaPlayers.contains(player) || player == this.masterMediaPlayer) {
            return;
        }
        ElanLocale.addElanLocaleListener(this.transcription, player);
        player.setRate(this.masterMediaPlayer.getRate());
        player.setVolume(0.0f);
        this.masterMediaPlayer.addController(player);
        this.slaveMediaPlayers.add(player);
    }

    public void destroyMediaPlayer(ElanMediaPlayer player) {
        if (player == this.masterMediaPlayer) {
            return;
        }
        this.masterMediaPlayer.removeController(player);
        this.slaveMediaPlayers.remove(player);
        this.disabledMediaPlayers.remove(player);
        player = null;
    }

    public void enableMediaPlayer(ElanMediaPlayer player) {
        if (this.disabledMediaPlayers.contains(player)) {
            this.masterMediaPlayer.addController(player);
            this.slaveMediaPlayers.add(player);
            this.disabledMediaPlayers.remove(player);
        }
    }

    public void disableMediaPlayer(ElanMediaPlayer player) {
        if (this.slaveMediaPlayers.contains(player)) {
            this.masterMediaPlayer.removeController(player);
            this.slaveMediaPlayers.remove(player);
            this.disabledMediaPlayers.add(player);
        }
    }

    public void enableDisabledMediaPlayers() {
        Enumeration en = this.disabledMediaPlayers.elements();
        while (en.hasMoreElements()) {
            this.masterMediaPlayer.addController((ElanMediaPlayer)en.nextElement());
        }
        this.slaveMediaPlayers.addAll(this.disabledMediaPlayers);
        this.disabledMediaPlayers.clear();
    }

    public void disableSlaveMediaPlayers() {
        Enumeration en = this.slaveMediaPlayers.elements();
        while (en.hasMoreElements()) {
            this.masterMediaPlayer.removeController((ElanMediaPlayer)en.nextElement());
        }
        this.disabledMediaPlayers.addAll(this.slaveMediaPlayers);
        this.slaveMediaPlayers.clear();
    }

    public void setSignalSourcePlayer(ElanMediaPlayer player) {
        this.signalSourcePlayer = player;
    }

    public long getSignalViewerOffset() {
        long offset = 0L;
        if (this.signalSourcePlayer != null) {
            offset = this.signalSourcePlayer.getOffset();
        }
        return offset;
    }

    public SignalViewer getSignalViewer() {
        return this.signalViewer;
    }

    public void setOffset(ElanMediaPlayer player, long offset) {
        player.setOffset(offset);
        if (player == this.signalSourcePlayer && this.signalViewer != null) {
            this.signalViewer.setOffset(offset);
        }
        this.transcription.setChanged();
    }

    public ElanMediaPlayer getMasterMediaPlayer() {
        return this.masterMediaPlayer;
    }

    public Vector getSlaveMediaPlayers() {
        return this.slaveMediaPlayers;
    }

    public ElanMediaPlayerController getMediaPlayerController() {
        if (this.mediaPlayerController == null) {
            this.mediaPlayerController = new ElanMediaPlayerController(this);
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.mediaPlayerController, controller);
            this.connect(this.mediaPlayerController);
            this.viewers.add(this.mediaPlayerController);
            this.enabledViewers.add(this.mediaPlayerController);
        }
        return this.mediaPlayerController;
    }

    public void destroyElanMediaPlayerController() {
        if (this.mediaPlayerController != null) {
            this.destroyViewer(this.mediaPlayerController);
            this.mediaPlayerController = null;
        }
    }

    public MediaPlayerControlSlider getMediaPlayerControlSlider() {
        if (this.mediaPlayerControlSlider == null) {
            this.mediaPlayerControlSlider = new MediaPlayerControlSlider();
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.mediaPlayerControlSlider, controller);
            this.connect(this.mediaPlayerControlSlider);
            this.viewers.add(this.mediaPlayerControlSlider);
            this.enabledViewers.add(this.mediaPlayerControlSlider);
        }
        return this.mediaPlayerControlSlider;
    }

    public AnnotationDensityViewer getAnnotationDensityViewer() {
        if (this.annotationDensityViewer == null) {
            this.annotationDensityViewer = new AnnotationDensityViewer(this.transcription);
            this.annotationDensityViewer.setTierOrderObject(this.tierOrder);
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.annotationDensityViewer, controller);
            this.connect(this.annotationDensityViewer);
            this.viewers.add(this.annotationDensityViewer);
            this.enabledViewers.add(this.annotationDensityViewer);
        }
        return this.annotationDensityViewer;
    }

    public TimePanel getTimePanel() {
        if (this.timePanel == null) {
            this.timePanel = new TimePanel();
            PeriodicUpdateController controller = this.getControllerForPeriod(100L);
            this.controllers.put(this.timePanel, controller);
            this.connect(this.timePanel);
            this.viewers.add(this.timePanel);
            this.enabledViewers.add(this.timePanel);
        }
        return this.timePanel;
    }

    public Viewer createViewer(String className, long controllerPeriod) {
        Viewer viewer = null;
        try {
            viewer = (Viewer)Class.forName(className).newInstance();
            viewer.setViewerManager(this);
            if (viewer instanceof AbstractViewer) {
                PeriodicUpdateController controller = this.getControllerForPeriod(controllerPeriod);
                this.controllers.put(viewer, controller);
                this.connect((AbstractViewer)viewer);
                this.viewers.add(viewer);
                this.enabledViewers.add(viewer);
            } else if (viewer instanceof ControllerListener) {
                this.getControllerForPeriod(controllerPeriod).addControllerListener((ControllerListener)((Object)viewer));
            }
        }
        catch (Exception e) {
            System.out.println("Could not create viewer: " + className + ": " + e.getMessage());
        }
        return viewer;
    }

    public void connectListener(Object listener) {
        if (listener instanceof ControllerListener) {
            this.getControllerForPeriod(100L).addControllerListener((ControllerListener)listener);
        }
        if (listener instanceof SelectionListener) {
            this.selection.addSelectionListener((SelectionListener)listener);
        }
        if (listener instanceof ActiveAnnotationListener) {
            this.activeAnnotation.addActiveAnnotationListener((ActiveAnnotationListener)listener);
        }
        if (listener instanceof TimeScaleListener) {
            this.timeScale.addTimeScaleListener((TimeScaleListener)listener);
        }
        if (listener instanceof ACMEditListener) {
            try {
                this.transcription.addACMEditListener((ACMEditListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener instanceof PreferencesListener) {
            Preferences.addPreferencesListener(this.transcription, (PreferencesListener)listener);
        }
    }

    public void disconnectListener(Object listener) {
        if (listener instanceof ControllerListener) {
            this.getControllerForPeriod(100L).removeControllerListener((ControllerListener)listener);
        }
        if (listener instanceof SelectionListener) {
            this.selection.removeSelectionListener((SelectionListener)listener);
        }
        if (listener instanceof ActiveAnnotationListener) {
            this.activeAnnotation.removeActiveAnnotationListener((ActiveAnnotationListener)listener);
        }
        if (listener instanceof TimeScaleListener) {
            this.timeScale.removeTimeScaleListener((TimeScaleListener)listener);
        }
        if (listener instanceof ACMEditListener) {
            try {
                this.transcription.removeACMEditListener((ACMEditListener)listener);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (listener instanceof PreferencesListener) {
            Preferences.removePreferencesListener(this.transcription, (PreferencesListener)listener);
        }
    }

    public MultiTierControlPanel getMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            return this.createMultiTierControlPanel();
        }
        return this.multiTierControlPanel;
    }

    public MultiTierControlPanel createMultiTierControlPanel() {
        if (this.multiTierControlPanel == null) {
            this.multiTierControlPanel = new MultiTierControlPanel(this.transcription, this.tierOrder);
            ElanLocale.addElanLocaleListener(this.transcription, this.multiTierControlPanel);
            Preferences.addPreferencesListener(this.transcription, this.multiTierControlPanel);
        }
        return this.multiTierControlPanel;
    }

    public void destroyMultiTierControlPanel() {
        if (this.multiTierControlPanel != null) {
            Preferences.removePreferencesListener(this.transcription, this.multiTierControlPanel);
            ElanLocale.removeElanLocaleListener(this.multiTierControlPanel);
            this.multiTierControlPanel = null;
        }
    }

    public TimeLineViewer createTimeLineViewer() {
        this.timeLineViewer = new TimeLineViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(this.timeLineViewer, controller);
        this.connect(this.timeLineViewer);
        this.viewers.add(this.timeLineViewer);
        this.enabledViewers.add(this.timeLineViewer);
        return this.timeLineViewer;
    }

    public InterlinearViewer createInterlinearViewer() {
        Object val = Preferences.get("Menu.View.Viewers.InterLinear", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.interlinearViewer == null) {
                this.interlinearViewer = new InterlinearViewer(this.transcription);
                PeriodicUpdateController controller = this.getControllerForPeriod(100L);
                this.controllers.put(this.interlinearViewer, controller);
                this.connect(this.interlinearViewer);
                this.viewers.add(this.interlinearViewer);
                this.enabledViewers.add(this.interlinearViewer);
            }
            return this.interlinearViewer;
        }
        return null;
    }

    public InterlinearViewer getInterlinearViewer() {
        return this.interlinearViewer;
    }

    public String getSignalMediaURL() {
        return this.signalMediaURL;
    }

    public void setAudioPaths(ArrayList<String> audioPath) {
        this.audioPaths.clear();
        if (audioPath != null) {
            for (int i = 0; i < audioPath.size(); ++i) {
                String path = audioPath.get(i);
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if (this.audioPaths.contains(path)) continue;
                this.audioPaths.add(path);
            }
        }
    }

    public ArrayList<String> getAudioPaths() {
        return this.audioPaths;
    }

    public void setVideoPaths(ArrayList<String> videoPath) {
        this.videoPaths.clear();
        if (videoPath != null) {
            for (int i = 0; i < videoPath.size(); ++i) {
                String path = videoPath.get(i);
                if (path.startsWith("file:")) {
                    path = path.substring(5);
                }
                if (this.videoPaths.contains(path)) continue;
                this.videoPaths.add(path);
            }
        }
    }

    public ArrayList<String> getVideoPaths() {
        return this.videoPaths;
    }

    public SignalViewer createSignalViewer() {
        Object val = Preferences.get("Menu.View.Viewers.Signal", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.signalViewer == null && this.signalMediaURL != null) {
                this.createSignalViewer(this.signalMediaURL);
                this.signalViewer.setOffset(this.getSignalViewerOffset());
                this.signalViewer.preferencesChanged();
            }
            return this.signalViewer;
        }
        return null;
    }

    public SignalViewer createSignalViewer(String mediaURL) {
        SignalViewer viewer = null;
        if (mediaURL != null) {
            this.signalMediaURL = mediaURL;
        }
        if (mediaURL.startsWith("rtsp://")) {
            return viewer;
        }
        Object val = Preferences.get("Menu.View.Viewers.Signal", null);
        if (val != null && val instanceof Boolean && !((Boolean)val).booleanValue()) {
            return viewer;
        }
        viewer = new SignalViewer(mediaURL);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        this.signalViewer = viewer;
        return viewer;
    }

    public TranscriptionViewer createTranscriptionViewer() {
        this.transcriptionViewer = new TranscriptionViewer(this);
        PeriodicUpdateController controller = this.getControllerForPeriod(100L);
        this.controllers.put(this.transcriptionViewer, controller);
        this.connect(this.transcriptionViewer);
        this.viewers.add(this.transcriptionViewer);
        this.enabledViewers.add(this.transcriptionViewer);
        return this.transcriptionViewer;
    }

    public TranscriptionViewer getTranscriptionViewer() {
        return this.transcriptionViewer;
    }

    public GridViewer createGridViewer() {
        Object val = Preferences.get("Menu.View.Viewers.Grid", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.gridViewer == null) {
                this.gridViewer = new GridViewer();
                this.connect(this.gridViewer);
                this.viewers.add(this.gridViewer);
                this.enabledViewers.add(this.gridViewer);
            }
            return this.gridViewer;
        }
        return null;
    }

    public GridViewer getGridViewer() {
        return this.gridViewer;
    }

    public ElanResultViewer createSearchResultViewer() {
        ElanResultViewer viewer = new ElanResultViewer();
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public SubtitleViewer createSubtitleViewer() {
        Object val = Preferences.get("Menu.View.Viewers.Subtitles", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            SubtitleViewer subtitleViewer = new SubtitleViewer();
            this.connect(subtitleViewer);
            this.viewers.add(subtitleViewer);
            this.enabledViewers.add(subtitleViewer);
            this.subtitleViewers.add(subtitleViewer);
            return subtitleViewer;
        }
        return null;
    }

    public Vector<SubtitleViewer> getSubtitleViewers() {
        return this.subtitleViewers;
    }

    public TextViewer createTextViewer() {
        Object val = Preferences.get("Menu.View.Viewers.Text", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.textViewer == null) {
                this.textViewer = new TextViewer();
                this.connect(this.textViewer);
                this.viewers.add(this.textViewer);
                this.enabledViewers.add(this.textViewer);
            }
            return this.textViewer;
        }
        return null;
    }

    public TextViewer getTextViewer() {
        return this.textViewer;
    }

    public GlassPaneSVGViewer createSVGViewer() {
        GlassPaneSVGViewer viewer = new GlassPaneSVGViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(100L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public JMFSVGViewer createJMFSVGViewer() {
        if (this.getMasterMediaPlayer() != null && this.getMasterMediaPlayer() instanceof JMFGraphicMediaPlayer && ((JMFGraphicMediaPlayer)this.getMasterMediaPlayer()).getRenderer() != null) {
            JMFSVGViewer viewer = new JMFSVGViewer(this.transcription);
            if (((JMFGraphicMediaPlayer)this.getMasterMediaPlayer()).connectViewer(viewer)) {
                this.connect(viewer);
                this.viewers.add(viewer);
                this.enabledViewers.add(viewer);
            } else {
                viewer = null;
            }
            return viewer;
        }
        return null;
    }

    public QTSVGViewer createQTSVGViewer() {
        if (this.getMasterMediaPlayer() != null && this.getMasterMediaPlayer() instanceof QTMediaPlayer && ((QTMediaPlayer)this.getMasterMediaPlayer()).getMovie() != null) {
            QTSVGViewer viewer = new QTSVGViewer(this.transcription);
            viewer.setMediaFileDimension(((QTMediaPlayer)this.getMasterMediaPlayer()).getMediaFileDimension());
            viewer.setMovie(((QTMediaPlayer)this.getMasterMediaPlayer()).getMovie());
            ((QTMediaPlayer)this.getMasterMediaPlayer()).setStopMode(0);
            this.connect(viewer);
            this.viewers.add(viewer);
            this.enabledViewers.add(viewer);
            return viewer;
        }
        return null;
    }

    public SegmentationViewer2 createSegmentationViewer() {
        SegmentationViewer2 viewer = new SegmentationViewer2(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public TimeSeriesViewer createTimeSeriesViewer() {
        TimeSeriesViewer viewer = new TimeSeriesViewer(this.transcription);
        PeriodicUpdateController controller = this.getControllerForPeriod(50L);
        this.controllers.put(viewer, controller);
        this.connect(viewer);
        this.viewers.add(viewer);
        this.enabledViewers.add(viewer);
        return viewer;
    }

    public void connectViewer(AbstractViewer viewer, boolean connect) {
        if (viewer == null) {
            return;
        }
        if (connect) {
            if (viewer instanceof TimeSeriesViewer) {
                this.controllers.put(viewer, this.getControllerForPeriod(50L));
            } else if (viewer instanceof SignalViewer) {
                this.controllers.put(viewer, this.getControllerForPeriod(50L));
            }
            this.connect(viewer);
            this.viewers.add(viewer);
            this.enabledViewers.add(viewer);
            this.disabledViewers.remove(viewer);
        } else {
            this.disconnect(viewer, false);
            this.enabledViewers.remove(viewer);
            this.disabledViewers.add(viewer);
        }
    }

    public MetadataViewer createMetadataViewer() {
        Object val = Preferences.get("Menu.View.Viewers.MetaData", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.metadataViewer == null) {
                this.metadataViewer = new MetadataViewer(this);
                ElanLocale.addElanLocaleListener(this.transcription, this.metadataViewer);
                Preferences.addPreferencesListener(this.transcription, this.metadataViewer);
            }
            return this.metadataViewer;
        }
        return null;
    }

    public MetadataViewer getMetadataViewer() {
        return this.metadataViewer;
    }

    public void destroyMetaDataViewer() {
        if (this.metadataViewer != null) {
            ElanLocale.removeElanLocaleListener(this.metadataViewer);
            Preferences.removePreferencesListener(this.transcription, this.metadataViewer);
            this.metadataViewer = null;
        }
    }

    public AudioRecognizerPanel createAudioRecognizerPanel() {
        Object val = Preferences.get("Menu.View.Viewers.Audio", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.audioRecognizerPanel == null && this.audioPaths != null && this.audioPaths.size() > 0) {
                this.audioRecognizerPanel = new AudioRecognizerPanel(this, this.audioPaths);
                ElanLocale.addElanLocaleListener(this.transcription, this.audioRecognizerPanel);
            }
            return this.audioRecognizerPanel;
        }
        return null;
    }

    public AudioRecognizerPanel getAudioRecognizerPanel() {
        return this.audioRecognizerPanel;
    }

    public VideoRecognizerPanel createVideoRecognizerPanel() {
        Object val = Preferences.get("Menu.View.Viewers.Video", null);
        if (val == null || val instanceof Boolean && ((Boolean)val).booleanValue()) {
            if (this.videoRecognizerPanel == null && this.videoPaths != null && this.videoPaths.size() > 0) {
                this.videoRecognizerPanel = new VideoRecognizerPanel(this, this.videoPaths);
                ElanLocale.addElanLocaleListener(this.transcription, this.videoRecognizerPanel);
            }
            return this.videoRecognizerPanel;
        }
        return null;
    }

    public LexiconEntryViewer createLexiconEntryViewer() {
        this.lexiconViewer = new LexiconEntryViewer();
        this.connect(this.lexiconViewer);
        this.viewers.add(this.lexiconViewer);
        this.enabledViewers.add(this.lexiconViewer);
        return this.lexiconViewer;
    }

    public LexiconEntryViewer getLexiconViewer() {
        return this.lexiconViewer;
    }

    public void destroyPanel(String panelName) {
        if (panelName == null) {
            return;
        }
        if (panelName.equals("Menu.View.Viewers.Video")) {
            if (this.videoRecognizerPanel != null) {
                ElanLocale.removeElanLocaleListener(this.videoRecognizerPanel);
                this.videoRecognizerPanel = null;
            }
        } else if (panelName.equals("Menu.View.Viewers.Audio") && this.audioRecognizerPanel != null) {
            ElanLocale.removeElanLocaleListener(this.audioRecognizerPanel);
            this.audioRecognizerPanel = null;
        }
    }

    public VideoRecognizerPanel getVideoRecognizerPanel() {
        return this.videoRecognizerPanel;
    }

    public void setControllersForViewer(AbstractViewer viewer, String[] tierNames) {
        try {
            Tier[] tiers = new Tier[tierNames.length];
            for (int i = 0; i < tierNames.length; ++i) {
                tiers[i] = this.transcription.getTierWithId(tierNames[i]);
            }
            this.setControllersForViewer(viewer, tiers);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setTierForViewer(SingleTierViewer viewer, Tier tier) {
        if (viewer instanceof AbstractViewer) {
            Tier[] tierArray;
            AbstractViewer abstractViewer = (AbstractViewer)((Object)viewer);
            if (tier == null) {
                tierArray = new Tier[]{};
            } else {
                Tier[] tierArray2 = new Tier[1];
                tierArray = tierArray2;
                tierArray2[0] = tier;
            }
            this.setControllersForViewer(abstractViewer, tierArray);
        }
        viewer.setTier(tier);
    }

    public void setControllersForViewer(AbstractViewer viewer, Tier[] tiers) {
        if (viewer == null) {
            return;
        }
        this.disconnectController(viewer, true);
        if (tiers != null && tiers.length > 0) {
            TimeLineController controller = this.getControllerForTier(tiers[0]);
            controller.addControllerListener(viewer);
            this.controllers.put(viewer, controller);
            if (this.masterMediaPlayer.isPlaying()) {
                controller.start();
            }
        }
    }

    public SingleTierViewerPanel createSingleTierViewerPanel() {
        SingleTierViewerPanel panel = new SingleTierViewerPanel(this);
        this.tierOrder.addTierOrderListener(panel);
        try {
            this.transcription.addACMEditListener(panel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ElanLocale.addElanLocaleListener(this.transcription, panel);
        return panel;
    }

    public void destroySingleTierViewerPanel(SingleTierViewerPanel panel) {
        if (panel == null) {
            return;
        }
        this.tierOrder.removeTierorderListener(panel);
        try {
            this.transcription.removeACMEditListener(panel);
            Preferences.removePreferencesListener(this.transcription, panel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ElanLocale.removeElanLocaleListener(panel);
    }

    public void destroyViewer(AbstractViewer viewer) {
        if (this.enabledViewers.contains(viewer)) {
            this.enabledViewers.remove(viewer);
        }
        if (this.disabledViewers.contains(viewer)) {
            this.disabledViewers.remove(viewer);
        }
        this.disconnect(viewer, true);
        this.viewers.remove(viewer);
    }

    public void destroyTranscriptionViewer() {
        if (this.transcriptionViewer != null) {
            this.destroyViewer(this.transcriptionViewer);
            this.transcriptionViewer = null;
        }
    }

    public void destroyGridViewer() {
        if (this.gridViewer != null) {
            this.destroyViewer(this.gridViewer);
            this.gridViewer = null;
        }
    }

    public void destroyTextViewer() {
        if (this.textViewer != null) {
            this.destroyViewer(this.textViewer);
            this.textViewer = null;
        }
    }

    public void destroySubtitleViewers() {
        if (this.subtitleViewers != null) {
            for (int i = 0; i < this.subtitleViewers.size(); ++i) {
                this.destroyViewer(this.subtitleViewers.elementAt(i));
            }
            this.subtitleViewers.clear();
        }
    }

    public void destroyLexiconViewer() {
        if (this.lexiconViewer != null) {
            this.destroyViewer(this.lexiconViewer);
            this.lexiconViewer = null;
        }
    }

    public void destroySignalViewer() {
        if (this.signalViewer != null) {
            this.destroyViewer(this.signalViewer);
            this.signalViewer = null;
        }
    }

    public void destroyInterlinearViewer() {
        if (this.interlinearViewer != null) {
            this.destroyViewer(this.interlinearViewer);
            this.interlinearViewer = null;
        }
    }

    public void destroyTimeLineViewer() {
        if (this.timeLineViewer != null) {
            this.destroyViewer(this.timeLineViewer);
            this.timeLineViewer = null;
        }
    }

    public void destroyAnnotationDensityViewer() {
        if (this.annotationDensityViewer != null) {
            this.destroyViewer(this.annotationDensityViewer);
            this.annotationDensityViewer = null;
        }
    }

    public void destroyMediaPlayerControlSlider() {
        if (this.mediaPlayerControlSlider != null) {
            this.destroyViewer(this.mediaPlayerControlSlider);
            this.mediaPlayerControlSlider = null;
        }
    }

    public void destroyTimePanel() {
        if (this.timePanel != null) {
            this.destroyViewer(this.timePanel);
            this.timePanel = null;
        }
    }

    public void disableViewer(AbstractViewer viewer) {
        if (this.enabledViewers.contains(viewer)) {
            this.enabledViewers.remove(viewer);
            this.disconnect(viewer, false);
            this.disabledViewers.add(viewer);
        }
    }

    public void enableViewer(AbstractViewer viewer) {
        if (this.disabledViewers.contains(viewer)) {
            this.disabledViewers.remove(viewer);
            this.connect(viewer);
            this.enabledViewers.add(viewer);
        }
    }

    public void setFrameStepsToBeginOfFrame(boolean stepsToBegin) {
        ElanMediaPlayer player;
        int i;
        if (this.masterMediaPlayer != null) {
            this.masterMediaPlayer.setFrameStepsToFrameBegin(stepsToBegin);
        }
        for (i = 0; i < this.slaveMediaPlayers.size(); ++i) {
            player = (ElanMediaPlayer)this.slaveMediaPlayers.get(i);
            player.setFrameStepsToFrameBegin(stepsToBegin);
        }
        for (i = 0; i < this.disabledMediaPlayers.size(); ++i) {
            player = (ElanMediaPlayer)this.disabledMediaPlayers.get(i);
            player.setFrameStepsToFrameBegin(stepsToBegin);
        }
    }

    public void cleanUpOnClose() {
        ElanMediaPlayer player;
        int i;
        if (this.masterMediaPlayer != null && this.masterMediaPlayer.isPlaying()) {
            this.masterMediaPlayer.stop();
        }
        for (i = 0; i < this.slaveMediaPlayers.size(); ++i) {
            player = (ElanMediaPlayer)this.slaveMediaPlayers.get(i);
            player.cleanUpOnClose();
        }
        for (i = 0; i < this.disabledMediaPlayers.size(); ++i) {
            player = (ElanMediaPlayer)this.disabledMediaPlayers.get(i);
            player.cleanUpOnClose();
        }
        if (this.masterMediaPlayer != null) {
            this.masterMediaPlayer.cleanUpOnClose();
        }
        for (i = 0; i < this.viewers.size(); ++i) {
            AbstractViewer viewer = (AbstractViewer)this.viewers.get(i);
            this.disconnect(viewer, true);
            if (viewer instanceof ACMEditListener && this.transcription != null) {
                this.transcription.removeACMEditListener((ACMEditListener)((Object)viewer));
            }
            if (viewer instanceof TimeLineViewer) {
                ((TimeLineViewer)viewer).setTranscription(null);
            }
            if (!(viewer instanceof InterlinearViewer)) continue;
            ((InterlinearViewer)viewer).setTranscription(null);
        }
        if (this.audioRecognizerPanel != null) {
            // empty if block
        }
        this.enabledViewers.clear();
        this.viewers.clear();
        this.disabledViewers.clear();
    }

    private void connect(AbstractViewer viewer) {
        Controller controller;
        viewer.setPlayer(this.masterMediaPlayer);
        viewer.setSelectionObject(this.selection);
        this.selection.addSelectionListener(viewer);
        viewer.setActiveAnnotationObject(this.activeAnnotation);
        this.activeAnnotation.addActiveAnnotationListener(viewer);
        ElanLocale.addElanLocaleListener(this.transcription, viewer);
        viewer.setViewerManager(this);
        if (viewer instanceof ACMEditListener) {
            try {
                this.transcription.addACMEditListener((ACMEditListener)((Object)viewer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (viewer instanceof TimeScaleUser) {
            ((TimeScaleUser)((Object)viewer)).setGlobalTimeScale(this.timeScale);
            this.timeScale.addTimeScaleListener((TimeScaleListener)((Object)viewer));
        }
        if (viewer instanceof GesturesListener && SystemReporting.isMacOS()) {
            GestureMacDispatcher disp = new GestureMacDispatcher(viewer, (GesturesListener)((Object)viewer));
            this.gestureMap.put(viewer, disp);
            disp.connect();
        }
        if (viewer instanceof MultiTierViewer && this.multiTierControlPanel != null) {
            this.multiTierControlPanel.addViewer((MultiTierViewer)((Object)viewer));
        }
        if (viewer instanceof PreferencesListener) {
            Preferences.addPreferencesListener(this.transcription, viewer);
        }
        if ((controller = (Controller)this.controllers.get(viewer)) != null) {
            controller.addControllerListener(viewer);
            viewer.controllerUpdate(new TimeEvent(controller));
        }
    }

    private void disconnect(AbstractViewer viewer, boolean finalDisconnection) {
        GestureDispatcher disp;
        viewer.setPlayer(null);
        viewer.setSelectionObject(null);
        this.selection.removeSelectionListener(viewer);
        viewer.setActiveAnnotationObject(null);
        this.activeAnnotation.removeActiveAnnotationListener(viewer);
        ElanLocale.removeElanLocaleListener(viewer);
        viewer.setViewerManager(null);
        if (viewer instanceof ACMEditListener) {
            try {
                this.transcription.removeACMEditListener((ACMEditListener)((Object)viewer));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (viewer instanceof TimeScaleUser) {
            this.timeScale.removeTimeScaleListener((TimeScaleUser)((Object)viewer));
        }
        if (viewer instanceof GesturesListener && SystemReporting.isMacOS() && (disp = this.gestureMap.remove(viewer)) != null) {
            disp.disconnect();
        }
        if (viewer instanceof MultiTierViewer && this.multiTierControlPanel != null) {
            this.multiTierControlPanel.removeViewer((MultiTierViewer)((Object)viewer));
        }
        if (viewer instanceof PreferencesListener) {
            Preferences.removePreferencesListener(this.transcription, viewer);
        }
        this.disconnectController(viewer, finalDisconnection);
    }

    private void disconnectController(AbstractViewer viewer, boolean finalDisconnection) {
        Controller controller = (Controller)this.controllers.get(viewer);
        if (controller != null) {
            controller.removeControllerListener(viewer);
            if (finalDisconnection) {
                this.controllers.remove(viewer);
                if (controller.getNrOfConnectedListeners() == 0) {
                    this.removeFromHashTable(controller, this.controllers);
                    this.masterMediaPlayer.removeController(controller);
                    controller = null;
                }
            }
        }
    }

    private TimeLineController getControllerForTier(Tier tier) {
        if (tier == null) {
            return null;
        }
        TimeLineController controller = null;
        if (this.controllers.containsKey(tier)) {
            controller = (TimeLineController)this.controllers.get(tier);
        } else {
            controller = new TimeLineController(tier, this.masterMediaPlayer);
            this.masterMediaPlayer.addController(controller);
            this.controllers.put(tier, controller);
        }
        return controller;
    }

    private PeriodicUpdateController getControllerForPeriod(long period) {
        PeriodicUpdateController controller = null;
        Long periodKey = new Long(period);
        if (this.controllers.containsKey(periodKey)) {
            controller = (PeriodicUpdateController)this.controllers.get(periodKey);
        } else {
            controller = new PeriodicUpdateController(period);
            this.masterMediaPlayer.addController(controller);
            this.controllers.put(periodKey, controller);
        }
        return controller;
    }

    private boolean removeFromHashTable(Object object, Hashtable hashtable) {
        boolean objectRemoved = false;
        Enumeration e = hashtable.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if (this.controllers.get(key) != object) continue;
            hashtable.remove(key);
            objectRemoved = true;
        }
        return objectRemoved;
    }
}

