/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.RefAnnotation;

public class ActiveAnnotationCommand
implements Command {
    private String commandName;

    public ActiveAnnotationCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        ViewerManager2 vm = (ViewerManager2)receiver;
        Annotation annot = (Annotation)arguments[0];
        vm.getActiveAnnotation().setAnnotation(annot);
        if (annot != null) {
            if (annot instanceof AlignableAnnotation) {
                vm.getSelection().setSelection(annot.getBeginTimeBoundary(), annot.getEndTimeBoundary());
                if (!vm.getMediaPlayerController().isBeginBoundaryActive()) {
                    vm.getMediaPlayerController().toggleActiveSelectionBoundary();
                }
            } else if (annot instanceof RefAnnotation) {
                Annotation parent = annot;
                while ((parent = parent.getParentAnnotation()) != null && !(parent instanceof AlignableAnnotation)) {
                }
                if (parent instanceof AlignableAnnotation) {
                    AlignableAnnotation aa = (AlignableAnnotation)parent;
                    vm.getSelection().setSelection(aa.getBeginTimeBoundary(), aa.getEndTimeBoundary());
                }
            }
            vm.getMasterMediaPlayer().setMediaTime(annot.getBeginTimeBoundary());
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

