/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class AddTierCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier = null;
    private Transcription transcription;

    public AddTierCommand(String theName) {
        this.commandName = theName;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        String tierName = (String)arguments[0];
        Tier parentTier = (Tier)arguments[1];
        String lingType = (String)arguments[2];
        String participant = (String)arguments[3];
        String annotator = (String)arguments[4];
        Locale locale = (Locale)arguments[5];
        if (this.transcription != null) {
            this.tier = new TierImpl(parentTier, tierName, null, this.transcription, null);
            Vector types = this.transcription.getLinguisticTypes();
            LinguisticType t = null;
            Iterator typeIter = types.iterator();
            while (typeIter.hasNext() && !(t = (LinguisticType)typeIter.next()).getLinguisticTypeName().equals(lingType)) {
            }
            this.tier.setLinguisticType(t);
            this.tier.setParticipant(participant);
            this.tier.setAnnotator(annotator);
            this.tier.setDefaultLocale(locale);
            if (this.transcription.getTierWithId(tierName) == null) {
                this.transcription.addTier(this.tier);
            }
        }
    }

    @Override
    public void undo() {
        if (this.tier != null) {
            this.transcription.removeTier(this.tier);
        }
    }

    @Override
    public void redo() {
        if (this.tier != null && this.transcription.getTierWithId(this.tier.getName()) == null) {
            this.transcription.addTier(this.tier);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

