/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class AnnotationAfterCommand
implements UndoableCommand {
    private String commandName;
    private TierImpl tier;
    private Transcription transcription;
    private AnnotationDataRecord activeAnnRecord;
    private long aaMiddle;
    private long newAnnMiddle;

    public AnnotationAfterCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.tier != null) {
            AlignableAnnotation activeAnn;
            Annotation delAnn = this.tier.getAnnotationAtTime(this.newAnnMiddle);
            if (delAnn != null) {
                this.tier.removeAnnotation(delAnn);
            }
            if (this.tier.isTimeAlignable() && (activeAnn = (AlignableAnnotation)this.tier.getAnnotationAtTime(this.aaMiddle)) != null && (activeAnn.getBegin().isTimeAligned() != this.activeAnnRecord.isBeginTimeAligned() || activeAnn.getEnd().isTimeAligned() != this.activeAnnRecord.isEndTimeAligned())) {
                int curPropMode = 0;
                curPropMode = this.transcription.getTimeChangePropagationMode();
                if (curPropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                activeAnn.updateTimeInterval(this.activeAnnRecord.getBeginTime(), this.activeAnnRecord.getEndTime());
                this.transcription.setTimeChangePropagationMode(curPropMode);
            }
        }
    }

    @Override
    public void redo() {
        Annotation afterAnn;
        if (this.tier != null && (afterAnn = this.tier.getAnnotationAtTime(this.aaMiddle)) != null) {
            this.tier.createAnnotationAfter(afterAnn);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        Annotation activeAnn = (Annotation)arguments[0];
        this.activeAnnRecord = new AnnotationDataRecord(activeAnn);
        this.aaMiddle = (this.activeAnnRecord.getBeginTime() + this.activeAnnRecord.getEndTime()) / 2L;
        this.transcription = (Transcription)this.tier.getParent();
        Annotation newAnnotation = this.tier.createAnnotationAfter(activeAnn);
        if (newAnnotation != null) {
            this.newAnnMiddle = (newAnnotation.getBeginTimeBoundary() + newAnnotation.getEndTimeBoundary()) / 2L;
            Object pref = Preferences.get("ClearSelectionAfterCreation", null);
            if (pref instanceof Boolean && ((Boolean)pref).booleanValue()) {
                ViewerManager2 vm = ELANCommandFactory.getViewerManager(this.transcription);
                if (vm.getMediaPlayerController().getSelectionMode()) {
                    vm.getSelection().setSelection(vm.getMediaPlayerController().getMediaTime(), vm.getMediaPlayerController().getMediaTime());
                } else {
                    vm.getSelection().setSelection(0L, 0L);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

