/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.SelectionListener;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.CommandAction;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.util.ClientLogger;

public class ClipMediaCA
extends CommandAction
implements SelectionListener {
    private File scriptFile;
    private String executable;
    private String paramLine;
    private final String scriptFileName = "clip-media.txt";
    private long lastModified = 0L;
    private String outFilePath = null;

    public ClipMediaCA(ViewerManager2 viewerManager) {
        super(viewerManager, "Menu.File.Export.MediaWithScript");
        try {
            this.scriptFile = this.getScriptFile();
            if (this.scriptFile != null) {
                ClientLogger.LOG.info("Found clipping script: " + this.scriptFile.getName());
            } else {
                ClientLogger.LOG.info("No clipping script found!");
            }
        }
        catch (Exception e) {
            ClientLogger.LOG.info("No clipping script found");
        }
        viewerManager.connectListener(this);
    }

    @Override
    protected void newCommand() {
        this.command = ELANCommandFactory.createCommand(this.vm.getTranscription(), "Menu.File.Export.MediaWithScript");
    }

    public void setPath(String outFilePath) {
        this.outFilePath = outFilePath;
    }

    @Override
    protected Object getReceiver() {
        return null;
    }

    @Override
    protected Object[] getArguments() {
        if (this.scriptFile == null) {
            return new Object[]{this.vm, new Exception(ElanLocale.getString("ExportClipDialog.Message.NoScript") + "\n" + ElanLocale.getString("ExportClipDialog.Message.LookingFor") + "\n" + System.getProperty("user.dir") + File.separator + "clip-media.txt" + "\n" + Constants.ELAN_DATA_DIR + File.separator + "clip-media.txt")};
        }
        if (this.executable == null) {
            return new Object[]{this.vm, new Exception(ElanLocale.getString("ExportClipDialog.Message.InvalidScript"))};
        }
        if (this.outFilePath != null) {
            return new Object[]{this.vm, this.executable, this.paramLine, this.outFilePath};
        }
        return new Object[]{this.vm, this.executable, this.paramLine};
    }

    @Override
    public void updateSelection() {
        if (this.vm.getSelection().getEndTime() > this.vm.getSelection().getBeginTime()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private File getScriptFile() {
        File f = new File(Constants.ELAN_DATA_DIR + File.separator + "clip-media.txt");
        if (f.exists() && f.isFile() && f.canRead()) {
            return f;
        }
        f = new File(System.getProperty("user.dir") + File.separator + "clip-media.txt");
        if (f.exists() && f.isFile() && f.canRead()) {
            return f;
        }
        return null;
    }

    private void parseScriptLine() {
        if (this.scriptFile != null) {
            try {
                FileReader fileRead = new FileReader(this.scriptFile);
                BufferedReader bufRead = new BufferedReader(fileRead);
                String line = null;
                while ((line = bufRead.readLine()) != null) {
                    int index;
                    if (line.length() == 0 || line.startsWith("#")) continue;
                    if ((line = line.trim()).startsWith("\"")) {
                        index = line.indexOf("\"", 1);
                        if (index > -1) {
                            this.executable = line.substring(1, index);
                            if (index >= line.length() - 2) continue;
                            this.paramLine = line.substring(index + 2);
                            continue;
                        }
                        this.executable = null;
                        continue;
                    }
                    index = line.indexOf(32);
                    if (index <= 0) continue;
                    this.executable = line.substring(0, index);
                    if (index >= line.length() - 1) continue;
                    this.paramLine = line.substring(index + 1);
                }
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.warning("The script file can not be found");
                this.executable = null;
                this.paramLine = null;
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Error while reading the script file " + ioe.getMessage());
                this.executable = null;
                this.paramLine = null;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.scriptFile == null) {
            this.scriptFile = this.getScriptFile();
            if (this.scriptFile != null) {
                this.lastModified = this.scriptFile.lastModified();
                this.parseScriptLine();
            }
        } else {
            long lm = this.scriptFile.lastModified();
            if (lm > this.lastModified) {
                this.parseScriptLine();
                this.lastModified = lm;
            }
        }
        super.actionPerformed(event);
    }
}

