/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.linkedmedia.MediaDescriptorUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clom.TranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.ACMTranscriptionStore;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.ProcessReporter;
import mpi.eudico.server.corpora.util.SimpleReport;

public class CreateTranscriptionsCommand
implements Command,
ProcessReporter {
    private String name;
    private List<Character> delimiters;
    private ProcessReport report;
    private int count = 0;

    public CreateTranscriptionsCommand(String name) {
        this.name = name;
        this.delimiters = new ArrayList<Character>(4);
        this.delimiters.add(Character.valueOf('-'));
        this.delimiters.add(Character.valueOf('_'));
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        String sourceFol;
        if (this.report == null) {
            this.report = new SimpleReport();
        }
        if ((sourceFol = (String)arguments[0]) == null || sourceFol.length() == 0) {
            String message = "No source folder containing media files specified";
            ClientLogger.LOG.severe(message);
            this.report(message);
            this.report("Stopping, no transcriptions created.");
            return;
        }
        String templateFile = (String)arguments[1];
        String destFol = (String)arguments[2];
        Boolean recursive = (Boolean)arguments[3];
        Boolean combineVideos = (Boolean)arguments[4];
        Boolean prefixBased = (Boolean)arguments[5];
        String separator = (String)arguments[6];
        if (separator != null && separator.length() > 0) {
            this.delimiters.add(0, Character.valueOf(separator.charAt(0)));
        }
        File sourceFolFile = new File(sourceFol);
        try {
            if (!sourceFolFile.exists() || !sourceFolFile.isDirectory()) {
                String message = "The specified source folder does not exist";
                ClientLogger.LOG.severe(message);
                this.report(message);
                this.report("Stopping, no transcriptions created.");
                return;
            }
        }
        catch (Exception ex) {
            String message = "Cannot access the source folder";
            ClientLogger.LOG.severe(message);
            this.report(message);
            this.report("Stopping, no transcriptions created.");
            return;
        }
        this.createTranscriptions(sourceFolFile, templateFile, destFol, recursive, combineVideos, prefixBased);
        this.report("\nFinished processing: " + this.count + " EAF files have been created.\n");
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void createTranscriptions(File source, String templatePath, String destinationPath, Boolean recursive, Boolean combineVideos, Boolean prefixBased) {
        TranscriptionImpl trans;
        String path;
        if (source == null || source.getAbsolutePath().equals(destinationPath)) {
            return;
        }
        File[] files = source.listFiles();
        if (files.length == 0) {
            ClientLogger.LOG.warning("There are no media files in the source folder");
            return;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<File> waveList = new ArrayList<File>();
        ArrayList<String> exts = new ArrayList<String>(5);
        exts.add(".txt");
        exts.add(".eaf");
        exts.add(".etf");
        exts.add(".pfsx");
        exts.add(".db");
        block6: for (File f : files) {
            if (f.isDirectory()) {
                if (!recursive.booleanValue()) continue;
                this.createTranscriptions(f, templatePath, destinationPath, recursive, combineVideos, prefixBased);
                continue;
            }
            path = f.getName().toLowerCase();
            if (path.startsWith(".")) continue;
            for (String s : exts) {
                if (!path.endsWith(s)) continue;
                continue block6;
            }
            if (path.endsWith(".wav")) {
                waveList.add(f);
                continue;
            }
            fileList.add(f);
        }
        fileList.addAll(waveList);
        if (templatePath != null) {
            trans = new TranscriptionImpl(templatePath);
        } else {
            trans = new TranscriptionImpl();
            LinguisticType type = new LinguisticType("default-lt");
            TierImpl tier = new TierImpl("default", "", trans, type);
            trans.addLinguisticType(type);
            trans.addTier(tier);
            tier.setDefaultLocale(null);
        }
        ArrayList<File> processedFiles = new ArrayList<File>();
        for (File f : fileList) {
            MediaDescriptor md;
            if (processedFiles.contains(f)) continue;
            path = f.getAbsolutePath();
            int index = path.lastIndexOf(46);
            String withoutExt = null;
            if (index > -1) {
                withoutExt = path.substring(0, index);
                if (!waveList.contains(f)) {
                    File wavFile = this.findWavFile(waveList, withoutExt);
                    List<File> otherVideos = null;
                    if (combineVideos.booleanValue() && (otherVideos = this.findCorVideo(fileList, f, prefixBased)) != null && otherVideos.size() > 0) {
                        processedFiles.addAll(otherVideos);
                    }
                    Vector<MediaDescriptor> mds = new Vector<MediaDescriptor>(6);
                    MediaDescriptor md1 = MediaDescriptorUtil.createMediaDescriptor(path);
                    mds.add(md1);
                    md = null;
                    if (wavFile != null) {
                        processedFiles.add(wavFile);
                        md = MediaDescriptorUtil.createMediaDescriptor(wavFile.getAbsolutePath());
                        md.extractedFrom = md1.mediaURL;
                        mds.add(md);
                    }
                    if (otherVideos != null) {
                        for (File ov : otherVideos) {
                            if (ov == null) continue;
                            md = MediaDescriptorUtil.createMediaDescriptor(ov.getAbsolutePath());
                            mds.add(md);
                        }
                    }
                    trans.setMediaDescriptors(mds);
                } else {
                    Vector<MediaDescriptor> mds = new Vector<MediaDescriptor>(1);
                    MediaDescriptor md2 = MediaDescriptorUtil.createMediaDescriptor(f.getAbsolutePath());
                    mds.add(md2);
                    trans.setMediaDescriptors(mds);
                }
            } else {
                withoutExt = path;
                MediaDescriptor md3 = MediaDescriptorUtil.createMediaDescriptor(path);
                Vector<MediaDescriptor> mds = new Vector<MediaDescriptor>(1);
                mds.add(md3);
                trans.setMediaDescriptors(mds);
            }
            boolean saveToSave = false;
            String nextEafPath = null;
            if (destinationPath == null) {
                nextEafPath = withoutExt + ".eaf";
                File eafFile = new File(nextEafPath);
                int count = 0;
                do {
                    try {
                        if (!eafFile.exists()) {
                            saveToSave = true;
                            break;
                        }
                        nextEafPath = withoutExt + "-" + ++count + ".eaf";
                        eafFile = new File(nextEafPath);
                    }
                    catch (SecurityException se) {
                        nextEafPath = withoutExt + "-" + ++count + ".eaf";
                        eafFile = new File(nextEafPath);
                    }
                } while (count < 20);
            } else {
                String fileName = withoutExt;
                int index2 = fileName.lastIndexOf(File.separatorChar);
                fileName = index2 > 0 ? fileName.substring(index2) : File.separator + fileName;
                nextEafPath = destinationPath + fileName + ".eaf";
                File eafFile = new File(nextEafPath);
                int count = 0;
                do {
                    try {
                        if (!eafFile.exists()) {
                            saveToSave = true;
                            break;
                        }
                        nextEafPath = destinationPath + fileName + "-" + ++count + ".eaf";
                        eafFile = new File(nextEafPath);
                    }
                    catch (SecurityException se) {
                        nextEafPath = destinationPath + fileName + "-" + ++count + ".eaf";
                        eafFile = new File(nextEafPath);
                    }
                } while (count < 20);
            }
            if (saveToSave) {
                trans.setPathName(nextEafPath);
                String fullEAFURL = FileUtility.pathToURLString(trans.getFullPath());
                Vector mediaDescriptors = trans.getMediaDescriptors();
                for (int i = 0; i < mediaDescriptors.size(); ++i) {
                    String relUrl;
                    md = (MediaDescriptor)mediaDescriptors.elementAt(i);
                    md.relativeMediaURL = relUrl = FileUtility.getRelativePath(fullEAFURL, md.mediaURL);
                }
                TranscriptionStore store = ACMTranscriptionStore.getCurrentTranscriptionStore();
                try {
                    store.storeTranscription(trans, null, null, 0);
                    ++this.count;
                    this.report("Created: " + nextEafPath);
                }
                catch (IOException ioe) {
                    ClientLogger.LOG.warning("Cannot save a new transcription file: " + nextEafPath);
                }
                continue;
            }
            ClientLogger.LOG.warning("Cannot save a new transcription for file: " + path);
        }
        for (File f : waveList) {
        }
    }

    private File findWavFile(List<File> waveList, String withoutExt) {
        if (waveList == null || withoutExt == null) {
            return null;
        }
        for (File f : waveList) {
            String wavFile = f.getAbsolutePath();
            int index = wavFile.lastIndexOf(46);
            if (index > -1) {
                wavFile = wavFile.substring(0, index);
            }
            if (!withoutExt.equals(wavFile)) continue;
            return f;
        }
        return null;
    }

    private List<File> findCorVideo(List<File> fileList, File first, boolean prefixBased) {
        if (first == null || fileList == null) {
            return null;
        }
        String trunk = first.getName();
        int index = trunk.lastIndexOf(46);
        if (index > -1) {
            trunk = trunk.substring(0, index);
        }
        ArrayList<File> result = null;
        block0: for (File f : fileList) {
            String sub2;
            String sub1;
            int hindex2;
            int hindex;
            if (f == first) continue;
            String trunk2 = f.getName();
            int index2 = trunk2.lastIndexOf(46);
            if (index2 > -1) {
                trunk2 = trunk2.substring(0, index2);
            }
            if (prefixBased) {
                for (Character ch : this.delimiters) {
                    hindex = trunk.indexOf(ch.charValue());
                    hindex2 = trunk2.indexOf(ch.charValue());
                    if (hindex <= -1 || hindex2 <= -1) continue;
                    sub1 = trunk.substring(hindex);
                    sub2 = trunk2.substring(hindex2);
                    if (sub1.length() == 0 || sub2.length() == 0 || !sub1.equals(sub2)) continue;
                    if (result == null) {
                        result = new ArrayList<File>(6);
                    }
                    result.add(f);
                    continue block0;
                }
                continue;
            }
            for (Character ch : this.delimiters) {
                hindex = trunk.lastIndexOf(ch.charValue());
                hindex2 = trunk2.lastIndexOf(ch.charValue());
                if (hindex <= -1 || hindex2 <= -1) continue;
                sub1 = trunk.substring(0, hindex);
                sub2 = trunk2.substring(0, hindex2);
                if (sub1.length() == 0 || sub2.length() == 0 || !sub1.equals(sub2)) continue;
                if (result == null) {
                    result = new ArrayList(6);
                }
                result.add(f);
            }
        }
        return result;
    }

    @Override
    public ProcessReport getProcessReport() {
        return this.report;
    }

    @Override
    public void report(String message) {
        if (this.report != null) {
            this.report.append(message);
        }
    }

    @Override
    public void setProcessReport(ProcessReport report) {
        this.report = report;
    }
}

