/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class DeleteSelectedAnnotationsCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private List<DefaultMutableTreeNode> delAnnRecords;

    public DeleteSelectedAnnotationsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void redo() {
        this.deleteAnnotations();
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.delAnnRecords != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            ((TranscriptionImpl)this.transcription).setNotifying(false);
            this.setWaitCursor(true);
            for (DefaultMutableTreeNode n : this.delAnnRecords) {
                AnnotationRecreator.createAnnotationFromTree(this.transcription, n, true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
            ((TranscriptionImpl)this.transcription).setNotifying(true);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        if (arguments != null && arguments[0] instanceof List) {
            List selectedAnnos = (List)arguments[0];
            this.delAnnRecords = new ArrayList<DefaultMutableTreeNode>(selectedAnnos.size());
            this.setWaitCursor(true);
            this.storeAnnotationTrees(selectedAnnos);
            this.deleteAnnotations();
            this.setWaitCursor(false);
        }
    }

    private void storeAnnotationTrees(List selectedAnnos) {
        if (selectedAnnos != null) {
            block0: for (int i = 0; i < selectedAnnos.size(); ++i) {
                Object next = selectedAnnos.get(i);
                if (!(next instanceof AbstractAnnotation)) continue;
                AbstractAnnotation annotation = (AbstractAnnotation)next;
                for (int j = 0; j < selectedAnnos.size(); ++j) {
                    Object next2;
                    if (j == i || !((next2 = selectedAnnos.get(j)) instanceof AbstractAnnotation)) continue;
                    AbstractAnnotation annotation2 = (AbstractAnnotation)next2;
                    if (((TierImpl)annotation.getTier()).hasAncestor(annotation2.getTier()) && annotation.getBeginTimeBoundary() >= annotation2.getBeginTimeBoundary() && annotation.getEndTimeBoundary() <= annotation2.getEndTimeBoundary()) continue block0;
                }
                DefaultMutableTreeNode node = AnnotationRecreator.createTreeForAnnotation(annotation);
                if (node == null) continue;
                this.delAnnRecords.add(node);
            }
        }
    }

    private void deleteAnnotations() {
        if (this.delAnnRecords != null && this.delAnnRecords.size() > 0) {
            ArrayList<AbstractAnnotation> toDelete = new ArrayList<AbstractAnnotation>(this.delAnnRecords.size());
            TierImpl tier = null;
            for (DefaultMutableTreeNode defaultMutableTreeNode : this.delAnnRecords) {
                AnnotationDataRecord record = (AnnotationDataRecord)defaultMutableTreeNode.getUserObject();
                tier = (TierImpl)this.transcription.getTierWithId(record.getTierName());
                if (tier == null) {
                    ClientLogger.LOG.warning("The tier could not be found: " + record.getTierName());
                    continue;
                }
                AbstractAnnotation annotation = (AbstractAnnotation)tier.getAnnotationAtTime((record.getBeginTime() + record.getEndTime()) / 2L);
                if (annotation == null) continue;
                toDelete.add(annotation);
            }
            ((TranscriptionImpl)this.transcription).setNotifying(false);
            for (Annotation annotation : toDelete) {
                ((TierImpl)annotation.getTier()).removeAnnotation(annotation);
            }
            ((TranscriptionImpl)this.transcription).setNotifying(true);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }
}

