/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.MutableInt;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ExportOverlapsCommand
implements Command {
    private String name;
    private Writer singleWriter;
    final String NL = "\n";
    final String TAB = "\t";
    final String Y = "1";
    final String N = "0";

    public ExportOverlapsCommand(String name) {
        this.name = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        Writer outWriter = (Writer)receiver;
        String refTier = (String)arguments[1];
        List compTiers = (List)arguments[2];
        if (outWriter == null && arguments.length > 3) {
            try {
                this.singleWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream((String)arguments[3]), "UTF-8"));
                this.singleWriter.write("Begin time");
                this.singleWriter.write("\t");
                this.singleWriter.write("End time");
                this.singleWriter.write("\t");
                this.singleWriter.write(refTier);
                this.singleWriter.write("\t");
                for (int i = 0; i < compTiers.size(); ++i) {
                    String nm = (String)compTiers.get(i);
                    this.singleWriter.write(nm + "-ov");
                    this.singleWriter.write("\t");
                    this.singleWriter.write(nm + "-same");
                    this.singleWriter.write("\t");
                    this.singleWriter.write(nm + "ov-dur");
                    this.singleWriter.write("\t");
                    this.singleWriter.write(nm + "-no-ann");
                    this.singleWriter.write("\t");
                    this.singleWriter.write(nm + "-value");
                    this.singleWriter.write("\t");
                }
                this.singleWriter.write("\n");
                outWriter = this.singleWriter;
            }
            catch (FileNotFoundException fnfe) {
                ClientLogger.LOG.warning("Export failed: " + fnfe.getMessage());
                return;
            }
            catch (UnsupportedEncodingException uee) {
                ClientLogger.LOG.warning("Export failed: " + uee.getMessage());
                return;
            }
            catch (IOException ioe) {
                ClientLogger.LOG.warning("Export failed: " + ioe.getMessage());
                return;
            }
        }
        if (outWriter == null) {
            ClientLogger.LOG.warning("Export failed: no file to write to.");
            return;
        }
        try {
            TranscriptionImpl trans = new TranscriptionImpl((String)arguments[0]);
            this.exportOverlaps(outWriter, trans, refTier, compTiers);
            outWriter.flush();
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Export failed: " + ex.getMessage());
        }
        if (this.singleWriter != null) {
            try {
                this.singleWriter.flush();
                this.singleWriter.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void exportOverlaps(Writer outWriter, TranscriptionImpl tr, String refTier, List<String> compTiers) throws IOException {
        outWriter.write(tr.getPathName());
        outWriter.write("\n");
        TierImpl tier = (TierImpl)tr.getTierWithId(refTier);
        if (tier == null) {
            ClientLogger.LOG.warning("The reference tier was not found in this transcription.");
            return;
        }
        Vector refAnnos = tier.getAnnotations();
        int numRows = refAnnos.size();
        if (numRows == 0) {
            return;
        }
        int numComs = compTiers.size();
        HashMap<String, Vector> annosForTiers = new HashMap<String, Vector>(compTiers.size());
        HashMap<String, MutableInt> curAnnIndex = new HashMap<String, MutableInt>(compTiers.size());
        for (int i = 0; i < compTiers.size(); ++i) {
            String name = compTiers.get(i);
            TierImpl nt = (TierImpl)tr.getTierWithId(name);
            if (nt != null) {
                annosForTiers.put(name, nt.getAnnotations());
            } else {
                annosForTiers.put(name, null);
            }
            curAnnIndex.put(name, new MutableInt(0));
        }
        long bt = 0L;
        long et = 0L;
        int k = 0;
        for (int i = 0; i < refAnnos.size(); ++i) {
            AbstractAnnotation aa1 = (AbstractAnnotation)refAnnos.get(i);
            bt = aa1.getBeginTimeBoundary();
            et = aa1.getEndTimeBoundary();
            outWriter.write(String.valueOf(bt));
            outWriter.write("\t");
            outWriter.write(String.valueOf(et));
            outWriter.write("\t");
            outWriter.write(String.valueOf(et - bt));
            outWriter.write("\t");
            outWriter.write(aa1.getValue());
            outWriter.write("\t");
            for (int j = 0; j < numComs; ++j) {
                long oet;
                long obt;
                String tName = compTiers.get(j);
                List annos = (List)annosForTiers.get(tName);
                if (annos == null) {
                    outWriter.write("\t\t\t\t\t\t\t\t");
                    continue;
                }
                String annValue = new String();
                int numOv = 0;
                long dur = 0L;
                boolean same = false;
                AbstractAnnotation nextAfterRef = null;
                for (k = ((MutableInt)curAnnIndex.get((Object)tName)).intValue; k < annos.size(); ++k) {
                    AbstractAnnotation aa2 = (AbstractAnnotation)annos.get(k);
                    obt = aa2.getBeginTimeBoundary();
                    oet = aa2.getEndTimeBoundary();
                    if (oet <= bt) continue;
                    if (obt >= et) {
                        ((MutableInt)curAnnIndex.get((Object)tName)).intValue = k;
                        nextAfterRef = aa2;
                        break;
                    }
                    annValue = annValue.length() == 0 ? aa2.getValue() : annValue + ", " + aa2.getValue();
                    same = ++numOv == 1 && aa2.getValue().equals(aa1.getValue());
                    dur += Math.min(et, oet) - Math.max(bt, obt);
                    if (oet <= et || obt >= et) continue;
                    ((MutableInt)curAnnIndex.get((Object)tName)).intValue = k;
                    if (k >= annos.size() - 2) break;
                    nextAfterRef = (AbstractAnnotation)annos.get(k + 1);
                    break;
                }
                if (numOv == 0) {
                    outWriter.write("0");
                    outWriter.write("\t");
                    outWriter.write("0");
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(dur));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(numOv));
                    outWriter.write("\t");
                    outWriter.write("\t");
                } else {
                    outWriter.write("1");
                    outWriter.write("\t");
                    outWriter.write(same ? "1" : "0");
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(dur));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(numOv));
                    outWriter.write("\t");
                    outWriter.write(annValue);
                    outWriter.write("\t");
                }
                if (nextAfterRef != null) {
                    obt = nextAfterRef.getBeginTimeBoundary();
                    oet = nextAfterRef.getEndTimeBoundary();
                    outWriter.write(String.valueOf(obt - bt));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(obt - et));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(oet - et));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(obt));
                    outWriter.write("\t");
                    outWriter.write(String.valueOf(oet));
                    outWriter.write("\t");
                    outWriter.write(nextAfterRef.getValue());
                    outWriter.write("\t");
                    continue;
                }
                outWriter.write("0");
                outWriter.write("\t");
                outWriter.write("0");
                outWriter.write("\t");
                outWriter.write("0");
                outWriter.write("\t");
                outWriter.write("0");
                outWriter.write("\t");
                outWriter.write("0");
                outWriter.write("\t");
                outWriter.write("\t");
            }
            outWriter.write("\n");
        }
        outWriter.write("\n");
    }
}

