/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.HashMap;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.imports.praat.PraatTextGrid;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ImportPraatGridCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private ArrayList listeners;
    private TranscriptionImpl transcription;
    private PraatTextGrid ptg;
    private String typeName;
    private LinguisticType lt;
    private boolean skipEmptyIntervals;
    private ArrayList tierNames;
    private ArrayList annRecords;

    public ImportPraatGridCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.tierNames != null && this.tierNames.size() > 0) {
            this.setWaitCursor(true);
            for (int i = 0; i < this.tierNames.size(); ++i) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId((String)this.tierNames.get(i));
                this.transcription.removeTier(t);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.tierNames != null && this.tierNames.size() > 0) {
            this.setWaitCursor(true);
            if (this.typeName != null) {
                this.lt = this.transcription.getLinguisticTypeByName(this.typeName);
                if (this.lt != null) {
                    TierImpl t = null;
                    for (int i = 0; i < this.tierNames.size(); ++i) {
                        String name = (String)this.tierNames.get(i);
                        t = new TierImpl(name, "", this.transcription, this.lt);
                        if (this.transcription.getTierWithId(name) != null) continue;
                        this.transcription.addTier(t);
                    }
                    this.transcription.setNotifying(false);
                    int curPropMode = 0;
                    curPropMode = this.transcription.getTimeChangePropagationMode();
                    if (curPropMode != 0) {
                        this.transcription.setTimeChangePropagationMode(0);
                    }
                    for (int i = 0; i < this.annRecords.size(); ++i) {
                        Annotation ann;
                        AnnotationDataRecord record = (AnnotationDataRecord)this.annRecords.get(i);
                        if (t == null || !t.getName().equals(record.getTierName())) {
                            t = (TierImpl)this.transcription.getTierWithId(record.getTierName());
                        }
                        if (t == null || (ann = t.createAnnotation(record.getBeginTime(), record.getEndTime())) == null || record.getValue() == null) continue;
                        ann.setValue(record.getValue());
                    }
                    this.transcription.setTimeChangePropagationMode(curPropMode);
                    this.transcription.setNotifying(true);
                }
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (TranscriptionImpl)receiver;
        this.ptg = (PraatTextGrid)arguments[0];
        if (this.ptg == null) {
            this.progressInterrupt("No Praat TextGrid object specified.");
        }
        if (arguments.length > 1 && arguments[2] instanceof Boolean) {
            this.skipEmptyIntervals = (Boolean)arguments[2];
        }
        this.typeName = (String)arguments[1];
        if (this.typeName != null) {
            this.lt = this.transcription.getLinguisticTypeByName(this.typeName);
            if (this.lt != null) {
                this.tierNames = new ArrayList();
                this.annRecords = new ArrayList();
                PraatTGThread ptgThread = new PraatTGThread(ImportPraatGridCommand.class.getName());
                try {
                    ptgThread.start();
                }
                catch (Exception exc) {
                    this.transcription.setNotifying(true);
                    LOG.severe("Exception in calculation of overlaps: " + exc.getMessage());
                    this.progressInterrupt("An exception occurred: " + exc.getMessage());
                }
            } else {
                this.progressInterrupt("The Linguistic Type does not exist.");
            }
        } else {
            this.progressInterrupt("No Linguistic Type specified for new tiers.");
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    class PraatTGThread
    extends Thread {
        PraatTGThread() {
        }

        PraatTGThread(String name) {
            super(name);
        }

        @Override
        public void interrupt() {
            super.interrupt();
            ImportPraatGridCommand.this.progressInterrupt("Operation interrupted...");
        }

        @Override
        public void run() {
            int tierCount = ImportPraatGridCommand.this.ptg.getTierNames().size();
            if (tierCount == 0) {
                ImportPraatGridCommand.this.progressInterrupt("No tiers detected in TextGrid file");
                return;
            }
            HashMap<String, String> nameMap = new HashMap<String, String>(tierCount);
            float perTier = 10.0f / (float)tierCount;
            for (int i = 0; i < tierCount; ++i) {
                String name = (String)ImportPraatGridCommand.this.ptg.getTierNames().get(i);
                if (ImportPraatGridCommand.this.transcription.getTierWithId(name) != null) {
                    int count = 40;
                    for (int z = 1; z < count; ++z) {
                        String nextNm = name + "-" + z;
                        if (ImportPraatGridCommand.this.transcription.getTierWithId(nextNm) != null) continue;
                        nameMap.put(nextNm, name);
                        name = nextNm;
                        break;
                    }
                } else {
                    nameMap.put(name, name);
                }
                TierImpl t = new TierImpl(name, "", ImportPraatGridCommand.this.transcription, ImportPraatGridCommand.this.lt);
                if (ImportPraatGridCommand.this.transcription.getTierWithId(name) == null) {
                    ImportPraatGridCommand.this.transcription.addTier(t);
                    ImportPraatGridCommand.this.tierNames.add(name);
                    ImportPraatGridCommand.this.progressUpdate((int)((float)(i + 1) * perTier), "Added tier: " + name);
                    continue;
                }
                ImportPraatGridCommand.this.progressUpdate((int)((float)(i + 1) * perTier), "Could not add tier: " + name);
            }
            ImportPraatGridCommand.this.transcription.setNotifying(false);
            int curPropMode = 0;
            curPropMode = ImportPraatGridCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                ImportPraatGridCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            tierCount = ImportPraatGridCommand.this.tierNames.size();
            perTier = 90.0f / (float)tierCount;
            for (int i = 0; i < tierCount; ++i) {
                String name = (String)ImportPraatGridCommand.this.tierNames.get(i);
                TierImpl t = (TierImpl)ImportPraatGridCommand.this.transcription.getTierWithId(name);
                String orgName = (String)nameMap.get(name);
                ArrayList anns = (ArrayList)ImportPraatGridCommand.this.ptg.getAnnotationRecords(orgName);
                if (anns.size() == 0 || t == null) {
                    ImportPraatGridCommand.this.progressUpdate(10 + (int)((float)(i + 1) * perTier), "Added annotations of tier: " + name);
                    continue;
                }
                float perAnn = perTier / (float)anns.size();
                AnnotationDataRecord record = null;
                ImportPraatGridCommand.this.progressUpdate(10 + (int)((float)i * perTier), "Creating annotations...");
                for (int j = 0; j < anns.size(); ++j) {
                    record = (AnnotationDataRecord)anns.get(j);
                    if (ImportPraatGridCommand.this.skipEmptyIntervals && (record.getValue() == null || record.getValue().length() == 0)) continue;
                    Annotation ann = t.createAnnotation(record.getBeginTime(), record.getEndTime());
                    if (ann != null) {
                        ann.setValue(record.getValue());
                        ImportPraatGridCommand.this.annRecords.add(new AnnotationDataRecord(ann));
                    }
                    ImportPraatGridCommand.this.progressUpdate((int)(10.0f + (float)i * perTier + (float)(j + 1) * perAnn), null);
                }
                ImportPraatGridCommand.this.progressUpdate(10 + (int)((float)(i + 1) * perTier), "Added annotations of tier: " + name);
            }
            ImportPraatGridCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            ImportPraatGridCommand.this.transcription.setNotifying(true);
            ImportPraatGridCommand.this.progressComplete("Operation complete...");
        }
    }
}

