/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.io.File;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.Command;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class ImportPrefsCommand
implements Command {
    private String commandName;
    private Transcription transcription;

    public ImportPrefsCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.transcription = (Transcription)receiver;
        if (this.transcription == null) {
            return;
        }
        String filePath = this.promptForImportFile();
        if (filePath == null) {
            return;
        }
        Preferences.importPreferences(this.transcription, filePath);
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private String promptForImportFile() {
        String prefDir = (String)Preferences.get("", null);
        if (prefDir == null) {
            prefDir = System.getProperty("user.dir");
        }
        FileChooser chooser = new FileChooser(ELANCommandFactory.getRootFrame(this.transcription));
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.ELAN_XML_PREFS_EXT, false, "LastUsedExportDir", 0, null);
        File prefFile = chooser.getSelectedFile();
        if (prefFile != null) {
            return prefFile.getAbsolutePath();
        }
        return null;
    }
}

