/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import java.util.Vector;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.imports.MergeUtil;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.server.corpora.clomimpl.abstr.ParseException;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.EAFSkeletonParser;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.util.ControlledVocabulary;

public class ImportTiersCommand
implements UndoableCommand,
ClientLogger {
    private String commandName;
    private TranscriptionImpl transcription;
    private ArrayList tiersAdded;
    private ArrayList typesAdded;
    private ArrayList cvsAdded;

    public ImportTiersCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void undo() {
        int i;
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        if (this.tiersAdded == null) {
            LOG.warning("No tiers have been added.");
            return;
        }
        for (i = 0; i < this.tiersAdded.size(); ++i) {
            this.transcription.removeTier((TierImpl)this.tiersAdded.get(i));
        }
        for (i = 0; i < this.typesAdded.size(); ++i) {
            this.transcription.removeLinguisticType((LinguisticType)this.typesAdded.get(i));
        }
        for (i = 0; i < this.cvsAdded.size(); ++i) {
            this.transcription.removeControlledVocabulary((ControlledVocabulary)this.cvsAdded.get(i));
        }
    }

    @Override
    public void redo() {
        int i;
        if (this.transcription == null) {
            LOG.warning("The transcription is null.");
            return;
        }
        if (this.tiersAdded == null) {
            LOG.warning("No tiers can be added.");
            return;
        }
        for (i = 0; i < this.cvsAdded.size(); ++i) {
            this.transcription.addControlledVocabulary((ControlledVocabulary)this.cvsAdded.get(i));
        }
        for (i = 0; i < this.typesAdded.size(); ++i) {
            this.transcription.addLinguisticType((LinguisticType)this.typesAdded.get(i));
        }
        for (i = 0; i < this.tiersAdded.size(); ++i) {
            this.transcription.addTier((TierImpl)this.tiersAdded.get(i));
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        int i;
        this.transcription = (TranscriptionImpl)receiver;
        String fileName = (String)arguments[0];
        if (fileName == null) {
            LOG.warning("The filename is null");
            return;
        }
        fileName = FileUtility.pathToURLString(fileName).substring(5);
        TranscriptionImpl srcTrans = null;
        try {
            int i2;
            EAFSkeletonParser parser = new EAFSkeletonParser(fileName);
            parser.parse();
            ArrayList tiers = parser.getTiers();
            ArrayList tierOrder = parser.getTierOrder();
            ArrayList types = parser.getLinguisticTypes();
            ArrayList cvs = parser.getControlledVocabularies();
            srcTrans = new TranscriptionImpl();
            srcTrans.setLinguisticTypes(new Vector(types));
            for (i2 = 0; i2 < tierOrder.size(); ++i2) {
                String tierName = (String)tierOrder.get(i2);
                for (int j = 0; j < tiers.size(); ++j) {
                    TierImpl tier = (TierImpl)tiers.get(j);
                    if (!tierName.equals(tier.getName())) continue;
                    srcTrans.addTier(tier);
                }
            }
            for (i2 = 0; i2 < cvs.size(); ++i2) {
                srcTrans.addControlledVocabulary((ControlledVocabulary)cvs.get(i2));
            }
        }
        catch (ParseException pe) {
            LOG.warning(pe.getMessage());
            pe.printStackTrace();
            return;
        }
        ArrayList currentTiers = new ArrayList(this.transcription.getTiers());
        ArrayList currentTypes = new ArrayList(this.transcription.getLinguisticTypes());
        ArrayList currentCvs = new ArrayList(this.transcription.getControlledVocabularies());
        MergeUtil mergeUtil = new MergeUtil();
        ArrayList tiersAddable = mergeUtil.getAddableTiers(srcTrans, this.transcription, null);
        if (tiersAddable == null || tiersAddable.size() == 0) {
            LOG.warning("There are no tiers that can be imported");
            this.transcription.setNotifying(true);
            return;
        }
        tiersAddable = mergeUtil.sortTiers(tiersAddable);
        mergeUtil.addTiersTypesAndCVs(srcTrans, this.transcription, tiersAddable);
        this.tiersAdded = new ArrayList();
        this.typesAdded = new ArrayList();
        this.cvsAdded = new ArrayList();
        for (i = 0; i < this.transcription.getTiers().size(); ++i) {
            if (currentTiers.contains(this.transcription.getTiers().get(i))) continue;
            this.tiersAdded.add(this.transcription.getTiers().get(i));
        }
        for (i = 0; i < this.transcription.getLinguisticTypes().size(); ++i) {
            if (currentTypes.contains(this.transcription.getLinguisticTypes().get(i))) continue;
            this.typesAdded.add(this.transcription.getLinguisticTypes().get(i));
        }
        for (i = 0; i < this.transcription.getControlledVocabularies().size(); ++i) {
            if (currentCvs.contains(this.transcription.getControlledVocabularies().get(i))) continue;
            this.cvsAdded.add(this.transcription.getControlledVocabularies().get(i));
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

