/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.client.annotator.util.TierNameCompare;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AlignableAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.dobes.TierRecord;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class MergeTierGroupCommand
implements UndoableCommand {
    private ArrayList listeners;
    private String commandName;
    private TranscriptionImpl transcription;
    private String sourceTierName1;
    private String sourceTierName2;
    private String destTierName;
    private ArrayList<TierRecord> tierRecords;
    private ArrayList<DefaultMutableTreeNode> annRecords;
    private String copySuffix;

    public MergeTierGroupCommand(String name) {
        this.commandName = name;
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TierImpl destTier;
        this.transcription = (TranscriptionImpl)receiver;
        this.sourceTierName1 = (String)arguments[0];
        this.sourceTierName2 = (String)arguments[1];
        this.copySuffix = (String)arguments[2];
        TierImpl sourceTier1 = (TierImpl)this.transcription.getTierWithId(this.sourceTierName1);
        TierImpl sourceTier2 = (TierImpl)this.transcription.getTierWithId(this.sourceTierName2);
        if (sourceTier1 == null || sourceTier2 == null) {
            this.progressInterrupt("One of the sourcetiers could not be found");
            return;
        }
        if (this.copySuffix == null) {
            this.copySuffix = "MergedGroup";
            ClientLogger.LOG.warning("Name of destination tier is null, changed to MergedGroup");
        }
        if ((destTier = (TierImpl)this.transcription.getTierWithId(this.sourceTierName1 + this.copySuffix)) != null) {
            int count = 1;
            String cName = this.copySuffix + "-";
            while (destTier != null) {
                cName = cName + count;
                destTier = (TierImpl)this.transcription.getTierWithId(this.sourceTierName1 + cName);
                ++count;
            }
            ClientLogger.LOG.warning("Tier " + this.sourceTierName1 + this.copySuffix + " already exists, changed name to " + this.sourceTierName1 + cName);
            this.copySuffix = cName;
        }
        this.destTierName = this.sourceTierName1 + this.copySuffix;
        this.progressUpdate(5, "Creating tier group: " + this.destTierName);
        MergeThread mergeThread = new MergeThread(MergeTierGroupCommand.class.getName());
        try {
            mergeThread.start();
        }
        catch (Exception exc) {
            this.transcription.setNotifying(true);
            ClientLogger.LOG.severe("Exception in calculation of overlaps: " + exc.getMessage());
            this.progressInterrupt("An exception occurred: " + exc.getMessage());
        }
    }

    @Override
    public void undo() {
        if (this.transcription != null && this.destTierName != null) {
            this.setWaitCursor(true);
            TierImpl destTier = (TierImpl)this.transcription.getTierWithId(this.destTierName);
            if (destTier != null) {
                this.transcription.removeTier(destTier);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void redo() {
        if (this.transcription != null && this.destTierName != null) {
            int curPropMode = 0;
            curPropMode = this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                this.transcription.setTimeChangePropagationMode(0);
            }
            this.setWaitCursor(true);
            TierRecord tr = null;
            for (int i = 0; i < this.tierRecords.size(); ++i) {
                TierImpl pt = null;
                tr = this.tierRecords.get(i);
                if (this.transcription.getTierWithId(tr.getName()) == null) {
                    if (tr.getParentTier() != null && (pt = (TierImpl)this.transcription.getTierWithId(tr.getParentTier())) == null) {
                        ClientLogger.LOG.severe("Cannot recreate tier: " + tr.getName() + " because the parent tier was not found");
                        continue;
                    }
                    LinguisticType lt = this.transcription.getLinguisticTypeByName(tr.getLinguisticType());
                    if (lt == null) {
                        ClientLogger.LOG.severe("Cannot recreate tier: " + tr.getName() + " because the linguistic type was not found");
                        continue;
                    }
                    TierImpl tt = new TierImpl(pt, tr.getName(), tr.getParticipant(), this.transcription, lt);
                    this.transcription.addTier(tt);
                    tt.setAnnotator(tr.getAnnotator());
                    if (tr.getDefaultLocale() == null) continue;
                    Locale l = new Locale(tr.getDefaultLocale());
                    tt.setDefaultLocale(l);
                    continue;
                }
                ClientLogger.LOG.warning("Tier already exists!");
            }
            if (this.transcription.getTierWithId(this.destTierName) == null) {
                ClientLogger.LOG.severe("Could not recreate tier group, exiting...");
                this.setWaitCursor(false);
                this.transcription.setTimeChangePropagationMode(curPropMode);
                return;
            }
            if (this.annRecords != null && this.annRecords.size() > 0) {
                this.transcription.setNotifying(false);
                for (int i = 0; i < this.annRecords.size(); ++i) {
                    DefaultMutableTreeNode node = this.annRecords.get(i);
                    AbstractAnnotation ann = AnnotationRecreator.createAnnotationFromTree(this.transcription, node);
                    if (ann != null) continue;
                    ClientLogger.LOG.warning("Could not recreate annotation: " + ((AnnotationDataRecord)node.getUserObject()).getValue());
                }
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
            this.transcription.setTimeChangePropagationMode(curPropMode);
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }

    private TierRecord recordForTier(TierImpl t) {
        TierRecord tr = new TierRecord();
        tr.setAnnotator(t.getAnnotator());
        Locale defLoc = t.getDefaultLocale();
        if (defLoc != null) {
            tr.setDefaultLocale(defLoc.getLanguage());
        }
        tr.setLinguisticType(t.getLinguisticType().getLinguisticTypeName());
        tr.setName(t.getName());
        tr.setParticipant(t.getParticipant());
        if (t.hasParentTier()) {
            tr.setParentTier(t.getParentTier().getName());
        }
        return tr;
    }

    private void createChildTiers(TierImpl parent, List children, String copySuffix) {
        if (parent == null || children == null || children.size() == 0) {
            return;
        }
        for (int i = 0; i < children.size(); ++i) {
            TierImpl ch = (TierImpl)children.get(i);
            String nch = ch.getName() + copySuffix;
            TierImpl ti = new TierImpl(parent, nch, ch.getParticipant(), (Transcription)parent.getParent(), ch.getLinguisticType());
            ti.setAnnotator(ch.getAnnotator());
            ti.setDefaultLocale(ch.getDefaultLocale());
            ((Transcription)parent.getParent()).addTier(ti);
            this.tierRecords.add(this.recordForTier(ti));
            this.createChildTiers(ti, ch.getChildTiers(), copySuffix);
        }
    }

    private void setWaitCursor(boolean showWaitCursor) {
        if (showWaitCursor) {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            ELANCommandFactory.getRootFrame(this.transcription).getRootPane().setCursor(Cursor.getDefaultCursor());
        }
    }

    public synchronized void addProgressListener(ProgressListener pl) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(2);
        }
        this.listeners.add(pl);
    }

    public synchronized void removeProgressListener(ProgressListener pl) {
        if (pl != null && this.listeners != null) {
            this.listeners.remove(pl);
        }
    }

    private void progressUpdate(int percent, String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressUpdated(this, percent, message);
            }
        }
    }

    private void progressComplete(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressCompleted(this, message);
            }
        }
    }

    private void progressInterrupt(String message) {
        if (this.listeners != null) {
            for (int i = 0; i < this.listeners.size(); ++i) {
                ((ProgressListener)this.listeners.get(i)).progressInterrupted(this, message);
            }
        }
    }

    private class MergeThread
    extends Thread {
        public MergeThread() {
        }

        public MergeThread(String name) {
            super(name);
        }

        @Override
        public void interrupt() {
            super.interrupt();
            MergeTierGroupCommand.this.progressInterrupt("Operation interrupted...");
        }

        @Override
        public void run() {
            DefaultMutableTreeNode node;
            TierImpl sourceTier1 = (TierImpl)MergeTierGroupCommand.this.transcription.getTierWithId(MergeTierGroupCommand.this.sourceTierName1);
            TierImpl sourceTier2 = (TierImpl)MergeTierGroupCommand.this.transcription.getTierWithId(MergeTierGroupCommand.this.sourceTierName2);
            TierImpl destTier = new TierImpl(null, MergeTierGroupCommand.this.destTierName, null, MergeTierGroupCommand.this.transcription, sourceTier1.getLinguisticType());
            destTier.setDefaultLocale(sourceTier1.getDefaultLocale());
            destTier.setParticipant(sourceTier1.getParticipant());
            destTier.setAnnotator(sourceTier1.getAnnotator());
            MergeTierGroupCommand.this.transcription.addTier(destTier);
            MergeTierGroupCommand.this.tierRecords = new ArrayList(10);
            MergeTierGroupCommand.this.tierRecords.add(MergeTierGroupCommand.this.recordForTier(destTier));
            MergeTierGroupCommand.this.createChildTiers(destTier, sourceTier1.getChildTiers(), MergeTierGroupCommand.this.copySuffix);
            MergeTierGroupCommand.this.progressUpdate(10, "Created tier group: " + MergeTierGroupCommand.this.destTierName);
            MergeTierGroupCommand.this.transcription.setNotifying(false);
            int curPropMode = 0;
            curPropMode = MergeTierGroupCommand.this.transcription.getTimeChangePropagationMode();
            if (curPropMode != 0) {
                MergeTierGroupCommand.this.transcription.setTimeChangePropagationMode(0);
            }
            TierNameCompare tnCompare = new TierNameCompare();
            int[] indices = tnCompare.findCorrespondingAffix(sourceTier1.getName(), sourceTier2.getName());
            char del = ' ';
            String affix = "";
            if (indices != null && indices[0] > -1) {
                int di;
                del = sourceTier1.getName().charAt(indices[0]);
                if (indices[1] <= -1) {
                    di = sourceTier1.getName().lastIndexOf(del);
                    if (di > -1) {
                        affix = sourceTier1.getName().substring(di);
                    }
                } else {
                    di = sourceTier1.getName().indexOf(del);
                    if (di > -1) {
                        affix = sourceTier1.getName().substring(0, di);
                    }
                }
            }
            MergeTierGroupCommand.this.annRecords = new ArrayList();
            MergeTierGroupCommand.this.progressUpdate(10, "Creating copies of annotations...");
            ArrayList sourceAnns1 = new ArrayList(sourceTier1.getAnnotations());
            int numAnns1 = sourceAnns1.size();
            ArrayList sourceAnns2 = new ArrayList(sourceTier2.getAnnotations());
            int numAnns2 = sourceAnns2.size();
            int numAnn = numAnns1 + numAnns2;
            float perAnn = 90.0f / (float)(numAnn > 0 ? numAnn : 1);
            AlignableAnnotation ann1 = null;
            AlignableAnnotation ann2 = null;
            for (int i = 0; i < numAnns1; ++i) {
                ann1 = (AlignableAnnotation)sourceAnns1.get(i);
                node = AnnotationRecreator.createTreeForAnnotation(ann1);
                tnCompare.addAffixToTierNames(node, MergeTierGroupCommand.this.copySuffix, -1);
                ann2 = (AlignableAnnotation)AnnotationRecreator.createAnnotationFromTree(MergeTierGroupCommand.this.transcription, node);
                MergeTierGroupCommand.this.annRecords.add(AnnotationRecreator.createTreeForAnnotation(ann2));
                MergeTierGroupCommand.this.progressUpdate((int)(10.0f + (float)i * perAnn), null);
            }
            int numSkippedAnnos = 0;
            for (int i = 0; i < numAnns2; ++i) {
                ann1 = (AlignableAnnotation)sourceAnns2.get(i);
                node = AnnotationRecreator.createTreeForAnnotation(ann1);
                tnCompare.adjustTierNames(node, affix, del, indices[1]);
                tnCompare.addAffixToTierNames(node, MergeTierGroupCommand.this.copySuffix, -1);
                ann2 = (AlignableAnnotation)AnnotationRecreator.createAnnotationFromTree(MergeTierGroupCommand.this.transcription, node);
                if (ann2 != null) {
                    MergeTierGroupCommand.this.annRecords.add(AnnotationRecreator.createTreeForAnnotation(ann2));
                } else {
                    if (numSkippedAnnos == 0) {
                        ClientLogger.LOG.warning("Could not recreate annotation on new tier group.");
                    }
                    ++numSkippedAnnos;
                }
                MergeTierGroupCommand.this.progressUpdate((int)(10.0f + (float)numAnns1 * perAnn + (float)i * perAnn), null);
            }
            if (numSkippedAnnos > 1) {
                ClientLogger.LOG.warning(numSkippedAnnos + " annotations could not be recreated.");
            }
            MergeTierGroupCommand.this.transcription.setTimeChangePropagationMode(curPropMode);
            MergeTierGroupCommand.this.transcription.setNotifying(true);
            MergeTierGroupCommand.this.progressComplete("Operation complete...");
        }
    }
}

