/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import mpi.eudico.client.annotator.commands.UndoableCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.ExternalReferenceImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class ModifyAnnotationDatCatCommand
implements UndoableCommand {
    private String commandName;
    private Transcription transcription;
    private AnnotationDataRecord annotationRecord;
    private String oldValue;
    private String newValue;

    public ModifyAnnotationDatCatCommand(String commandName) {
        this.commandName = commandName;
    }

    @Override
    public void redo() {
        TierImpl tier;
        AbstractAnnotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (AbstractAnnotation)(tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.removeExtRef(new ExternalReferenceImpl(this.oldValue, 2));
            if (this.newValue != null) {
                annotation.addExtRef(new ExternalReferenceImpl(this.newValue, 2));
            }
        }
    }

    @Override
    public void undo() {
        TierImpl tier;
        AbstractAnnotation annotation;
        if (this.annotationRecord != null && this.transcription != null && (annotation = (AbstractAnnotation)(tier = (TierImpl)this.transcription.getTierWithId(this.annotationRecord.getTierName())).getAnnotationAtTime(this.annotationRecord.getBeginTime())) != null && annotation.getEndTimeBoundary() == this.annotationRecord.getEndTime()) {
            annotation.removeExtRef(new ExternalReferenceImpl(this.newValue, 2));
            if (this.oldValue != null) {
                annotation.addExtRef(new ExternalReferenceImpl(this.oldValue, 2));
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        AbstractAnnotation annotation = (AbstractAnnotation)receiver;
        if (annotation != null) {
            this.transcription = (Transcription)annotation.getTier().getParent();
        }
        this.annotationRecord = new AnnotationDataRecord(annotation);
        this.newValue = (String)arguments[0];
        this.oldValue = annotation.getExtRefValue(2);
        if (this.oldValue != null) {
            annotation.removeExtRef(new ExternalReferenceImpl(this.oldValue, 2));
        }
        if (this.newValue != null) {
            annotation.addExtRef(new ExternalReferenceImpl(this.newValue, 2));
        }
    }

    @Override
    public String getName() {
        return this.commandName;
    }
}

