/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.PasteAnnotationTreeCommand;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationRecreator;
import mpi.eudico.client.annotator.util.MonitoringLogger;
import mpi.eudico.client.annotator.util.TierNameCompare;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MoveAnnotationToTierCommand
extends PasteAnnotationTreeCommand {
    private DefaultMutableTreeNode movedNode = null;
    private String origTierName = null;

    public MoveAnnotationToTierCommand(String name) {
        super(name);
    }

    @Override
    public void redo() {
        if (this.transcription != null) {
            TierImpl t;
            this.setWaitCursor(true);
            this.transcription.setNotifying(false);
            this.newAnnotation();
            AbstractAnnotation aa = null;
            if (this.record != null && this.origTierName != null && (t = (TierImpl)this.transcription.getTierWithId(this.origTierName)) != null && (aa = (AbstractAnnotation)t.getAnnotationAtTime((this.record.getBeginTime() + this.record.getEndTime()) / 2L)) != null) {
                t.removeAnnotation(aa);
            }
            this.transcription.setNotifying(true);
            this.setWaitCursor(false);
        }
    }

    @Override
    public void undo() {
        boolean setNotifyingOff = false;
        if (this.tier != null && this.newAnnotation != null) {
            this.setWaitCursor(true);
            Annotation aa = this.tier.getAnnotationAtTime((this.newAnnBegin + this.newAnnEnd) / 2L);
            if (aa != null) {
                this.tier.removeAnnotation(aa);
                if (MonitoringLogger.isInitiated()) {
                    MonitoringLogger.getLogger(this.transcription).log(MonitoringLogger.UNDO, MonitoringLogger.NEW_ANNOTATION);
                }
            }
            if (this.tier.isTimeAlignable()) {
                this.transcription.setNotifying(false);
                setNotifyingOff = true;
                this.restoreInUndo();
            }
            if (this.movedNode != null) {
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                AnnotationRecreator.createAnnotationFromTree(this.transcription, this.movedNode, true);
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(this.timePropMode);
                }
            } else if (this.record != null) {
                TierImpl t;
                AbstractAnnotation oa;
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(0);
                }
                if ((oa = (AbstractAnnotation)(t = (TierImpl)this.transcription.getTierWithId(this.origTierName)).createAnnotation(this.record.getBeginTime(), this.record.getEndTime())) != null) {
                    oa.setValue(this.record.getValue());
                    if (this.record.getExtRef() != null) {
                        oa.setExtRef(this.record.getExtRef());
                    }
                }
                if (this.timePropMode != 0) {
                    this.transcription.setTimeChangePropagationMode(this.timePropMode);
                }
            }
            if (setNotifyingOff) {
                this.transcription.setNotifying(true);
            }
            this.setWaitCursor(false);
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        this.tier = (TierImpl)receiver;
        this.destTierName = this.tier.getName();
        this.transcription = (TranscriptionImpl)this.tier.getParent();
        this.changedAnnotations = new ArrayList();
        this.removedAnnotations = new ArrayList();
        AbstractAnnotation aa = (AbstractAnnotation)arguments[0];
        TierImpl srcTier = (TierImpl)aa.getTier();
        this.origTierName = srcTier.getName();
        if (this.tier == null || srcTier == null || this.tier.getParentTier() != null) {
            return;
        }
        if (aa.getParentListeners().size() == 0) {
            this.record = new AnnotationDataRecord(aa);
        } else {
            this.node = AnnotationRecreator.createTreeForAnnotation(aa);
            this.record = (AnnotationDataRecord)this.node.getUserObject();
        }
        this.timePropMode = this.transcription.getTimeChangePropagationMode();
        this.begin = aa.getBeginTimeBoundary();
        this.end = aa.getEndTimeBoundary();
        if (arguments.length > 2) {
            this.begin = (Long)arguments[1];
            this.end = (Long)arguments[2];
        }
        this.newAnnBegin = this.begin;
        this.newAnnEnd = this.end;
        if (this.node != null) {
            this.adjustTierNames(this.node, this.tier.getName());
        } else if (this.record != null) {
            this.record.setTierName(this.tier.getName());
        }
        this.storeForUndo();
        this.newAnnotation();
        if (this.newAnnotation != null) {
            this.movedNode = AnnotationRecreator.createTreeForAnnotation(aa);
            ((TierImpl)aa.getTier()).removeAnnotation(aa);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ELANCommandFactory.getRootFrame(MoveAnnotationToTierCommand.this.transcription).requestFocus();
            }
        });
    }

    @Override
    protected void adjustTimes() {
    }

    protected void adjustTierNames(DefaultMutableTreeNode inNode, String destTierName) {
        AnnotationDataRecord aRecord;
        TierNameCompare tnc;
        int[] indices;
        if (inNode != null && destTierName != null && (indices = (tnc = new TierNameCompare()).findCorrespondingAffix((aRecord = (AnnotationDataRecord)inNode.getUserObject()).getTierName(), destTierName)) != null && indices[0] > -1) {
            char del = aRecord.getTierName().charAt(indices[0]);
            String affix = "";
            if (indices[1] <= -1) {
                int di = destTierName.lastIndexOf(del);
                if (di > -1) {
                    affix = destTierName.substring(di);
                }
            } else {
                int di = destTierName.indexOf(del);
                if (di > -1) {
                    affix = destTierName.substring(0, di);
                }
            }
            tnc.adjustTierNames(inNode, affix, del, indices[1]);
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }
}

