/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.NewAnnotationCommand;
import mpi.eudico.client.annotator.util.AnnotationDataFlavor;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.AnnotationTreeDataFlavor;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class PasteAnnotationCommand
extends NewAnnotationCommand
implements ClientLogger {
    private AnnotationDataRecord record;
    private String destTierName;
    private Long newBeginTime;

    public PasteAnnotationCommand(String name) {
        super(name);
    }

    @Override
    public void undo() {
        super.undo();
    }

    @Override
    public void redo() {
        super.redo();
        if (this.newAnnotation != null && this.record != null) {
            this.newAnnotation.setValue(this.record.getValue());
            if (this.record.getExtRef() != null) {
                ((AbstractAnnotation)this.newAnnotation).setExtRef(this.record.getExtRef());
            }
        }
    }

    @Override
    public void execute(Object receiver, Object[] arguments) {
        TranscriptionImpl tr = (TranscriptionImpl)receiver;
        if (this.canAccessSystemClipboard()) {
            Object contents = null;
            Transferable ta = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            try {
                contents = ta.getTransferData(AnnotationDataFlavor.getInstance());
            }
            catch (UnsupportedFlavorException nfe) {
                try {
                    contents = ta.getTransferData(AnnotationTreeDataFlavor.getInstance());
                }
                catch (Exception e) {
                    LOG.warning("Unsupported flavor on the clipboord: " + nfe.getMessage());
                    return;
                }
            }
            catch (IOException ioe) {
                LOG.warning("I/O error: " + ioe.getMessage());
                return;
            }
            if (contents instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)contents;
                this.record = (AnnotationDataRecord)node.getUserObject();
            } else if (contents instanceof AnnotationDataRecord) {
                this.record = (AnnotationDataRecord)contents;
            } else {
                return;
            }
            this.destTierName = this.record.getTierName();
            if (arguments != null && arguments.length > 0) {
                if (arguments[0] != null) {
                    this.destTierName = (String)arguments[0];
                }
                if (arguments.length > 1) {
                    this.newBeginTime = (Long)arguments[1];
                }
            }
            TierImpl tier = null;
            if (this.destTierName != null) {
                tier = (TierImpl)tr.getTierWithId(this.destTierName);
            }
            if (tier == null && (tier = (TierImpl)ELANCommandFactory.getViewerManager(tr).getMultiTierControlPanel().getActiveTier()) != null) {
                this.destTierName = tier.getName();
            }
            if (tier == null) {
                LOG.warning("Cannot paste annotation: tier not found: " + this.destTierName);
                return;
            }
            Object[] args = new Long[2];
            if (this.newBeginTime != null) {
                if (tier.isTimeAlignable()) {
                    args[0] = this.newBeginTime;
                    args[1] = new Long(this.newBeginTime + (this.record.getEndTime() - this.record.getBeginTime()));
                } else {
                    args[0] = this.newBeginTime;
                    args[1] = this.newBeginTime;
                }
            } else if (tier.isTimeAlignable()) {
                args[0] = new Long(this.record.getBeginTime());
                args[1] = new Long(this.record.getEndTime());
            } else {
                long mid = (this.record.getBeginTime() + this.record.getEndTime()) / 2L;
                args[0] = new Long(mid);
                args[1] = args[0];
            }
            super.execute(tier, args);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ELANCommandFactory.getRootFrame(PasteAnnotationCommand.this.transcription).requestFocus();
                }
            });
        }
    }

    @Override
    void newAnnotation() {
        super.newAnnotation();
        if (this.newAnnotation != null) {
            this.newAnnotation.setValue(this.record.getValue());
            if (this.record.getExtRef() != null) {
                ((AbstractAnnotation)this.newAnnotation).setExtRef(this.record.getExtRef());
            }
        }
    }

    protected boolean canAccessSystemClipboard() {
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                return true;
            }
            catch (SecurityException se) {
                LOG.warning("Cannot access the clipboard");
                return false;
            }
        }
        return true;
    }
}

