/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ELAN;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.prefs.PreferencesReader;
import mpi.eudico.client.annotator.prefs.PreferencesWriter;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.annotator.util.SystemReporting;

public class ShortcutsUtil {
    private static ShortcutsUtil shortcutsUtil;
    public static final String ANN_EDIT_CAT = "Frame.ShortcutFrame.Sub.AnnotationEdit";
    public static final String ANN_NAVIGATION_CAT = "Frame.ShortcutFrame.Sub.AnnotationNavigation";
    public static final String TIER_TYPE_CAT = "Frame.ShortcutFrame.Sub.TierType";
    public static final String SELECTION_CAT = "Frame.ShortcutFrame.Sub.Selection";
    public static final String MEDIA_CAT = "Frame.ShortcutFrame.Sub.MediaNavigation";
    public static final String DOCUMENT_CAT = "Frame.ShortcutFrame.Sub.Document";
    public static final String MISC_CAT = "Frame.ShortcutFrame.Sub.Misc";
    private static final String PREF_FILEPATH;
    private static final String NEW_PREF_FILEPATH;
    private Map<String, Map<String, List<String>>> shortcuttableActionsMap = new LinkedHashMap<String, Map<String, List<String>>>(8);
    private Map<String, Map<String, KeyStroke>> shortcutKeyStrokesMap = new LinkedHashMap<String, Map<String, KeyStroke>>(80);
    private boolean shortcutClash = false;

    private ShortcutsUtil() {
        this.fillActionsMap();
        this.fillShortcutMap();
    }

    public static ShortcutsUtil getInstance() {
        if (shortcutsUtil == null) {
            shortcutsUtil = new ShortcutsUtil();
        }
        return shortcutsUtil;
    }

    private void fillActionsMap() {
        this.shortcuttableActionsMap.put("Shortcuts.Common", this.getCommonShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.SyncMode", this.getSyncModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.TranscriptionMode", this.getTranscModeShortcuttableActionsMap());
        this.shortcuttableActionsMap.put("Menu.Options.SegmentationMode", this.getSegmentModeShortcuttableActionsMap());
    }

    private void fillShortcutMap() {
        if (!this.readCurrentShortcuts()) {
            this.loadDefaultShortcuts();
        }
    }

    private void loadDefaultShortcuts() {
        this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
        this.addActionsWithoutShortcut();
    }

    private Map<String, List<String>> getAnnotationModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.AnnotationMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.NewAnnotation");
        editActions.add("Menu.Annotation.NewAnnotationBefore");
        editActions.add("Menu.Annotation.NewAnnotationAfter");
        editActions.add("CommandActions.KeyCreateAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotation");
        editActions.add("Menu.Annotation.CopyAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotation");
        editActions.add("Menu.Annotation.PasteAnnotationHere");
        editActions.add("Menu.Annotation.PasteAnnotationTree");
        editActions.add("Menu.Annotation.PasteAnnotationTreeHere");
        editActions.add("Menu.Annotation.DuplicateAnnotation");
        editActions.add("CommandActions.CopyToNextAnnotation");
        editActions.add("Menu.Annotation.ModifyAnnotation");
        editActions.add("CommandActions.ModifyAnnotationTime");
        editActions.add("Menu.Annotation.ModifyAnnotationDatCat");
        editActions.add("CommandActions.Annotation_LBound_Left");
        editActions.add("CommandActions.Annotation_LBound_Right");
        editActions.add("CommandActions.Annotation_RBound_Left");
        editActions.add("CommandActions.Annotation_RBound_Right");
        editActions.add("Menu.Annotation.RemoveAnnotationValue");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.ShiftActiveAnnotation");
        editActions.add("CommandActions.OpenInlineEditBox");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("Menu.Tier.RegularAnnotation");
        editActions.add("Menu.Annotation.DeleteAnnotationsInSelection");
        editActions.add("Menu.Annotation.DeleteAnnotationsLeftOf");
        editActions.add("Menu.Annotation.DeleteAnnotationsRightOf");
        editActions.add("Menu.Annotation.DeleteAllLeftOf");
        editActions.add("Menu.Annotation.DeleteAllRightOf");
        editActions.add("Menu.Annotation.ShiftAll");
        editActions.add("Menu.Annotation.ShiftAllLeftOf");
        editActions.add("Menu.Annotation.ShiftAllRightOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsInSelection");
        editActions.add("Menu.Annotation.ShiftAnnotationsLeftOf");
        editActions.add("Menu.Annotation.ShiftAnnotationsRightOf");
        editActions.add("Menu.Annotation.SplitAnnotation");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("CommandActions.PreviousAnnotation");
        navActions.add("CommandActions.PreviousAnnotationEdit");
        navActions.add("CommandActions.NextAnnotation");
        navActions.add("CommandActions.NextAnnotationEdit");
        navActions.add("CommandActions.AnnotationUp");
        navActions.add("CommandActions.AnnotationDown");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("CommandActions.PreviousActiveTier");
        tierActions.add("CommandActions.NextActiveTier");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ClearSelectionAndMode");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        selActions.add("CommandActions.SelectionMode");
        selActions.add("TimeLineViewer.CenterSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.PlayStepAndRepeat");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToPreviousScrollview");
        medNavActions.add("Menu.Play.GoToNextScrollview");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("CommandActions.LoopMode");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("CommandActions.PlaybackRateToggle");
        miscActions.add("CommandActions.PlaybackVolumeToggle");
        miscActions.add("MultiTierViewer.ShiftToolTip");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getAnnotationModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotation", KeyStroke.getKeyStroke(78, 8));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationBefore", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Annotation.NewAnnotationAfter", KeyStroke.getKeyStroke(78, 9));
        shortcutKeyStrokes.put("CommandActions.KeyCreateAnnotation", KeyStroke.getKeyStroke(10, 1));
        shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotation", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Annotation.CopyAnnotationTree", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotation", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationHere", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTree", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Annotation.PasteAnnotationTreeHere", KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8 + 1));
        shortcutKeyStrokes.put("Menu.Annotation.DuplicateAnnotation", KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.CopyToNextAnnotation", KeyStroke.getKeyStroke(68, 3));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotation", KeyStroke.getKeyStroke(77, 8));
        shortcutKeyStrokes.put("CommandActions.ModifyAnnotationTime", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Annotation.ModifyAnnotationDatCat", KeyStroke.getKeyStroke(77, 9));
        shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Left", KeyStroke.getKeyStroke(74, 2));
        shortcutKeyStrokes.put("CommandActions.Annotation_LBound_Right", KeyStroke.getKeyStroke(85, 2));
        shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Left", KeyStroke.getKeyStroke(74, 3));
        shortcutKeyStrokes.put("CommandActions.Annotation_RBound_Right", KeyStroke.getKeyStroke(85, 3));
        shortcutKeyStrokes.put("Menu.Annotation.RemoveAnnotationValue", KeyStroke.getKeyStroke(127, 8));
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(68, 8));
        shortcutKeyStrokes.put("Menu.Annotation.ShiftActiveAnnotation", KeyStroke.getKeyStroke(10, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("CommandActions.OpenInlineEditBox", KeyStroke.getKeyStroke(69, 1));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotation", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("CommandActions.PreviousAnnotationEdit", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("CommandActions.NextAnnotation", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("CommandActions.NextAnnotationEdit", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationUp", KeyStroke.getKeyStroke(38, 8));
        shortcutKeyStrokes.put("CommandActions.AnnotationDown", KeyStroke.getKeyStroke(40, 8));
        shortcutKeyStrokes.put("CommandActions.PreviousActiveTier", KeyStroke.getKeyStroke(38, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.NextActiveTier", KeyStroke.getKeyStroke(40, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ClearSelectionAndMode", KeyStroke.getKeyStroke(90, 3));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("CommandActions.SelectionMode", KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("TimeLineViewer.CenterSelection", KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.PlayStepAndRepeat", KeyStroke.getKeyStroke(32, 10));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToPreviousScrollview", KeyStroke.getKeyStroke(33, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.GoToNextScrollview", KeyStroke.getKeyStroke(34, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.PlaybackRateToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("CommandActions.PlaybackVolumeToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getTranscModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.TranscriptionMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("TranscriptionMode.Actions.CommitChanges");
        editActions.add("TranscriptionMode.Actions.CancelChanges");
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> navActions = new ArrayList<String>();
        navActions.add("TranscriptionMode.Actions.MoveUp");
        navActions.add("TranscriptionMode.Actions.MoveDown");
        navActions.add("TranscriptionMode.Actions.MoveLeft");
        navActions.add("TranscriptionMode.Actions.MoveRight");
        shortcuttableActions.put(ANN_NAVIGATION_CAT, navActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("TranscriptionMode.Actions.PlayFromStart");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("CommandActions.LoopMode");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("TranscriptionTableEditBox.EditInAnnotationMode");
        miscActions.add("TranscriptionMode.Actions.FreezeTier");
        miscActions.add("TranscriptionTable.Label.HideLinkedTiers");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getTranscModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        shortcutKeyStrokes.put("TranscriptionMode.Actions.CommitChanges", KeyStroke.getKeyStroke(10, 0));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.CancelChanges", KeyStroke.getKeyStroke(27, 0));
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(127, 1));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithNext", KeyStroke.getKeyStroke(65, 2));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithBefore", KeyStroke.getKeyStroke(66, 2));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveUp", KeyStroke.getKeyStroke(38, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveDown", KeyStroke.getKeyStroke(40, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveLeft", KeyStroke.getKeyStroke(37, 8));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.MoveRight", KeyStroke.getKeyStroke(39, 8));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(9, 0));
        shortcutKeyStrokes.put("TranscriptionMode.Actions.PlayFromStart", KeyStroke.getKeyStroke(9, 1));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("CommandActions.LoopMode", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getSegmentModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.SegmentationMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> editActions = new ArrayList<String>();
        editActions.add("Menu.Annotation.DeleteAnnotation");
        editActions.add("SegmentationMode.Actions.Segment");
        editActions.add("Menu.Annotation.MergeWithNext");
        editActions.add("Menu.Annotation.MergeWithBefore");
        editActions.add("Menu.Annotation.SplitAnnotation");
        shortcuttableActions.put(ANN_EDIT_CAT, editActions);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("CommandActions.PreviousActiveTier");
        tierActions.add("CommandActions.NextActiveTier");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> selActions = new ArrayList<String>();
        selActions.add("Menu.Play.ClearSelection");
        selActions.add("Menu.Play.ToggleCrosshairInSelection");
        selActions.add("Menu.Play.MoveCrosshairToCenterOfSelection");
        shortcuttableActions.put(SELECTION_CAT, selActions);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.PlaySelection");
        medNavActions.add("CommandActions.PlayAroundSelection");
        medNavActions.add("Menu.Play.PlayStepAndRepeat");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("Menu.Options.PlayAroundSelectionDialog");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("CommandActions.PlaybackRateToggle");
        miscActions.add("CommandActions.PlaybackVolumeToggle");
        miscActions.add("Menu.Options.BulldozerMode");
        miscActions.add("Menu.Options.NormalPropagationMode");
        miscActions.add("Menu.Options.ShiftMode");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getSegmentModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        shortcutKeyStrokes.put("Menu.Annotation.DeleteAnnotation", KeyStroke.getKeyStroke(8, 0));
        shortcutKeyStrokes.put("SegmentationMode.Actions.Segment", KeyStroke.getKeyStroke(10, 0));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithNext", KeyStroke.getKeyStroke(65, 2));
        shortcutKeyStrokes.put("Menu.Annotation.MergeWithBefore", KeyStroke.getKeyStroke(66, 2));
        shortcutKeyStrokes.put("CommandActions.PreviousActiveTier", KeyStroke.getKeyStroke(38, 0));
        shortcutKeyStrokes.put("CommandActions.NextActiveTier", KeyStroke.getKeyStroke(40, 0));
        shortcutKeyStrokes.put("Menu.Play.ClearSelection", KeyStroke.getKeyStroke(67, 9));
        shortcutKeyStrokes.put("Menu.Play.ToggleCrosshairInSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.MoveCrosshairToCenterOfSelection", KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.PlaySelection", KeyStroke.getKeyStroke(32, 1));
        shortcutKeyStrokes.put("CommandActions.PlayAroundSelection", KeyStroke.getKeyStroke(32, 3));
        shortcutKeyStrokes.put("Menu.Play.PlayStepAndRepeat", KeyStroke.getKeyStroke(32, 10));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.PlaybackRateToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("CommandActions.PlaybackVolumeToggle", KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getSyncModeShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Menu.Options.SyncMode");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> medNavActions = new ArrayList<String>();
        medNavActions.add("Menu.Play.PlayPause");
        medNavActions.add("Menu.Play.1PixelLeft");
        medNavActions.add("Menu.Play.1PixelRight");
        medNavActions.add("Menu.Play.Previous");
        medNavActions.add("Menu.Play.Next");
        medNavActions.add("Menu.Play.1SecLeft");
        medNavActions.add("Menu.Play.1SecRight");
        medNavActions.add("Menu.Play.GoToBegin");
        medNavActions.add("Menu.Play.GoToEnd");
        medNavActions.add("Menu.Search.GoTo");
        medNavActions.add("Menu.Options.PlaybackToggleDialog");
        shortcuttableActions.put(MEDIA_CAT, medNavActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getSyncModeDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        shortcutKeyStrokes.put("Menu.Play.PlayPause", KeyStroke.getKeyStroke(32, 2));
        shortcutKeyStrokes.put("Menu.Play.1PixelLeft", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.1PixelRight", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Play.Previous", KeyStroke.getKeyStroke(37, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.Next", KeyStroke.getKeyStroke(39, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.1SecLeft", KeyStroke.getKeyStroke(37, 1));
        shortcutKeyStrokes.put("Menu.Play.1SecRight", KeyStroke.getKeyStroke(39, 1));
        shortcutKeyStrokes.put("Menu.Play.GoToBegin", KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Play.GoToEnd", KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Search.GoTo", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return shortcutKeyStrokes;
    }

    private Map<String, List<String>> getCommonShortcuttableActionsMap() {
        Map<String, List<String>> shortcuttableActions = this.shortcuttableActionsMap.get("Shortcuts.Common");
        if (shortcuttableActions != null) {
            return shortcuttableActions;
        }
        shortcuttableActions = new LinkedHashMap<String, List<String>>(8);
        ArrayList<String> tierActions = new ArrayList<String>();
        tierActions.add("Menu.Tier.AddNewTier");
        tierActions.add("Menu.Tier.DeleteTier");
        tierActions.add("Menu.Type.AddNewType");
        tierActions.add("Menu.Tier.ChangeTier");
        tierActions.add("Menu.Tier.ReparentTier");
        tierActions.add("Menu.Tier.Tokenize");
        tierActions.add("Menu.Tier.FilterTier");
        tierActions.add("Menu.Tier.CopyTier");
        tierActions.add("Menu.Tier.AnnotationsFromOverlaps");
        tierActions.add("Menu.Tier.MergeTiers");
        tierActions.add("Menu.Tier.AnnotationsFromGaps");
        tierActions.add("Menu.Tier.ChangeCase");
        tierActions.add("Menu.Tier.CompareAnnotators");
        tierActions.add("Menu.Tier.RemoveAnnotationsOrValues");
        tierActions.add("Menu.Tier.AnnotationsOnDependentTiers");
        tierActions.add("Menu.Tier.LabelAndNumber");
        tierActions.add("Menu.View.Dependencies");
        tierActions.add("Menu.Type.ChangeType");
        tierActions.add("Menu.Type.DeleteType");
        shortcuttableActions.put(TIER_TYPE_CAT, tierActions);
        ArrayList<String> docActions = new ArrayList<String>();
        docActions.add("Menu.File.New");
        docActions.add("Menu.File.Open");
        docActions.add("Menu.File.Save");
        docActions.add("Menu.File.SaveAs");
        docActions.add("Menu.File.SaveAsTemplate");
        docActions.add("Menu.File.Print");
        docActions.add("Menu.File.PrintPreview");
        docActions.add("Menu.File.PageSetup");
        docActions.add("Menu.Window.Next");
        docActions.add("Menu.Window.Previous");
        docActions.add("Menu.File.Close");
        docActions.add("Menu.File.Exit");
        docActions.add("Menu.File.SaveSelectionAsEAF");
        docActions.add("Menu.File.MergeTranscriptions");
        docActions.add("Menu.File.Import.Shoebox");
        docActions.add("Menu.File.Import.Toolbox");
        docActions.add("Menu.File.Import.FLEx");
        docActions.add("Menu.File.Import.CHAT");
        docActions.add("Menu.File.Import.Transcriber");
        docActions.add("Menu.File.Import.Delimited");
        docActions.add("Menu.File.Import.PraatTiers");
        docActions.add("Menu.Edit.Preferences.Import");
        docActions.add("Menu.Tier.ImportTiers");
        docActions.add("Menu.Type.ImportTypes");
        docActions.add("Menu.File.Export.Tab");
        docActions.add("Menu.File.Export.AnnotationListMulti");
        docActions.add("Menu.File.Export.WordList");
        docActions.add("Menu.File.Export.Tiers");
        docActions.add("Menu.File.Export.FilmStrip");
        docActions.add("Menu.File.Export.HTML");
        docActions.add("Menu.File.Export.ImageFromWindow");
        docActions.add("Menu.File.Export.Interlinear");
        docActions.add("Menu.File.Export.Media");
        docActions.add("Menu.File.Export.Praat");
        docActions.add("Menu.Edit.Preferences.Export");
        docActions.add("Menu.File.Export.QtSub");
        docActions.add("Menu.File.Export.Shoebox");
        docActions.add("Menu.File.Export.Smil.RealPlayer");
        docActions.add("Menu.File.Export.Smil.QuickTime");
        docActions.add("Menu.File.Export.Subtitles");
        docActions.add("Menu.File.Export.Tab");
        docActions.add("Menu.File.Export.RecognizerTiers");
        docActions.add("Menu.File.Export.Tiger");
        docActions.add("Menu.File.Export.Toolbox");
        docActions.add("Menu.File.Export.TraditionalTransript");
        docActions.add("Menu.File.Export.WordList");
        shortcuttableActions.put(DOCUMENT_CAT, docActions);
        ArrayList<String> miscActions = new ArrayList<String>();
        miscActions.add("Menu.Edit.Undo");
        miscActions.add("Menu.Edit.Redo");
        miscActions.add("Menu.Search.Find");
        miscActions.add("Menu.Search.Multiple");
        miscActions.add("Menu.Search.StructuredMultiple");
        miscActions.add("Menu.Edit.LinkedFiles");
        miscActions.add("Menu.Edit.EditCV");
        miscActions.add("Menu.Help.Contents");
        miscActions.add("CommandActions.CopyCurrentTime");
        miscActions.add("Menu.Search.FindReplaceMulti");
        miscActions.add("Menu.Edit.EditLexSrvc");
        miscActions.add("Menu.Edit.Preferences.Edit");
        miscActions.add("Menu.Edit.Preferences.Shortcut");
        miscActions.add("Menu.Edit.Author");
        miscActions.add("Menu.View.FontBrowser");
        miscActions.add("Menu.View.Shortcuts");
        miscActions.add("Menu.View.SpreadSheet");
        miscActions.add("Menu.View.Statistics");
        miscActions.add("Menu.Help.About");
        miscActions.add("Menu.Options.AnnotationMode");
        miscActions.add("Menu.Options.SyncMode");
        miscActions.add("Menu.Options.TranscriptionMode");
        miscActions.add("Menu.Options.SegmentationMode");
        miscActions.add("Menu.Options.InterlinearizationMode");
        shortcuttableActions.put(MISC_CAT, miscActions);
        return shortcuttableActions;
    }

    private Map<String, KeyStroke> getCommonDefaultShortcutsMap() {
        LinkedHashMap<String, KeyStroke> shortcutKeyStrokes = new LinkedHashMap<String, KeyStroke>(80);
        shortcutKeyStrokes.put("Menu.Tier.AddNewTier", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Tier.DeleteTier", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Type.AddNewType", KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.File.New", KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.File.Open", KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.File.Save", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.File.SaveAs", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.File.SaveAsTemplate", KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1 + 8));
        shortcutKeyStrokes.put("Menu.File.Print", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.File.PrintPreview", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.File.PageSetup", KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Window.Next", KeyStroke.getKeyStroke(40, 1));
        shortcutKeyStrokes.put("Menu.Window.Previous", KeyStroke.getKeyStroke(38, 1));
        shortcutKeyStrokes.put("Menu.File.Close", KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.File.Exit", KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Edit.Undo", KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Edit.Redo", KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Search.Find", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("Menu.Search.Multiple", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Search.StructuredMultiple", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1 + 8));
        shortcutKeyStrokes.put("Menu.Edit.LinkedFiles", KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        shortcutKeyStrokes.put("Menu.Edit.EditCV", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 1));
        shortcutKeyStrokes.put("Menu.Help.Contents", KeyStroke.getKeyStroke(72, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        shortcutKeyStrokes.put("CommandActions.CopyCurrentTime", KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() + 8));
        return shortcutKeyStrokes;
    }

    private void addActionsWithoutShortcut() {
        Iterator<Map.Entry<String, Map<String, List<String>>>> it = this.shortcuttableActionsMap.entrySet().iterator();
        while (it.hasNext()) {
            String modeName = it.next().getKey();
            Map<String, KeyStroke> shortcutKeyStrokes = this.shortcutKeyStrokesMap.get(modeName);
            for (Map.Entry<String, List<String>> kvpair : this.shortcuttableActionsMap.get(modeName).entrySet()) {
                List<String> actionList = kvpair.getValue();
                for (int i = 0; i < actionList.size(); ++i) {
                    String action = actionList.get(i);
                    if (shortcutKeyStrokes.containsKey(action)) continue;
                    shortcutKeyStrokes.put(action, null);
                }
            }
        }
    }

    public KeyStroke getKeyStrokeForAction(String actionID, String modeName) {
        KeyStroke ks = null;
        if (actionID != null) {
            if (modeName == null) {
                if (this.shortcutKeyStrokesMap.get("Shortcuts.Common").containsKey(actionID)) {
                    ks = this.shortcutKeyStrokesMap.get("Shortcuts.Common").get(actionID);
                }
            } else if (this.shortcutKeyStrokesMap.get(modeName).containsKey(actionID)) {
                ks = this.shortcutKeyStrokesMap.get(modeName).get(actionID);
            } else if (this.shortcutKeyStrokesMap.get("Shortcuts.Common").containsKey(actionID)) {
                ks = this.shortcutKeyStrokesMap.get("Shortcuts.Common").get(actionID);
            }
        }
        return ks;
    }

    public Map<String, KeyStroke> getCurrentShortcuts(String modeName) {
        HashMap<String, KeyStroke> currentShortcutKeyStrokes = new HashMap<String, KeyStroke>();
        currentShortcutKeyStrokes.putAll(this.shortcutKeyStrokesMap.get("Shortcuts.Common"));
        if (modeName != null) {
            currentShortcutKeyStrokes.putAll(this.shortcutKeyStrokesMap.get(modeName));
        }
        return currentShortcutKeyStrokes;
    }

    public Map<String, List<String>> getShortcuttableActions(String modeName) {
        if (modeName == null) {
            return this.shortcuttableActionsMap.get("Shortcuts.Common");
        }
        return this.shortcuttableActionsMap.get(modeName);
    }

    public Map<String, KeyStroke> getShortcutKeysOnlyIn(String modeName) {
        if (modeName == null) {
            return this.shortcutKeyStrokesMap.get("Shortcuts.Common");
        }
        return this.shortcutKeyStrokesMap.get(modeName);
    }

    public String getDescriptionForAction(String actionID) {
        if (actionID == null) {
            return "";
        }
        String desc = ElanLocale.getString(actionID + "ToolTip");
        if (desc == null || desc.length() == 0) {
            desc = ElanLocale.getString(actionID);
        }
        return desc;
    }

    public String getCategoryForAction(String modeName, String actionID) {
        if (actionID == null) {
            return "";
        }
        Iterator<Map.Entry<String, List<String>>> it = modeName == null ? this.shortcuttableActionsMap.get("Shortcuts.Common").entrySet().iterator() : this.shortcuttableActionsMap.get(modeName).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> pairs = it.next();
            String cat = pairs.getKey();
            ArrayList actionList = (ArrayList)pairs.getValue();
            if (!actionList.contains(actionID)) continue;
            return cat;
        }
        return "";
    }

    public String getDescriptionForKeyStroke(KeyStroke ks) {
        if (ks == null) {
            return "";
        }
        String nwAcc = "";
        if (SystemReporting.isMacOS()) {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = nwAcc + "\u2303";
            }
            if ((modifier & 1) != 0) {
                nwAcc = nwAcc + "\u21e7";
            }
            if ((modifier & 8) != 0) {
                nwAcc = nwAcc + "\u2325";
            }
            if ((modifier & 4) != 0) {
                nwAcc = nwAcc + "\u2318";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? (ks.getKeyCode() == 127 ? nwAcc + "Delete" : (ks.getKeyCode() == 33 ? nwAcc + "PageUp" : (ks.getKeyCode() == 34 ? nwAcc + "PageDown" : (ks.getKeyCode() == 32 ? nwAcc + "Space" : nwAcc + KeyEvent.getKeyText(ks.getKeyCode()))))) : nwAcc + String.valueOf(ks.getKeyChar());
        } else {
            int modifier = ks.getModifiers();
            if ((modifier & 2) != 0) {
                nwAcc = nwAcc + "Ctrl+";
            }
            if ((modifier & 8) != 0) {
                nwAcc = nwAcc + "Alt+";
            }
            if ((modifier & 1) != 0) {
                nwAcc = nwAcc + "Shift+";
            }
            nwAcc = ks.getKeyChar() == '\uffff' ? nwAcc + KeyEvent.getKeyText(ks.getKeyCode()) : nwAcc + String.valueOf(ks.getKeyChar());
        }
        return nwAcc;
    }

    public void restoreDefaultShortcutsForthisMode(String modeName) {
        if (modeName == null || modeName.equals("Shortcuts.Common")) {
            this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.AnnotationMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getAnnotationModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.SyncMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getSyncModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.TranscriptionMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getTranscModeDefaultShortcutsMap());
        } else if (modeName.equals("Menu.Options.SegmentationMode")) {
            this.shortcutKeyStrokesMap.put(modeName, this.getSegmentModeDefaultShortcutsMap());
        }
        JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Restored") + " " + ElanLocale.getString(modeName));
    }

    public void restoreAll() {
        this.shortcutKeyStrokesMap.put("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
        this.shortcutKeyStrokesMap.put("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
        JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.RestoredAll"));
    }

    public boolean readCurrentShortcuts() {
        PreferencesReader xmlPrefsReader = new PreferencesReader();
        HashMap<String, Map<String, KeyStroke>> shortcutKeyMap = new HashMap<String, Map<String, KeyStroke>>();
        HashMap shortcutMapRaw = null;
        try {
            File file = new File(NEW_PREF_FILEPATH);
            shortcutMapRaw = file.exists() ? (HashMap)xmlPrefsReader.parse(NEW_PREF_FILEPATH) : (HashMap)xmlPrefsReader.parse(PREF_FILEPATH);
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not load the keyboard shortcut preferences file");
        }
        if (shortcutMapRaw != null && !shortcutMapRaw.isEmpty()) {
            if (shortcutMapRaw.values().iterator().hasNext()) {
                Object val = shortcutMapRaw.values().iterator().next();
                if (val instanceof ArrayList) {
                    Iterator it = shortcutMapRaw.entrySet().iterator();
                    HashMap<String, KeyStroke> shortcutMap = new HashMap<String, KeyStroke>();
                    while (it.hasNext()) {
                        Map.Entry pair = it.next();
                        String actionName = (String)pair.getKey();
                        val = pair.getValue();
                        if (!(val instanceof ArrayList)) continue;
                        ArrayList codes = (ArrayList)val;
                        if (codes.isEmpty()) {
                            shortcutMap.put(actionName, null);
                            continue;
                        }
                        int keycode = Integer.parseInt((String)codes.get(0));
                        int modcode = Integer.parseInt((String)codes.get(1));
                        KeyStroke aks = KeyStroke.getKeyStroke(keycode, modcode);
                        shortcutMap.put(actionName, aks);
                    }
                    shortcutKeyMap.putAll(this.covertToNewShortCutMap(shortcutMap));
                } else if (val instanceof Map) {
                    for (Map.Entry pair2 : shortcutMapRaw.entrySet()) {
                        String modeName = (String)pair2.getKey();
                        val = pair2.getValue();
                        HashMap<String, KeyStroke> shortcutMap = null;
                        if (val instanceof Map) {
                            shortcutMap = new HashMap<String, KeyStroke>();
                            for (Map.Entry pair2 : ((Map)val).entrySet()) {
                                String actionName = (String)pair2.getKey();
                                val = pair2.getValue();
                                if (!(val instanceof ArrayList)) continue;
                                ArrayList codes = (ArrayList)val;
                                if (codes.isEmpty()) {
                                    shortcutMap.put(actionName, null);
                                    continue;
                                }
                                int keycode = Integer.parseInt((String)codes.get(0));
                                int modcode = Integer.parseInt((String)codes.get(1));
                                KeyStroke aks = KeyStroke.getKeyStroke(keycode, modcode);
                                shortcutMap.put(actionName, aks);
                            }
                        }
                        shortcutKeyMap.put(modeName, shortcutMap);
                    }
                }
                this.shortcutKeyStrokesMap.clear();
                this.shortcutKeyStrokesMap.putAll(shortcutKeyMap);
                if (this.checkForNewShortcuts()) {
                    PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
                    try {
                        xmlPrefsWriter.encodeAndSave(this.getStorableShortcutMap(this.shortcutKeyStrokesMap), NEW_PREF_FILEPATH);
                    }
                    catch (Exception ex) {
                        ClientLogger.LOG.warning("Error while updating the shortcuts file. File not created.");
                    }
                }
            }
            this.addActionsWithoutShortcut();
            return true;
        }
        return false;
    }

    public HashMap<String, HashMap<String, List<String>>> getStorableShortcutMap(Map<String, Map<String, KeyStroke>> shortcutKeyStrokesMap) {
        HashMap<String, HashMap<String, List<String>>> shortcutModeMap = new HashMap<String, HashMap<String, List<String>>>();
        for (Map.Entry<String, Map<String, KeyStroke>> entry : shortcutKeyStrokesMap.entrySet()) {
            String modeName = entry.getKey();
            Map<String, KeyStroke> valMap = entry.getValue();
            Iterator<Map.Entry<String, KeyStroke>> it1 = valMap.entrySet().iterator();
            HashMap map = new HashMap();
            while (it1.hasNext()) {
                Map.Entry<String, KeyStroke> entry2 = it1.next();
                String actionName = entry2.getKey();
                KeyStroke ks = entry2.getValue();
                ArrayList<String> codes = new ArrayList<String>(2);
                if (ks != null) {
                    codes.add(String.valueOf(ks.getKeyCode()));
                    codes.add(String.valueOf(ks.getModifiers()));
                }
                map.put(actionName, codes);
            }
            shortcutModeMap.put(modeName, map);
        }
        return shortcutModeMap;
    }

    private HashMap<String, Map<String, KeyStroke>> covertToNewShortCutMap(HashMap<String, KeyStroke> shortcutMap) {
        ArrayList<String> generalActions = new ArrayList<String>();
        ArrayList<String> annModeActions = new ArrayList<String>();
        ArrayList<String> transModeActions = new ArrayList<String>();
        ArrayList<String> syncModeActions = new ArrayList<String>();
        ArrayList<String> segMentActions = new ArrayList<String>();
        HashMap<String, KeyStroke> annModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> transModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> syncModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> segmentModeMap = new HashMap<String, KeyStroke>();
        HashMap<String, KeyStroke> commonModeMap = new HashMap<String, KeyStroke>();
        Iterator<Object> it = this.getCommonShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            generalActions.addAll(it.next());
        }
        it = this.getAnnotationModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            annModeActions.addAll(it.next());
        }
        it = this.getTranscModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            transModeActions.addAll(it.next());
        }
        it = this.getSyncModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            syncModeActions.addAll(it.next());
        }
        it = this.getSegmentModeShortcuttableActionsMap().values().iterator();
        while (it.hasNext()) {
            segMentActions.addAll(it.next());
        }
        for (Map.Entry entry : shortcutMap.entrySet()) {
            String actionName = (String)entry.getKey();
            KeyStroke val = (KeyStroke)entry.getValue();
            if (generalActions.contains(actionName) && val != null) {
                commonModeMap.put(actionName, val);
                continue;
            }
            if (annModeActions.contains(actionName) && val != null) {
                annModeMap.put(actionName, val);
            }
            if (transModeActions.contains(actionName) && val != null) {
                transModeMap.put(actionName, val);
            }
            if (syncModeActions.contains(actionName) && val != null) {
                syncModeMap.put(actionName, val);
            }
            if (!segMentActions.contains(actionName) || val == null) continue;
            segmentModeMap.put(actionName, val);
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        if (transModeMap.containsValue(keyStroke) || commonModeMap.containsValue(keyStroke)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.CommitChanges", keyStroke);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(27, 0);
        if (transModeMap.containsValue(keyStroke2) || commonModeMap.containsValue(keyStroke2)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.CancelChanges", keyStroke2);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(127, 1);
        if (transModeMap.containsValue(keyStroke3) || commonModeMap.containsValue(keyStroke3)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.DeleteAnnotation", keyStroke3);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(65, 2);
        if (transModeMap.containsValue(keyStroke4) || commonModeMap.containsValue(keyStroke4)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.MergeWithNext", keyStroke4);
        KeyStroke keyStroke5 = KeyStroke.getKeyStroke(66, 2);
        if (transModeMap.containsValue(keyStroke5) || commonModeMap.containsValue(keyStroke5)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Annotation.MergeWithBefore", keyStroke5);
        KeyStroke keyStroke6 = KeyStroke.getKeyStroke(38, 8);
        if (transModeMap.containsValue(keyStroke6) || commonModeMap.containsValue(keyStroke6)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveUp", keyStroke6);
        KeyStroke keyStroke7 = KeyStroke.getKeyStroke(40, 8);
        if (transModeMap.containsValue(keyStroke7) || commonModeMap.containsValue(keyStroke7)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveDown", keyStroke7);
        KeyStroke keyStroke8 = KeyStroke.getKeyStroke(37, 8);
        if (transModeMap.containsValue(keyStroke8) || commonModeMap.containsValue(keyStroke8)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveLeft", keyStroke8);
        KeyStroke keyStroke9 = KeyStroke.getKeyStroke(39, 8);
        if (transModeMap.containsValue(keyStroke9) || commonModeMap.containsValue(keyStroke9)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.MoveRight", keyStroke9);
        KeyStroke keyStroke10 = KeyStroke.getKeyStroke(9, 0);
        if (transModeMap.containsValue(keyStroke10) || commonModeMap.containsValue(keyStroke10)) {
            this.shortcutClash = true;
        }
        transModeMap.put("Menu.Play.PlayPause", keyStroke10);
        KeyStroke keyStroke11 = KeyStroke.getKeyStroke(9, 1);
        if (transModeMap.containsValue(keyStroke11) || commonModeMap.containsValue(keyStroke11)) {
            this.shortcutClash = true;
        }
        transModeMap.put("TranscriptionMode.Actions.PlayFromStart", keyStroke11);
        KeyStroke keyStroke12 = KeyStroke.getKeyStroke(8, 0);
        if (segmentModeMap.containsValue(keyStroke12) || commonModeMap.containsValue(keyStroke12)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.DeleteAnnotation", keyStroke12);
        KeyStroke keyStroke13 = KeyStroke.getKeyStroke(10, 0);
        if (segmentModeMap.containsValue(keyStroke13) || commonModeMap.containsValue(keyStroke13)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("SegmentationMode.Actions.Segment", keyStroke13);
        KeyStroke keyStroke14 = KeyStroke.getKeyStroke(65, 2);
        if (segmentModeMap.containsValue(keyStroke14) || commonModeMap.containsValue(keyStroke14)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.MergeWithNext", keyStroke14);
        KeyStroke keyStroke15 = KeyStroke.getKeyStroke(66, 2);
        if (segmentModeMap.containsValue(keyStroke15) || commonModeMap.containsValue(keyStroke15)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("Menu.Annotation.MergeWithBefore", keyStroke15);
        KeyStroke keyStroke16 = KeyStroke.getKeyStroke(38, 0);
        if (segmentModeMap.containsValue(keyStroke16) || commonModeMap.containsValue(keyStroke16)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("CommandActions.PreviousActiveTier", keyStroke16);
        KeyStroke keyStroke17 = KeyStroke.getKeyStroke(40, 0);
        if (segmentModeMap.containsValue(keyStroke17) || commonModeMap.containsValue(keyStroke17)) {
            this.shortcutClash = true;
        }
        segmentModeMap.put("CommandActions.NextActiveTier", keyStroke17);
        HashMap<String, Map<String, KeyStroke>> shortcutKeysMap = new HashMap<String, Map<String, KeyStroke>>();
        shortcutKeysMap.put("Shortcuts.Common", commonModeMap);
        shortcutKeysMap.put("Menu.Options.AnnotationMode", annModeMap);
        shortcutKeysMap.put("Menu.Options.SyncMode", syncModeMap);
        shortcutKeysMap.put("Menu.Options.TranscriptionMode", transModeMap);
        shortcutKeysMap.put("Menu.Options.SegmentationMode", segmentModeMap);
        return shortcutKeysMap;
    }

    private boolean checkForNewShortcuts() {
        Object val = Preferences.get("ShortcutKeyUpdateVersion", null);
        String version = ELAN.getVersionString();
        if (val == null || !((String)val).equals(version)) {
            this.addNewShortcuts("Shortcuts.Common", this.getCommonDefaultShortcutsMap());
            this.addNewShortcuts("Menu.Options.AnnotationMode", this.getAnnotationModeDefaultShortcutsMap());
            this.addNewShortcuts("Menu.Options.TranscriptionMode", this.getTranscModeDefaultShortcutsMap());
            this.addNewShortcuts("Menu.Options.SyncMode", this.getSyncModeDefaultShortcutsMap());
            this.addNewShortcuts("Menu.Options.SegmentationMode", this.getSegmentModeDefaultShortcutsMap());
            Preferences.set("ShortcutKeyUpdateVersion", version, null);
            if (this.shortcutClash) {
                String message = ElanLocale.getString("Shortcuts.Warning.Clashes") + System.getProperty("line.separator") + ElanLocale.getString("Shortcuts.Warning.Edit");
                JOptionPane.showMessageDialog(null, message, ElanLocale.getString("Message.Warning"), 2);
            }
            return true;
        }
        return false;
    }

    private void addNewShortcuts(String modeName, Map<String, KeyStroke> defaultShorcutMap) {
        Map<String, KeyStroke> currentShorcutMapForThisMode = this.shortcutKeyStrokesMap.get(modeName);
        HashMap<String, KeyStroke> currentlyUsedShorcutMap = new HashMap<String, KeyStroke>();
        currentlyUsedShorcutMap.putAll(this.shortcutKeyStrokesMap.get(modeName));
        if (!modeName.equals("Shortcuts.Common")) {
            currentlyUsedShorcutMap.putAll(this.shortcutKeyStrokesMap.get("Shortcuts.Common"));
        }
        for (Map.Entry<String, KeyStroke> pair : defaultShorcutMap.entrySet()) {
            String actionName = pair.getKey();
            if (currentShorcutMapForThisMode.containsKey(actionName)) continue;
            KeyStroke ks = pair.getValue();
            currentShorcutMapForThisMode.put(actionName, ks);
            if (currentlyUsedShorcutMap.containsValue(ks)) {
                this.shortcutClash = true;
            }
            currentlyUsedShorcutMap.put(actionName, ks);
        }
        this.shortcutKeyStrokesMap.put(modeName, currentShorcutMapForThisMode);
    }

    public void saveCurrentShortcuts(HashMap<String, HashMap<String, List<String>>> shortcutMap) {
        PreferencesWriter xmlPrefsWriter = new PreferencesWriter();
        try {
            xmlPrefsWriter.encodeAndSave(shortcutMap, NEW_PREF_FILEPATH);
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.Saved"));
        }
        catch (Exception ex) {
            ClientLogger.LOG.warning("Could not save the keyboard shortcut preferences file");
            JOptionPane.showMessageDialog(null, ElanLocale.getString("Shortcuts.Message.NotSaved"));
        }
    }

    static {
        PREF_FILEPATH = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts.pfsx";
        NEW_PREF_FILEPATH = Constants.ELAN_DATA_DIR + System.getProperty("file.separator") + "shortcuts1.pfsx";
    }
}

