/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanFrame2;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.FrameManager;
import mpi.eudico.client.annotator.commands.global.FrameMenuAction;
import mpi.eudico.client.annotator.gui.ImportTranscriberDialog;
import mpi.eudico.server.corpora.clom.DecoderInfo;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportTranscriberMA
extends FrameMenuAction {
    public ImportTranscriberMA(String name, ElanFrame2 frame) {
        super(name, frame);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        ImportTranscriberDialog dialog = new ImportTranscriberDialog(this.frame);
        Object value = dialog.showDialog();
        if (value == null) {
            return;
        }
        DecoderInfo decInfo = (DecoderInfo)value;
        if (decInfo.getSourceFilePath() == null) {
            return;
        }
        try {
            int answer;
            String path = decInfo.getSourceFilePath();
            TranscriptionImpl transcription = new TranscriptionImpl(path, decInfo);
            transcription.setChanged();
            int lastSlash = path.lastIndexOf(47);
            String transcriberPath = path.substring(0, lastSlash);
            boolean validMedia = true;
            if (this.frame != null) {
                validMedia = this.frame.checkMedia(transcription, transcriberPath);
            }
            if (!validMedia && (answer = JOptionPane.showConfirmDialog(this.frame, ElanLocale.getString("Frame.ElanFrame.IncompleteMediaQuestion"), ElanLocale.getString("Frame.ElanFrame.IncompleteMediaAvailable"), 0)) != 0) {
                return;
            }
            FrameManager.getInstance().createFrame(transcription);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

