/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.commands.global;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.commands.global.MenuAction;
import mpi.eudico.client.annotator.export.ShortCutPrinter;
import mpi.eudico.client.annotator.gui.ClosableFrame;
import mpi.eudico.client.util.SubHeaderTableCellRenderer;
import mpi.eudico.client.util.TableSubHeaderObject;

public class ShortcutsMA
extends MenuAction {
    private JFrame shortcutsFrame;
    private JTabbedPane shortcutPane;
    private JButton printButton;
    private JButton printAllButton;

    public ShortcutsMA(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.printButton) {
            int index = this.shortcutPane.getSelectedIndex();
            JTable tableShortcuts = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(index)).getViewport().getView();
            new ShortCutPrinter(tableShortcuts).startPrint();
            return;
        }
        if (e.getSource() == this.printAllButton) {
            ArrayList<JTable> tableList = new ArrayList<JTable>();
            for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
                tableList.add((JTable)((JScrollPane)this.shortcutPane.getComponentAt(i)).getViewport().getView());
            }
            new ShortCutPrinter(tableList).startPrint();
            return;
        }
        if (this.shortcutsFrame == null) {
            this.shortcutsFrame = new ClosableFrame("Shortcuts");
            this.shortcutsFrame.setDefaultCloseOperation(2);
            this.shortcutPane = new JTabbedPane();
            JTable table = this.getNewTable();
            table.setName(ElanLocale.getString("Shortcuts.Common"));
            this.shortcutPane.add(table.getName(), new JScrollPane(table));
            table = this.getNewTable();
            table.setName(ElanLocale.getString("Menu.Options.AnnotationMode"));
            this.shortcutPane.add(table.getName(), new JScrollPane(table));
            table = this.getNewTable();
            table.setName(ElanLocale.getString("Menu.Options.SyncMode"));
            this.shortcutPane.add(table.getName(), new JScrollPane(table));
            table = this.getNewTable();
            table.setName(ElanLocale.getString("Menu.Options.TranscriptionMode"));
            this.shortcutPane.add(table.getName(), new JScrollPane(table));
            table = this.getNewTable();
            table.setName(ElanLocale.getString("Menu.Options.SegmentationMode"));
            this.shortcutPane.add(table.getName(), new JScrollPane(table));
            this.shortcutsFrame.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 4, 2);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            this.shortcutsFrame.getContentPane().add((Component)this.shortcutPane, gbc);
            this.printButton = new JButton();
            this.printButton.addActionListener(this);
            this.printAllButton = new JButton();
            this.printAllButton.addActionListener(this);
            JPanel buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
            buttonPanel.add(this.printButton);
            buttonPanel.add(this.printAllButton);
            gbc.gridy = 1;
            gbc.weightx = 0.0;
            gbc.weighty = 0.0;
            gbc.fill = 0;
            gbc.anchor = 10;
            this.shortcutsFrame.getContentPane().add((Component)buttonPanel, gbc);
            this.updateLocale();
            this.shortcutsFrame.pack();
            this.shortcutsFrame.setVisible(true);
            this.shortcutsFrame.addWindowListener(new CloseListener());
        } else {
            this.shortcutsFrame.setVisible(true);
            this.shortcutsFrame.setState(0);
            this.shortcutsFrame.toFront();
        }
    }

    private JTable getNewTable() {
        DefaultTableModel model = new DefaultTableModel(0, 2);
        JTable tableShortcuts = new JTable(model);
        tableShortcuts.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        tableShortcuts.setPreferredScrollableViewportSize(new Dimension(500, 600));
        tableShortcuts.setShowVerticalLines(false);
        tableShortcuts.getTableHeader().setReorderingAllowed(false);
        tableShortcuts.setEnabled(false);
        tableShortcuts.getColumnModel().getColumn(0).setPreferredWidth(200);
        tableShortcuts.getColumnModel().getColumn(1).setPreferredWidth(300);
        tableShortcuts.setDefaultRenderer(Object.class, new SubHeaderTableCellRenderer());
        for (int i = 0; i < tableShortcuts.getRowCount(); ++i) {
            if (!(tableShortcuts.getValueAt(i, 0) instanceof TableSubHeaderObject)) continue;
            tableShortcuts.setRowHeight(i, tableShortcuts.getRowHeight() + 6);
        }
        return tableShortcuts;
    }

    @Override
    public void updateLocale() {
        super.updateLocale();
        if (this.shortcutPane != null) {
            this.printButton.setText(ElanLocale.getString("Menu.File.Print"));
            this.printAllButton.setText(ElanLocale.getString("Button.PrintAll"));
            for (int i = 0; i < this.shortcutPane.getTabCount(); ++i) {
                String modeConstant = this.getConstant(this.shortcutPane.getTitleAt(i));
                JTable tableShortcuts = (JTable)((JScrollPane)this.shortcutPane.getComponentAt(i)).getViewport().getView();
                tableShortcuts.getColumnModel().getColumn(0).setHeaderValue(ElanLocale.getString("Frame.ShortcutFrame.ColumnShortcut"));
                tableShortcuts.getColumnModel().getColumn(1).setHeaderValue(ElanLocale.getString("Frame.ShortcutFrame.ColumnDescription"));
                DefaultTableModel model = (DefaultTableModel)tableShortcuts.getModel();
                model.setRowCount(0);
                this.loadModel(model, ShortcutsUtil.getInstance().getShortcuttableActions(modeConstant), ShortcutsUtil.getInstance().getShortcutKeysOnlyIn(modeConstant));
            }
            if (this.shortcutsFrame != null) {
                this.shortcutsFrame.setTitle(ElanLocale.getString("Menu.View.ShortcutsDialog"));
                this.shortcutsFrame.repaint();
            }
        }
    }

    private String getConstant(String tabName) {
        String constant = null;
        if (tabName.equals(ElanLocale.getString("Shortcuts.Common"))) {
            constant = "Shortcuts.Common";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.AnnotationMode"))) {
            constant = "Menu.Options.AnnotationMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.TranscriptionMode"))) {
            constant = "Menu.Options.TranscriptionMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.SyncMode"))) {
            constant = "Menu.Options.SyncMode";
        } else if (tabName.equals(ElanLocale.getString("Menu.Options.SegmentationMode"))) {
            constant = "Menu.Options.SegmentationMode";
        }
        return constant;
    }

    private void loadModel(DefaultTableModel model, Map<String, List<String>> curShorts, Map<String, KeyStroke> shortcutMap) {
        Iterator<Map.Entry<String, List<String>>> csIt = curShorts.entrySet().iterator();
        while (csIt.hasNext()) {
            String key = csIt.next().getKey();
            List<String> ids = curShorts.get(key);
            boolean categoryAdded = false;
            for (int i = 0; i < ids.size(); ++i) {
                String shortcutId = ids.get(i);
                KeyStroke stroke = shortcutMap.get(shortcutId);
                if (stroke == null) continue;
                if (!categoryAdded) {
                    model.addRow(new Object[]{new TableSubHeaderObject(ElanLocale.getString(key)), new TableSubHeaderObject(null)});
                    categoryAdded = true;
                }
                model.addRow(new Object[]{ShortcutsUtil.getInstance().getDescriptionForKeyStroke(stroke), ShortcutsUtil.getInstance().getDescriptionForAction(shortcutId)});
            }
        }
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosed(WindowEvent e) {
            ShortcutsMA.this.shortcutsFrame.removeWindowListener(this);
            ShortcutsMA.this.shortcutsFrame = null;
        }
    }
}

