/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clom.AnnotationCore;

public class ExportGridTable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportTableAsTabDelimitedText(AnnotationTable table) {
        if (table == null) {
            return;
        }
        String encoding = "UTF-8";
        FileChooser chooser = new FileChooser(null);
        chooser.createAndShowFileAndEncodingDialog(ElanLocale.getString("ExportTabDialog.Title"), 1, FileExtension.TEXT_EXT, "LastUsedExportDir", encoding);
        File exportFile = chooser.getSelectedFile();
        if (exportFile == null) {
            return;
        }
        encoding = chooser.getSelectedEncoding();
        BufferedWriter writer = null;
        GridViewerTableModel dataModel = null;
        boolean filtering = false;
        try {
            int i;
            FileOutputStream out = new FileOutputStream(exportFile);
            OutputStreamWriter osw = null;
            try {
                osw = new OutputStreamWriter((OutputStream)out, encoding);
            }
            catch (UnsupportedCharsetException uce) {
                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
            }
            writer = new BufferedWriter(osw);
            dataModel = (GridViewerTableModel)table.getModel();
            filtering = dataModel.isFiltering();
            dataModel.setFiltering(false);
            ArrayList<String> visColumns = new ArrayList<String>();
            boolean tierNameColumnPresent = false;
            for (int i2 = 0; i2 < dataModel.getColumnCount(); ++i2) {
                String columnName = dataModel.getColumnName(i2);
                if (!table.isColumnVisible(columnName)) continue;
                visColumns.add(columnName);
                if (!columnName.equals("ColumnTierName")) continue;
                tierNameColumnPresent = true;
            }
            String tierName = "";
            if (!tierNameColumnPresent && dataModel.getRowCount() > 0) {
                for (int i3 = 0; i3 < dataModel.getColumnCount(); ++i3) {
                    Object o;
                    if (!visColumns.contains(dataModel.getColumnName(i3)) || !((o = dataModel.getValueAt(0, i3)) instanceof Annotation)) continue;
                    tierName = ((Annotation)o).getTier().getName();
                    break;
                }
            }
            for (i = 1; i < dataModel.getColumnCount(); ++i) {
                if (!visColumns.contains(dataModel.getColumnName(i))) continue;
                String header = (String)table.getColumnModel().getColumn(i).getHeaderValue();
                if (!tierNameColumnPresent && dataModel.getColumnName(i).equals("ColumnAnnotation") && tierName.length() > 0) {
                    header = tierName;
                }
                writer.write(header + "\t");
            }
            writer.write("\n");
            for (i = 0; i < dataModel.getRowCount(); ++i) {
                for (int j = 1; j < dataModel.getColumnCount(); ++j) {
                    if (!visColumns.contains(dataModel.getColumnName(j))) continue;
                    Object o = dataModel.getValueAt(i, j);
                    if (o instanceof Annotation) {
                        writer.write(((Annotation)o).getValue().replace('\n', ' '));
                    } else if (o instanceof AnnotationCore) {
                        writer.write(((AnnotationCore)o).getValue().replace('\n', ' '));
                    } else if (o != null) {
                        writer.write(o.toString());
                    } else {
                        writer.write("");
                    }
                    writer.write("\t");
                }
                writer.write("\n");
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(table, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Warning"), 2);
        }
        finally {
            if (dataModel != null) {
                dataModel.setFiltering(filtering);
            }
            try {
                writer.close();
            }
            catch (Exception ee) {}
        }
    }
}

