/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTGEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.praat.PraatTextGridEncoder;

public class ExportPraatDialog
extends AbstractExtTierExportDialog
implements ItemListener {
    private JCheckBox selectionCB;
    private JCheckBox correctTimesCB;
    final String prefSelectedTiers = "ExportPraatDialog.selectedTiers";
    final String prefTierOrder = "ExportPraatDialog.TierOrder";
    final String prefParentTierOrder = "ExportPraatDialog.ParentTierOrder";
    final String prefSelectTiersMode = "ExportPraatDialog.SelectTiersMode";
    final String prefLastSelectedItems = "ExportPraatDialog.LastSelectedItems";
    final String prefHiddenTiers = "ExportPraatDialog.HiddenTiers";
    final String prefRootTiersOnly = "ExportPraatDialog.ShowOnlyRootTiers";
    final String prefSelectionOnly = "ExportPraatDialog.SelectionOnly";
    final String prefAddOffsetTime = "ExportPraatDialog.AddOffsetTime";

    public ExportPraatDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        this.extractTiers();
    }

    protected void extractTiers() {
        Object useTyp = Preferences.get("ExportPraatDialog.TierOrder", this.transcription);
        if (useTyp instanceof List) {
            this.setTierOrder((List)useTyp);
        } else {
            super.extractTiers(false);
        }
        useTyp = Preferences.get("ExportPraatDialog.selectedTiers", this.transcription);
        if (useTyp instanceof List) {
            this.setSelectedTiers((List)useTyp);
        }
        if ((useTyp = Preferences.get("ExportPraatDialog.SelectTiersMode", this.transcription)) instanceof String) {
            Object selItems;
            this.setSelectionMode((String)useTyp);
            if (!"Tier".equals((String)useTyp) && (selItems = Preferences.get("ExportPraatDialog.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems((List)selItems);
            }
        }
        this.setPreferredSetting();
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.selectionCB = new JCheckBox();
        this.correctTimesCB = new JCheckBox();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.selectionCB, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this.optionsPanel.add((Component)this.correctTimesCB, gridBagConstraints);
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        Vector mds;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        String[] encodings = new String[]{ElanLocale.getString("Button.Default"), "UTF-8", "UTF-16"};
        File exportFile = this.promptForFile(ElanLocale.getString("ExportPraatDialog.Title"), null, FileExtension.PRAAT_TEXTGRID_EXT, true, encodings);
        if (exportFile == null) {
            return false;
        }
        long begin = 0L;
        long end = ELANCommandFactory.getViewerManager(this.transcription).getMasterMediaPlayer().getMediaDuration();
        boolean exportSelection = false;
        if (this.selectionCB.isSelected() && this.selection != null && this.selection.getBeginTime() < this.selection.getEndTime()) {
            begin = this.selection.getBeginTime();
            end = this.selection.getEndTime();
            exportSelection = true;
        }
        long mediaOffset = 0L;
        if (this.correctTimesCB.isSelected() && (mds = this.transcription.getMediaDescriptors()) != null && mds.size() > 0) {
            mediaOffset = ((MediaDescriptor)mds.get((int)0)).timeOrigin;
        }
        PraatTGEncoderInfo encInfo = new PraatTGEncoderInfo(begin, end);
        encInfo.setEncoding(this.encoding);
        encInfo.setOffset(mediaOffset);
        encInfo.setExportSelection(exportSelection);
        PraatTextGridEncoder encoder = new PraatTextGridEncoder();
        encoder.encodeAndSave(this.transcription, encInfo, selectedTiers, exportFile.getAbsolutePath());
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportPraatDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportPraatDialog.Title"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportPraatDialog.ShowOnlyRootTiers", null);
        if (useTyp == null) {
            useTyp = Preferences.get("ExportPraatDialog.rootTiersCB", null);
            Preferences.set("ExportPraatDialog.rootTiersCB", null, null);
        }
        if (useTyp != null) {
            this.setRootTiersOnly((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportPraatDialog.SelectionOnly", null)) == null) {
            useTyp = Preferences.get("ExportPraatDialog.selectionCB", null);
            Preferences.set("ExportPraatDialog.selectionCB", null, null);
        }
        if (useTyp != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportPraatDialog.AddOffsetTime", null)) == null) {
            useTyp = Preferences.get("ExportPraatDialog.correctTimesCB", null);
            Preferences.set("ExportPraatDialog.correctTimesCB", null, null);
        }
        if (useTyp instanceof Boolean) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        boolean rootsOnly = this.tierSelectPanel.isRootTiersOnly();
        Preferences.set("ExportPraatDialog.ShowOnlyRootTiers", rootsOnly, null);
        Preferences.set("ExportPraatDialog.SelectionOnly", this.selectionCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.AddOffsetTime", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportPraatDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
        Preferences.set("ExportPraatDialog.SelectTiersMode", this.getSelectionMode(), this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportPraatDialog.LastSelectedItems", this.getSelectedItems(), this.transcription);
        }
        Preferences.set("ExportPraatDialog.HiddenTiers", this.getHiddenTiers(), this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportPraatDialog.TierOrder", tierOrder, this.transcription);
    }
}

