/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Transcription;

public class ExportStatistics
extends AbstractTierExportDialog {
    public static final String TAB = "\t";
    private static final String NEWLINE = "\n";
    private JTable statTable;

    public ExportStatistics(Frame parent, boolean modal, Transcription transcription, JTable statTable) {
        super(parent, modal, transcription, null);
        this.statTable = statTable;
        try {
            this.startExport();
        }
        catch (Exception ee) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + NEWLINE + "(" + ee.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
        }
    }

    @Override
    protected void updateLocale() {
        this.setTitle(ElanLocale.getString("ExportTabDialog.Title"));
    }

    @Override
    protected boolean startExport() throws IOException {
        if (null == this.statTable) {
            throw new NullPointerException("The statistics table is null");
        }
        File file = this.promptForFile(ElanLocale.getString("ExportTabDialog.Title"), null, FileExtension.TEXT_EXT, true);
        if (file == null) {
            return false;
        }
        FileOutputStream out = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)out, this.encoding);
        BufferedWriter writer = new BufferedWriter(osw);
        writer.write(this.toTabDelimitedText());
        writer.close();
        return true;
    }

    private String toTabDelimitedText() {
        String text = "";
        for (int j = 0; j < this.statTable.getColumnCount(); ++j) {
            text = text + this.statTable.getColumnName(j);
            text = text + TAB;
        }
        text = text + NEWLINE;
        for (int i = 0; i < this.statTable.getRowCount(); ++i) {
            for (int j = 0; j < this.statTable.getColumnCount(); ++j) {
                text = text + this.statTable.getValueAt(i, j);
                text = text + TAB;
            }
            text = text + NEWLINE;
        }
        return text;
    }
}

