/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.client.annotator.export.ExportTigerFeatureCheckPane;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.Transcription2Tiger;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class ExportTigerDialog
extends AbstractTierExportDialog
implements ListSelectionListener {
    private JPanel textFieldPanel;
    private JTextField[] featureTextFields = new JTextField[0];

    public ExportTigerDialog(Frame parent, boolean modal, Transcription transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.updateFeatureTextFields();
        this.postInit();
    }

    public static void main(String[] args) {
        String filename = "resources/testdata/elan/elan-example2.eaf";
        TranscriptionImpl transcription = new TranscriptionImpl(filename);
        JFrame frame = new JFrame();
        ExportTigerDialog dialog = new ExportTigerDialog((Frame)frame, false, transcription, null);
        dialog.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("export");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
            this.updateFeatureTextFields();
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            Object useTyp;
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                List v = ExportTigerDialog.getSentenceTiers(this.transcription);
                for (int i = 0; i < v.size(); ++i) {
                    TierImpl t = (TierImpl)v.get(i);
                    this.model.addRow(new Object[]{Boolean.TRUE, t.getName()});
                }
            }
            if ((useTyp = Preferences.get("ExportTigerDialog.selectedTiers", this.transcription)) instanceof ArrayList) {
                this.loadTierPreferences((ArrayList)useTyp);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        this.optionsPanel.add((Component)this.restrictCheckBox, gridBagConstraints);
        gridBagConstraints.fill = 1;
        this.optionsPanel.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 12;
        this.optionsPanel.add((Component)new JLabel("Features:"), gridBagConstraints);
        this.textFieldPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 17;
        this.optionsPanel.add((Component)this.textFieldPanel, gridBagConstraints);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.setPreferredSetting();
        this.updateLocale();
    }

    @Override
    protected boolean startExport() throws IOException {
        List selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        long selectionBT = 0L;
        long selectionET = Long.MAX_VALUE;
        if (this.restrictCheckBox.isSelected()) {
            selectionBT = this.selection.getBeginTime();
            selectionET = this.selection.getEndTime();
        }
        String[] features = new String[this.featureTextFields.length];
        for (int i = 0; i < this.featureTextFields.length; ++i) {
            features[i] = this.featureTextFields[i].getText();
        }
        LinkedHashMap sentenceTierHash = new LinkedHashMap();
        for (int i = 0; i < selectedTiers.size(); ++i) {
            Tier sentenceTier = this.transcription.getTierWithId((String)selectedTiers.get(i));
            List featureTiers = ExportTigerDialog.getFeatureTiers(sentenceTier);
            LinkedHashMap featureHash = new LinkedHashMap();
            for (int j = 0; j < featureTiers.size(); ++j) {
                featureHash.put(featureTiers.get(j), features[j]);
            }
            sentenceTierHash.put(sentenceTier, featureHash);
        }
        if (features.length > 1 && ExportTigerFeatureCheckPane.showFeatureCheckPane(this, sentenceTierHash, features) == 2) {
            return false;
        }
        File exportFile = this.promptForFile(ElanLocale.getString("Export.TigerDialog.title"), null, FileExtension.TIGER_EXT, true);
        if (exportFile == null) {
            return false;
        }
        Transcription2Tiger.exportTiers(this.transcription, sentenceTierHash, exportFile, this.encoding, selectionBT, selectionET);
        return true;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTigerDialog.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTigerDialog.TitleLabel"));
    }

    private static List getFeatureTiers(Tier sentenceTier) {
        ArrayList<Tier> featureTiers = new ArrayList<Tier>();
        Vector childTiers = ((TierImpl)sentenceTier).getChildTiers();
        for (int j = 0; j < childTiers.size(); ++j) {
            Tier childTier = (Tier)childTiers.get(j);
            if (((TierImpl)childTier).getLinguisticType().getConstraints().getStereoType() != 0) continue;
            featureTiers.add(childTier);
            ExportTigerDialog.addDescendantFeatureTiers(featureTiers, childTier);
        }
        return featureTiers;
    }

    private static List getSentenceTiers(Transcription transcription) {
        int i;
        ArrayList noConstraintTiers = new ArrayList();
        ArrayList sentenceTiers = new ArrayList();
        Vector lingTypes = transcription.getLinguisticTypes();
        for (i = 0; i < lingTypes.size(); ++i) {
            LinguisticType lingType = (LinguisticType)lingTypes.get(i);
            if (lingType.getConstraints() != null) continue;
            noConstraintTiers.addAll(transcription.getTiersWithLinguisticType(((LinguisticType)lingTypes.get(i)).getLinguisticTypeName()));
        }
        for (i = 0; i < noConstraintTiers.size(); ++i) {
            Vector childTiers = ((TierImpl)noConstraintTiers.get(i)).getChildTiers();
            boolean containsWordTier = false;
            for (int j = 0; j < childTiers.size(); ++j) {
                Tier childTier = (Tier)childTiers.get(j);
                Constraint constraint = ((TierImpl)childTier).getLinguisticType().getConstraints();
                if (constraint == null || constraint.getStereoType() != 0) continue;
                containsWordTier = true;
                break;
            }
            if (!containsWordTier) continue;
            sentenceTiers.add(noConstraintTiers.get(i));
        }
        return sentenceTiers;
    }

    private static void addDescendantFeatureTiers(List featureTiers, Tier tier) {
        Vector childTiers = ((TierImpl)tier).getChildTiers();
        for (int k = 0; k < childTiers.size(); ++k) {
            Tier childTier = (Tier)childTiers.get(k);
            if (((TierImpl)childTier).getLinguisticType().getConstraints().getStereoType() != 4) continue;
            featureTiers.add(childTier);
            ExportTigerDialog.addDescendantFeatureTiers(featureTiers, childTier);
        }
    }

    private void updateFeatureTextFields() {
        int i;
        int includeCol = this.model.findColumn("export");
        int nameCol = this.model.findColumn("tier");
        int maxFeatures = 0;
        for (i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            try {
                Tier sentenceTier = this.transcription.getTierWithId((String)this.model.getValueAt(i, nameCol));
                maxFeatures = Math.max(maxFeatures, ExportTigerDialog.getFeatureTiers(sentenceTier).size());
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (maxFeatures != this.featureTextFields.length) {
            this.textFieldPanel.removeAll();
            this.featureTextFields = new JTextField[maxFeatures];
            for (i = 0; i < maxFeatures; ++i) {
                this.featureTextFields[i] = new JTextField(i < Transcription2Tiger.defaultFeatureNames.length ? Transcription2Tiger.defaultFeatureNames[i] : "", 10);
                this.textFieldPanel.add(this.featureTextFields[i]);
            }
            this.featureTextFields[0].setEnabled(false);
            this.textFieldPanel.revalidate();
        }
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportTigerDialog.restrictCheckBox", null);
        if (useTyp != null) {
            this.restrictCheckBox.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTigerDialog.featureTextFields", this.transcription)) instanceof ArrayList) {
            this.textFieldPanel.removeAll();
            this.featureTextFields = new JTextField[((List)useTyp).size()];
            for (int i = 0; i < ((List)useTyp).size(); ++i) {
                this.featureTextFields[i] = new JTextField((String)((List)useTyp).get(i));
                this.textFieldPanel.add(this.featureTextFields[i]);
            }
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTigerDialog.restrictCheckBox", this.restrictCheckBox.isSelected(), null);
        ArrayList<String> features = new ArrayList<String>();
        for (int i = 0; i < this.featureTextFields.length; ++i) {
            features.add(this.featureTextFields[i].getText());
        }
        Preferences.set("ExportTigerDialog.featureTextFields", features, this.transcription);
        Preferences.set("ExportTigerDialog.selectedTiers", this.getSelectedTiers(), this.transcription);
    }
}

