/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.export.AbstractTierExportDialog;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.interlinear.ToolboxEncoder;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.client.util.SelectableObject;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.shoebox.MarkerRecord;
import mpi.eudico.server.corpora.clomimpl.shoebox.ShoeboxTypFile;
import mpi.eudico.server.corpora.clomimpl.shoebox.ToolboxEncoderInfo;
import mpi.eudico.server.corpora.clomimpl.type.Constraint;

public class ExportToolboxDialog
extends AbstractTierExportDialog
implements ItemListener,
ListSelectionListener {
    private JButton typButton;
    private JCheckBox blankLineCB;
    private JCheckBox correctTimesCB;
    private JCheckBox wrapBlocksCB;
    private JCheckBox wrapLinesCB;
    private JCheckBox includeEmptyLinesCB;
    private JLabel charPerLineLabel;
    private JLabel toolboxDBTypeLabel;
    private JLabel recordMarkerLabel;
    private JLabel timeFormatLabel;
    private JPanel markerPanel;
    private JPanel outerPanel;
    private JScrollPane outerScrollPane;
    private JRadioButton hhMMSSMSFormatRB;
    private JRadioButton specRB;
    private JRadioButton ssMSFormatRB;
    private JRadioButton typeRB;
    private JRadioButton wrapNextLineRB;
    private JRadioButton wrapAfterBlockRB;
    private JRadioButton detectedRMRB;
    private JRadioButton defaultRMRB;
    private JRadioButton customRMRB;
    private JTextField dbTypField;
    private JTextField numCharTF;
    private JTextField typField;
    private JTextField markerTF;
    private JCheckBox mediaMarkerCB;
    private JLabel mediaMarkerNameLabel;
    private JTextField mediaMarkerNameTF;
    private JComboBox mediaFilesCombo;
    private JRadioButton absFilePathRB;
    private JRadioButton relFilePathRB;
    private final int NUM_CHARS = 80;
    private List markers;
    private String databaseType;
    private String exportFileName;
    private int numRootTiers = 1;
    private String recordMarker = "";
    private ArrayList mergedTiers = new ArrayList();
    private ArrayList markersWithBlankLine = new ArrayList(5);
    private final String elanBeginLabel = "ELANBegin";
    private final String elanEndLabel = "ELANEnd";
    private final String elanParticipantLabel = "ELANParticipant";

    public ExportToolboxDialog(Frame parent, boolean modal, TranscriptionImpl transcription) {
        super(parent, modal, transcription, null);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
        this.typField.requestFocus();
    }

    public Vector getTierTree(TierImpl tier) {
        int j;
        Vector<TierImpl> tierTree = new Vector<TierImpl>();
        Vector<Vector> tierTrees = new Vector<Vector>();
        Vector children = tier.getChildTiers();
        tierTree.add(tier);
        for (j = 0; j < children.size(); ++j) {
            TierImpl child = (TierImpl)children.elementAt(j);
            tierTrees.add(this.getTierTree(child));
        }
        Collections.sort(tierTrees, new VectorComparator());
        for (j = 0; j < tierTrees.size(); ++j) {
            tierTree.addAll((Vector)tierTrees.elementAt(j));
        }
        return tierTree;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.typButton) {
            this.chooseTyp();
            this.typeRB.setSelected(true);
        } else {
            super.actionPerformed(ae);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.wrapBlocksCB) {
            if (this.wrapBlocksCB.isSelected()) {
                this.setDefaultNumOfChars();
                this.numCharTF.requestFocus();
                this.wrapLinesCB.setEnabled(true);
                this.wrapNextLineRB.setEnabled(this.wrapLinesCB.isSelected());
                this.wrapAfterBlockRB.setEnabled(this.wrapLinesCB.isSelected());
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
                this.wrapLinesCB.setEnabled(false);
                this.wrapNextLineRB.setEnabled(false);
                this.wrapAfterBlockRB.setEnabled(false);
            }
        } else if (ie.getSource() == this.wrapLinesCB) {
            this.wrapNextLineRB.setEnabled(this.wrapLinesCB.isSelected());
            this.wrapAfterBlockRB.setEnabled(this.wrapLinesCB.isSelected());
        } else if (ie.getSource() == this.typeRB) {
            this.enableTypComponents(true);
        } else if (ie.getSource() == this.specRB) {
            this.enableTypComponents(false);
        } else if (ie.getSource() == this.blankLineCB) {
            Object val;
            int row = this.tierTable.getSelectedRow();
            if (row > -1 && (val = this.model.getValueAt(row, this.model.findColumn("tier"))) instanceof SelectableObject) {
                ((SelectableObject)val).setSelected(this.blankLineCB.isSelected());
                this.tierTable.repaint();
            }
        } else if (ie.getSource() == this.detectedRMRB || ie.getSource() == this.defaultRMRB) {
            this.markerTF.setEnabled(false);
        } else if (ie.getSource() == this.customRMRB) {
            this.markerTF.setEnabled(true);
        } else if (ie.getSource() == this.mediaMarkerCB) {
            this.mediaFilesCombo.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaMarkerNameTF.setEnabled(this.mediaMarkerCB.isSelected());
            this.absFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.relFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int col = this.model.findColumn("export");
            int row = this.tierTable.getSelectedRow();
            if (row > -1) {
                Object val;
                if (this.tierTable.isRowSelected(row)) {
                    this.model.setValueAt(Boolean.TRUE, row, col);
                }
                if ((val = this.model.getValueAt(row, this.model.findColumn("tier"))) instanceof SelectableObject) {
                    this.blankLineCB.setSelected(((SelectableObject)val).isSelected());
                }
            }
        }
    }

    protected void extractTiers() {
        if (this.model != null) {
            for (int i = this.model.getRowCount() - 1; i >= 0; --i) {
                this.model.removeRow(i);
            }
            if (this.transcription != null) {
                ArrayList tierList;
                int i;
                List tierOrderList = ELANCommandFactory.getViewerManager(this.transcription).getTierOrder().getTierOrder();
                Vector<TierImpl> v = new Vector<TierImpl>();
                for (int i2 = 0; i2 < tierOrderList.size(); ++i2) {
                    TierImpl t = (TierImpl)this.transcription.getTierWithId(tierOrderList.get(i2).toString());
                    if (t == null) continue;
                    v.add(t);
                }
                ArrayList<String> rootTiers = new ArrayList<String>(5);
                for (int i3 = 0; i3 < v.size(); ++i3) {
                    TierImpl t = (TierImpl)v.get(i3);
                    String tName = t.getName();
                    int atIndex = tName.indexOf(64);
                    if (atIndex > -1) {
                        String markName = tName.substring(0, atIndex);
                        if (!this.mergedTiers.contains(markName)) {
                            this.mergedTiers.add(markName);
                        }
                        if (t.hasParentTier() || rootTiers.contains(markName)) continue;
                        rootTiers.add(markName);
                        continue;
                    }
                    this.mergedTiers.add(tName);
                    if (t.hasParentTier()) continue;
                    rootTiers.add(tName);
                }
                this.numRootTiers = rootTiers.size();
                if (this.numRootTiers == 1) {
                    this.recordMarker = (String)rootTiers.get(0);
                    int index = this.mergedTiers.indexOf(this.recordMarker);
                    if (index != 0) {
                        this.mergedTiers.remove(index);
                        this.mergedTiers.add(0, this.recordMarker);
                    }
                    if (this.detectedRMRB != null) {
                        this.detectedRMRB.setEnabled(true);
                        this.detectedRMRB.setText(this.detectedRMRB.getText() + " (\\" + this.recordMarker + ")");
                    }
                } else {
                    this.detectedRMRB.setEnabled(false);
                    this.defaultRMRB.setSelected(true);
                }
                List tierOrder = (List)Preferences.get("ExportToolbox.TierOrder", this.transcription);
                if (tierOrder != null) {
                    this.mergedTiers.add("ELANBegin");
                    this.mergedTiers.add("ELANEnd");
                    this.mergedTiers.add("ELANParticipant");
                    i = 0;
                    while (i < tierOrder.size()) {
                        if (!this.mergedTiers.contains(tierOrder.get(i))) {
                            tierOrder.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    if (tierOrder.size() != this.mergedTiers.size()) {
                        i = 0;
                        while (this.mergedTiers.size() != tierOrder.size()) {
                            if (!tierOrder.contains(this.mergedTiers.get(i))) {
                                tierOrder.add(this.mergedTiers.get(i));
                            }
                            ++i;
                        }
                    }
                    this.mergedTiers = new ArrayList(tierOrder);
                } else if (this.mergedTiers.size() > 1) {
                    this.mergedTiers.add(1, "ELANParticipant");
                    this.mergedTiers.add(1, "ELANEnd");
                    this.mergedTiers.add(1, "ELANBegin");
                } else {
                    this.mergedTiers.add("ELANParticipant");
                    this.mergedTiers.add("ELANEnd");
                    this.mergedTiers.add("ELANBegin");
                }
                for (i = 0; i < this.mergedTiers.size(); ++i) {
                    this.model.addRow(new Object[]{Boolean.TRUE, new SelectableObject(this.mergedTiers.get(i), false)});
                }
                Object useTyp = Preferences.get("ExportToolbox.selectedTiers", this.transcription);
                if (useTyp != null && useTyp instanceof ArrayList && (tierList = (ArrayList)useTyp).size() > 0) {
                    int includeCol = this.model.findColumn("export");
                    int nameCol = this.model.findColumn("tier");
                    for (int i4 = 0; i4 < this.model.getRowCount(); ++i4) {
                        SelectableObject obj = (SelectableObject)this.model.getValueAt(i4, nameCol);
                        if (tierList.contains(obj.getValue())) {
                            this.model.setValueAt(true, i4, includeCol);
                            continue;
                        }
                        this.model.setValueAt(false, i4, includeCol);
                    }
                }
            }
            if (this.model.getRowCount() > 1) {
                this.upButton.setEnabled(true);
                this.downButton.setEnabled(true);
            } else {
                this.upButton.setEnabled(false);
                this.downButton.setEnabled(false);
            }
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.charPerLineLabel = new JLabel();
        this.wrapBlocksCB = new JCheckBox();
        this.wrapBlocksCB.setSelected(true);
        this.numCharTF = new JTextField(4);
        this.timeFormatLabel = new JLabel();
        this.ssMSFormatRB = new JRadioButton();
        this.hhMMSSMSFormatRB = new JRadioButton();
        this.correctTimesCB = new JCheckBox();
        this.blankLineCB = new JCheckBox();
        this.blankLineCB.addItemListener(this);
        this.wrapLinesCB = new JCheckBox();
        this.wrapLinesCB.setSelected(true);
        this.wrapNextLineRB = new JRadioButton();
        this.wrapAfterBlockRB = new JRadioButton();
        this.wrapNextLineRB.setSelected(true);
        ButtonGroup wrapGroup = new ButtonGroup();
        wrapGroup.add(this.wrapNextLineRB);
        wrapGroup.add(this.wrapAfterBlockRB);
        this.includeEmptyLinesCB = new JCheckBox();
        this.includeEmptyLinesCB.setSelected(true);
        this.toolboxDBTypeLabel = new JLabel();
        this.typField = new JTextField("", 23);
        this.typButton = new JButton("...");
        this.dbTypField = new JTextField("", 14);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.typeRB = new JRadioButton();
        this.typeRB.setSelected(true);
        this.typeRB.addItemListener(this);
        this.specRB = new JRadioButton();
        this.specRB.addItemListener(this);
        buttonGroup.add(this.typeRB);
        buttonGroup.add(this.specRB);
        this.recordMarkerLabel = new JLabel();
        this.detectedRMRB = new JRadioButton();
        this.detectedRMRB.setSelected(true);
        this.defaultRMRB = new JRadioButton();
        this.customRMRB = new JRadioButton();
        ButtonGroup rmGroup = new ButtonGroup();
        rmGroup.add(this.detectedRMRB);
        rmGroup.add(this.defaultRMRB);
        rmGroup.add(this.customRMRB);
        this.markerTF = new JTextField("", 6);
        this.markerTF.setEnabled(false);
        this.mediaMarkerCB = new JCheckBox("");
        this.mediaMarkerCB.addItemListener(this);
        this.mediaMarkerNameLabel = new JLabel();
        this.mediaMarkerNameTF = new JTextField("", 6);
        this.mediaMarkerNameTF.setEnabled(false);
        this.mediaFilesCombo = new JComboBox();
        this.mediaFilesCombo.setEnabled(false);
        this.absFilePathRB = new JRadioButton();
        this.absFilePathRB.setSelected(true);
        this.relFilePathRB = new JRadioButton();
        ButtonGroup fileGroup = new ButtonGroup();
        fileGroup.add(this.absFilePathRB);
        fileGroup.add(this.relFilePathRB);
        this.model.setColumnIdentifiers(new String[]{"export", "tier"});
        this.tierTable.getColumn("export").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("export").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("tier").setCellRenderer(new MarkerCellRenderer());
        this.tierTable.getColumn("export").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().setSelectionMode(0);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        this.outerPanel = new JPanel();
        this.outerPanel.setLayout(new GridBagLayout());
        this.outerScrollPane = new JScrollPane(this.outerPanel);
        this.outerScrollPane.setBorder(null);
        Insets vertInsets = new Insets(0, 2, 2, 2);
        Insets leftVertIndent = new Insets(0, 26, 2, 2);
        Insets innerInsets = new Insets(4, 2, 4, 2);
        JPanel updownPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = innerInsets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        updownPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = innerInsets;
        updownPanel.add((Component)this.blankLineCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.tierSelectionPanel.add((Component)updownPanel, gridBagConstraints);
        this.getContentPane().remove(this.tierSelectionPanel);
        this.getContentPane().remove(this.optionsPanel);
        this.optionsPanel.setLayout(new GridBagLayout());
        JPanel wrapPanel = new JPanel(new GridBagLayout());
        JPanel timePanel = new JPanel(new GridBagLayout());
        this.wrapBlocksCB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = innerInsets;
        wrapPanel.add((Component)this.wrapBlocksCB, gridBagConstraints);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        wrapPanel.add((Component)this.numCharTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        wrapPanel.add((Component)this.charPerLineLabel, gridBagConstraints);
        this.wrapLinesCB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = innerInsets;
        wrapPanel.add((Component)this.wrapLinesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        wrapPanel.add((Component)this.wrapNextLineRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        wrapPanel.add((Component)this.wrapAfterBlockRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.insets;
        wrapPanel.add((Component)this.includeEmptyLinesCB, gridBagConstraints);
        ButtonGroup group = new ButtonGroup();
        group.add(this.ssMSFormatRB);
        this.ssMSFormatRB.setSelected(true);
        group.add(this.hhMMSSMSFormatRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = innerInsets;
        timePanel.add((Component)this.timeFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        timePanel.add((Component)this.hhMMSSMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        timePanel.add((Component)this.ssMSFormatRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = innerInsets;
        timePanel.add((Component)this.correctTimesCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.optionsPanel.add((Component)wrapPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.optionsPanel.add((Component)new JPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        this.optionsPanel.add((Component)timePanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = innerInsets;
        this.outerPanel.add((Component)this.tierSelectionPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = innerInsets;
        this.outerPanel.add((Component)this.optionsPanel, gridBagConstraints);
        this.markerPanel = new JPanel();
        this.markerPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = this.insets;
        this.markerPanel.add((Component)this.toolboxDBTypeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.typeRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.typField, gridBagConstraints);
        this.typButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.typButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.specRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.dbTypField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = innerInsets;
        this.markerPanel.add((Component)this.recordMarkerLabel, gridBagConstraints);
        this.detectedRMRB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.detectedRMRB, gridBagConstraints);
        this.defaultRMRB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.defaultRMRB, gridBagConstraints);
        this.customRMRB.addItemListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.customRMRB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.markerTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.mediaMarkerCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.mediaFilesCombo, gridBagConstraints);
        JPanel mediaPanel = new JPanel(new GridLayout(1, 2));
        mediaPanel.add(this.absFilePathRB);
        mediaPanel.add(this.relFilePathRB);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = innerInsets;
        this.markerPanel.add((Component)mediaPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = leftVertIndent;
        this.markerPanel.add((Component)this.mediaMarkerNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = vertInsets;
        this.markerPanel.add((Component)this.mediaMarkerNameTF, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = innerInsets;
        gridBagConstraints.gridy = 2;
        this.outerPanel.add((Component)this.markerPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = this.insets;
        this.getContentPane().add((Component)this.outerScrollPane, gridBagConstraints);
        this.setDefaultNumOfChars();
        this.setShoeboxMarkerRB();
        this.loadMediaFileNames();
        this.updateLocale();
        this.loadPreferences();
        this.addComponentListener(new SizeListener());
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void savePreferences() {
        Preferences.set("ExportToolbox.WrapBlocks", this.wrapBlocksCB.isSelected(), null);
        Preferences.set("ExportToolbox.CharacterPerBlocks", this.numCharTF.getText(), null);
        Preferences.set("ExportToolbox.wrapLinesCB", this.wrapLinesCB.isSelected(), null);
        Preferences.set("ExportToolbox.wrapNextLineRB", this.wrapNextLineRB.isSelected(), null);
        Preferences.set("ExportToolbox.includeEmptyLinesCB", this.includeEmptyLinesCB.isSelected(), null);
        Preferences.set("ExportToolbox.ssMSFormatRB", this.ssMSFormatRB.isSelected(), null);
        Preferences.set("ExportToolbox.correctTimesCB", this.correctTimesCB.isSelected(), null);
        Preferences.set("ExportToolbox.detectedRMRB", this.detectedRMRB.isSelected(), null);
        Preferences.set("ExportToolbox.defaultRMRB", this.defaultRMRB.isSelected(), null);
        Preferences.set("ExportToolbox.markerTF", this.markerTF.getText(), null);
        Preferences.set("ExportToolbox.blankLineCB", this.blankLineCB.isSelected(), null);
        Preferences.set("ExportToolbox.selectedTiers", this.getSelectedTiers(), this.transcription);
        List prefferedTierOrder = this.getCurrentTierOrder();
        for (int i = 0; i < prefferedTierOrder.size(); ++i) {
            if (prefferedTierOrder.get(i) == this.mergedTiers.get(i)) continue;
            Preferences.set("ExportToolbox.TierOrder", prefferedTierOrder, this.transcription);
            break;
        }
        if (this.specRB.isSelected()) {
            Preferences.set("ExportToolbox.ManualDBName", this.dbTypField.getText(), null);
        }
        Preferences.set("ExportToolbox.exportMediaMarker", this.mediaMarkerCB.isSelected(), null);
        if (this.mediaMarkerCB.isSelected()) {
            Preferences.set("ExportToolbox.mediaMarkerName", this.mediaMarkerNameTF.getText(), null);
            Preferences.set("ExportToolbox.fileForMediaMarker", this.mediaFilesCombo.getSelectedItem(), this.transcription);
            Preferences.set("ExportToolbox.absoluteMediaFileName", this.absFilePathRB.isSelected(), null);
        }
    }

    private void loadPreferences() {
        Object useTyp = Preferences.get("ExportToolbox.WrapBlocks", null);
        if (useTyp != null) {
            this.wrapBlocksCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportShoebox.numCharTF", null)) != null) {
            this.numCharTF.setText((String)useTyp);
        }
        if ((useTyp = Preferences.get("ExportShoebox.wrapLinesCB", null)) != null) {
            this.wrapLinesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.wrapNextLineRB", null)) != null) {
            this.wrapNextLineRB.setSelected((Boolean)useTyp);
            this.wrapAfterBlockRB.setSelected((Boolean)useTyp == false);
        }
        if ((useTyp = Preferences.get("ExportToolbox.includeEmptyLinesCB", null)) != null) {
            this.includeEmptyLinesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.ssMSFormatRB", null)) != null) {
            this.ssMSFormatRB.setSelected((Boolean)useTyp);
            this.hhMMSSMSFormatRB.setSelected((Boolean)useTyp == false);
        }
        if ((useTyp = Preferences.get("ExportToolbox.correctTimesCB", null)) != null) {
            this.correctTimesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.detectedRMRB", null)) != null) {
            this.detectedRMRB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.defaultRMRB", null)) != null) {
            this.defaultRMRB.setSelected((Boolean)useTyp);
        }
        if (this.defaultRMRB.isSelected() || this.detectedRMRB.isSelected()) {
            this.customRMRB.setSelected(false);
        } else {
            this.customRMRB.setSelected(true);
        }
        useTyp = Preferences.get("ExportToolbox.markerTF", null);
        if (useTyp != null) {
            this.markerTF.setText((String)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.blankLineCB", null)) != null) {
            this.blankLineCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.ManualDBName", null)) != null) {
            this.dbTypField.setText((String)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.exportMediaMarker", null)) != null) {
            this.mediaMarkerCB.setSelected((Boolean)useTyp);
            this.mediaFilesCombo.setEnabled(this.mediaMarkerCB.isSelected());
            this.mediaMarkerNameTF.setEnabled(this.mediaMarkerCB.isSelected());
            this.absFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
            this.relFilePathRB.setEnabled(this.mediaMarkerCB.isSelected());
        }
        if ((useTyp = Preferences.get("ExportToolbox.mediaMarkerName", null)) != null) {
            this.mediaMarkerNameTF.setText((String)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.fileForMediaMarker", this.transcription)) != null) {
            this.mediaFilesCombo.setSelectedItem((String)useTyp);
        }
        if ((useTyp = Preferences.get("ExportToolbox.absoluteMediaFileName", null)) != null) {
            this.absFilePathRB.setSelected((Boolean)useTyp);
            this.relFilePathRB.setSelected((Boolean)useTyp == false);
        }
    }

    @Override
    protected boolean startExport() {
        File exportFile;
        this.savePreferences();
        if (!this.checkFields()) {
            return false;
        }
        List selectedTiers = this.getSelectedTiers();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        if (selectedTiers.contains(this.recordMarker) && !selectedTiers.get(0).equals(this.recordMarker)) {
            selectedTiers.remove(this.recordMarker);
            selectedTiers.add(0, this.recordMarker);
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapBlocksCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportShoebox.Message.InvalidNumber"));
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        int timeFormat = 1;
        if (this.hhMMSSMSFormatRB.isSelected()) {
            timeFormat = 0;
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportShoebox.Title.Toolbox"), null, FileExtension.TOOLBOX_TEXT_EXT, false)) == null) {
            return false;
        }
        this.exportFileName = exportFile.getPath();
        boolean success = this.doExport(this.exportFileName, selectedTiers, charsPerLine, timeFormat, this.correctTimesCB.isSelected());
        return success;
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportShoebox.Title.Toolbox"));
        this.titleLabel.setText(ElanLocale.getString("ExportShoebox.Title.Toolbox"));
        this.blankLineCB.setText(ElanLocale.getString("ExportShoebox.Button.BlankLineAfter"));
        this.markerPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportShoebox.Label.ToolboxOptions")));
        this.wrapBlocksCB.setText(ElanLocale.getString("ExportShoebox.Label.WrapBlocks"));
        this.charPerLineLabel.setText(ElanLocale.getString("ExportShoebox.Label.NumberChars"));
        this.wrapLinesCB.setText(ElanLocale.getString("ExportShoebox.Label.WrapLines"));
        this.wrapAfterBlockRB.setText(ElanLocale.getString("ExportShoebox.Label.WrapEndOfBlock"));
        this.wrapNextLineRB.setText(ElanLocale.getString("ExportShoebox.Label.WrapNextLine"));
        this.includeEmptyLinesCB.setText(ElanLocale.getString("ExportShoebox.Label.IncludeEmpty"));
        this.timeFormatLabel.setText(ElanLocale.getString("ExportShoebox.Label.Format"));
        this.hhMMSSMSFormatRB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.TimeCode"));
        this.ssMSFormatRB.setText(ElanLocale.getString("InterlinearizerOptionsDlg.TimeCodeFormat.Seconds"));
        this.correctTimesCB.setText(ElanLocale.getString("ExportDialog.CorrectTimes"));
        this.toolboxDBTypeLabel.setText(ElanLocale.getString("ExportShoebox.Label.ToolboxBDName"));
        this.toolboxDBTypeLabel.setToolTipText("e.g. \\_sh v3.0  400 Text");
        this.typeRB.setText(ElanLocale.getString("ExportShoebox.Label.Type"));
        this.specRB.setText(ElanLocale.getString("ExportShoebox.Label.SpecifyType"));
        this.recordMarkerLabel.setText(ElanLocale.getString("ExportShoebox.Label.RecordMarker"));
        this.detectedRMRB.setText(ElanLocale.getString("ExportShoebox.Label.Detected"));
        this.defaultRMRB.setText(ElanLocale.getString("ExportShoebox.Label.DefaultMarker") + " (\\block)");
        this.customRMRB.setText(ElanLocale.getString("ExportShoebox.Label.CustomMarker"));
        this.mediaMarkerCB.setText(ElanLocale.getString("ExportShoebox.Label.IncludeMediaMarker"));
        this.mediaMarkerNameLabel.setText(ElanLocale.getString("ExportShoebox.Label.MediaMarkerName"));
        this.absFilePathRB.setText(ElanLocale.getString("ExportShoebox.Label.AbsoluteMediaFile"));
        this.relFilePathRB.setText(ElanLocale.getString("ExportShoebox.Label.RelMediaFile"));
    }

    private void loadMediaFileNames() {
        Vector mds = this.transcription.getMediaDescriptors();
        if (mds != null && mds.size() > 0) {
            MediaDescriptor md = null;
            for (int i = 0; i < mds.size(); ++i) {
                md = (MediaDescriptor)mds.get(i);
                String name = FileUtility.fileNameFromPath(md.mediaURL);
                if (name == null) continue;
                this.mediaFilesCombo.addItem(name);
            }
        } else {
            this.mediaMarkerCB.setSelected(false);
            this.mediaMarkerCB.setEnabled(false);
        }
    }

    private void setDefaultNumOfChars() {
        this.numCharTF.setEnabled(true);
        this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
        if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
            this.numCharTF.setText("80");
        }
    }

    private List getMarkersWithBlankLines() {
        ArrayList<Object> mbl = new ArrayList<Object>();
        int nameCol = this.model.findColumn("tier");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            SelectableObject sob = (SelectableObject)this.model.getValueAt(i, nameCol);
            if (!sob.isSelected()) continue;
            mbl.add(sob.getValue());
        }
        return mbl;
    }

    private Vector getHierarchicallySortedTiers(TranscriptionImpl transcription) {
        Vector<Vector> tierTrees = new Vector<Vector>();
        Vector sortedTiers = new Vector();
        Vector topTiers = transcription.getTopTiers();
        for (int i = 0; i < topTiers.size(); ++i) {
            TierImpl topTier = (TierImpl)topTiers.elementAt(i);
            tierTrees.add(this.getTierTree(topTier));
        }
        Collections.sort(tierTrees, new VectorComparator());
        for (int j = 0; j < tierTrees.size(); ++j) {
            sortedTiers.addAll((Vector)tierTrees.elementAt(j));
        }
        return sortedTiers;
    }

    private void setShoeboxMarkerRB() {
        Object useTyp = Preferences.get("LastUsedShoeboxExport", null);
        if (useTyp == null || useTyp instanceof String && ((String)useTyp).equalsIgnoreCase("typ")) {
            this.typeRB.setSelected(true);
            Object luTypFile = Preferences.get("LastUsedShoeboxTypFile", null);
            if (luTypFile instanceof String) {
                this.typField.setText((String)luTypFile);
            }
            this.enableTypComponents(true);
        } else {
            this.specRB.setSelected(true);
            this.enableTypComponents(false);
        }
    }

    private void enableTypComponents(boolean enable) {
        this.typField.setEnabled(enable);
        this.typButton.setEnabled(enable);
        this.dbTypField.setEnabled(!enable);
    }

    private void autoGenerateMarkerFile() {
        Vector<MarkerRecord> markerRecords = new Vector<MarkerRecord>();
        try {
            Vector tiers = this.transcription.getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = (TierImpl)tiers.elementAt(i);
                MarkerRecord mkrRecord = new MarkerRecord();
                mkrRecord.setMarker(t.getName());
                if (t.hasParentTier()) {
                    mkrRecord.setParentMarker(t.getParentTier().getName());
                    if (t.getLinguisticType() != null) {
                        int stereotype = t.getLinguisticType().getConstraints().getStereoType();
                        if (stereotype == 3 || stereotype == 0 || stereotype == 1) {
                            mkrRecord.setStereoType(Constraint.stereoTypes[3]);
                        } else if (stereotype == 4) {
                            mkrRecord.setStereoType(Constraint.stereoTypes[4]);
                        }
                    }
                }
                mkrRecord.setCharset("Unicode (UTF-8)");
                mkrRecord.setParticipantMarker(false);
                mkrRecord.setExcluded(false);
                markerRecords.add(mkrRecord);
            }
            String fileName = ((TranscriptionImpl)this.transcription).getPathName();
            if (this.exportFileName != null) {
                fileName = this.exportFileName.substring(0, this.exportFileName.lastIndexOf("."));
            } else if (fileName.toLowerCase().endsWith(".eaf")) {
                fileName = fileName.substring(0, fileName.lastIndexOf("."));
            }
            fileName = fileName + ".mkr";
            File newSaveFile = new File(fileName);
            if (newSaveFile != null) {
                int answer;
                if (newSaveFile.exists() && (answer = JOptionPane.showConfirmDialog(null, ElanLocale.getString("Message.Overwrite") + "\n" + fileName, ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                    return;
                }
                FileOutputStream out = new FileOutputStream(newSaveFile);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                Iterator markerIter = markerRecords.iterator();
                while (markerIter.hasNext()) {
                    writer.write(((MarkerRecord)markerIter.next()).toString());
                }
                writer.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private boolean checkFields() {
        String mediaMarker;
        if (this.typeRB.isSelected() && (this.typField.getText() == null || this.typField.getText().length() == 0)) {
            this.showError(ElanLocale.getString("ImportDialog.Message.SpecifyType"));
            return false;
        }
        if (this.typeRB.isSelected()) {
            File tf = new File(this.typField.getText());
            if (!tf.exists()) {
                this.showError(ElanLocale.getString("ImportDialog.Message.NoType"));
                return false;
            }
            try {
                ShoeboxTypFile typFile = new ShoeboxTypFile(tf);
                this.databaseType = typFile.getDatabaseType();
            }
            catch (Exception exception) {}
        } else {
            this.databaseType = this.dbTypField.getText();
            if (this.databaseType == null || this.databaseType.trim().length() == 0) {
                this.showError(ElanLocale.getString("ExportShoebox.Message.NoType"));
                this.dbTypField.requestFocus();
                return false;
            }
        }
        if (this.customRMRB.isSelected()) {
            String custRM = this.markerTF.getText();
            if (custRM == null || custRM.trim().length() == 0) {
                this.showError(ElanLocale.getString("ExportShoebox.Message.NoRecordMarker"));
                this.markerTF.requestFocus();
                return false;
            }
            this.recordMarker = custRM.trim();
        } else if (this.defaultRMRB.isSelected()) {
            this.recordMarker = "block";
        }
        if (this.mediaMarkerCB.isSelected() && ((mediaMarker = this.mediaMarkerNameTF.getText()) == null || mediaMarker.trim().length() <= 0)) {
            this.showError(ElanLocale.getString("ExportShoebox.Message.NoMediaMarker"));
            this.mediaMarkerNameTF.requestFocus();
            return false;
        }
        return true;
    }

    private void chooseTyp() {
        FileChooser chooser = new FileChooser(this);
        chooser.createAndShowFileDialog(ElanLocale.getString("ImportDialog.Title.Select"), 0, ElanLocale.getString("ImportDialog.Approve"), null, FileExtension.SHOEBOX_TYP_EXT, false, "LastUsedShoeboxTypDir", 0, null);
        File f = chooser.getSelectedFile();
        if (f != null) {
            this.typField.setText(f.getAbsolutePath());
        }
    }

    private boolean doExport(String fileName, List orderedTiers, int charsPerLine, int timeFormat, boolean correctTimes) {
        Vector mds;
        int markerSource = 2;
        if (this.typeRB.isSelected()) {
            markerSource = 0;
            Preferences.set("LastUsedShoeboxExport", "typ", null);
            Preferences.set("LastUsedShoeboxTypFile", this.typField.getText(), null);
        } else {
            Preferences.set("LastUsedShoeboxExport", "", null);
        }
        ToolboxEncoderInfo tbEncoderInfo = new ToolboxEncoderInfo(charsPerLine, markerSource, timeFormat);
        tbEncoderInfo.setCorrectAnnotationTimes(correctTimes);
        if (this.databaseType != null) {
            tbEncoderInfo.setDatabaseType(this.databaseType);
        }
        if (charsPerLine != Integer.MAX_VALUE) {
            tbEncoderInfo.setWrapLines(this.wrapLinesCB.isSelected());
            if (this.wrapLinesCB.isSelected()) {
                if (this.wrapNextLineRB.isSelected()) {
                    tbEncoderInfo.setLineWrapStyle(4);
                } else {
                    tbEncoderInfo.setLineWrapStyle(5);
                }
            } else {
                tbEncoderInfo.setLineWrapStyle(3);
            }
        } else {
            tbEncoderInfo.setWrapLines(false);
            tbEncoderInfo.setLineWrapStyle(3);
        }
        if (this.correctTimesCB.isSelected() && (mds = this.transcription.getMediaDescriptors()) != null && mds.size() > 0) {
            long mediaOffset = ((MediaDescriptor)mds.get((int)0)).timeOrigin;
            tbEncoderInfo.setTimeOffset(mediaOffset);
        }
        tbEncoderInfo.setIncludeEmptyMarkers(this.includeEmptyLinesCB.isSelected());
        tbEncoderInfo.setRecordMarker(this.recordMarker);
        tbEncoderInfo.setOrderedVisibleTiers(orderedTiers);
        tbEncoderInfo.setMarkersWithBlankLines(this.getMarkersWithBlankLines());
        boolean includeMediaMarker = this.mediaMarkerCB.isSelected();
        if (includeMediaMarker) {
            tbEncoderInfo.setIncludeMediaMarker(true);
            tbEncoderInfo.setMediaMarker(this.mediaMarkerNameTF.getText());
            String selFileName = (String)this.mediaFilesCombo.getSelectedItem();
            if (this.relFilePathRB.isSelected()) {
                tbEncoderInfo.setMediaFileName(selFileName);
            } else {
                Vector mds2 = this.transcription.getMediaDescriptors();
                for (int i = 0; i < mds2.size(); ++i) {
                    MediaDescriptor md = (MediaDescriptor)mds2.get(i);
                    if (md.mediaURL == null || !md.mediaURL.endsWith(selFileName)) continue;
                    String fileURL = FileUtility.urlToAbsPath(md.mediaURL);
                    int numSlash = 0;
                    for (int j = 0; j < fileURL.length() && fileURL.charAt(j) == '/'; ++j) {
                        ++numSlash;
                    }
                    if (numSlash != 0 && numSlash != 2) {
                        fileURL = fileURL.substring(numSlash);
                    }
                    tbEncoderInfo.setMediaFileName(fileURL.replace('/', '\\'));
                    break;
                }
            }
        }
        if (fileName != null) {
            try {
                ToolboxEncoder encoder = new ToolboxEncoder();
                encoder.encodeAndSave(this.transcription, tbEncoderInfo, orderedTiers, fileName);
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error") + "\n" + "(" + ioe.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
        return true;
    }

    @Override
    protected List getSelectedTiers() {
        int includeCol = this.model.findColumn("export");
        int nameCol = this.model.findColumn("tier");
        ArrayList<Object> selectedTiers = new ArrayList<Object>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Boolean include = (Boolean)this.model.getValueAt(i, includeCol);
            if (!include.booleanValue()) continue;
            selectedTiers.add(((SelectableObject)this.model.getValueAt(i, nameCol)).getValue());
        }
        return selectedTiers;
    }

    private List getCurrentTierOrder() {
        int includeCol = this.model.findColumn("export");
        int nameCol = this.model.findColumn("tier");
        ArrayList<Object> tierOrder = new ArrayList<Object>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            tierOrder.add(((SelectableObject)this.model.getValueAt(i, nameCol)).getValue());
        }
        return tierOrder;
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Error"), 0);
    }

    class SizeListener
    implements ComponentListener {
        SizeListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            if (ExportToolboxDialog.this.outerScrollPane != null) {
                if (ExportToolboxDialog.this.outerScrollPane.getHorizontalScrollBar().isVisible() || ExportToolboxDialog.this.outerScrollPane.getVerticalScrollBar().isVisible()) {
                    if (ExportToolboxDialog.this.outerScrollPane.getBorder() == null) {
                        ExportToolboxDialog.this.outerScrollPane.setBorder(new LineBorder(Color.GRAY, 1));
                    }
                } else if (ExportToolboxDialog.this.outerScrollPane.getBorder() != null) {
                    ExportToolboxDialog.this.outerScrollPane.setBorder(null);
                }
            }
        }

        @Override
        public void componentShown(ComponentEvent e) {
            this.componentResized(e);
        }
    }

    class MarkerCellRenderer
    extends DefaultTableCellRenderer {
        MarkerCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof SelectableObject) {
                if (((SelectableObject)value).isSelected()) {
                    c.setForeground(Constants.ACTIVEANNOTATIONCOLOR);
                } else if (!isSelected) {
                    c.setForeground(table.getForeground());
                }
            }
            return c;
        }
    }

    class VectorComparator
    implements Comparator {
        VectorComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Vector v0 = (Vector)arg0;
            Vector v1 = (Vector)arg1;
            if (v0.size() < v1.size()) {
                return 1;
            }
            if (v0.size() > v1.size()) {
                return -1;
            }
            return 0;
        }
    }
}

