/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.Selection;
import mpi.eudico.client.annotator.export.AbstractExtTierExportDialog;
import mpi.eudico.client.annotator.util.AnnotationDataRecord;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.server.corpora.clom.Annotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;
import mpi.eudico.util.TimeRelation;

public class ExportTradTranscript
extends AbstractExtTierExportDialog
implements ItemListener {
    private JCheckBox labelsCB;
    private JTextField labelWidthTF;
    private JCheckBox labelWidthCB;
    private JCheckBox selectionCB;
    private JCheckBox timeCodeCB;
    private JCheckBox silenceCB;
    private JTextField minDurSilTF;
    private JLabel minDurSilLabel;
    private JComboBox silenceDecimalComboBox;
    private JLabel silDecimalLabel;
    private JCheckBox wrapLinesCB;
    private JCheckBox emptyLineCB;
    private JLabel charPerLineLabel;
    private JTextField numCharTF;
    private JCheckBox mergeAnnCB;
    private JTextField mergeDurTF;
    private JLabel mergeDurLabel;
    private final String NEW_LINE = "\n";
    private final String SPACE = " ";
    private final String TIME_SEP = " - ";
    private final char NL_CHAR = (char)10;
    private final char SPACE_CHAR = (char)32;
    private final int LABEL_VALUE_MARGIN = 3;
    private final int NUM_CHARS = 80;
    private final int LABEL_WIDTH = 5;
    private final int MERGE_DUR = 50;
    private final int MIN_SILENCE = 20;

    public ExportTradTranscript(Frame parent, boolean modal, TranscriptionImpl transcription, Selection selection) {
        super(parent, modal, transcription, selection);
        this.makeLayout();
        this.extractTiers();
        this.postInit();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        if (ie.getSource() == this.wrapLinesCB) {
            if (this.wrapLinesCB.isSelected()) {
                this.numCharTF.setEnabled(true);
                this.numCharTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.numCharTF.getText() != null || this.numCharTF.getText().length() == 0) {
                    this.numCharTF.setText("80");
                }
                this.numCharTF.requestFocus();
            } else {
                this.numCharTF.setEnabled(false);
                this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.silenceCB) {
            if (this.silenceCB.isSelected()) {
                this.minDurSilTF.setEnabled(true);
                this.minDurSilTF.setBackground(Constants.SHAREDCOLOR4);
                this.silenceDecimalComboBox.setEnabled(true);
                if (this.minDurSilTF.getText() == null || this.minDurSilTF.getText().length() == 0) {
                    this.minDurSilTF.setText("20");
                }
                this.minDurSilTF.requestFocus();
            } else {
                this.minDurSilTF.setEnabled(false);
                this.silenceDecimalComboBox.setEnabled(false);
                this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.labelsCB) {
            this.labelWidthCB.setEnabled(this.labelsCB.isSelected());
            if (this.labelWidthCB.isEnabled()) {
                if (this.labelWidthCB.isSelected()) {
                    this.labelWidthTF.setEnabled(true);
                    this.labelWidthTF.setBackground(Constants.SHAREDCOLOR4);
                    if (this.labelWidthTF.getText() == null || this.labelWidthTF.getText().length() == 0) {
                        this.labelWidthTF.setText("5");
                    }
                    this.labelWidthTF.requestFocus();
                } else {
                    this.labelWidthTF.setEnabled(false);
                    this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
                }
            } else {
                this.labelWidthTF.setEnabled(false);
                this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.labelWidthCB) {
            if (this.labelWidthCB.isSelected() && this.labelWidthCB.isEnabled()) {
                this.labelWidthTF.setEnabled(true);
                this.labelWidthTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.labelWidthTF.getText() == null || this.labelWidthTF.getText().length() == 0) {
                    this.labelWidthTF.setText("5");
                }
                this.labelWidthTF.requestFocus();
            } else {
                this.labelWidthTF.setEnabled(false);
                this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        } else if (ie.getSource() == this.mergeAnnCB) {
            if (this.mergeAnnCB.isSelected()) {
                this.mergeDurTF.setEnabled(true);
                this.mergeDurTF.setBackground(Constants.SHAREDCOLOR4);
                if (this.mergeDurTF.getText() == null || this.mergeDurTF.getText().length() == 0) {
                    this.mergeDurTF.setText("50");
                }
                this.mergeDurTF.requestFocus();
            } else {
                this.mergeDurTF.setEnabled(false);
                this.mergeDurTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
            }
        }
    }

    protected void extractTiers() {
        Object useTyp = Preferences.get("ExportTradTranscript.TierOrder", this.transcription);
        if (useTyp instanceof List) {
            this.setTierOrder((List)useTyp);
        } else {
            super.extractTiers(true);
        }
        useTyp = Preferences.get("ExportTradTranscript.selectedTiers", this.transcription);
        if (useTyp instanceof List) {
            this.setSelectedTiers((List)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.SelectTiersMode", this.transcription)) instanceof String) {
            Object selItems;
            this.setSelectionMode((String)useTyp);
            if (!"Tier".equals((String)useTyp) && (selItems = Preferences.get("ExportTradTranscript.LastSelectedItems", this.transcription)) instanceof List) {
                this.setSelectedItems((List)selItems);
            }
        }
    }

    @Override
    protected void makeLayout() {
        super.makeLayout();
        this.charPerLineLabel = new JLabel();
        this.wrapLinesCB = new JCheckBox();
        this.numCharTF = new JTextField(4);
        this.timeCodeCB = new JCheckBox();
        this.silenceCB = new JCheckBox();
        this.minDurSilLabel = new JLabel();
        this.minDurSilTF = new JTextField(4);
        this.silDecimalLabel = new JLabel();
        this.silenceDecimalComboBox = new JComboBox();
        this.silenceDecimalComboBox.addItem(1);
        this.silenceDecimalComboBox.addItem(2);
        this.silenceDecimalComboBox.addItem(3);
        this.silenceDecimalComboBox.setSelectedItem(2);
        this.labelsCB = new JCheckBox();
        this.labelWidthCB = new JCheckBox();
        this.labelWidthTF = new JTextField(4);
        this.selectionCB = new JCheckBox();
        this.emptyLineCB = new JCheckBox();
        this.emptyLineCB.setSelected(true);
        this.mergeAnnCB = new JCheckBox();
        this.mergeDurLabel = new JLabel();
        this.mergeDurTF = new JTextField(4);
        this.optionsPanel.setLayout(new GridBagLayout());
        JPanel labelWidthPanel = new JPanel(new GridBagLayout());
        this.labelWidthCB.addItemListener(this);
        this.labelWidthCB.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = this.insets;
        labelWidthPanel.add((Component)this.labelWidthCB, gbc);
        this.labelWidthTF.setEnabled(false);
        this.labelWidthTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc.gridx = 1;
        labelWidthPanel.add((Component)this.labelWidthTF, gbc);
        this.wrapLinesCB.addItemListener(this);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 17;
        gbc.insets = this.insets;
        this.optionsPanel.add((Component)this.wrapLinesCB, gbc);
        JPanel fill = new JPanel();
        Dimension fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        ++gbc.gridy;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)fill, gbc);
        this.numCharTF.setEnabled(false);
        this.numCharTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.numCharTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.charPerLineLabel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.timeCodeCB, gbc);
        this.mergeAnnCB.addItemListener(this);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.mergeAnnCB, gbc);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)fill, gbc);
        this.mergeDurTF.setEnabled(false);
        this.mergeDurTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.mergeDurTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.mergeDurLabel, gbc);
        this.labelsCB.addItemListener(this);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.labelsCB, gbc);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)fill, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        this.optionsPanel.add((Component)labelWidthPanel, gbc);
        gbc.gridx = 0;
        gbc.gridwidth = 3;
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.emptyLineCB, gbc);
        this.silenceCB.addItemListener(this);
        ++gbc.gridy;
        this.optionsPanel.add((Component)this.silenceCB, gbc);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)fill, gbc);
        this.minDurSilTF.setEnabled(false);
        this.minDurSilTF.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.minDurSilTF, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.minDurSilLabel, gbc);
        fill = new JPanel();
        fillDim = new Dimension(30, 10);
        fill.setPreferredSize(fillDim);
        gbc.gridx = 0;
        ++gbc.gridy;
        this.optionsPanel.add((Component)fill, gbc);
        gbc.gridx = 1;
        this.optionsPanel.add((Component)this.silenceDecimalComboBox, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.silDecimalLabel, gbc);
        gbc.gridx = 0;
        ++gbc.gridy;
        gbc.gridwidth = 3;
        this.optionsPanel.add((Component)this.selectionCB, gbc);
        this.setPreferredSetting();
        this.updateLocale();
    }

    protected void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    @Override
    protected boolean startExport() {
        File exportFile;
        List<String> selectedTiers = this.getSelectedTiers();
        this.savePreferences();
        if (selectedTiers.size() == 0) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportTradTranscript.Message.NoTiers"), ElanLocale.getString("Message.Warning"), 2);
            return false;
        }
        int charsPerLine = Integer.MAX_VALUE;
        if (this.wrapLinesCB.isSelected()) {
            String textValue = this.numCharTF.getText().trim();
            try {
                charsPerLine = Integer.parseInt(textValue);
                if (charsPerLine <= 10) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber"));
                    this.numCharTF.selectAll();
                    this.numCharTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber"));
                this.numCharTF.selectAll();
                this.numCharTF.requestFocus();
                return false;
            }
        }
        int labelWidth = 5;
        if (this.labelsCB.isSelected() && this.labelWidthCB.isSelected()) {
            String textValue = this.labelWidthTF.getText().trim();
            try {
                labelWidth = Integer.parseInt(textValue);
                if (labelWidth <= 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber3"));
                    this.labelWidthTF.selectAll();
                    this.labelWidthTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber3"));
                this.labelWidthTF.selectAll();
                this.labelWidthTF.requestFocus();
                return false;
            }
        }
        int mergeValue = 50;
        if (this.mergeAnnCB.isSelected()) {
            String textValue = this.mergeDurTF.getText().trim();
            try {
                mergeValue = Integer.parseInt(textValue);
                if (mergeValue <= 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber4"));
                    this.mergeDurTF.selectAll();
                    this.mergeDurTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber4"));
                this.mergeDurTF.selectAll();
                this.mergeDurTF.requestFocus();
                return false;
            }
        }
        int minSilence = 20;
        if (this.silenceCB.isSelected()) {
            String textValue = this.minDurSilTF.getText().trim();
            try {
                minSilence = Integer.parseInt(textValue);
                if (minSilence <= 0) {
                    this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber2"));
                    this.minDurSilTF.selectAll();
                    this.minDurSilTF.requestFocus();
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.showWarningDialog(ElanLocale.getString("ExportTradTranscript.Message.InvalidNumber2"));
                this.minDurSilTF.selectAll();
                this.minDurSilTF.requestFocus();
                return false;
            }
        }
        if ((exportFile = this.promptForFile(ElanLocale.getString("ExportTradTranscript.Title"), null, FileExtension.TEXT_EXT, true)) == null) {
            return false;
        }
        return this.doExport(exportFile, selectedTiers, charsPerLine, minSilence, mergeValue, labelWidth);
    }

    @Override
    protected void updateLocale() {
        super.updateLocale();
        this.setTitle(ElanLocale.getString("ExportTradTranscript.Title"));
        this.titleLabel.setText(ElanLocale.getString("ExportTradTranscript.Title"));
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportDialog.Label.Options")));
        this.wrapLinesCB.setText(ElanLocale.getString("ExportTradTranscript.Label.WrapLines"));
        this.charPerLineLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.NumberChars"));
        this.timeCodeCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTimeCode"));
        this.labelsCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeTierLabels"));
        this.silenceCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeSilence"));
        this.minDurSilLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.MinSilenceDuration"));
        this.selectionCB.setText(ElanLocale.getString("ExportDialog.Restrict"));
        this.silDecimalLabel.setText(ElanLocale.getString("InterlinearizerOptionsDlg.NumberofDigits"));
        this.emptyLineCB.setText(ElanLocale.getString("ExportTradTranscript.Label.IncludeEmptyLines"));
        this.labelWidthCB.setText(ElanLocale.getString("ExportTradTranscript.Label.MaxLabelWidth"));
        this.mergeAnnCB.setText(ElanLocale.getString("ExportTradTranscript.Label.MergeAnnotations"));
        this.mergeDurLabel.setText(ElanLocale.getString("ExportTradTranscript.Label.MergeDuration"));
    }

    private String getMarginString(String name, int numchars, int fixedLabelWidth) {
        int nameLength = 0;
        if (name != null) {
            if (name.length() > fixedLabelWidth) {
                name = name.substring(0, fixedLabelWidth);
            }
            nameLength = name.length();
        }
        StringBuffer bf = new StringBuffer(name);
        for (int i = 0; i < numchars - nameLength; ++i) {
            bf.append(" ");
        }
        return bf.toString();
    }

    private String[] breakValue(String val, int maxAnnotationLength) {
        if (val == null) {
            return new String[0];
        }
        if (val.indexOf(" ") < 0 || val.length() < maxAnnotationLength) {
            return new String[]{val};
        }
        ArrayList<String> vals = new ArrayList<String>();
        String sub = null;
        while (val.length() > maxAnnotationLength) {
            sub = val.substring(0, maxAnnotationLength);
            int breakSpace = sub.lastIndexOf(32);
            if (breakSpace < 0) {
                breakSpace = val.indexOf(32);
                if (breakSpace < 0) {
                    vals.add(val);
                    break;
                }
                vals.add(val.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            } else {
                vals.add(sub.substring(0, breakSpace + 1));
                val = val.substring(breakSpace + 1);
            }
            if (val.length() > maxAnnotationLength) continue;
            vals.add(val);
            break;
        }
        return vals.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doExport(File exportFile, List orderedTiers, int charsPerLine, int minSilence, int mergeValue, int fixedLabelWidth) {
        boolean selectionOnly = this.selectionCB.isSelected();
        boolean wrapLines = this.wrapLinesCB.isSelected();
        boolean includeTimeCodes = this.timeCodeCB.isSelected();
        boolean includeLabels = this.labelsCB.isSelected();
        boolean includeSilence = this.silenceCB.isSelected();
        boolean insertEmptyLine = this.emptyLineCB.isSelected();
        boolean mergeAnn = this.mergeAnnCB.isSelected();
        int labelMargin = 0;
        int labelWidth = 0;
        Hashtable<String, String> marginStrings = null;
        String tcLabel = "TC";
        String emptyLabel = "empty";
        int maxAnnotationLength = charsPerLine;
        if (includeLabels) {
            int count;
            String name;
            int i;
            marginStrings = new Hashtable<String, String>();
            if (this.labelWidthCB.isSelected()) {
                labelWidth = fixedLabelWidth;
                labelMargin = labelWidth + 3;
            } else {
                for (i = 0; i < orderedTiers.size(); ++i) {
                    name = (String)orderedTiers.get(i);
                    if (name.length() <= labelMargin) continue;
                    labelMargin = name.length();
                }
                labelWidth = labelMargin;
                labelMargin += 3;
            }
            for (i = 0; i < orderedTiers.size(); ++i) {
                name = (String)orderedTiers.get(i);
                marginStrings.put(name, this.getMarginString(name, labelMargin, labelWidth));
            }
            if (includeTimeCodes) {
                if (!marginStrings.containsKey(tcLabel)) {
                    marginStrings.put(tcLabel, this.getMarginString(tcLabel, labelMargin, labelWidth));
                } else {
                    for (count = 1; count < 100; ++count) {
                        String tcl = tcLabel + "-" + count;
                        if (marginStrings.containsKey(tcl)) continue;
                        tcLabel = tcl;
                        marginStrings.put(tcLabel, this.getMarginString(tcLabel, labelMargin, labelWidth));
                        break;
                    }
                }
            }
            if (!marginStrings.containsKey(emptyLabel)) {
                marginStrings.put(emptyLabel, this.getMarginString("", labelMargin, labelWidth));
            } else {
                for (count = 1; count < 100; ++count) {
                    String tcl = emptyLabel + "-" + count;
                    if (marginStrings.containsKey(tcl)) continue;
                    emptyLabel = tcl;
                    marginStrings.put(emptyLabel, this.getMarginString("", labelMargin, labelWidth));
                    break;
                }
            }
        }
        if (wrapLines && includeLabels) {
            maxAnnotationLength = charsPerLine - labelMargin;
        }
        long bb = 0L;
        long eb = Long.MAX_VALUE;
        if (selectionOnly && this.selection != null) {
            bb = this.selection.getBeginTime();
            eb = this.selection.getEndTime();
        }
        TreeSet<IndexedExportRecord> records = new TreeSet<IndexedExportRecord>();
        block19: for (int i = 0; i < orderedTiers.size(); ++i) {
            String tierName = (String)orderedTiers.get(i);
            TierImpl t = (TierImpl)this.transcription.getTierWithId(tierName);
            if (t == null) continue;
            Vector v = t.getAnnotations();
            for (int j = 0; j < v.size(); ++j) {
                Annotation ann = (Annotation)v.get(j);
                if (TimeRelation.overlaps(ann, bb, eb)) {
                    records.add(new IndexedExportRecord(ann, i));
                }
                if (ann.getBeginTimeBoundary() > eb) continue block19;
            }
        }
        if (includeSilence) {
            IndexedExportRecord rec1 = null;
            IndexedExportRecord rec22 = null;
            long endTime = 0L;
            for (IndexedExportRecord rec22 : records) {
                long dur;
                if (rec1 != null && (dur = rec22.getBeginTime() - endTime) >= (long)minSilence) {
                    rec1.setSilenceAfter(this.formatSilenceString(dur));
                }
                if (endTime < rec22.getEndTime()) {
                    endTime = rec22.getEndTime();
                }
                rec1 = rec22;
            }
        }
        float mergeVal = (float)mergeValue / 1000.0f;
        BufferedWriter writer = null;
        try {
            block90: {
                Iterator recIter;
                block89: {
                    block92: {
                        IndexedExportRecord record;
                        block91: {
                            String[] valLines;
                            FileOutputStream out = new FileOutputStream(exportFile);
                            OutputStreamWriter osw = null;
                            try {
                                osw = new OutputStreamWriter((OutputStream)out, this.encoding);
                            }
                            catch (UnsupportedCharsetException uce) {
                                osw = new OutputStreamWriter((OutputStream)out, "UTF-8");
                            }
                            writer = new BufferedWriter(osw);
                            recIter = records.iterator();
                            if (!mergeAnn) break block89;
                            if (!recIter.hasNext()) break block90;
                            record = (IndexedExportRecord)recIter.next();
                            String val = record.getValue();
                            long beginTime = record.getBeginTime();
                            float silDur = -1.0f;
                            while (recIter.hasNext()) {
                                IndexedExportRecord nextRec = (IndexedExportRecord)recIter.next();
                                silDur = -1.0f;
                                if (record.getSilenceAfter() != null) {
                                    try {
                                        silDur = Float.parseFloat(record.getSilenceAfter());
                                    }
                                    catch (NumberFormatException e) {
                                        silDur = -1.0f;
                                    }
                                }
                                if (record.getTierName().equals(nextRec.getTierName()) && silDur > 0.0f && silDur <= mergeVal) {
                                    if (includeSilence) {
                                        val = val + " (" + silDur + ")";
                                    }
                                    val = val + " " + nextRec.getValue();
                                    record = nextRec;
                                    continue;
                                }
                                val = val.replace('\n', ' ');
                                if (includeLabels) {
                                    writer.write((String)marginStrings.get(record.getTierName()));
                                }
                                if (!wrapLines) {
                                    writer.write(val);
                                } else if (val.length() <= maxAnnotationLength) {
                                    writer.write(val);
                                } else {
                                    valLines = this.breakValue(val, maxAnnotationLength);
                                    for (int i = 0; i < valLines.length; ++i) {
                                        if (i != 0 && includeLabels) {
                                            writer.write((String)marginStrings.get(emptyLabel));
                                        }
                                        writer.write(valLines[i]);
                                        if (i == valLines.length - 1) continue;
                                        writer.write("\n");
                                    }
                                }
                                writer.write("\n");
                                if (includeTimeCodes) {
                                    if (includeLabels) {
                                        writer.write((String)marginStrings.get(tcLabel));
                                    }
                                    writer.write(TimeFormatter.toString(beginTime));
                                    writer.write(" - ");
                                    writer.write(TimeFormatter.toString(record.getEndTime()));
                                    writer.write("\n");
                                    if (includeSilence && record.getSilenceAfter() != null) {
                                        if (includeLabels) {
                                            writer.write((String)marginStrings.get(emptyLabel));
                                        }
                                        writer.write("(" + record.getSilenceAfter() + ")");
                                        writer.write("\n");
                                    }
                                    if (insertEmptyLine) {
                                        writer.write("\n");
                                    }
                                } else if (includeSilence) {
                                    if (record.getSilenceAfter() != null) {
                                        if (includeLabels) {
                                            writer.write((String)marginStrings.get(emptyLabel));
                                        }
                                        writer.write("(" + record.getSilenceAfter() + ")");
                                        writer.write("\n");
                                    }
                                    if (insertEmptyLine) {
                                        writer.write("\n");
                                    }
                                } else if (insertEmptyLine) {
                                    writer.write("\n");
                                }
                                record = nextRec;
                                val = record.getValue();
                                beginTime = record.getBeginTime();
                            }
                            val = val.replace('\n', ' ');
                            if (includeLabels) {
                                writer.write((String)marginStrings.get(record.getTierName()));
                            }
                            if (!wrapLines) {
                                writer.write(val);
                            } else if (val.length() <= maxAnnotationLength) {
                                writer.write(val);
                            } else {
                                valLines = this.breakValue(val, maxAnnotationLength);
                                for (int i = 0; i < valLines.length; ++i) {
                                    if (i != 0 && includeLabels) {
                                        writer.write((String)marginStrings.get(emptyLabel));
                                    }
                                    writer.write(valLines[i]);
                                    if (i == valLines.length - 1) continue;
                                    writer.write("\n");
                                }
                            }
                            writer.write("\n");
                            if (!includeTimeCodes) break block91;
                            if (includeLabels) {
                                writer.write((String)marginStrings.get(tcLabel));
                            }
                            writer.write(TimeFormatter.toString(beginTime));
                            writer.write(" - ");
                            writer.write(TimeFormatter.toString(record.getEndTime()));
                            writer.write("\n");
                            if (includeSilence && record.getSilenceAfter() != null) {
                                if (includeLabels) {
                                    writer.write((String)marginStrings.get(emptyLabel));
                                }
                                writer.write("(" + record.getSilenceAfter() + ")");
                            }
                            if (insertEmptyLine) {
                                writer.write("\n");
                            }
                            break block90;
                        }
                        if (!includeSilence) break block92;
                        if (record.getSilenceAfter() != null) {
                            if (includeLabels) {
                                writer.write((String)marginStrings.get(emptyLabel));
                            }
                            writer.write("(" + record.getSilenceAfter() + ")");
                        }
                        if (insertEmptyLine) {
                            writer.write("\n");
                        }
                        break block90;
                    }
                    if (!insertEmptyLine) break block90;
                    writer.write("\n");
                    break block90;
                }
                while (recIter.hasNext()) {
                    IndexedExportRecord record = (IndexedExportRecord)recIter.next();
                    String val = record.getValue().replace('\n', ' ');
                    if (includeLabels) {
                        writer.write((String)marginStrings.get(record.getTierName()));
                    }
                    if (!wrapLines) {
                        writer.write(val);
                    } else if (val.length() <= maxAnnotationLength) {
                        writer.write(val);
                    } else {
                        String[] valLines = this.breakValue(val, maxAnnotationLength);
                        for (int i = 0; i < valLines.length; ++i) {
                            if (i != 0 && includeLabels) {
                                writer.write((String)marginStrings.get(emptyLabel));
                            }
                            writer.write(valLines[i]);
                            if (i == valLines.length - 1) continue;
                            writer.write("\n");
                        }
                    }
                    writer.write("\n");
                    if (includeTimeCodes) {
                        if (includeLabels) {
                            writer.write((String)marginStrings.get(tcLabel));
                        }
                        writer.write(TimeFormatter.toString(record.getBeginTime()));
                        writer.write(" - ");
                        writer.write(TimeFormatter.toString(record.getEndTime()));
                        writer.write("\n");
                        if (includeSilence && record.getSilenceAfter() != null) {
                            if (includeLabels) {
                                writer.write((String)marginStrings.get(emptyLabel));
                            }
                            writer.write("(" + record.getSilenceAfter() + ")");
                            writer.write("\n");
                        }
                        if (!insertEmptyLine) continue;
                        writer.write("\n");
                        continue;
                    }
                    if (includeSilence) {
                        if (record.getSilenceAfter() != null) {
                            if (includeLabels) {
                                writer.write((String)marginStrings.get(emptyLabel));
                            }
                            writer.write("(" + record.getSilenceAfter() + ")");
                            writer.write("\n");
                        }
                        if (!insertEmptyLine) continue;
                        writer.write("\n");
                        continue;
                    }
                    if (!insertEmptyLine) continue;
                    writer.write("\n");
                }
            }
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Warning"), 2);
            ex.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception ee) {}
        }
        return true;
    }

    private String formatSilenceString(long dur) {
        if (dur <= 0L) {
            return null;
        }
        String silDur = null;
        int decimal = (Integer)this.silenceDecimalComboBox.getSelectedItem();
        if (decimal == 1) {
            silDur = String.valueOf((float)Math.round((float)dur / 100.0f) / 10.0f);
        } else if (decimal == 2) {
            silDur = String.valueOf((float)Math.round(dur / 10L) / 100.0f);
        } else if (decimal == 3) {
            silDur = String.valueOf((float)Math.round(dur) / 1000.0f);
        }
        return silDur;
    }

    private void setPreferredSetting() {
        Object useTyp = Preferences.get("ExportTradTranscript.rootTiersCB", null);
        if (useTyp != null) {
            this.setRootTiersOnly((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.wrapLinesCB", null)) != null) {
            this.wrapLinesCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.minimalDurTF", null)) != null) {
            Preferences.set("ExportTradTranscript.numCharPerLine", useTyp.toString(), null);
            Preferences.set("ExportTradTranscript.minimalDurTF", null, null);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.numCharPerLine", null)) != null) {
            this.numCharTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.timeCodeCB", null)) != null) {
            this.timeCodeCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.MergeAnnotations", null)) != null) {
            this.mergeAnnCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.MergeDurationValue", null)) != null) {
            this.mergeDurTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.labelsCB", null)) != null) {
            this.labelsCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.FixedLabelWidth", null)) != null) {
            this.labelWidthCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.FixedLabelWidthValue", null)) != null) {
            this.labelWidthTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.IncludeEmptyLines", null)) != null) {
            this.emptyLineCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.silenceCB", null)) != null) {
            this.silenceCB.setSelected((Boolean)useTyp);
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.minDurSilTF", null)) != null) {
            this.minDurSilTF.setText(useTyp.toString());
        }
        if ((useTyp = Preferences.get("NumberOfDecimalDigits", null)) instanceof Integer) {
            this.silenceDecimalComboBox.setSelectedItem((int)((Integer)useTyp));
        }
        if ((useTyp = Preferences.get("ExportTradTranscript.selectionCB", null)) != null) {
            this.selectionCB.setSelected((Boolean)useTyp);
        }
    }

    private void savePreferences() {
        Preferences.set("ExportTradTranscript.rootTiersCB", this.isRootTiersOnly(), null);
        Preferences.set("ExportTradTranscript.wrapLinesCB", this.wrapLinesCB.isSelected(), null);
        if (this.numCharTF.getText() != null) {
            Preferences.set("ExportTradTranscript.numCharPerLine", this.numCharTF.getText().trim(), null);
        }
        Preferences.set("ExportTradTranscript.timeCodeCB", this.timeCodeCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.MergeAnnotations", this.mergeAnnCB.isSelected(), null);
        if (this.mergeDurTF.getText() != null) {
            Preferences.set("ExportTradTranscript.MergeDurationValue", this.mergeDurTF.getText(), null);
        }
        Preferences.set("ExportTradTranscript.labelsCB", this.labelsCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.FixedLabelWidth", this.labelWidthCB.isSelected(), null);
        if (this.labelWidthTF.getText() != null) {
            Preferences.set("ExportTradTranscript.FixedLabelWidthValue", this.labelWidthTF.getText().trim(), null);
        }
        Preferences.set("ExportTradTranscript.IncludeEmptyLines", this.emptyLineCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.silenceCB", this.silenceCB.isSelected(), null);
        if (this.minDurSilTF.getText() != null) {
            Preferences.set("ExportTradTranscript.minDurSilTF", this.minDurSilTF.getText().trim(), null);
        }
        Preferences.set("NumberOfDecimalDigits", this.silenceDecimalComboBox.getSelectedItem(), null);
        Preferences.set("ExportTradTranscript.selectionCB", this.selectionCB.isSelected(), null);
        Preferences.set("ExportTradTranscript.selectedTiers", this.getSelectedTiers(), this.transcription);
        Preferences.set("ExportTradTranscript.SelectTiersMode", this.getSelectionMode(), this.transcription);
        if (this.getSelectionMode() != "Tier") {
            Preferences.set("ExportTradTranscript.LastSelectedItems", this.getSelectedItems(), this.transcription);
        }
        Preferences.set("ExportTradTranscript.HiddenTiers", this.getHiddenTiers(), this.transcription);
        List<String> tierOrder = this.getTierOrder();
        Preferences.set("ExportTradTranscript.TierOrder", tierOrder, this.transcription);
    }

    private class IndexedExportRecord
    extends AnnotationDataRecord
    implements Comparable {
        private int index;
        private String silAfter;
        private boolean childAnn;

        IndexedExportRecord(Annotation annotation, int index) {
            super(annotation);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setSilenceAfter(String value) {
            this.silAfter = value;
        }

        public String getSilenceAfter() {
            return this.silAfter;
        }

        public int compareTo(Object o) throws ClassCastException {
            if (!(o instanceof IndexedExportRecord)) {
                throw new ClassCastException("Object is not an IndexedExportRecord");
            }
            IndexedExportRecord other = (IndexedExportRecord)o;
            if (this.getBeginTime() < other.getBeginTime()) {
                return -1;
            }
            if (this.getBeginTime() > other.getBeginTime()) {
                return 1;
            }
            if (this.getEndTime() == other.getEndTime()) {
                if (this.index < other.getIndex()) {
                    return -1;
                }
                if (this.index > other.getIndex()) {
                    return 1;
                }
            }
            TierImpl thisTier = (TierImpl)ExportTradTranscript.this.transcription.getTierWithId(this.getTierName());
            TierImpl otherTier = (TierImpl)ExportTradTranscript.this.transcription.getTierWithId(other.getTierName());
            Vector childTiers = thisTier.getChildTiers();
            if (childTiers != null && childTiers.contains(otherTier)) {
                return -1;
            }
            childTiers = otherTier.getChildTiers();
            if (childTiers != null && childTiers.contains(thisTier)) {
                return 1;
            }
            if (this.getEndTime() < other.getEndTime()) {
                return -1;
            }
            if (this.getEndTime() > other.getEndTime()) {
                return 1;
            }
            return 0;
        }
    }
}

