/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.util.FileExtension;

public class ImageExporter {
    Frame parentFrame = null;

    public ImageExporter() {
    }

    public ImageExporter(Frame frame) {
        this.parentFrame = frame;
    }

    public void exportImage(Image image) {
        BufferedImage img = !(image instanceof BufferedImage) ? this.imageToBufferedImage(image) : (BufferedImage)image;
        if (img == null) {
            JOptionPane.showMessageDialog(this.parentFrame, ElanLocale.getString("ImageExporter.Message.NoImage"), ElanLocale.getString("Message.Warning"), 2);
            return;
        }
        String saveDir = (String)Preferences.get("MediaDir", null);
        if (saveDir == null) {
            saveDir = System.getProperty("user.dir");
        }
        FileChooser chooser = new FileChooser(this.parentFrame);
        chooser.createAndShowFileDialog(null, 1, FileExtension.IMAGE_EXT, "MediaDir");
        String imageIOType = "jpg";
        File saveFile = chooser.getSelectedFile();
        if (saveFile != null) {
            int answer;
            String fileName = saveFile.getAbsolutePath();
            String lowerFileName = fileName.toLowerCase();
            if (lowerFileName.endsWith("png")) {
                imageIOType = "png";
            } else if (lowerFileName.endsWith("bmp")) {
                imageIOType = "bmp";
            } else if (!lowerFileName.endsWith("jpg") && !lowerFileName.endsWith("jpeg")) {
                fileName = fileName + ".jpg";
            }
            File newSaveFile = new File(fileName);
            if (newSaveFile.exists() && (answer = JOptionPane.showConfirmDialog(this.parentFrame, ElanLocale.getString("Message.Overwrite"), ElanLocale.getString("SaveDialog.Message.Title"), 0)) == 1) {
                return;
            }
            if (img.getColorModel().hasAlpha() && !imageIOType.equals("png")) {
                BufferedImage flatImg = new BufferedImage(img.getWidth(), img.getHeight(), 1);
                flatImg.getGraphics().drawImage(img, 0, 0, null);
                img = flatImg;
            }
            try {
                ImageIO.write((RenderedImage)img, imageIOType, newSaveFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(this.parentFrame, ElanLocale.getString("ExportDialog.Message.Error"), ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    private BufferedImage imageToBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        BufferedImage bufImg = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bufImg.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bufImg;
    }
}

