/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.util.TableSubHeaderObject;

public class ShortCutPrinter
implements Printable,
Pageable {
    private int numPages = 1;
    private int firstColWidth = 0;
    private PageFormat pf;
    private float scale = 0.9f;
    private ArrayList<JTable> tableList;
    HashMap<Integer, HashMap<Integer, Integer[]>> pageTableMap;

    public ShortCutPrinter(JTable shortCutTable) {
        this.tableList = new ArrayList();
        this.tableList.add(shortCutTable);
    }

    public ShortCutPrinter(ArrayList<JTable> shortCutTable) {
        this.tableList = shortCutTable;
    }

    public void startPrint() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        this.pf = printJob.pageDialog(printJob.defaultPage());
        this.calculateNumPages();
        printJob.setPrintable(this, this.pf);
        printJob.setPageable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(null, ElanLocale.getString("InterlinearizerOptionsDlg.Error.Print") + " \n" + "(" + ex.getMessage() + ")", ElanLocale.getString("Message.Error"), 0);
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex >= this.getNumberOfPages()) {
            return 1;
        }
        this.renderPage(graphics, pageIndex);
        return 0;
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return this.pf;
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex < 0) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " < 0");
        }
        if (pageIndex >= this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("Page Index: " + pageIndex + " > " + (this.getNumberOfPages() - 1));
        }
        return this;
    }

    private void calculateNumPages() {
        if (this.tableList == null || this.pf == null) {
            return;
        }
        this.pageTableMap = new HashMap();
        int imgH = (int)this.pf.getImageableHeight();
        int curY = 0;
        int curp = 0;
        HashMap<Integer, Integer[]> tableRowMap = new HashMap<Integer, Integer[]>();
        for (int c = 0; c < this.tableList.size(); ++c) {
            JTable table = this.tableList.get(c);
            curY += (int)(this.scale * (float)table.getTableHeader().getHeight());
            if (table.getName() != null && table.getName().trim().length() > 0) {
                curY += (int)(this.scale * (float)table.getRowHeight() * 3.0f);
            }
            int startIndex = 0;
            Integer[] extr = new Integer[2];
            if (c == 0) {
                tableRowMap = new HashMap();
            }
            for (int i = 0; i < table.getRowCount(); ++i) {
                if ((curY += (int)(this.scale * (float)table.getRowHeight(i))) > imgH) {
                    ++this.numPages;
                    if (i != 0) {
                        extr[0] = startIndex;
                        startIndex = i--;
                        if (table.getValueAt(i, 0) instanceof TableSubHeaderObject) {
                            startIndex = i--;
                        }
                        extr[1] = i;
                        tableRowMap.put(c, extr);
                        extr = new Integer[2];
                    }
                    this.pageTableMap.put(curp, tableRowMap);
                    tableRowMap = new HashMap();
                    ++curp;
                    curY = 0;
                    if (i != 0) continue;
                    --c;
                    break;
                }
                if (i != table.getRowCount() - 1) continue;
                extr[0] = startIndex;
                extr[1] = i;
                tableRowMap.put(c, extr);
            }
            if (c != this.tableList.size() - 1) continue;
            this.pageTableMap.put(curp, tableRowMap);
        }
    }

    private int calcFirstColWidth(Graphics graphics, JTable table) {
        if (table == null) {
            return 200;
        }
        int cw = 0;
        int rowW = 0;
        Graphics2D g2d = (Graphics2D)graphics;
        String val = (String)table.getTableHeader().getColumnModel().getColumn(0).getHeaderValue();
        cw = (int)(this.scale * (float)g2d.getFontMetrics(table.getTableHeader().getFont()).stringWidth(val));
        for (int i = 0; i < table.getRowCount(); ++i) {
            Object rv = table.getValueAt(i, 0);
            if (!(rv instanceof String)) continue;
            val = (String)rv;
            rowW = (int)(this.scale * (float)g2d.getFontMetrics(table.getFont()).stringWidth(val));
            if (rowW <= cw) continue;
            cw = rowW;
        }
        return cw + 40;
    }

    private void renderPage(Graphics graphics, int pageIndex) {
        if (this.tableList == null || this.pf == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setStroke(new BasicStroke(0.6f));
        int ix = (int)this.pf.getImageableX();
        int iy = (int)this.pf.getImageableY();
        int iw = (int)this.pf.getImageableWidth();
        int curY = iy;
        HashMap<Integer, Integer[]> tableRowMap = this.pageTableMap.get(pageIndex);
        if (tableRowMap == null) {
            return;
        }
        for (Map.Entry<Integer, Integer[]> pair : tableRowMap.entrySet()) {
            int tableIndex = pair.getKey();
            Integer[] rowExt = pair.getValue();
            JTable table = this.tableList.get(tableIndex);
            this.firstColWidth = this.calcFirstColWidth(graphics, table);
            Font normF = table.getFont().deriveFont(0, (int)(this.scale * (float)table.getFont().getSize()));
            Font boldF = table.getFont().deriveFont(1, (int)(this.scale * (float)(table.getFont().getSize() + 2)));
            Font italicF = table.getFont().deriveFont(2, (int)(this.scale * (float)(table.getFont().getSize() + 2)));
            if (rowExt[0] == 0) {
                int tw = 0;
                int tx = 0;
                String val = table.getName();
                if (val == null || val.trim().length() > 0) {
                    g2d.drawString("", tx, (curY += (int)(this.scale * (float)table.getTableHeader().getHeight())) - g2d.getFontMetrics().getDescent());
                    tw = (int)(this.scale * (float)g2d.getFontMetrics(italicF).stringWidth(val));
                    tx = ix + (iw - tw) / 2;
                    g2d.setFont(italicF);
                    g2d.drawString(val, tx, (curY += (int)(this.scale * (float)table.getTableHeader().getHeight())) - g2d.getFontMetrics().getDescent());
                    g2d.drawString("", tx, (curY += (int)(this.scale * (float)table.getTableHeader().getHeight())) - g2d.getFontMetrics().getDescent());
                }
                val = (String)table.getTableHeader().getColumnModel().getColumn(0).getHeaderValue();
                tw = (int)(this.scale * (float)g2d.getFontMetrics(table.getTableHeader().getFont()).stringWidth(val));
                tx = ix + (this.firstColWidth - tw) / 2;
                g2d.setFont(normF);
                g2d.drawString(val, tx, (curY += (int)(this.scale * (float)table.getTableHeader().getHeight())) - g2d.getFontMetrics().getDescent());
                val = (String)table.getTableHeader().getColumnModel().getColumn(1).getHeaderValue();
                tw = (int)(this.scale * (float)g2d.getFontMetrics(table.getTableHeader().getFont()).stringWidth(val));
                tx = ix + this.firstColWidth + (iw - this.firstColWidth - tw) / 2;
                g2d.drawString(val, tx, curY - g2d.getFontMetrics().getDescent());
                g2d.drawLine(ix, curY, ix + iw, curY);
            }
            boolean gray = true;
            Color bg = new Color(236, 236, 236);
            int th = 0;
            for (int i = rowExt[0].intValue(); i <= rowExt[1] && i < table.getRowCount(); ++i) {
                Object rv = table.getValueAt(i, 0);
                th = (int)(this.scale * (float)table.getRowHeight(i));
                curY += th;
                if (rv instanceof String) {
                    if (gray) {
                        g2d.setColor(bg);
                        g2d.fillRect(ix, curY - th, iw, th);
                    }
                    gray = !gray;
                    g2d.setColor(Color.BLACK);
                    g2d.drawLine(ix, curY - th, ix + iw, curY - th);
                    g2d.setFont(normF);
                    g2d.drawString((String)rv, ix + 4, curY - g2d.getFontMetrics().getDescent());
                    rv = table.getValueAt(i, 1);
                    g2d.drawString((String)rv, ix + this.firstColWidth, curY - g2d.getFontMetrics().getDescent());
                    continue;
                }
                if (!(rv instanceof TableSubHeaderObject)) continue;
                if (i != 0) {
                    g2d.drawLine(ix, curY - th, ix + iw, curY - th);
                }
                g2d.setFont(boldF);
                TableSubHeaderObject tsho = (TableSubHeaderObject)rv;
                g2d.drawString(tsho.toString(), ix + 4, curY - g2d.getFontMetrics().getDescent());
                gray = true;
            }
        }
    }
}

