/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.ProgressStepPane;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public abstract class AbstractMultiFileExportProgessStepPane
extends ProgressStepPane {
    private List<String> files;
    protected List<String> selectedTiers;
    private boolean useOriginalDir;
    private boolean newDir;
    private String newDirName;
    private boolean sameDir;
    private String sameDirName;
    private boolean dontExportFilesWithoutTiers;
    private boolean useOriginalFileName;
    private boolean useOriginalFileNameWithSuffix;
    private String extension;

    public AbstractMultiFileExportProgessStepPane(MultiStepPane multiPane) {
        super(multiPane);
        this.initComponents();
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("MultiFileExport.ProgessPane.Title");
    }

    @Override
    public void enterStepForward() {
        this.files = (List)this.multiPane.getStepProperty("OpenedFiles");
        this.selectedTiers = (List)this.multiPane.getStepProperty("SelectedTiers");
        this.useOriginalDir = (Boolean)this.multiPane.getStepProperty("UseOriginalDir");
        this.newDir = (Boolean)this.multiPane.getStepProperty("NewDirectory");
        this.newDirName = (String)this.multiPane.getStepProperty("NewDirName");
        this.sameDir = (Boolean)this.multiPane.getStepProperty("TogetherInSameDir");
        this.sameDirName = (String)this.multiPane.getStepProperty("SameDirectoryName");
        this.dontExportFilesWithoutTiers = (Boolean)this.multiPane.getStepProperty("DontExportFilesWithoutTiers");
        this.useOriginalFileName = (Boolean)this.multiPane.getStepProperty("UseOriginalFileName");
        this.useOriginalFileNameWithSuffix = (Boolean)this.multiPane.getStepProperty("UseOriginalFileNameWithSuffix");
        this.extension = (String)this.multiPane.getStepProperty("ExportExtension");
        this.doFinish();
    }

    @Override
    public boolean doFinish() {
        this.completed = false;
        this.multiPane.setButtonEnabled(8, false);
        ExportThread t = new ExportThread();
        t.start();
        return false;
    }

    protected abstract boolean doExport(TranscriptionImpl var1, String var2);

    private class ExportThread
    extends Thread {
        private final int YES = 1;
        private final int NO = 2;
        private final int YES_TO_ALL = 0;
        private final int NO_TO_ALL = 3;

        private String getDirectoryToSave(String fileName) {
            int index = fileName.lastIndexOf(File.separatorChar);
            String originalDirectory = fileName.substring(0, index + 1);
            if (AbstractMultiFileExportProgessStepPane.this.useOriginalDir) {
                return originalDirectory;
            }
            if (AbstractMultiFileExportProgessStepPane.this.newDir) {
                return originalDirectory + AbstractMultiFileExportProgessStepPane.this.newDirName;
            }
            if (AbstractMultiFileExportProgessStepPane.this.sameDir) {
                return AbstractMultiFileExportProgessStepPane.this.sameDirName;
            }
            return null;
        }

        private String getFileName(String path, TranscriptionImpl transImpl) {
            if (AbstractMultiFileExportProgessStepPane.this.extension != null) {
                if (!AbstractMultiFileExportProgessStepPane.this.extension.startsWith(".")) {
                    AbstractMultiFileExportProgessStepPane.this.extension = "." + AbstractMultiFileExportProgessStepPane.this.extension;
                }
                String orifileName = transImpl.getName();
                int index = orifileName.lastIndexOf(46);
                orifileName = orifileName.substring(0, index);
                if (AbstractMultiFileExportProgessStepPane.this.useOriginalFileName) {
                    return orifileName + AbstractMultiFileExportProgessStepPane.this.extension;
                }
                if (AbstractMultiFileExportProgessStepPane.this.useOriginalFileNameWithSuffix) {
                    int i = 1;
                    String fileName = orifileName;
                    File f = new File(path + fileName + AbstractMultiFileExportProgessStepPane.this.extension);
                    while (f.exists()) {
                        fileName = orifileName + i;
                        f = new File(path + fileName + AbstractMultiFileExportProgessStepPane.this.extension);
                        ++i;
                    }
                    return fileName + AbstractMultiFileExportProgessStepPane.this.extension;
                }
            }
            return null;
        }

        private boolean createDirectory(String directoryPath) {
            boolean directoryExists = true;
            File directory = new File(directoryPath);
            if (!directory.exists()) {
                directoryExists = new File(directoryPath).mkdir();
            }
            return directoryExists;
        }

        @Override
        public void run() {
            int failedExports = 0;
            int refusedExports = 0;
            int emptyFiles = 0;
            boolean saveForever = false;
            boolean skipForever = false;
            for (int f = 0; f < AbstractMultiFileExportProgessStepPane.this.files.size(); ++f) {
                String newfileName = null;
                String fileName = (String)AbstractMultiFileExportProgessStepPane.this.files.get(f);
                if (fileName == null) continue;
                try {
                    TranscriptionImpl transImpl = new TranscriptionImpl(fileName);
                    String path = this.getDirectoryToSave(fileName);
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        path = path + File.separatorChar;
                    }
                    String directoryToSave = newfileName = path + this.getFileName(path, transImpl);
                    boolean directoryExists = this.createDirectory(path);
                    boolean saveThisFile = true;
                    boolean fileExists = new File(directoryToSave).exists();
                    if (fileExists && skipForever) {
                        saveThisFile = false;
                    }
                    if (!skipForever && !saveForever && fileExists) {
                        Object[] possibleValues = new Object[]{"Yes To All", "Yes", "No", "No To All"};
                        int choice = JOptionPane.showOptionDialog(null, ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description1") + " " + newfileName + " " + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description2") + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description3") + "\t " + directoryToSave + "\n\n" + ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Description4") + "\n", ElanLocale.getString("ExportTiersDialog.Message.OverwriteMessage.Title"), -1, 2, null, possibleValues, possibleValues[2]);
                        switch (choice) {
                            case 1: {
                                saveThisFile = true;
                                break;
                            }
                            case 0: {
                                saveForever = true;
                                break;
                            }
                            case 3: {
                                skipForever = true;
                                saveThisFile = false;
                                break;
                            }
                            default: {
                                saveThisFile = false;
                            }
                        }
                    }
                    if (directoryExists) {
                        if (saveForever || saveThisFile) {
                            if (!AbstractMultiFileExportProgessStepPane.this.dontExportFilesWithoutTiers) {
                                AbstractMultiFileExportProgessStepPane.this.doExport(transImpl, newfileName);
                            } else if (transImpl.getTiers().size() > 0) {
                                AbstractMultiFileExportProgessStepPane.this.doExport(transImpl, newfileName);
                            } else {
                                ++emptyFiles;
                            }
                        } else {
                            ++refusedExports;
                        }
                    } else {
                        ++failedExports;
                    }
                }
                catch (Exception ex) {
                    ClientLogger.LOG.warning("Could not handle file: " + fileName);
                }
                if (f + 1 >= AbstractMultiFileExportProgessStepPane.this.files.size()) continue;
                AbstractMultiFileExportProgessStepPane.this.progressUpdated(AbstractMultiFileExportProgessStepPane.this, Math.round((float)(100 * (f + 1)) / (float)AbstractMultiFileExportProgessStepPane.this.files.size()), null);
            }
            String msg = AbstractMultiFileExportProgessStepPane.this.files.size() - failedExports - refusedExports - emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.OutOf") + " " + AbstractMultiFileExportProgessStepPane.this.files.size() + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg1");
            if (emptyFiles + refusedExports + failedExports > 0) {
                msg = emptyFiles == 1 ? msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2single") : msg + "\n\n" + emptyFiles + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg2");
                msg = refusedExports == 1 ? msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3single") : msg + "\n" + refusedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg3");
                msg = failedExports == 1 ? msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4single") : msg + "\n" + failedExports + " " + ElanLocale.getString("ExportTiersDialog.Message.InfoMsg4");
            }
            AbstractMultiFileExportProgessStepPane.this.progressCompleted(AbstractMultiFileExportProgessStepPane.this, msg);
        }
    }
}

