/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.export.multiplefiles;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.gui.FileChooser;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;

public abstract class AbstractMultiFileExportSaveSettingsStepPane
extends StepPane
implements ActionListener {
    protected String saveWithOriginalNames;
    protected String saveInOriginalFolder;
    protected String saveInRelativeFolder;
    protected String saveInRelativeFolderName;
    protected String saveInSameFolderName;
    protected String dontCreateEmptyFiles;
    protected JButton browseBtn;
    protected JCheckBox dontExportFilesWithoutTiersCB;
    protected JRadioButton originalDirRB;
    protected JRadioButton togetherInSameDirRB;
    protected JRadioButton newDirectoryRB;
    protected JRadioButton originalFileNameRB;
    protected JRadioButton addSuffixRB;
    protected JTextField sameDirectoryTextField;
    protected JTextField localDirectoryTextField;
    protected JPanel fileNameOptionsPanel;
    protected JPanel directoryOptionsPanel;
    protected JPanel otherOptionsPanel;
    protected Insets insets = new Insets(2, 4, 2, 4);
    protected JComboBox fileExtComboBox;
    protected JScrollPane outerScrollPane;
    protected Object browseDirText = ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField");
    private String[] extensions;

    public AbstractMultiFileExportSaveSettingsStepPane(MultiStepPane multiStepPane) {
        super(multiStepPane);
        this.setPreferenceStrings();
        this.extensions = this.getExportExtensions();
        this.initComponents();
    }

    protected abstract void setPreferenceStrings();

    @Override
    protected void initComponents() {
        this.initFileNameOptionsPanel();
        this.initDirectoryOptionsPanel();
        this.initOtherOptionsPanel();
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        this.outerScrollPane = new JScrollPane(outerPanel);
        this.outerScrollPane.setBorder(null);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        outerPanel.add((Component)this.fileNameOptionsPanel, gbc);
        gbc.gridy = 1;
        outerPanel.add((Component)this.directoryOptionsPanel, gbc);
        gbc.gridy = 2;
        outerPanel.add((Component)this.otherOptionsPanel, gbc);
        gbc.gridy = 3;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weighty = 1.0;
        outerPanel.add((Component)new JPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.outerScrollPane, gbc);
        TextFieldHandler keyListener = new TextFieldHandler();
        this.originalDirRB.addActionListener(this);
        this.newDirectoryRB.addActionListener(this);
        this.togetherInSameDirRB.addActionListener(this);
        this.originalFileNameRB.addActionListener(this);
        this.addSuffixRB.addActionListener(this);
        this.browseBtn.addActionListener(this);
        this.localDirectoryTextField.addKeyListener(keyListener);
        this.loadPreferences();
    }

    @Override
    public abstract String getStepTitle();

    protected abstract String[] getExportExtensions();

    @Override
    public boolean doFinish() {
        this.savePreferences();
        this.multiPane.nextStep();
        return false;
    }

    @Override
    public void enterStepForward() {
        this.updateButtonStates();
    }

    @Override
    public void enterStepBackward() {
        this.updateButtonStates();
    }

    @Override
    public boolean leaveStepForward() {
        this.multiPane.putStepProperty("UseOriginalDir", this.originalDirRB.isSelected());
        this.multiPane.putStepProperty("NewDirectory", this.newDirectoryRB.isSelected());
        this.multiPane.putStepProperty("NewDirName", this.localDirectoryTextField.getText().trim());
        this.multiPane.putStepProperty("TogetherInSameDir", this.togetherInSameDirRB.isSelected());
        this.multiPane.putStepProperty("SameDirectoryName", this.sameDirectoryTextField.getText());
        this.multiPane.putStepProperty("DontExportFilesWithoutTiers", this.dontExportFilesWithoutTiersCB.isSelected());
        this.multiPane.putStepProperty("UseOriginalFileName", this.originalFileNameRB.isSelected());
        this.multiPane.putStepProperty("UseOriginalFileNameWithSuffix", this.addSuffixRB.isSelected());
        if (this.fileExtComboBox != null) {
            this.multiPane.putStepProperty("ExportExtension", this.fileExtComboBox.getSelectedItem().toString());
        }
        return true;
    }

    public void updateButtonStates() {
        this.multiPane.setButtonEnabled(2, true);
        this.multiPane.setButtonEnabled(1, false);
        this.multiPane.setButtonEnabled(3, true);
        if (this.togetherInSameDirRB.isSelected() && this.sameDirectoryTextField.getText().equals(this.browseDirText)) {
            this.multiPane.setButtonEnabled(3, false);
            return;
        }
        if (this.newDirectoryRB.isSelected() && this.localDirectoryTextField.getText().length() <= 0) {
            this.multiPane.setButtonEnabled(3, false);
            return;
        }
    }

    protected void initFileNameOptionsPanel() {
        this.fileNameOptionsPanel = new JPanel(new GridBagLayout());
        this.fileNameOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Label.FileNameOptions")));
        this.originalFileNameRB = new JRadioButton(ElanLocale.getString("MultiFileExport.SaveSettingsPane.RB.OriginalFileName"), true);
        this.addSuffixRB = new JRadioButton(ElanLocale.getString("MultiFileExport.SaveSettingsPane.RB.OriginalFileNameWithSuffix"));
        ButtonGroup fileNameBtnGroup = new ButtonGroup();
        fileNameBtnGroup.add(this.originalFileNameRB);
        fileNameBtnGroup.add(this.addSuffixRB);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        this.fileNameOptionsPanel.add((Component)this.originalFileNameRB, gbc);
        gbc.gridy = 1;
        this.fileNameOptionsPanel.add((Component)this.addSuffixRB, gbc);
        if (this.extensions != null) {
            gbc.gridy = 2;
            this.fileNameOptionsPanel.add((Component)this.getFileExtensionPanel(), gbc);
        }
    }

    protected JPanel getFileExtensionPanel() {
        this.fileExtComboBox = new JComboBox();
        for (String ext : this.extensions) {
            this.fileExtComboBox.addItem(ext);
        }
        JPanel fileExtPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        fileExtPanel.add((Component)new JLabel(ElanLocale.getString("MultiFileExport.SaveSettingsPane.Label.FileExtension")), gbc);
        gbc.weightx = 1.0;
        gbc.fill = 0;
        gbc.gridx = 1;
        fileExtPanel.add((Component)this.fileExtComboBox, gbc);
        return fileExtPanel;
    }

    protected void initDirectoryOptionsPanel() {
        this.directoryOptionsPanel = new JPanel(new GridBagLayout());
        this.directoryOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("MultiFileExportToolbox.Label.SaveDirOptions")));
        this.originalDirRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.OriginalDirectory"), true);
        this.newDirectoryRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.NewDirectory"));
        this.togetherInSameDirRB = new JRadioButton(ElanLocale.getString("ExportTiersDialog.RadioButton.TogetherInSameDirectory"));
        ButtonGroup saveTierBtnGroup = new ButtonGroup();
        saveTierBtnGroup.add(this.originalDirRB);
        saveTierBtnGroup.add(this.togetherInSameDirRB);
        saveTierBtnGroup.add(this.newDirectoryRB);
        this.localDirectoryTextField = new JTextField(ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName"));
        this.localDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField = new JTextField(ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField"));
        this.sameDirectoryTextField.setEnabled(false);
        this.sameDirectoryTextField.setEditable(false);
        this.sameDirectoryTextField.setMinimumSize(new Dimension(194, this.sameDirectoryTextField.getMinimumSize().height));
        this.browseBtn = new JButton(ElanLocale.getString("ExportTiersDialog.Button.Browse"));
        this.browseBtn.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        this.directoryOptionsPanel.add((Component)this.originalDirRB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        this.directoryOptionsPanel.add((Component)this.newDirectoryRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.directoryOptionsPanel.add((Component)this.localDirectoryTextField, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.directoryOptionsPanel.add((Component)this.togetherInSameDirRB, gbc);
        gbc.gridx = 1;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.directoryOptionsPanel.add((Component)this.sameDirectoryTextField, gbc);
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.directoryOptionsPanel.add((Component)this.browseBtn, gbc);
    }

    protected void initOtherOptionsPanel() {
        this.otherOptionsPanel = new JPanel(new GridBagLayout());
        this.otherOptionsPanel.setBorder(new TitledBorder(ElanLocale.getString("ExportTiersDialog.Label.OtherOptions")));
        this.dontExportFilesWithoutTiersCB = new JCheckBox(ElanLocale.getString("ExportTiersDialog.CheckBox.ExportFilesWithoutTiers"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 0;
        gbc.insets = this.insets;
        gbc.weightx = 1.0;
        this.otherOptionsPanel.add((Component)this.dontExportFilesWithoutTiersCB, gbc);
    }

    protected void updateButtonsAndFields() {
        this.sameDirectoryTextField.setEnabled(this.togetherInSameDirRB.isSelected());
        this.browseBtn.setEnabled(this.togetherInSameDirRB.isSelected());
        this.localDirectoryTextField.setEnabled(this.newDirectoryRB.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String directoryStr;
        Object source = ae.getSource();
        if (source == this.browseBtn && (directoryStr = this.showDirectoryChooser()) != null) {
            this.sameDirectoryTextField.setText(directoryStr);
        }
        this.updateButtonsAndFields();
        this.updateButtonStates();
    }

    protected String showDirectoryChooser() {
        FileChooser dirChooser = new FileChooser(this);
        dirChooser.createAndShowFileDialog(ElanLocale.getString("Frame.ElanFrame.OpenDialog.Title"), 0, ElanLocale.getString("Button.OK"), null, null, false, "LastUsedExportDir", 1, null);
        File selectedDir = dirChooser.getSelectedFile();
        if (selectedDir != null) {
            return selectedDir.getAbsolutePath();
        }
        return null;
    }

    protected void savePreferences() {
        if (this.saveWithOriginalNames != null) {
            Preferences.set(this.saveWithOriginalNames, this.originalFileNameRB.isSelected(), null);
        }
        if (this.saveInOriginalFolder != null) {
            Preferences.set(this.saveInOriginalFolder, this.originalDirRB.isSelected(), null);
        }
        if (this.saveInRelativeFolder != null) {
            Preferences.set(this.saveInRelativeFolder, this.newDirectoryRB.isSelected(), null);
        }
        if (this.saveInRelativeFolderName != null) {
            String relFolderName = this.localDirectoryTextField.getText();
            if (!ElanLocale.getString("ExportTiersDialog.TextField.DefaultLocalDirectoryName").equals(relFolderName)) {
                Preferences.set(this.saveInRelativeFolderName, relFolderName, null);
            }
        }
        if (this.saveInSameFolderName != null) {
            String sameFolder = this.sameDirectoryTextField.getText();
            if (!ElanLocale.getString("ExportTiersDialog.TextField.DirectoryNameField").equals(sameFolder)) {
                Preferences.set(this.saveInSameFolderName, sameFolder, null);
            }
        }
        if (this.dontCreateEmptyFiles != null) {
            Preferences.set(this.dontCreateEmptyFiles, this.dontExportFilesWithoutTiersCB.isSelected(), null);
        }
    }

    protected void loadPreferences() {
        boolean origFolder;
        Object prefValue;
        if (this.saveWithOriginalNames != null && (prefValue = Preferences.get(this.saveWithOriginalNames, null)) != null && prefValue instanceof Boolean) {
            this.originalFileNameRB.setSelected((Boolean)prefValue);
            this.addSuffixRB.setSelected((Boolean)prefValue == false);
        }
        if (this.saveInOriginalFolder != null && (prefValue = Preferences.get(this.saveInOriginalFolder, null)) instanceof Boolean && !(origFolder = ((Boolean)prefValue).booleanValue()) && (prefValue = Preferences.get(this.saveInRelativeFolder, null)) instanceof Boolean) {
            boolean relFolder = (Boolean)prefValue;
            if (relFolder) {
                this.newDirectoryRB.setSelected(true);
            } else {
                this.togetherInSameDirRB.setSelected(true);
            }
        }
        if (this.saveInRelativeFolderName != null && (prefValue = Preferences.get(this.saveInRelativeFolderName, null)) instanceof String) {
            this.localDirectoryTextField.setText((String)prefValue);
        }
        if (this.saveInSameFolderName != null && (prefValue = Preferences.get(this.saveInSameFolderName, null)) instanceof String) {
            this.sameDirectoryTextField.setText((String)prefValue);
        }
        if (this.dontCreateEmptyFiles != null && (prefValue = Preferences.get(this.dontCreateEmptyFiles, null)) instanceof Boolean) {
            this.dontExportFilesWithoutTiersCB.setSelected((Boolean)prefValue);
        }
        this.updateButtonsAndFields();
    }

    protected class TextFieldHandler
    implements KeyListener {
        protected TextFieldHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AbstractMultiFileExportSaveSettingsStepPane.this.updateButtonStates();
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

