/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.InlineEditBoxListener;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.grid.AbstractEditableGridViewer;
import mpi.eudico.client.annotator.grid.AnnotationTable;
import mpi.eudico.client.annotator.grid.GridViewerTableModel;
import mpi.eudico.client.annotator.viewer.SingleTierViewer;
import mpi.eudico.server.corpora.clom.AnnotationCore;
import mpi.eudico.server.corpora.clom.Tier;
import mpi.eudico.server.corpora.clomimpl.abstr.AnnotationCoreImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.ConcatAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.event.ACMEditEvent;
import mpi.eudico.util.CVEntry;
import mpi.eudico.util.ControlledVocabulary;

public class GridViewer
extends AbstractEditableGridViewer
implements SingleTierViewer,
ActionListener,
InlineEditBoxListener {
    public static final int SINGLE_TIER_MODE = 0;
    public static final int MULTI_TIER_ASSOCIATION_MODE = 1;
    public static final int MULTI_TIER_SUBDIVISION_MODE = 2;
    public static final int MULTI_TIER_MODE = 1;
    private int mode = 0;
    private final String EMPTY = "";
    private TierImpl tier;
    private List childTiers = new ArrayList();
    private Map childTierNames = new HashMap();
    private Set storedInvisibleColumns = new HashSet();

    public GridViewer() {
        super(new AnnotationTable(new GridViewerTableModel()));
        if (this.popup != null) {
            this.popup.addActionListener(this);
        }
        this.storedInvisibleColumns.add("ColumnBeginTime");
        this.storedInvisibleColumns.add("ColumnEndTime");
        this.storedInvisibleColumns.add("ColumnDuration");
    }

    @Override
    public void updateDataModel(List annotations) {
        this.removeChildrenColumns();
        this.childTiers.clear();
        this.childTierNames.clear();
        super.updateDataModel(annotations);
    }

    @Override
    public void isClosing() {
        if (this.table != null && this.table.isEditing() && this.gridEditor != null) {
            Object val = Preferences.get("InlineEdit.DeselectCommits", null);
            if (val instanceof Boolean && ((Boolean)val).booleanValue()) {
                this.gridEditor.commitEdit();
            } else {
                this.gridEditor.cancelCellEditing();
            }
        }
    }

    @Override
    public void ACMEdited(ACMEditEvent e) {
        if (this.tier == null) {
            return;
        }
        switch (e.getOperation()) {
            case 3: {
                if (this.isCreatingAnnotation) {
                    this.isCreatingAnnotation = false;
                    return;
                }
            }
            case 4: 
            case 5: 
            case 7: {
                this.annotationsChanged(null);
                break;
            }
            case 6: 
            case 14: {
                this.annotationsChanged(null);
                break;
            }
            case 2: {
                TierImpl invalTier = (TierImpl)e.getInvalidatedObject();
                this.tierChanged(invalTier);
                break;
            }
            case 0: 
            case 1: {
                TierImpl ti = (TierImpl)e.getModification();
                this.tierChanged(ti);
                break;
            }
            default: {
                super.ACMEdited(e);
            }
        }
    }

    private void tierChanged(TierImpl changedTier) {
        if (this.mode == 0) {
            if (changedTier == this.tier) {
                this.setTier(changedTier);
            }
        } else {
            this.setTier(this.tier);
        }
    }

    @Override
    public void setTier(Tier tier) {
        this.gridEditor.cancelCellEditing();
        this.tier = (TierImpl)tier;
        if (tier == null) {
            this.updateDataModel(new ArrayList());
            this.table.setFontsForTiers(null);
            this.setPreference("GridViewer.TierName", tier, this.getViewerManager().getTranscription());
        } else {
            Vector annotations = null;
            try {
                annotations = this.tier.getAnnotations();
            }
            catch (Exception ex) {
                LOG.warning("Could not get the annotations: " + ex.getMessage());
            }
            this.updateDataModel(annotations);
            if (this.mode == 1) {
                this.extractChildTiers(this.tier, 4);
                this.addExtraColumns();
            }
            if (this.mode == 2) {
                this.extractChildTiers(this.tier, 3);
                this.addExtraColumns();
            }
            this.setPreference("GridViewer.TierName", tier.getName(), this.getViewerManager().getTranscription());
            this.preferencesChanged();
        }
        this.updateSelection();
        this.doUpdate();
    }

    protected void extractChildTiers(TierImpl tier, int constraint) {
        if (tier != null) {
            Vector depTiers = tier.getDependentTiers();
            for (TierImpl t : depTiers) {
                if (t.getParentTier() != tier || t.getLinguisticType().getConstraints().getStereoType() != constraint) continue;
                this.childTiers.add(t);
                this.childTierNames.put(t, t.getName());
                this.extractChildTiers(t, constraint);
            }
        }
    }

    @Override
    public void updateActiveAnnotation() {
        if (this.tier == null) {
            return;
        }
        if (this.getActiveAnnotation() == null) {
            this.repaint();
            return;
        }
        if (this.mode == 0) {
            super.updateActiveAnnotation();
        } else if (this.getActiveAnnotation().getTier() != this.tier && !this.childTiers.contains(this.getActiveAnnotation().getTier())) {
            this.repaint();
            return;
        }
        this.doUpdate();
    }

    protected void addExtraColumns() {
        if (this.childTiers.size() == 0) {
            return;
        }
        Tier tierChild = null;
        int vecChildren_size = this.childTiers.size();
        for (int i = 0; i < vecChildren_size; ++i) {
            tierChild = (Tier)this.childTiers.get(i);
            this.handleExtraColumn(tierChild);
        }
    }

    private void handleExtraColumn(Tier childTier) {
        try {
            List v = null;
            if (this.mode == 1) {
                v = this.createChildAnnotationVector(childTier);
            } else if (this.mode == 2) {
                v = this.createChildAnnotationVectorS(childTier);
            }
            String name = childTier.getName();
            this.dataModel.addChildTier(name, v);
            int columnIndex = this.dataModel.findColumn(name);
            TableColumn tc = new TableColumn();
            tc.setHeaderValue(name);
            tc.setIdentifier(name);
            this.table.addColumn(tc);
            int curIndex = this.table.getColumnModel().getColumnIndex(name);
            this.table.moveColumn(curIndex, columnIndex);
            this.updateColumnModelIndices();
            this.table.setColumnVisible(name, true);
        }
        catch (Exception ex) {
            LOG.warning("Could not handle the extra column for the child tier: " + ex.getMessage());
        }
    }

    private List createChildAnnotationVectorS(Tier childTier) {
        ArrayList<AnnotationCore> cv = new ArrayList<AnnotationCore>(this.dataModel.getRowCount());
        Vector existingChildren = ((TierImpl)childTier).getAnnotations();
        boolean i = false;
        ArrayList<AnnotationCore> annotationList = new ArrayList<AnnotationCore>();
        int k = 0;
        for (int j = 0; j < this.dataModel.getRowCount(); ++j) {
            AnnotationCore annotation = this.dataModel.getAnnotationCore(j);
            long begin = annotation.getBeginTimeBoundary();
            long end = annotation.getEndTimeBoundary();
            while (k < existingChildren.size()) {
                AnnotationCore child = (AnnotationCore)existingChildren.get(k);
                if (child.getBeginTimeBoundary() >= begin && child.getEndTimeBoundary() <= end) {
                    annotationList.add(child);
                } else if (child.getBeginTimeBoundary() >= end) {
                    if (annotationList.size() > 0) {
                        cv.add(new ConcatAnnotation(annotationList));
                        annotationList.clear();
                        break;
                    }
                    cv.add(new AnnotationCoreImpl("", begin, end));
                    break;
                }
                ++k;
            }
            if (k == existingChildren.size() && annotationList.size() > 0) {
                cv.add(new ConcatAnnotation(annotationList));
                annotationList.clear();
            }
            if (cv.size() >= j) continue;
            cv.add(new AnnotationCoreImpl("", begin, end));
        }
        return cv;
    }

    private List createChildAnnotationVector(Tier childTier) {
        ArrayList<Object> cv = new ArrayList<Object>(this.dataModel.getRowCount());
        Vector existingChildren = ((TierImpl)childTier).getAnnotations();
        int j = 0;
        for (int i = 0; i < this.dataModel.getRowCount(); ++i) {
            AnnotationCore annotation = this.dataModel.getAnnotationCore(i);
            long begin = annotation.getBeginTimeBoundary();
            if (j < existingChildren.size()) {
                AnnotationCore childAnnotation = (AnnotationCore)existingChildren.get(j);
                if (childAnnotation.getBeginTimeBoundary() == begin) {
                    cv.add(childAnnotation);
                    ++j;
                    continue;
                }
                cv.add("");
                continue;
            }
            cv.add("");
        }
        return cv;
    }

    public void setMode(int mode) {
        if (this.mode == mode) {
            return;
        }
        this.mode = mode;
        Set invisibleColumns = this.getInvisibleColumns();
        this.setInvisibleColumns(this.storedInvisibleColumns);
        this.storedInvisibleColumns = invisibleColumns;
        this.setPreference("GridViewer.MultiTierMode", new Boolean(mode == 1 || mode == 2), this.getViewerManager().getTranscription());
        if (mode == 2) {
            this.setPreference("GridViewer.MultiTierMode.Subdivision", new Boolean(true), this.getViewerManager().getTranscription());
        } else {
            this.setPreference("GridViewer.MultiTierMode.Subdivision", new Boolean(false), this.getViewerManager().getTranscription());
        }
    }

    public int getMode() {
        return this.mode;
    }

    protected Set getInvisibleColumns() {
        HashSet<Object> invisibleColumns = new HashSet<Object>();
        invisibleColumns.clear();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            if (this.table.isColumnVisible((String)tc.getIdentifier())) continue;
            invisibleColumns.add(tc.getIdentifier());
        }
        return invisibleColumns;
    }

    protected void setInvisibleColumns(Set invisibleColumns) {
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tc = this.table.getColumnModel().getColumn(i);
            this.table.setColumnVisible(this.dataModel.getColumnName(i), !invisibleColumns.contains(tc.getIdentifier()));
        }
    }

    protected void annotationsChanged(TierImpl invTier) {
        if (invTier == null || invTier == this.tier || invTier.getDependentTiers().contains(this.tier) || this.childTiers.contains(invTier)) {
            Vector annotations = this.tier.getAnnotations();
            this.dataModel.updateAnnotations(annotations);
            for (int i = 0; i < this.childTiers.size(); ++i) {
                Tier childTier = (Tier)this.childTiers.get(i);
                List vec = null;
                if (this.mode == 1) {
                    vec = this.createChildAnnotationVector(childTier);
                } else if (this.mode == 2) {
                    vec = this.createChildAnnotationVectorS(childTier);
                }
                this.dataModel.addChildTier(childTier.getName(), vec);
            }
            this.updateSelection();
            this.doUpdate();
        }
    }

    private void removeChildrenColumns() {
        if (this.childTiers.size() > 0) {
            for (int i = 0; i < this.childTiers.size(); ++i) {
                TierImpl t = (TierImpl)this.childTiers.get(i);
                String columnID = (String)this.childTierNames.get(t);
                try {
                    this.table.removeColumn(this.table.getColumn(columnID));
                    this.updateColumnModelIndices();
                    continue;
                }
                catch (IllegalArgumentException iae) {
                    LOG.warning("Column not found: " + iae.getMessage());
                }
            }
        }
    }

    private void updateColumnModelIndices() {
        Enumeration<TableColumn> ten = this.table.getColumnModel().getColumns();
        TableColumn tabcol = null;
        while (ten.hasMoreElements()) {
            tabcol = ten.nextElement();
            int tableIndex = this.table.getColumnModel().getColumnIndex(tabcol.getIdentifier());
            tabcol.setModelIndex(tableIndex);
        }
    }

    @Override
    public Tier getTier() {
        return this.tier;
    }

    @Override
    public void preferencesChanged() {
        Object val;
        Object cvPrefObj;
        Object fo;
        Integer fontSi = (Integer)this.getPreference("GridViewer.FontSize", this.getViewerManager().getTranscription());
        if (fontSi != null) {
            this.setFontSize(fontSi);
        }
        if ((fo = this.getPreference("TierFonts", this.getViewerManager().getTranscription())) instanceof HashMap && this.tier != null) {
            HashMap foMap = (HashMap)fo;
            HashMap<String, String> gridMap = new HashMap<String, String>(5);
            Iterator keyIt = foMap.keySet().iterator();
            String key = null;
            Font ft = null;
            while (keyIt.hasNext()) {
                key = (String)keyIt.next();
                ft = (Font)foMap.get(key);
                if (key == null || ft == null) continue;
                if (key.equals(this.tier.getName())) {
                    gridMap.put("ColumnAnnotation", ft.getName());
                }
                gridMap.put(key, ft.getName());
            }
            this.table.setFontsForTiers(gridMap);
        }
        if ((cvPrefObj = Preferences.get("CV.Prefs", this.getViewerManager().getTranscription())) instanceof HashMap) {
            HashMap<String, Map<String, Color>> colMap = new HashMap<String, Map<String, Color>>();
            Vector tiers = this.getViewerManager().getTranscription().getTiers();
            for (int i = 0; i < tiers.size(); ++i) {
                ControlledVocabulary cv;
                String cvName;
                TierImpl t = (TierImpl)tiers.get(i);
                if (t != this.tier && !this.childTiers.contains(t) || (cvName = t.getLinguisticType().getControlledVocabylaryName()) == null || (cv = ((TranscriptionImpl)this.getViewerManager().getTranscription()).getControlledVocabulary(cvName)) == null) continue;
                CVEntry[] entries = cv.getEntries();
                HashMap<String, Color> eMap = new HashMap<String, Color>(entries.length);
                for (CVEntry cve : entries) {
                    if (cve.getPrefColor() == null) continue;
                    eMap.put(cve.getValue(), cve.getPrefColor());
                }
                if (t == this.tier) {
                    colMap.put("ColumnAnnotation", eMap);
                }
                colMap.put(t.getName(), eMap);
            }
            this.table.setColorsForAnnotations(colMap);
        }
        if ((val = this.getPreference("InlineEdit.EnterCommits", null)) instanceof Boolean) {
            this.gridEditor.setEnterCommits((Boolean)val);
        }
        if ((val = Preferences.get("InlineEdit.DeselectCommits", null)) instanceof Boolean) {
            this.table.setDeselectCommits((Boolean)val);
        }
        if ((val = this.getPreference("GridViewer.TimeFormat", this.getViewerManager().getTranscription())) instanceof String) {
            this.table.setTimeFormat((String)val);
            if (this.popup != null) {
                this.popup.setTimeFormat((String)val);
            }
        }
        this.doLayout();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("TOGGLETIMEFORMAT")) {
            if (this.dataModel instanceof GridViewerTableModel) {
                String timeFormat = this.dataModel.getTimeFormat();
                if ("TIMECODE".equals(timeFormat)) {
                    this.setPreference("GridViewer.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
                } else if ("MILLISECONDS".equals(timeFormat)) {
                    this.setPreference("GridViewer.TimeFormat", "ms", this.getViewerManager().getTranscription());
                } else {
                    this.setPreference("GridViewer.TimeFormat", null, this.getViewerManager().getTranscription());
                }
            }
        } else if (e.getActionCommand().equals("hh:mm:ss.ms")) {
            this.setPreference("GridViewer.TimeFormat", "hh:mm:ss.ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("PAL")) {
            this.setPreference("GridViewer.TimeFormat", "PAL", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("NTSC")) {
            this.setPreference("GridViewer.TimeFormat", "NTSC", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("ms")) {
            this.setPreference("GridViewer.TimeFormat", "ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().equals("ss.ms")) {
            this.setPreference("GridViewer.TimeFormat", "ss.ms", this.getViewerManager().getTranscription());
        } else if (e.getActionCommand().indexOf("font") != -1) {
            this.setPreference("GridViewer.FontSize", new Integer(this.table.getFontSize()), this.getViewerManager().getTranscription());
        }
    }

    public void setKeyStrokesNotToBeConsumed(List<KeyStroke> ksList) {
        this.gridEditor.setKeyStrokesNotToBeConsumed(ksList);
    }

    @Override
    public void editingCommitted() {
        if (this.table != null && this.table.isEditing()) {
            this.table.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void editingCancelled() {
        if (this.table != null && this.table.isEditing()) {
            this.table.editingCanceled(new ChangeEvent(this));
        }
    }
}

