/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.grid;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.export.ExportGridTable;
import mpi.eudico.client.annotator.grid.AnnotationTable;

public class GridViewerPopupMenu
extends JPopupMenu
implements ActionListener {
    protected final AnnotationTable table;
    private final JMenu fontMenu;
    private final JMenuItem toggleMenuItem;
    private final JMenuItem exportMenuItem;
    private final ButtonGroup fontSizeBG;
    private ButtonGroup formatBG;
    private JMenu formatMenu;
    private JRadioButtonMenuItem hhmmssmsMI;
    private JRadioButtonMenuItem timecodePalMI;
    private JRadioButtonMenuItem timecodeNtscMI;
    private JRadioButtonMenuItem msMI;
    private JRadioButtonMenuItem secMI;
    private int fontSize;
    private List actionListeners;

    public GridViewerPopupMenu(AnnotationTable table) {
        this.table = table;
        this.fontSizeBG = new ButtonGroup();
        this.fontMenu = new JMenu(ElanLocale.getString("Menu.View.FontSize"));
        for (int i = 0; i < Constants.FONT_SIZES.length; ++i) {
            JRadioButtonMenuItem fontRB = new JRadioButtonMenuItem(String.valueOf(Constants.FONT_SIZES[i]));
            fontRB.setActionCommand("font" + Constants.FONT_SIZES[i]);
            if (table.getFont().getSize() == Constants.FONT_SIZES[i]) {
                fontRB.setSelected(true);
            }
            fontRB.addActionListener(this);
            this.fontSizeBG.add(fontRB);
            this.fontMenu.add(fontRB);
        }
        this.toggleMenuItem = new JMenuItem(ElanLocale.getString("Menu.Options.TimeFormat"));
        this.toggleMenuItem.setActionCommand("TOGGLETIMEFORMAT");
        this.toggleMenuItem.addActionListener(this);
        this.formatBG = new ButtonGroup();
        this.formatMenu = new JMenu();
        this.hhmmssmsMI = new JRadioButtonMenuItem();
        this.hhmmssmsMI.setSelected(true);
        this.hhmmssmsMI.setActionCommand("hh:mm:ss.ms");
        this.timecodePalMI = new JRadioButtonMenuItem();
        this.timecodePalMI.setActionCommand("PAL");
        this.timecodeNtscMI = new JRadioButtonMenuItem();
        this.timecodeNtscMI.setActionCommand("NTSC");
        this.msMI = new JRadioButtonMenuItem();
        this.msMI.setActionCommand("ms");
        this.secMI = new JRadioButtonMenuItem();
        this.secMI.setActionCommand("ss.ms");
        this.formatBG.add(this.hhmmssmsMI);
        this.formatBG.add(this.timecodePalMI);
        this.formatBG.add(this.timecodeNtscMI);
        this.formatBG.add(this.msMI);
        this.formatBG.add(this.secMI);
        this.formatMenu.add(this.hhmmssmsMI);
        this.formatMenu.add(this.timecodePalMI);
        this.formatMenu.add(this.timecodeNtscMI);
        this.formatMenu.add(this.msMI);
        this.formatMenu.add(this.secMI);
        this.hhmmssmsMI.addActionListener(this);
        this.timecodePalMI.addActionListener(this);
        this.timecodeNtscMI.addActionListener(this);
        this.msMI.addActionListener(this);
        this.secMI.addActionListener(this);
        this.exportMenuItem = new JMenuItem(ElanLocale.getString("Frame.GridFrame.ExportTableAsTab"));
        this.exportMenuItem.setActionCommand("EXPORT");
        this.exportMenuItem.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("TOGGLETIMEFORMAT")) {
            this.table.toggleTimeFormat();
        } else if (actionCommand.equals("hh:mm:ss.ms")) {
            this.table.setTimeFormat(actionCommand);
        } else if (actionCommand.equals("PAL")) {
            this.table.setTimeFormat(actionCommand);
        } else if (actionCommand.equals("NTSC")) {
            this.table.setTimeFormat(actionCommand);
        } else if (actionCommand.equals("ms")) {
            this.table.setTimeFormat(actionCommand);
        } else if (actionCommand.equals("ss.ms")) {
            this.table.setTimeFormat(actionCommand);
        } else if (actionCommand.equals("EXPORT")) {
            ExportGridTable exporter = new ExportGridTable();
            exporter.exportTableAsTabDelimitedText(this.table);
        } else if (actionCommand.indexOf("font") != -1) {
            int index = actionCommand.indexOf("font") + 4;
            try {
                this.table.setFontSize(Integer.parseInt(actionCommand.substring(index)));
                this.table.repaint();
            }
            catch (Exception ex) {}
        } else {
            this.table.setColumnVisible(actionCommand, ((JCheckBoxMenuItem)e.getSource()).isSelected());
            this.table.adjustAnnotationColumns();
        }
        this.table.doLayout();
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ((ActionListener)this.actionListeners.get(i)).actionPerformed(e);
            }
        }
    }

    protected void makeLayout() {
        this.removeAll();
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn column = this.table.getColumnModel().getColumn(i);
            String columnName = (String)column.getIdentifier();
            if (columnName.equals("ColumnTriangle") || columnName.equals("ColumnCount") || columnName.equals("ColumnAnnotation")) continue;
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(column.getHeaderValue().toString());
            menuItem.setActionCommand(columnName);
            menuItem.setSelected(this.table.isColumnVisible(columnName));
            menuItem.addActionListener(this);
            this.add(menuItem);
        }
        this.addSeparator();
        this.add(this.fontMenu);
        this.addSeparator();
        this.add(this.formatMenu);
        this.add(this.exportMenuItem);
        this.updateLocale();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.makeLayout();
        }
        super.setVisible(b);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        if (this.fontSizeBG != null) {
            Enumeration<AbstractButton> en = this.fontSizeBG.getElements();
            while (en.hasMoreElements()) {
                JMenuItem item = (JMenuItem)en.nextElement();
                String value = item.getText();
                try {
                    int v = Integer.parseInt(value);
                    if (v != this.fontSize) continue;
                    item.setSelected(true);
                    if (this.table == null) break;
                    this.table.setFontSize(size);
                    this.table.repaint();
                    break;
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
    }

    public void setTimeFormat(String format) {
        if (format.equals("hh:mm:ss.ms") || format.equals("TIMECODE")) {
            this.hhmmssmsMI.setSelected(true);
        } else if (format.equals("PAL")) {
            this.timecodePalMI.setSelected(true);
        } else if (format.equals("NTSC")) {
            this.timecodeNtscMI.setSelected(true);
        } else if (format.equals("ss.ms")) {
            this.secMI.setSelected(true);
        } else if (format.equals("ms") || format.equals("MILLISECONDS")) {
            this.msMI.setSelected(true);
        }
    }

    public void updateLocale() {
        this.fontMenu.setText(ElanLocale.getString("Menu.View.FontSize"));
        this.toggleMenuItem.setText(ElanLocale.getString("Menu.Options.TimeFormat"));
        this.exportMenuItem.setText(ElanLocale.getString("Frame.GridFrame.ExportTableAsTab"));
        this.formatMenu.setText(ElanLocale.getString("TimeCodeFormat.Label.TimeFormat"));
        this.hhmmssmsMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode"));
        this.timecodePalMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.PAL"));
        this.timecodeNtscMI.setText(ElanLocale.getString("TimeCodeFormat.TimeCode.SMPTE.NTSC"));
        this.msMI.setText(ElanLocale.getString("TimeCodeFormat.MilliSec"));
        this.secMI.setText(ElanLocale.getString("TimeCodeFormat.Seconds"));
    }

    public void addActionListener(ActionListener listener) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList(2);
        }
        this.actionListeners.add(listener);
    }
}

