/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class AdvancedAttributeSettingOptionDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private JCheckBox typeCB;
    private JCheckBox dependentTiersCB;
    private JCheckBox participantsCB;
    private JCheckBox tierColorCB;
    private JCheckBox tierHighLightColorCB;
    private JCheckBox tierFontCB;
    private JButton okButton;
    private HashMap tierProperties;
    private String tierName;
    private Transcription transcription;
    private boolean appleAttributesDlg = false;

    public AdvancedAttributeSettingOptionDialog(Dialog owner, String title, HashMap tierProps) {
        super(owner, title, true);
        this.tierProperties = tierProps;
        this.initComponents();
        this.postInit();
    }

    public AdvancedAttributeSettingOptionDialog(Dialog owner, String title, Transcription transcription, String tierName) {
        super(owner, title, true);
        this.initialize(transcription, tierName);
    }

    public AdvancedAttributeSettingOptionDialog(Frame owner, String title, Transcription transcription, String tierName) {
        super(owner, title, true);
        this.initialize(transcription, tierName);
    }

    private void initialize(Transcription transcription, String tierName) {
        this.appleAttributesDlg = true;
        this.tierName = tierName;
        this.transcription = transcription;
        this.initComponents();
        this.postInit();
    }

    private void initComponents() {
        this.typeCB = new JCheckBox(ElanLocale.getString("EditTierDialog.AdvancedSetting.Type"));
        this.typeCB.addChangeListener(this);
        this.dependentTiersCB = new JCheckBox(ElanLocale.getString("EditTierDialog.AdvancedSetting.DependentTiers"));
        this.dependentTiersCB.addChangeListener(this);
        this.participantsCB = new JCheckBox(ElanLocale.getString("EditTierDialog.AdvancedSetting.Participants"));
        this.participantsCB.addChangeListener(this);
        this.tierColorCB = new JCheckBox(ElanLocale.getString("EditTierDialog.Label.TierColor"), true);
        this.tierColorCB.addChangeListener(this);
        this.tierHighLightColorCB = new JCheckBox(ElanLocale.getString("EditTierDialog.Label.TierHighlightColor"), true);
        this.tierHighLightColorCB.addChangeListener(this);
        this.tierFontCB = new JCheckBox(ElanLocale.getString("EditTierDialog.Label.TierFont"), true);
        this.tierFontCB.addChangeListener(this);
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel optionsPanel = new JPanel();
        optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.AdvancedSetting.Label.Options")));
        optionsPanel.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        optionsPanel.add((Component)this.typeCB, gbc);
        gbc.gridy = 1;
        optionsPanel.add((Component)this.dependentTiersCB, gbc);
        gbc.gridy = 2;
        optionsPanel.add((Component)this.participantsCB, gbc);
        JPanel settingsPanel = new JPanel();
        settingsPanel.setBorder(new TitledBorder(ElanLocale.getString("EditTierDialog.AdvancedSetting.Label.Setting")));
        settingsPanel.setLayout(new GridBagLayout());
        this.okButton = new JButton();
        this.okButton.setText(ElanLocale.getString("Button.Apply"));
        this.okButton.addActionListener(this);
        if (this.appleAttributesDlg) {
            this.okButton.setEnabled(false);
        }
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        settingsPanel.add((Component)this.tierColorCB, gbc);
        gbc.gridy = 1;
        settingsPanel.add((Component)this.tierHighLightColorCB, gbc);
        gbc.gridy = 2;
        settingsPanel.add((Component)this.tierFontCB, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = new Insets(6, 6, 6, 6);
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)settingsPanel, gbc);
        gbc.gridy = 1;
        this.getContentPane().add((Component)optionsPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = 3;
        gbc.anchor = 15;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.okButton, gbc);
    }

    private void postInit() {
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(this.getParent());
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    public HashMap getTierProperties() {
        return this.tierProperties;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ((this.tierColorCB.isSelected() || this.tierHighLightColorCB.isSelected() || this.tierFontCB.isSelected()) && (this.typeCB.isSelected() || this.dependentTiersCB.isSelected() || this.participantsCB.isSelected())) {
            if (this.tierProperties != null) {
                this.applyNewPropertyChanges();
            } else {
                this.applyAttributeSettings();
            }
        }
        this.doClose();
    }

    private void applyNewPropertyChanges() {
        this.tierProperties.put("SameType", this.typeCB.isSelected());
        this.tierProperties.put("DependingTiers", this.dependentTiersCB.isSelected());
        this.tierProperties.put("SameParticipants", this.participantsCB.isSelected());
        this.tierProperties.put("Color", this.tierColorCB.isSelected());
        this.tierProperties.put("HighLightColor", this.tierHighLightColorCB.isSelected());
        this.tierProperties.put("Font", this.tierFontCB.isSelected());
    }

    private void applyAttributeSettings() {
        HashMap<String, Font> fonts;
        HashMap<String, Color> highlightColors;
        HashMap<String, Color> colors = (HashMap<String, Color>)Preferences.get("TierColors", this.transcription);
        if (colors == null) {
            colors = new HashMap<String, Color>();
            Preferences.set("TierColors", colors, this.transcription);
        }
        if ((highlightColors = (HashMap<String, Color>)Preferences.get("TierHighlightColors", this.transcription)) == null) {
            highlightColors = new HashMap<String, Color>();
            Preferences.set("TierHighlightColors", highlightColors, this.transcription);
        }
        if ((fonts = (HashMap<String, Font>)Preferences.get("TierFonts", this.transcription)) == null) {
            fonts = new HashMap<String, Font>();
            Preferences.set("TierFonts", fonts, this.transcription);
        }
        TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.tierName);
        Color nextColor = (Color)colors.get(this.tierName);
        Color nextHighlightColor = (Color)highlightColors.get(this.tierName);
        Font fo = (Font)fonts.get(this.tierName);
        Vector<TierImpl> tierList = new Vector<TierImpl>();
        if (this.typeCB.isSelected() && tier.getLinguisticType() != null && this.transcription.getTiersWithLinguisticType(tier.getLinguisticType().getLinguisticTypeName()) != null) {
            tierList.addAll(this.transcription.getTiersWithLinguisticType(tier.getLinguisticType().getLinguisticTypeName()));
        }
        if (this.dependentTiersCB.isSelected() && tier.getDependentTiers() != null) {
            tierList.addAll(tier.getDependentTiers());
        }
        if (this.participantsCB.isSelected() && tier.getParticipant() != null) {
            Vector allTiers = this.transcription.getTiers();
            for (int i = 0; i < allTiers.size(); ++i) {
                TierImpl t = (TierImpl)allTiers.get(i);
                if (t.getParticipant() == null || !t.getParticipant().equals(tier.getParticipant()) || tierList.contains(t)) continue;
                tierList.add(t);
            }
        }
        for (int i = 0; i < tierList.size(); ++i) {
            TierImpl t = (TierImpl)tierList.get(i);
            if (this.tierColorCB.isSelected() && nextColor != null && !nextColor.equals(Color.WHITE)) {
                colors.put(t.getName(), nextColor);
            }
            if (this.tierHighLightColorCB.isSelected() && nextHighlightColor != null && !nextHighlightColor.equals(Color.WHITE)) {
                highlightColors.put(t.getName(), nextHighlightColor);
            }
            if (!this.tierFontCB.isSelected() || fo == null) continue;
            fonts.put(t.getName(), fo);
        }
        if (nextColor != null || nextHighlightColor != null || fo != null) {
            Preferences.set("TierHighlightColors", highlightColors, this.transcription, true);
            Preferences.set("TierColors", colors, this.transcription, true);
            Preferences.set("TierFonts", fonts, this.transcription, true);
        } else {
            JOptionPane.showMessageDialog(this, "No attribute settings avaible for the selected tier.", ElanLocale.getString("Message.Warning"), 2);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.tierColorCB.isSelected() || this.tierHighLightColorCB.isSelected() || this.tierFontCB.isSelected()) {
            this.typeCB.setEnabled(true);
            this.dependentTiersCB.setEnabled(true);
            this.participantsCB.setEnabled(true);
            if (this.appleAttributesDlg) {
                if (this.typeCB.isSelected() || this.dependentTiersCB.isSelected() || this.participantsCB.isSelected()) {
                    this.okButton.setEnabled(true);
                } else {
                    this.okButton.setEnabled(false);
                }
            }
        } else {
            this.typeCB.setEnabled(false);
            this.dependentTiersCB.setEnabled(false);
            this.participantsCB.setEnabled(false);
            if (this.appleAttributesDlg) {
                this.okButton.setEnabled(false);
            }
        }
    }
}

