/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import mpi.eudico.client.annotator.gui.FontTable;

public class FontGui
extends JFrame
implements ActionListener,
ListSelectionListener {
    JTextArea _jtext = new JTextArea("Enter UNICODE Text");
    JList _lstUniInfo = null;
    Vector _vUniInfo = new Vector();
    JList _lstFontUniInfo = null;
    Vector vFontUniInfo = new Vector();
    JList _lstsysfonts = null;
    JList _lstrenderfonts = null;
    JLabel _labFontInfo = null;
    Vector _vrendfonts = null;
    Font[] _fonts = null;
    Vector _vUniBlock = null;
    FontTable _fonttable = null;

    public FontGui() {
        super("Unicode Font Finder-Explorer");
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(ge.getDefaultScreenDevice().getDefaultConfiguration());
        this.setSize(Math.min(500, (dim.width - ins.left - ins.right) / 2), Math.min(800, dim.height - ins.top - ins.bottom));
        this.setLocation(ins.left, ins.top);
        this._fonts = ge.getAllFonts();
        Vector<String> tmv = new Vector<String>();
        for (int i = 0; i < this._fonts.length; ++i) {
            tmv.add(this._fonts[i].getFontName());
            this._fonts[i] = new Font(this._fonts[i].getFontName(), 0, 18);
        }
        this._lstsysfonts = new JList(tmv);
        this._lstsysfonts.setSelectionMode(1);
        this._lstsysfonts.addListSelectionListener(this);
        JScrollPane listScroller = new JScrollPane(this._lstsysfonts);
        listScroller.setPreferredSize(new Dimension(200, 80));
        listScroller.setMinimumSize(new Dimension(200, 80));
        listScroller.setAlignmentX(0.0f);
        JLabel label = new JLabel("System Fonts");
        label.setLabelFor(this._lstsysfonts);
        this._lstFontUniInfo = new JList();
        this._lstFontUniInfo.setSelectionMode(1);
        this._lstFontUniInfo.addListSelectionListener(this);
        JScrollPane listUniScroller = new JScrollPane(this._lstFontUniInfo);
        listUniScroller.setPreferredSize(new Dimension(48, 80));
        listUniScroller.setMinimumSize(new Dimension(48, 80));
        listUniScroller.setAlignmentX(0.0f);
        this._labFontInfo = new JLabel("Font Unicode Information");
        this._labFontInfo.setLabelFor(this._lstFontUniInfo);
        JPanel syspanel = new JPanel();
        syspanel.setLayout(new BoxLayout(syspanel, 1));
        syspanel.add(label);
        syspanel.add(Box.createRigidArea(new Dimension(0, 5)));
        syspanel.add(listScroller);
        syspanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        syspanel.add(Box.createRigidArea(new Dimension(0, 5)));
        syspanel.add(this._labFontInfo);
        syspanel.add(Box.createRigidArea(new Dimension(0, 5)));
        syspanel.add(listUniScroller);
        this._vrendfonts = new Vector();
        this._lstrenderfonts = new JList(this._vrendfonts);
        this._lstrenderfonts.addListSelectionListener(this);
        this._lstrenderfonts.setSelectionMode(1);
        listScroller = new JScrollPane(this._lstrenderfonts);
        listScroller.setPreferredSize(new Dimension(200, 80));
        listScroller.setMinimumSize(new Dimension(200, 80));
        listScroller.setAlignmentX(0.0f);
        label = new JLabel("Fonts that will Render text");
        label.setLabelFor(this._lstsysfonts);
        this._lstUniInfo = new JList();
        this._lstUniInfo.addListSelectionListener(this);
        JScrollPane uniScroller = new JScrollPane(this._lstUniInfo);
        uniScroller.setPreferredSize(new Dimension(48, 80));
        uniScroller.setMinimumSize(new Dimension(48, 80));
        uniScroller.setAlignmentX(0.0f);
        JLabel unilabel = new JLabel("Unicode Information");
        unilabel.setLabelFor(this._lstUniInfo);
        JPanel renpanel = new JPanel();
        renpanel.setLayout(new BoxLayout(renpanel, 1));
        renpanel.add(label);
        renpanel.add(Box.createRigidArea(new Dimension(0, 5)));
        renpanel.add(listScroller);
        renpanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        renpanel.add(Box.createRigidArea(new Dimension(0, 5)));
        renpanel.add(unilabel);
        renpanel.add(Box.createRigidArea(new Dimension(0, 5)));
        renpanel.add(uniScroller);
        JPanel fontsPane = new JPanel();
        fontsPane.setLayout(new BoxLayout(fontsPane, 0));
        fontsPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        fontsPane.add(syspanel);
        fontsPane.add(Box.createRigidArea(new Dimension(10, 0)));
        fontsPane.add(renpanel);
        JScrollPane textScroller = new JScrollPane(this._jtext);
        textScroller.setPreferredSize(new Dimension(5490, 100));
        textScroller.setMinimumSize(new Dimension(5490, 100));
        textScroller.setAlignmentX(0.0f);
        label = new JLabel("Paste UNICODE text");
        label.setLabelFor(this._jtext);
        JPanel textpanel = new JPanel();
        textpanel.setLayout(new BoxLayout(textpanel, 1));
        textpanel.add(label);
        textpanel.add(Box.createRigidArea(new Dimension(0, 5)));
        textpanel.add(textScroller);
        textpanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 10, 20));
        JPanel buttonpanel = new JPanel();
        buttonpanel.setLayout(new BoxLayout(buttonpanel, 0));
        buttonpanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonpanel.add(Box.createHorizontalGlue());
        JButton btncheck = new JButton("Check");
        btncheck.addActionListener(this);
        buttonpanel.add(btncheck);
        buttonpanel.add(Box.createRigidArea(new Dimension(10, 0)));
        JButton btnclear = new JButton("Clear");
        btnclear.addActionListener(this);
        buttonpanel.add(btnclear);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.getContentPane().add((Component)fontsPane, gbc);
        gbc.gridy = 1;
        this.getContentPane().add((Component)textpanel, gbc);
        gbc.gridy = 2;
        gbc.fill = 2;
        gbc.weighty = 0.0;
        this.getContentPane().add((Component)buttonpanel, gbc);
        this.readUniBlockTable();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        System.out.println(ae.getActionCommand());
        if (ae.getActionCommand().equals("Clear")) {
            this._lstsysfonts.removeListSelectionListener(this);
            this._lstFontUniInfo.removeListSelectionListener(this);
            this._lstrenderfonts.removeListSelectionListener(this);
            this._lstUniInfo.removeListSelectionListener(this);
            this._jtext.setText("");
            this._vrendfonts.clear();
            this._vUniInfo.clear();
            this.vFontUniInfo.clear();
            this._lstrenderfonts.setListData(this._vrendfonts);
            this._lstUniInfo.setListData(this._vUniInfo);
            this._lstFontUniInfo.setListData(this.vFontUniInfo);
            this._lstrenderfonts.invalidate();
            this._lstsysfonts.addListSelectionListener(this);
            this._lstFontUniInfo.addListSelectionListener(this);
            this._lstrenderfonts.addListSelectionListener(this);
            this._lstUniInfo.addListSelectionListener(this);
        } else if (ae.getActionCommand().equals("Check")) {
            this._lstrenderfonts.setListData(this._vrendfonts);
            this._lstrenderfonts.invalidate();
            this.checkUniText();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (lse.getSource() == this._lstsysfonts) {
            Font f = this._fonts[this._lstsysfonts.getSelectedIndex()];
            this.checkFontCapibilities(f);
            this._jtext.setFont(f);
            if (this._fonttable != null) {
                this._fonttable.setFont(f);
            }
        } else if (lse.getSource() == this._lstrenderfonts) {
            Font font = new Font((String)this._vrendfonts.elementAt(this._lstrenderfonts.getSelectedIndex()), 0, 20);
            this.checkFontCapibilities(font);
            this._jtext.setFont(font);
            if (this._fonttable != null) {
                this._fonttable.setFont(font);
            }
        } else if (lse.getSource() == this._lstUniInfo) {
            this.launchBrowser((UnicodeBlock)this._vUniInfo.elementAt(this._lstUniInfo.getSelectedIndex()));
            this.hiliteCharsInRange(this._lstUniInfo.getSelectedIndex());
        } else if (lse.getSource() == this._lstFontUniInfo) {
            if (this._lstFontUniInfo.getSelectedIndex() < 0) {
                return;
            }
            this.launchBrowser((UnicodeBlock)this.vFontUniInfo.elementAt(this._lstFontUniInfo.getSelectedIndex()));
        }
    }

    public void checkUniText() {
        String text = this._jtext.getText();
        this._vUniInfo.clear();
        for (int ii = 0; ii < text.length(); ++ii) {
            UnicodeBlock ub = this.findUniBlock(text.charAt(ii));
            if (Character.isWhitespace(text.charAt(ii)) || this._vUniInfo.contains(ub)) continue;
            this._vUniInfo.add(ub);
        }
        for (int i = 0; i < this._fonts.length; ++i) {
            Font f = this._fonts[i];
            if (f.canDisplayUpTo(text) != -1 || this._vrendfonts.contains(this._fonts[i].getFontName())) continue;
            this._vrendfonts.add(this._fonts[i].getFontName());
        }
        this._lstrenderfonts.setListData(this._vrendfonts);
        this._lstrenderfonts.invalidate();
        this._lstUniInfo.setListData(this._vUniInfo);
    }

    public void readUniBlockTable() {
        this._vUniBlock = new Vector();
        BufferedReader cdTable = null;
        try {
            String s;
            cdTable = new BufferedReader(new InputStreamReader(FontGui.class.getResourceAsStream("/mpi/eudico/client/annotator/resources/Blocks.txt")));
            while ((s = cdTable.readLine()) != null) {
                UnicodeBlock ucb = new UnicodeBlock();
                StringTokenizer st = new StringTokenizer(s, ";");
                String tok = st.nextToken();
                ucb._start = Integer.parseInt(tok, 16);
                ucb._end = Integer.parseInt(st.nextToken(), 16);
                ucb.desc = st.nextToken();
                this._vUniBlock.add(ucb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public UnicodeBlock findUniBlock(char b) {
        UnicodeBlock ucb = null;
        Enumeration e = this._vUniBlock.elements();
        while (e.hasMoreElements()) {
            ucb = (UnicodeBlock)e.nextElement();
            if (!ucb.inRange(b)) continue;
            return ucb;
        }
        return null;
    }

    public static void main(String[] args) {
        FontGui g = new FontGui();
        g.setVisible(true);
    }

    public void checkFontCapibilities(Font font) {
        UnicodeBlock ucb = null;
        this.vFontUniInfo.clear();
        Enumeration e = this._vUniBlock.elements();
        while (e.hasMoreElements()) {
            ucb = (UnicodeBlock)e.nextElement();
            int charsup = 0;
            for (int i = ucb._start; i < ucb._end; ++i) {
                if (!font.canDisplay((char)i)) continue;
                ++charsup;
            }
            if (charsup <= 0) continue;
            this.vFontUniInfo.add(ucb);
        }
        this._labFontInfo.setText(font.getFontName() + " Can Display " + this.vFontUniInfo.size());
        this._lstFontUniInfo.setListData(this.vFontUniInfo);
    }

    private void launchBrowser(UnicodeBlock ucb) {
        if (this._fonttable == null) {
            this._fonttable = new FontTable(ucb._start, ucb._end, ucb.desc, this._jtext.getFont());
            Point pt = this.getLocation();
            Dimension dm = this.getSize();
            pt.x += (int)dm.getWidth();
            this._fonttable.setLocation(pt);
            Dimension db = this._fonttable.getSize();
            this._fonttable.setSize((int)db.getWidth(), (int)dm.getHeight());
            this._fonttable.setVisible(true);
        } else {
            this._fonttable.reload(ucb._start, ucb._end, ucb.desc, this._jtext.getFont());
            if (!this._fonttable.isVisible()) {
                this._fonttable.setVisible(true);
            }
        }
    }

    private void hiliteCharsInRange(int pos) {
        try {
            Highlighter h = this._jtext.getHighlighter();
            h.removeAllHighlights();
            UnicodeBlock ucb = (UnicodeBlock)this._vUniInfo.elementAt(pos);
            DefaultHighlighter.DefaultHighlightPainter redHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.gray);
            String text = this._jtext.getText();
            for (int i = 0; i < text.length(); ++i) {
                if (!ucb.inRange(text.charAt(i))) continue;
                h.addHighlight(i, i + 1, redHighlightPainter);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this._fonttable != null) {
            this._fonttable.setVisible(visible);
            this._fonttable.dispose();
        }
        super.setVisible(visible);
    }

    private class UnicodeBlock {
        int _start;
        int _end;
        String desc;

        private UnicodeBlock() {
        }

        public boolean inRange(char b) {
            return b >= this._start && b <= this._end;
        }

        public String toString() {
            String s = this.desc + " " + Integer.toHexString(this._start) + " " + Integer.toHexString(this._end);
            return s;
        }
    }
}

