/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import mpi.eudico.client.annotator.gui.FontGui;

class FontTable
extends JFrame {
    int _start;
    int _end;
    String _codepgname;
    Font _font;
    DefaultTableModel _dataModel = null;
    JTable table = null;

    public FontTable(int start, int end, String name, Font font) {
        super("Font Browser for Codepage:" + name);
        this.reload(start, end, name, font);
        this.setSize(500, 700);
    }

    public void reload(int start, int end, String name, Font font) {
        this.setTitle("Font Browser for Codepage:" + name);
        this._start = start;
        this._end = end;
        this._codepgname = name;
        this._font = font;
        this.getContentPane().removeAll();
        Object[][] data = new Object[][]{{" ", " ", " "}};
        Object[] columnNames = new String[]{"Font", "Unicode Hex", "Display Name"};
        this._dataModel = null;
        this._dataModel = new DefaultTableModel(data, columnNames);
        this.table = new JTable(this._dataModel);
        JScrollPane scrollpane = new JScrollPane(this.table);
        TableColumn column = null;
        this.table.setRowHeight(20);
        this.loadTable();
        column = this.table.getColumnModel().getColumn(0);
        column.setMaxWidth(50);
        column.sizeWidthToFit();
        column = this.table.getColumnModel().getColumn(1);
        column.setMaxWidth(65);
        column.sizeWidthToFit();
        column = this.table.getColumnModel().getColumn(2);
        column.sizeWidthToFit();
        this.table.setFont(this._font);
        this.getContentPane().add(scrollpane);
        this.getContentPane().validate();
    }

    private void loadTable() {
        boolean ct = false;
        BufferedReader cdTable = null;
        try {
            String s;
            cdTable = new BufferedReader(new InputStreamReader(FontGui.class.getResourceAsStream("/mpi/eudico/client/annotator/resources/UnicodeData.txt")));
            while ((s = cdTable.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, ";");
                String tmpe = st.nextToken();
                int uni = Integer.parseInt(tmpe, 16);
                String desc = st.nextToken();
                if (uni < this._start || uni > this._end) continue;
                Vector<String> v = new Vector<String>();
                Character c = new Character((char)uni);
                v.add(c.toString());
                v.add(Integer.toHexString(uni));
                v.add(desc);
                this._dataModel.addRow(v);
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
            return;
        }
    }

    @Override
    public void setFont(Font f) {
        this.table.setFont(f);
    }
}

