/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.recognizer.data.Segment;

public class SegmentTableModel
extends AbstractTableModel {
    public static final String LABEL_PREF = "SegmentsToTierDialog.Table.";
    public static final String LABEL = "CurrentLabel";
    public static final String LABEL_NEW = "NewLabel";
    public static final String INCLUDE = "Include";
    public static final String NUMBER = "NumberSegments";
    public static final String NULL = "<null>";
    private final int NUM_COLS = 4;
    private ArrayList segmentList = new ArrayList();
    private List columnIds = new ArrayList(4);
    private List tableData = new ArrayList();
    private List classes = new ArrayList(4);

    public SegmentTableModel() {
        this.initLists();
    }

    private void initLists() {
        this.columnIds.add(INCLUDE);
        this.classes.add(Boolean.class);
        this.columnIds.add(LABEL);
        this.classes.add(String.class);
        this.columnIds.add(LABEL_NEW);
        this.classes.add(String.class);
        this.columnIds.add(NUMBER);
        this.classes.add(Boolean.class);
    }

    public void addSegment(Segment segment) {
        if (segment != null) {
            this.segmentList.add(segment);
            ArrayList<Object> rdata = new ArrayList<Object>(4);
            int index = this.columnIds.indexOf(INCLUDE);
            if (index > -1) {
                rdata.add(index, Boolean.TRUE);
            }
            if ((index = this.columnIds.indexOf(LABEL)) > -1) {
                if (segment.label != null) {
                    rdata.add(index, segment.label);
                } else {
                    rdata.add(index, NULL);
                }
            }
            if ((index = this.columnIds.indexOf(LABEL_NEW)) > -1) {
                rdata.add(index, "");
            }
            if ((index = this.columnIds.indexOf(NUMBER)) > -1) {
                rdata.add(index, Boolean.FALSE);
            }
            this.tableData.add(rdata);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnIds.size();
    }

    @Override
    public int getRowCount() {
        return this.tableData.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return null;
        }
        ArrayList row = (ArrayList)this.tableData.get(rowIndex);
        return row.get(columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.tableData.size() || columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return;
        }
        if (this.isCellEditable(rowIndex, columnIndex)) {
            ArrayList row = (ArrayList)this.tableData.get(rowIndex);
            row.set(columnIndex, aValue);
            this.fireTableDataChanged();
        }
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        int col = this.findColumn(LABEL);
        return column != col;
    }

    @Override
    public int findColumn(String columnName) {
        return this.columnIds.indexOf(columnName);
    }

    public int findColumnByName(String columnName) {
        if (columnName == null) {
            return -1;
        }
        for (int i = 0; i < this.columnIds.size(); ++i) {
            if (!columnName.equals(ElanLocale.getString(LABEL_PREF + (String)this.columnIds.get(i)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.columnIds.size()) {
            return "";
        }
        return ElanLocale.getString(LABEL_PREF + (String)this.columnIds.get(columnIndex));
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.classes.size()) {
            return null;
        }
        return (Class)this.classes.get(columnIndex);
    }

    public void removeRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.tableData.size()) {
            this.tableData.remove(rowIndex);
            this.segmentList.remove(rowIndex);
            this.fireTableDataChanged();
        }
    }

    public void removeAllRows() {
        this.tableData.clear();
        this.segmentList.clear();
        this.fireTableDataChanged();
    }
}

