/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.util.TimeFormatter;

public class ShiftAnnotationsDialog
extends ClosableDialog
implements ActionListener {
    private TranscriptionImpl transcription;
    private JLabel label;
    private JLabel minMaxLabel;
    private JTextField textField;
    private JPanel buttonPanel;
    private JButton okButton;
    private JButton cancelButton;
    private long value = 0L;
    private long minValue = 0L;
    private long maxValue = 0L;

    public ShiftAnnotationsDialog(Transcription transcription, long min, long max) {
        super((Frame)ELANCommandFactory.getRootFrame(transcription), true);
        this.transcription = (TranscriptionImpl)transcription;
        this.minValue = min;
        this.maxValue = max;
        this.initComponents();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.minMaxLabel = new JLabel();
        this.textField = new JTextField();
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 2));
        this.okButton = new JButton();
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().setLayout(new GridBagLayout());
        Insets inset = new Insets(2, 6, 2, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.minMaxLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.insets = inset;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.textField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 10;
        gbc.fill = 0;
        gbc.insets = inset;
        this.getContentPane().add((Component)this.buttonPanel, gbc);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ShiftAnnotationsDialog.this.closeDialog();
            }
        });
        this.updateLocale();
        this.pack();
        int w = 260;
        int h = 180;
        this.setSize(this.getSize().width < w ? w : this.getSize().width, this.getSize().height < h ? h : this.getSize().height);
        this.setLocationRelativeTo(this.getParent());
        this.textField.grabFocus();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void updateLocale() {
        this.setTitle(ElanLocale.getString("CommandActions.ShiftAnnotations"));
        this.label.setText(ElanLocale.getString("ShiftAllDialog.Label"));
        this.minMaxLabel.setText(this.minValue + "(ms)  &  " + this.maxValue + "(ms)");
        this.okButton.setText(ElanLocale.getString("Button.OK"));
        this.cancelButton.setText(ElanLocale.getString("Button.Cancel"));
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.closeDialog();
        } else if (e.getSource() == this.okButton) {
            String textValue = this.textField.getText().trim();
            long longValue = 0L;
            try {
                longValue = TimeFormatter.toMilliSeconds(textValue);
            }
            catch (NumberFormatException nfe) {
                this.textField.setText("");
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (longValue == 0L) {
                this.value = 0L;
                this.closeDialog();
                return;
            }
            if (longValue < this.minValue) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ShiftAllDialog.Warn") + " " + (this.minValue - 1L), ElanLocale.getString("Message.Warning"), 2);
                this.textField.setText("" + this.minValue);
                return;
            }
            if (longValue > this.maxValue) {
                JOptionPane.showMessageDialog(this, ElanLocale.getString("ShiftAllDialog.Warn2") + " " + (this.maxValue + 1L), ElanLocale.getString("Message.Warning"), 2);
                this.textField.setText("" + this.maxValue);
                return;
            }
            this.value = longValue;
            this.closeDialog();
        }
    }
}

