/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ShortcutsUtil;
import mpi.eudico.client.annotator.gui.ShortcutPanel;

public class ShortcutEditPanel
extends JPanel
implements KeyListener,
ActionListener {
    protected JTextField entryField;
    protected KeyStroke newShortcut;
    protected String newShortcutAsText;
    protected KeyStroke currentShortcut;
    protected String currentShortCutAsText;
    protected String currentAction;
    protected JButton cancelButton;
    protected JButton okButton;
    protected JButton applyAllModesButton;
    protected JButton removeButton;
    private ShortcutPanel shortcutPanel;

    public ShortcutEditPanel(ShortcutPanel shortcutPanel, String actionID, KeyStroke actionKey) {
        this.shortcutPanel = shortcutPanel;
        this.currentAction = actionID;
        this.currentShortcut = actionKey;
        this.currentShortCutAsText = ShortcutsUtil.getInstance().getDescriptionForKeyStroke(this.currentShortcut);
        this.newShortcut = this.currentShortcut;
        JLabel descField = new JLabel(ElanLocale.getString("Shortcuts.Editor.Title"));
        this.entryField = new JTextField();
        this.entryField.setPreferredSize(new Dimension(170, 25));
        this.entryField.setFocusable(true);
        this.entryField.setFocusTraversalKeysEnabled(false);
        this.entryField.addKeyListener(this);
        this.entryField.setText(this.currentShortCutAsText);
        this.okButton = new JButton(ElanLocale.getString("Button.Apply"));
        this.okButton.addActionListener(this);
        this.applyAllModesButton = new JButton(ElanLocale.getString("Shortcuts.Button.ApplyAll"));
        this.applyAllModesButton.addActionListener(this);
        this.removeButton = new JButton(ElanLocale.getString("Shortcuts.Button.Clear"));
        this.removeButton.addActionListener(this);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 2, 6, 0));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyAllModesButton);
        buttonPanel.add(this.cancelButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 6, 4, 6);
        this.add((Component)descField, gbc);
        gbc.gridx = 1;
        gbc.fill = 2;
        this.add((Component)this.entryField, gbc);
        gbc.gridx = 2;
        gbc.fill = 0;
        this.add((Component)this.removeButton, gbc);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(10, 6, 4, 6);
        this.add((Component)buttonPanel, gbc);
    }

    public KeyStroke getValue() {
        return this.newShortcut;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
        } else if (e.getSource() == this.removeButton) {
            this.newShortcut = null;
            this.newShortcutAsText = "";
            this.entryField.setText(this.newShortcutAsText);
            this.entryField.requestFocus();
        } else if (e.getSource() == this.okButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
            if (this.shortcutPanel != null) {
                this.shortcutPanel.changeShortcut(this.newShortcut, false);
            }
        } else if (e.getSource() == this.applyAllModesButton) {
            SwingUtilities.getWindowAncestor(this).setVisible(false);
            if (this.shortcutPanel != null) {
                this.shortcutPanel.changeShortcut(this.newShortcut, true);
            }
        }
    }

    public static void createAndShowGUI(ShortcutPanel caller, String actionID, ArrayList<Integer> codes) {
        JDialog owner = (JDialog)SwingUtilities.getWindowAncestor(caller);
        ShortcutsUtil scu = ShortcutsUtil.getInstance();
        String actionName = scu.getDescriptionForAction(actionID);
        KeyStroke actionKeyStroke = null;
        if (codes != null) {
            actionKeyStroke = KeyStroke.getKeyStroke(codes.get(0), (int)codes.get(1));
        }
        JDialog frame = new JDialog(owner, ElanLocale.getString("Shortcuts.Editor.Label") + " '" + actionName + "'", true);
        ShortcutEditPanel newContentPane = new ShortcutEditPanel(caller, actionID, actionKeyStroke);
        newContentPane.setOpaque(true);
        frame.setContentPane(newContentPane);
        frame.pack();
        frame.setLocationRelativeTo(owner);
        frame.setVisible(true);
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        this.entryField.setText("");
        this.newShortcut = KeyStroke.getKeyStrokeForEvent(ke);
        String myKeyString = KeyEvent.getKeyText(ke.getKeyCode());
        String myModifierString = KeyEvent.getModifiersExText(ke.getModifiersEx());
        this.newShortcutAsText = ke.getModifiersEx() == 0 ? myKeyString : myModifierString + " + " + myKeyString;
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        this.entryField.setText(this.newShortcutAsText);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }
}

