/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.tier.TierExportTableModel;
import mpi.eudico.client.util.CheckBoxTableCellRenderer;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class TierSortAndSelectDialog
extends ClosableDialog
implements ActionListener,
ListSelectionListener,
MouseListener {
    protected final String NOT_SPECIFIED = "not specified";
    protected final String BY_TIER = ElanLocale.getString("ExportDialog.Tab.Tier");
    protected final String BY_TYPE = ElanLocale.getString("ExportDialog.Tab.Type");
    protected final String BY_PART = ElanLocale.getString("ExportDialog.Tab.Participant");
    protected final String BY_ANN = ElanLocale.getString("ExportDialog.Tab.Annotators");
    protected JPanel buttonPanel;
    private JButton cancelButton;
    private JButton okButton;
    protected JPanel tierButtonPanel;
    protected JButton downButton;
    protected JButton upButton;
    protected JButton allButton;
    protected JButton noneButton;
    protected DefaultTableModel model;
    protected JPanel tierSelectionPanel;
    protected final JTabbedPane selectTiersTabPane = new JTabbedPane();
    protected JTable tierTable;
    protected final String SELECT_COLUMN = "select";
    protected final String TIER_NAME_COLUMN = "tier";
    private List<String> returnedTiers = null;
    private int currentTabIndex = 0;
    private List<String> allTierNames;
    private List<String> allTypeNames;
    private List<String> allPartNames;
    private List<String> allAnnNames;
    private List<String> selectedTypeNames;
    private List<String> selectedTierNames;
    private List<String> selectedParts;
    private List<String> selectedAnns;
    private Transcription transcription;
    private List<String> hiddenTiers;

    public TierSortAndSelectDialog(Frame owner, Transcription trans, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner);
        this.allTierNames = tierOrder;
        this.selectedTierNames = new Vector<String>(selectedTiers);
        this.transcription = trans;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Frame owner, boolean modal, Transcription trans, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner, modal);
        this.allTierNames = tierOrder;
        this.selectedTierNames = selectedTiers;
        this.transcription = trans;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Dialog owner, Transcription trans, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner);
        this.allTierNames = tierOrder;
        this.selectedTierNames = selectedTiers;
        this.transcription = trans;
        this.initComponents();
    }

    public TierSortAndSelectDialog(Dialog owner, boolean modal, Transcription trans, List<String> tierOrder, List<String> selectedTiers) throws HeadlessException {
        super(owner, modal);
        this.allTierNames = tierOrder;
        this.selectedTierNames = selectedTiers;
        this.transcription = trans;
        this.initComponents();
    }

    private void initComponents() {
        JCheckBox checkbox;
        int i;
        this.selectedTypeNames = new Vector<String>();
        this.selectedParts = new Vector<String>();
        this.selectedAnns = new Vector<String>();
        this.allTypeNames = new Vector<String>();
        this.allPartNames = new Vector<String>();
        this.allAnnNames = new Vector<String>();
        this.hiddenTiers = new Vector<String>();
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 4, 6);
        this.model = new TierExportTableModel();
        this.tierTable = new JTable(this.model);
        this.model.setColumnIdentifiers(new String[]{"select", "tier"});
        this.tierTable.getColumn("select").setCellEditor(new DefaultCellEditor(new JCheckBox()));
        this.tierTable.getColumn("select").setCellRenderer(new CheckBoxTableCellRenderer());
        this.tierTable.getColumn("select").setMaxWidth(30);
        this.tierTable.setShowVerticalLines(false);
        this.tierTable.setTableHeader(null);
        this.tierTable.getSelectionModel().addListSelectionListener(this);
        if (this.allTierNames != null) {
            for (String name : this.allTierNames) {
                if (this.selectedTierNames != null) {
                    if (this.selectedTierNames.contains(name)) {
                        this.model.addRow(new Object[]{Boolean.TRUE, name});
                    } else {
                        this.model.addRow(new Object[]{Boolean.FALSE, name});
                    }
                } else {
                    this.model.addRow(new Object[]{Boolean.TRUE, name});
                }
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(name);
                String value = tier.getParticipant();
                if (value.length() == 0) {
                    value = "not specified";
                }
                if (!this.allPartNames.contains(value)) {
                    this.allPartNames.add(value);
                }
                if ((value = tier.getAnnotator()).length() == 0) {
                    value = "not specified";
                }
                if (!this.allAnnNames.contains(value)) {
                    this.allAnnNames.add(value);
                }
                if (this.allTypeNames.contains(value = tier.getLinguisticType().getLinguisticTypeName())) continue;
                this.allTypeNames.add(value);
            }
        }
        Dimension tableDim = new Dimension(50, 150);
        JScrollPane tierScrollPane = new JScrollPane(this.tierTable);
        this.selectTiersTabPane.setPreferredSize(tableDim);
        this.selectTiersTabPane.addMouseListener(this);
        this.selectTiersTabPane.add(this.BY_TIER, tierScrollPane);
        JPanel checkboxPanel = new JPanel();
        BoxLayout box = new BoxLayout(checkboxPanel, 1);
        checkboxPanel.setLayout(box);
        for (i = 0; i < this.allTypeNames.size(); ++i) {
            checkbox = new JCheckBox(this.allTypeNames.get(i));
            checkboxPanel.add(checkbox);
        }
        this.selectTiersTabPane.add(this.BY_TYPE, new JScrollPane(checkboxPanel));
        checkboxPanel = new JPanel();
        box = new BoxLayout(checkboxPanel, 1);
        checkboxPanel.setLayout(box);
        for (i = 0; i < this.allPartNames.size(); ++i) {
            checkbox = new JCheckBox(this.allPartNames.get(i));
            checkboxPanel.add(checkbox);
        }
        this.selectTiersTabPane.addTab(this.BY_PART, new JScrollPane(checkboxPanel));
        checkboxPanel = new JPanel();
        box = new BoxLayout(checkboxPanel, 1);
        checkboxPanel.setLayout(box);
        for (i = 0; i < this.allAnnNames.size(); ++i) {
            checkbox = new JCheckBox(this.allAnnNames.get(i));
            checkboxPanel.add(checkbox);
        }
        this.selectTiersTabPane.addTab(this.BY_ANN, new JScrollPane(checkboxPanel));
        this.tierSelectionPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = insets;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.tierSelectionPanel.add((Component)this.selectTiersTabPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.tierSelectionPanel, gridBagConstraints);
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.allButton = new JButton(ElanLocale.getString("Button.SelectAll"));
        this.noneButton = new JButton(ElanLocale.getString("Button.SelectNone"));
        this.tierButtonPanel = new JPanel(new GridBagLayout());
        try {
            ImageIcon upIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Up16.gif"));
            ImageIcon downIcon = new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/navigation/Down16.gif"));
            this.upButton.setIcon(upIcon);
            this.downButton.setIcon(downIcon);
        }
        catch (Exception ex) {
            this.upButton.setText("Up");
            this.downButton.setText("Down");
        }
        this.upButton.addActionListener(this);
        this.downButton.addActionListener(this);
        this.allButton.addActionListener(this);
        this.noneButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.upButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.downButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 20, 4, 2);
        this.tierButtonPanel.add((Component)this.allButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = insets;
        this.tierButtonPanel.add((Component)this.noneButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.tierSelectionPanel.add((Component)this.tierButtonPanel, gridBagConstraints);
        this.cancelButton = new JButton(ElanLocale.getString("Button.Cancel"));
        this.cancelButton.addActionListener(this);
        this.okButton = new JButton(ElanLocale.getString("Button.OK"));
        this.okButton.addActionListener(this);
        this.buttonPanel = new JPanel(new GridLayout(1, 2, 6, 0));
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = insets;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
        int minW = 300;
        int minH = 400;
        this.setSize(Math.max(minW, this.getWidth()), Math.max(minH, this.getHeight()));
    }

    public List<String> getSelectedTiers() {
        return this.returnedTiers;
    }

    public List<String> getTierOrder() {
        int nameCol = this.model.findColumn("tier");
        ArrayList<String> orderedTiers = new ArrayList<String>();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            orderedTiers.add((String)this.model.getValueAt(i, nameCol));
        }
        return orderedTiers;
    }

    public List getHiddenTiers() {
        Vector<String> hiddenTiers = new Vector<String>();
        if (this.selectedTypeNames.size() > 0) {
            Vector tiers = new Vector();
            for (int i = 0; i < this.selectedTypeNames.size(); ++i) {
                tiers.addAll(this.transcription.getTiersWithLinguisticType(this.selectedTypeNames.get(i)));
            }
            for (int i = 0; i < tiers.size(); ++i) {
                TierImpl t = (TierImpl)tiers.get(i);
                if (this.selectedTierNames.contains(t.getName())) continue;
                hiddenTiers.add(t.getName());
            }
        } else if (this.selectedParts.size() > 0) {
            for (int i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String partName = tier.getParticipant();
                if (partName.length() == 0) {
                    partName = "not specified";
                }
                if (!this.selectedParts.contains(partName) || this.selectedTierNames.contains(tier.getName())) continue;
                hiddenTiers.add(tier.getName());
            }
        } else if (this.selectedAnns.size() > 0) {
            for (int i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String annName = tier.getAnnotator();
                if (annName.length() == 0) {
                    annName = "not specified";
                }
                if (!this.selectedAnns.contains(annName) || this.selectedTierNames.contains(tier.getName())) continue;
                hiddenTiers.add(tier.getName());
            }
        }
        if (hiddenTiers.size() > 0) {
            return hiddenTiers;
        }
        return null;
    }

    private void setHiddenTiers(List hiddenTiers) {
        if (hiddenTiers == null) {
            return;
        }
        this.hiddenTiers = hiddenTiers;
        String selectionMode = this.selectTiersTabPane.getTitleAt(this.currentTabIndex);
        if (selectionMode.equals(this.BY_ANN)) {
            int i;
            this.selectedAnns.clear();
            for (i = 0; i < this.selectedTierNames.size(); ++i) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId(this.selectedTierNames.get(i));
                String value = t.getAnnotator();
                if (value.length() == 0) {
                    value = "not specified";
                }
                if (this.selectedAnns.contains(value)) continue;
                this.selectedAnns.add(value);
            }
            this.selectedTierNames.clear();
            for (i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String annName = tier.getAnnotator();
                if (annName.length() == 0) {
                    annName = "not specified";
                }
                if (!this.selectedAnns.contains(annName) || hiddenTiers.contains(tier.getName())) continue;
                this.selectedTierNames.add(tier.getName());
            }
            this.selectedTypeNames.clear();
            this.selectedParts.clear();
        } else if (selectionMode.equals(this.BY_TYPE)) {
            this.selectedTypeNames.clear();
            for (int i = 0; i < this.selectedTierNames.size(); ++i) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId(this.selectedTierNames.get(i));
                String value = t.getLinguisticType().getLinguisticTypeName();
                if (this.selectedTypeNames.contains(value)) continue;
                this.selectedTypeNames.add(value);
            }
            this.selectedTierNames.clear();
            for (int i = 0; i < this.selectedTypeNames.size(); ++i) {
                String typeName = this.selectedTypeNames.get(i);
                Vector visibleTiers = this.transcription.getTiersWithLinguisticType(typeName);
                if (visibleTiers == null) continue;
                for (int x = 0; x < visibleTiers.size(); ++x) {
                    TierImpl tier = (TierImpl)visibleTiers.get(x);
                    if (hiddenTiers.contains(tier.getName())) continue;
                    this.selectedTierNames.add(tier.getName());
                }
            }
            this.selectedAnns.clear();
            this.selectedParts.clear();
        } else if (selectionMode.equals(this.BY_PART)) {
            int i;
            this.selectedParts.clear();
            for (i = 0; i < this.selectedTierNames.size(); ++i) {
                TierImpl t = (TierImpl)this.transcription.getTierWithId(this.selectedTierNames.get(i));
                String value = t.getParticipant();
                if (value.length() == 0) {
                    value = "not specified";
                }
                if (this.selectedParts.contains(value)) continue;
                this.selectedParts.add(value);
            }
            this.selectedTierNames.clear();
            for (i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String partName = tier.getParticipant();
                if (partName.length() == 0) {
                    partName = "not specified";
                }
                if (!this.selectedParts.contains(partName) || hiddenTiers.contains(tier.getName())) continue;
                this.selectedTierNames.add(tier.getName());
            }
            this.selectedTypeNames.clear();
            this.selectedAnns.clear();
            this.currentTabIndex = this.selectTiersTabPane.indexOfTab(this.BY_PART);
        } else {
            return;
        }
        this.updateTabAtIndex(this.currentTabIndex);
    }

    public void setSelectedMode(String selectionMode, List hiddenTiers) {
        if (selectionMode == null) {
            return;
        }
        this.currentTabIndex = selectionMode.equals(this.BY_ANN) ? this.selectTiersTabPane.indexOfTab(this.BY_ANN) : (selectionMode.equals(this.BY_TYPE) ? this.selectTiersTabPane.indexOfTab(this.BY_TYPE) : (selectionMode.equals(this.BY_PART) ? this.selectTiersTabPane.indexOfTab(this.BY_PART) : this.selectTiersTabPane.indexOfTab(this.BY_TIER)));
        this.selectTiersTabPane.setSelectedIndex(this.currentTabIndex);
        this.setHiddenTiers(hiddenTiers);
    }

    public String getSelectionMode() {
        if (this.selectedTypeNames.size() > 0) {
            return this.BY_TYPE;
        }
        if (this.selectedParts.size() > 0) {
            return this.BY_PART;
        }
        if (this.selectedAnns.size() > 0) {
            return this.BY_ANN;
        }
        return this.BY_TIER;
    }

    protected void moveDown() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = selected.length - 1; i >= 0; --i) {
            int row = selected[i];
            if (row >= this.model.getRowCount() - 1 || this.tierTable.isRowSelected(row + 1)) continue;
            this.model.moveRow(row, row, row + 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row + 1, 0, true, false);
        }
    }

    protected void moveUp() {
        if (this.tierTable == null || this.model == null || this.model.getRowCount() < 2) {
            return;
        }
        int[] selected = this.tierTable.getSelectedRows();
        for (int i = 0; i < selected.length; ++i) {
            int row = selected[i];
            if (row <= 0 || this.tierTable.isRowSelected(row - 1)) continue;
            this.model.moveRow(row, row, row - 1);
            this.tierTable.changeSelection(row, 0, true, false);
            this.tierTable.changeSelection(row - 1, 0, true, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.allButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.TRUE, i, 0);
                }
            }
        } else if (ae.getSource() == this.noneButton) {
            if (this.model != null) {
                for (int i = 0; i < this.tierTable.getRowCount(); ++i) {
                    this.model.setValueAt(Boolean.FALSE, i, 0);
                }
            }
        } else if (ae.getSource() == this.upButton) {
            this.moveUp();
        } else if (ae.getSource() == this.downButton) {
            this.moveDown();
        } else if (ae.getSource() == this.cancelButton) {
            this.setVisible(false);
            this.dispose();
        } else if (ae.getSource() == this.okButton) {
            this.updateChanges(this.currentTabIndex);
            this.returnedTiers = this.selectedTierNames;
            this.setVisible(false);
            this.dispose();
        } else {
            this.updateChanges(this.currentTabIndex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.model != null && lse.getValueIsAdjusting()) {
            int b = lse.getFirstIndex();
            int e = lse.getLastIndex();
            int col = this.model.findColumn("select");
            for (int i = b; i <= e; ++i) {
                if (!this.tierTable.isRowSelected(i)) continue;
                this.model.setValueAt(Boolean.TRUE, i, col);
            }
        }
    }

    private void showTiersTab() {
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Object value = this.model.getValueAt(i, nameCol);
            if (this.selectedTierNames.contains(value.toString())) {
                this.model.setValueAt(Boolean.TRUE, i, includeCol);
                continue;
            }
            this.model.setValueAt(Boolean.FALSE, i, includeCol);
        }
        if (this.model.getRowCount() > 1) {
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
        } else {
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
        }
    }

    private void showTypesTab() {
        int index = this.selectTiersTabPane.indexOfTab(this.BY_TYPE);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.selectedTypeNames.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private void showParticipantsTab() {
        int index = this.selectTiersTabPane.indexOfTab(this.BY_PART);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.selectedParts.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private void showAnnotatorsTab() {
        int index = this.selectTiersTabPane.indexOfTab(this.BY_ANN);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        Component[] boxes = checkboxPanel.getComponents();
        for (int i = 0; i < boxes.length; ++i) {
            if (!(boxes[i] instanceof JCheckBox)) continue;
            if (this.selectedAnns.contains(((JCheckBox)boxes[i]).getText())) {
                ((JCheckBox)boxes[i]).setSelected(true);
                continue;
            }
            ((JCheckBox)boxes[i]).setSelected(false);
        }
        this.upButton.setEnabled(false);
        this.downButton.setEnabled(false);
    }

    private void updateTiers() {
        int i;
        int includeCol = this.model.findColumn("select");
        int nameCol = this.model.findColumn("tier");
        Vector<String> oldselectedTierNames = new Vector<String>();
        oldselectedTierNames.addAll(this.selectedTierNames);
        this.selectedTierNames.clear();
        boolean valueChanged = false;
        for (i = 0; i < this.model.getRowCount(); ++i) {
            int x = this.model.getRowCount();
            Boolean t = (Boolean)this.model.getValueAt(i, includeCol);
            if (!((Boolean)this.model.getValueAt(i, includeCol)).booleanValue()) continue;
            String tierName = (String)this.model.getValueAt(i, nameCol);
            this.selectedTierNames.add(tierName);
            if (oldselectedTierNames.contains(tierName)) continue;
            if (this.hiddenTiers.contains(tierName)) {
                this.hiddenTiers.remove(tierName);
                if (valueChanged) continue;
                valueChanged = false;
                continue;
            }
            valueChanged = true;
        }
        if (valueChanged) {
            this.hiddenTiers.clear();
            this.selectedTypeNames.clear();
            this.selectedParts.clear();
            this.selectedAnns.clear();
        } else {
            for (i = 0; i < oldselectedTierNames.size(); ++i) {
                if (this.selectedTierNames.contains(oldselectedTierNames.get(i)) || this.hiddenTiers.contains(oldselectedTierNames.get(i))) continue;
                this.hiddenTiers.add((String)oldselectedTierNames.get(i));
            }
        }
    }

    private void updateLinguisticTypes() {
        int i;
        int index = this.selectTiersTabPane.indexOfTab(this.BY_TYPE);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedTypes = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            String typeName;
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedTypes.contains(typeName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedTypes.add(typeName);
        }
        if (selectedTypes.size() != this.selectedTypeNames.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedTypes.size(); ++i) {
                if (this.selectedTypeNames.contains(selectedTypes.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            int i2;
            if (this.selectedTypeNames.size() == 0) {
                this.hiddenTiers.clear();
            }
            this.selectedTypeNames = selectedTypes;
            this.selectedTierNames.clear();
            for (i2 = 0; i2 < this.selectedTypeNames.size(); ++i2) {
                String typeName = this.selectedTypeNames.get(i2);
                Vector visibleTiers = this.transcription.getTiersWithLinguisticType(typeName);
                if (visibleTiers == null) continue;
                for (int x = 0; x < visibleTiers.size(); ++x) {
                    this.selectedTierNames.add(((TierImpl)visibleTiers.get(x)).getName());
                }
            }
            for (i2 = 0; i2 < this.hiddenTiers.size(); ++i2) {
                if (!this.selectedTierNames.contains(this.hiddenTiers.get(i2))) continue;
                this.selectedTierNames.remove(this.hiddenTiers.get(i2));
            }
            this.selectedAnns.clear();
            this.selectedParts.clear();
        }
    }

    private void updateParticipants() {
        int i;
        int index = this.selectTiersTabPane.indexOfTab(this.BY_PART);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedPart = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            String partName;
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedPart.contains(partName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedPart.add(partName);
        }
        if (selectedPart.size() != this.selectedParts.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedPart.size(); ++i) {
                if (this.selectedParts.contains(selectedPart.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            if (this.selectedParts.size() == 0) {
                this.hiddenTiers.clear();
            }
            this.selectedTierNames.clear();
            this.selectedParts = selectedPart;
            for (i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String partName = tier.getParticipant();
                if (partName.length() == 0) {
                    partName = "not specified";
                }
                if (!this.selectedParts.contains(partName)) continue;
                this.selectedTierNames.add(tier.getName());
            }
            for (i = 0; i < this.hiddenTiers.size(); ++i) {
                if (!this.selectedTierNames.contains(this.hiddenTiers.get(i))) continue;
                this.selectedTierNames.remove(this.hiddenTiers.get(i));
            }
            this.selectedTypeNames.clear();
            this.selectedAnns.clear();
        }
    }

    private void updateAnnotators() {
        int i;
        int index = this.selectTiersTabPane.indexOfTab(this.BY_ANN);
        JPanel checkboxPanel = (JPanel)((JScrollPane)this.selectTiersTabPane.getComponentAt(index)).getViewport().getView();
        boolean changed = false;
        Vector<String> selectedAnn = new Vector<String>();
        Component[] boxes = checkboxPanel.getComponents();
        for (i = 0; i < boxes.length; ++i) {
            String annName;
            if (!(boxes[i] instanceof JCheckBox) || !((JCheckBox)boxes[i]).isSelected() || selectedAnn.contains(annName = ((JCheckBox)boxes[i]).getText())) continue;
            selectedAnn.add(annName);
        }
        if (selectedAnn.size() != this.selectedAnns.size()) {
            changed = true;
        } else {
            for (i = 0; i < selectedAnn.size(); ++i) {
                if (this.selectedAnns.contains(selectedAnn.get(i))) continue;
                changed = true;
                break;
            }
        }
        if (changed) {
            if (this.selectedAnns.size() == 0) {
                this.hiddenTiers.clear();
            }
            this.selectedAnns = selectedAnn;
            this.selectedTierNames.clear();
            for (i = 0; i < this.allTierNames.size(); ++i) {
                TierImpl tier = (TierImpl)this.transcription.getTierWithId(this.allTierNames.get(i));
                String annName = tier.getAnnotator();
                if (annName.length() == 0) {
                    annName = "not specified";
                }
                if (!this.selectedAnns.contains(annName)) continue;
                this.selectedTierNames.add(tier.getName());
            }
            for (i = 0; i < this.hiddenTiers.size(); ++i) {
                if (!this.selectedTierNames.contains(this.hiddenTiers.get(i))) continue;
                this.selectedTierNames.remove(this.hiddenTiers.get(i));
            }
            this.selectedTypeNames.clear();
            this.selectedParts.clear();
        }
    }

    private void updateChanges(int index) {
        String tabName = this.selectTiersTabPane.getTitleAt(index);
        if (tabName.equals(this.BY_TYPE)) {
            this.updateLinguisticTypes();
        } else if (tabName.equals(this.BY_TIER)) {
            this.updateTiers();
        } else if (tabName.equals(this.BY_PART)) {
            this.updateParticipants();
        } else if (tabName.equals(this.BY_ANN)) {
            this.updateAnnotators();
        }
    }

    private void updateTabAtIndex(int index) {
        String tabName = this.selectTiersTabPane.getTitleAt(index);
        if (tabName.equals(this.BY_TYPE)) {
            this.showTypesTab();
        } else if (tabName.equals(this.BY_TIER)) {
            this.showTiersTab();
        } else if (tabName.equals(this.BY_PART)) {
            this.showParticipantsTab();
        } else if (tabName.equals(this.BY_ANN)) {
            this.showAnnotatorsTab();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getSource() == this.selectTiersTabPane) {
            this.updateChanges(this.currentTabIndex);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getSource() == this.selectTiersTabPane) {
            this.currentTabIndex = this.selectTiersTabPane.getSelectedIndex();
            this.updateTabAtIndex(this.currentTabIndex);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

