/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import mpi.eudico.client.annotator.Constants;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.AbstractStatisticsPanel;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.util.TableHeaderToolTipAdapter;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.util.FloatStringComparator;
import mpi.eudico.util.IntStringComparator;

public class TierStatisticsPanel
extends AbstractStatisticsPanel
implements ClientLogger {
    private DecimalFormat format = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    private int numCols = 8;

    public TierStatisticsPanel(Transcription transcription) {
        super(transcription);
        this.initComponents();
    }

    public TierStatisticsPanel(Transcription transcription, long totalDuration) {
        super(transcription, totalDuration);
        ++this.numCols;
        this.initComponents();
    }

    @Override
    public JTable getStatisticsTable() {
        return this.statTable;
    }

    @Override
    void initComponents() {
        this.statPanel = new JPanel();
        this.statTable = new JTable();
        this.statTable.setBackground(Constants.DEFAULTBACKGROUNDCOLOR);
        this.statTable.setEnabled(false);
        this.initTable();
        this.statPane = new JScrollPane(this.statTable);
        Dimension size = new Dimension(500, 100);
        this.statPane.setPreferredSize(size);
        this.updateLocale();
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 6, 2, 6);
        this.statPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.statPanel.add((Component)this.statPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.statPanel, gridBagConstraints);
    }

    public void updateLocale() {
        this.statPanel.setBorder(new TitledBorder(ElanLocale.getString("Statistics.Pane.Table")));
    }

    private void initTable() {
        if (this.transcription != null) {
            TierImpl tier = null;
            Vector tierList = this.transcription.getTiers();
            int numRows = tierList.size();
            Object[][] data = new String[numRows][this.numCols];
            for (int i = 0; i < numRows; ++i) {
                tier = (TierImpl)tierList.get(i);
                data[i] = this.getRowForTier(tier);
            }
            Object[] headers = new String[this.numCols];
            headers[0] = ElanLocale.getString("Frame.GridFrame.ColumnTierName");
            headers[1] = ElanLocale.getString("Statistics.NumAnnotations");
            headers[2] = ElanLocale.getString("Statistics.MinimalDuration");
            headers[3] = ElanLocale.getString("Statistics.MaximalDuration");
            headers[4] = ElanLocale.getString("Statistics.AverageDuration");
            headers[5] = ElanLocale.getString("Statistics.MedianDuration");
            headers[6] = ElanLocale.getString("Statistics.TotalDuration");
            headers[7] = ElanLocale.getString("Statistics.Latency");
            if (this.numCols == 9) {
                headers[7] = ElanLocale.getString("Statistics.TotalDurationPercentage");
                headers[8] = ElanLocale.getString("Statistics.Latency");
            }
            DefaultTableModel model = new DefaultTableModel(data, headers);
            this.statTable.setModel(model);
            this.statTable.getTableHeader().addMouseMotionListener(new TableHeaderToolTipAdapter(this.statTable.getTableHeader()));
            TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>(model);
            IntStringComparator intComp = new IntStringComparator();
            rowSorter.setComparator(1, intComp);
            FloatStringComparator fsComp = new FloatStringComparator();
            for (int i = 2; i < this.numCols; ++i) {
                rowSorter.setComparator(i, fsComp);
            }
            this.statTable.setRowSorter(rowSorter);
        }
    }

    private String[] getRowForTier(TierImpl tier) {
        String[] row = new String[this.numCols];
        row[0] = tier.getName();
        Vector annotations = tier.getAnnotations();
        int numAnn = annotations.size();
        if (numAnn == 0) {
            for (int i = 1; i < this.numCols; ++i) {
                row[i] = "-";
            }
            return row;
        }
        AbstractAnnotation ann = null;
        long minDur = Long.MAX_VALUE;
        long maxDur = 0L;
        long totalDur = 0L;
        long medianDur = 0L;
        ArrayList<Long> durList = new ArrayList<Long>(numAnn);
        long firstOcc = Long.MAX_VALUE;
        for (int i = 0; i < numAnn; ++i) {
            ann = (AbstractAnnotation)annotations.get(i);
            long b = ann.getBeginTimeBoundary();
            long e = ann.getEndTimeBoundary();
            long d = e - b;
            durList.add(new Long(d));
            if (b < firstOcc) {
                firstOcc = b;
            }
            if (d < minDur) {
                minDur = d;
            }
            if (d > maxDur) {
                maxDur = d;
            }
            totalDur += d;
        }
        Collections.sort(durList);
        int numDurs = durList.size();
        if (numDurs == 1) {
            medianDur = (Long)durList.get(0);
        } else if (numDurs % 2 != 0) {
            medianDur = (Long)durList.get(numDurs / 2);
        } else {
            long h = (Long)durList.get(numDurs / 2);
            long l = (Long)durList.get(numDurs / 2 - 1);
            medianDur = (h + l) / 2L;
        }
        row[1] = String.valueOf(numAnn);
        row[2] = this.format2.format((float)minDur / 1000.0f);
        row[3] = this.format2.format((float)maxDur / 1000.0f);
        row[4] = this.format.format((float)totalDur / (float)numAnn / 1000.0f);
        row[5] = this.format2.format((float)medianDur / 1000.0f);
        row[6] = this.format2.format((float)totalDur / 1000.0f);
        row[7] = this.format2.format((float)firstOcc / 1000.0f);
        if (this.numCols == 9) {
            row[7] = this.totalDuration != 0L ? this.format2.format((float)totalDur / (float)this.totalDuration * 100.0f) : "-";
            row[8] = this.format2.format((float)firstOcc / 1000.0f);
        }
        return row;
    }
}

