/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.imports.praat;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.commands.ImportPraatGridCommand;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.imports.praat.PraatTextGrid;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class ImportPraatTGStep3
extends StepPane
implements ProgressListener {
    private TranscriptionImpl curTranscription;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private ImportPraatGridCommand com;
    private boolean inNewTranscription = false;

    public ImportPraatTGStep3(MultiStepPane multiPane, TranscriptionImpl curTranscription) {
        super(multiPane);
        this.curTranscription = curTranscription;
        this.initComponents();
    }

    public ImportPraatTGStep3(MultiStepPane multiPane, TranscriptionImpl curTranscription, boolean inNewTranscription) {
        super(multiPane);
        this.curTranscription = curTranscription;
        this.inNewTranscription = inNewTranscription;
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        Insets insets = new Insets(4, 6, 4, 6);
        this.progressLabel = new JLabel("...");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = insets;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)this.progressLabel, gbc);
        this.progressBar = new JProgressBar(0, 0, 100);
        this.progressBar.setIndeterminate(true);
        gbc.gridy = 1;
        this.add((Component)this.progressBar, gbc);
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("ImportDialog.Praat.Title3");
    }

    @Override
    public boolean doFinish() {
        this.multiPane.setButtonEnabled(8, false);
        String sourcePath = (String)this.multiPane.getStepProperty("Source");
        final String typeName = (String)this.multiPane.getStepProperty("Type");
        final Boolean includePT = (Boolean)this.multiPane.getStepProperty("PointTier");
        final Integer duration = (Integer)this.multiPane.getStepProperty("PointDuration");
        String tempEncoding = (String)this.multiPane.getStepProperty("Encoding");
        final Boolean skipEmpty = (Boolean)this.multiPane.getStepProperty("SkipEmpty");
        if (tempEncoding != null && tempEncoding.equals(ElanLocale.getString("Button.Default"))) {
            tempEncoding = null;
        }
        final String encoding = tempEncoding;
        if (sourcePath != null) {
            final File impFile = new File(sourcePath);
            if (impFile == null || !impFile.exists()) {
                this.progressInterrupted(null, "The TextGrid file does not exist");
            }
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            boolean ipt = false;
                            int dur = 40;
                            if (includePT != null) {
                                ipt = includePT;
                                if (duration != null) {
                                    dur = duration;
                                }
                            }
                            PraatTextGrid ptg = new PraatTextGrid(impFile, ipt, dur, encoding);
                            if (ImportPraatTGStep3.this.inNewTranscription) {
                                ImportPraatTGStep3.this.com = new ImportPraatGridCommand(ElanLocale.getString("Menu.File.Import.PraatTiers"));
                            } else {
                                ImportPraatTGStep3.this.com = (ImportPraatGridCommand)ELANCommandFactory.createCommand(ImportPraatTGStep3.this.curTranscription, "Menu.File.Import.PraatTiers");
                            }
                            ImportPraatTGStep3.this.com.addProgressListener(ImportPraatTGStep3.this);
                            ImportPraatTGStep3.this.progressBar.setIndeterminate(false);
                            ImportPraatTGStep3.this.progressBar.setValue(0);
                            ImportPraatTGStep3.this.com.execute(ImportPraatTGStep3.this.curTranscription, new Object[]{ptg, typeName, skipEmpty});
                        }
                        catch (IOException ioe) {
                            ImportPraatTGStep3.this.progressInterrupted(null, ioe.getMessage());
                        }
                    }
                }).start();
            }
            catch (Exception e) {
                this.progressInterrupted(null, e.getMessage());
            }
        } else {
            this.progressInterrupted(null, "No TextGrid file selected");
        }
        return false;
    }

    @Override
    public void enterStepForward() {
        this.doFinish();
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        if (this.progressLabel != null && message != null) {
            this.progressLabel.setText(message);
        }
        if (percent < 0) {
            percent = 0;
        } else if (percent > 100) {
            percent = 100;
        }
        this.progressBar.setValue(percent);
        if (percent >= 100) {
            if (this.com != null) {
                this.com.removeProgressListener(this);
            }
            this.showMessageDialog("Operation completed");
            this.multiPane.close();
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.showMessageDialog("Operation completed");
        this.multiPane.close();
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        if (this.progressLabel != null) {
            this.progressLabel.setText(message);
        }
        this.showWarningDialog("Operation interrupted: " + message);
        if (this.com != null) {
            this.com.removeProgressListener(this);
        }
        this.multiPane.close();
    }

    private void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this, message, ElanLocale.getString("Message.Warning"), 2);
    }

    private void showMessageDialog(String message) {
        JOptionPane.showMessageDialog(this, message, null, 1);
    }
}

