/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.interlinear;

import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;

public class InterlinearAnnotation {
    public static final int ROOT = 0;
    public static final int ASSOCIATION = 1;
    public static final int SUBDIVISION = 2;
    public static final int TIMECODE = 3;
    private String value;
    private String[] lines;
    private String tierName;
    public long bt;
    public long et;
    public int x;
    public int realWidth;
    public int calcWidth;
    public int colSpan = 1;
    public boolean hidden = false;
    public int nrOfLines = 1;
    public int type = 0;

    public InterlinearAnnotation(AbstractAnnotation aa) {
        if (aa != null) {
            this.value = aa.getValue().replace('\n', ' ').trim();
            this.bt = aa.getBeginTimeBoundary();
            this.et = aa.getEndTimeBoundary();
            TierImpl t = (TierImpl)aa.getTier();
            this.tierName = t.getName();
            if (t.hasParentTier()) {
                LinguisticType lt = t.getLinguisticType();
                this.type = lt != null && lt.getConstraints() != null ? (lt.getConstraints().getStereoType() == 4 ? 1 : 2) : 1;
            }
        }
    }

    public InterlinearAnnotation(String timecode, String tcTierName) {
        this.value = timecode;
        this.type = 3;
        this.tierName = tcTierName;
    }

    public InterlinearAnnotation(String tierName, int type) {
        this.value = "";
        this.type = type;
        this.tierName = tierName;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String[] getLines() {
        return this.lines;
    }

    public void setLines(String[] lines) {
        this.lines = lines;
        this.nrOfLines = lines != null ? lines.length : 1;
    }

    public String getTierName() {
        return this.tierName;
    }

    public void setTierName(String name) {
        this.tierName = name;
    }

    public String toString() {
        return this.value;
    }
}

