/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.lexicon;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.multistep.MultiStepPane;
import mpi.eudico.client.annotator.gui.multistep.StepPane;
import mpi.eudico.client.annotator.lexicon.LexiconClientFactoryLoader;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.server.corpora.clom.Transcription;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.lexicon.LexiconIdentification;
import mpi.eudico.server.corpora.lexicon.LexiconLink;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClient;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientException;
import mpi.eudico.server.corpora.lexicon.LexiconServiceClientFactory;

public class LexiconServiceStep1
extends StepPane
implements ActionListener,
ItemListener,
KeyListener {
    private LexiconLink oldLink;
    private JLabel nameLabel;
    private JTextField nameField;
    private JLabel questionLabel;
    private JComboBox lexiconTypeList;
    private JLabel urlLabel;
    private JLabel userNameLabel;
    private JLabel passWordLabel;
    private JTextField urlTextField;
    private JTextField userNameTextField;
    private JTextField passWordTextField;
    private JPanel fieldsPanel;
    private JLabel lexiconTypeLabel;
    private JLabel descriptionLabel;
    private JTextArea descriptionText;
    private JScrollPane descriptionTextScroller;
    private HashMap<String, LexiconServiceClientFactory> lexiconServiceClientFactories;
    private TranscriptionImpl transcription;
    private JButton defaultURLButton;

    public LexiconServiceStep1(MultiStepPane multiPane, LexiconLink link, Transcription tr) {
        super(multiPane);
        this.oldLink = link;
        this.transcription = (TranscriptionImpl)tr;
        if (!this.transcription.isLexcionServicesLoaded()) {
            try {
                new LexiconClientFactoryLoader().loadLexiconClientFactories(this.transcription);
            }
            catch (Exception exc) {
                ClientLogger.LOG.warning("Error while loading lexicon service clients: " + exc.getMessage());
            }
        }
        multiPane.putStepProperty("oldLink", link);
        this.lexiconServiceClientFactories = this.transcription.getLexiconServiceClientFactories();
        this.initComponents();
        this.postInit();
    }

    @Override
    protected void initComponents() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.fieldsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JLabel nameQuestionLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.EnterServiceName"));
        this.nameLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Name"));
        this.nameField = new JTextField();
        this.nameField.addKeyListener(this);
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        this.fieldsPanel.add((Component)nameQuestionLabel, c);
        c.insets = new Insets(5, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.fieldsPanel.add((Component)this.nameLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 1;
        this.fieldsPanel.add((Component)this.nameField, c);
        this.questionLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.EnterWorkspaceInfo"));
        this.lexiconTypeLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Type"));
        this.lexiconTypeList = this.lexiconServiceClientFactories != null ? new JComboBox<Object>(new ArrayList<String>(this.lexiconServiceClientFactories.keySet()).toArray()) : new JComboBox<String>(new String[0]);
        this.lexiconTypeList.addItemListener(this);
        this.descriptionLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Description"));
        this.descriptionText = new JTextArea();
        this.descriptionText.setEditable(false);
        this.descriptionText.setLineWrap(true);
        this.descriptionText.setWrapStyleWord(true);
        this.descriptionTextScroller = new JScrollPane(this.descriptionText);
        this.urlLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Url"));
        this.urlTextField = new JTextField();
        this.urlTextField.addKeyListener(this);
        this.defaultURLButton = new JButton(ElanLocale.getString("EditLexSrvcDialog.Button.DefaultUrl"));
        this.defaultURLButton.addActionListener(this);
        this.userNameLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Username"));
        this.userNameTextField = new JTextField();
        this.userNameTextField.addKeyListener(this);
        this.passWordLabel = new JLabel(ElanLocale.getString("EditLexSrvcDialog.Label.Password"));
        this.passWordTextField = new JPasswordField();
        this.passWordTextField.addKeyListener(this);
        if (this.oldLink != null && this.oldLink != null) {
            this.nameField.setText(this.oldLink.getName());
            this.urlTextField.setText(this.oldLink.getSrvcClient().getUrl());
            this.userNameTextField.setText(this.oldLink.getSrvcClient().getUsername());
            this.passWordTextField.setText(this.oldLink.getSrvcClient().getPassword());
        }
        c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(10, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        this.fieldsPanel.add((Component)this.questionLabel, c);
        c.insets = new Insets(5, 0, 0, 5);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        this.fieldsPanel.add((Component)this.lexiconTypeLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 3;
        this.fieldsPanel.add((Component)this.lexiconTypeList, c);
        c.insets = new Insets(5, 0, 0, 5);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 4;
        this.fieldsPanel.add((Component)this.descriptionLabel, c);
        c.fill = 1;
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.ipady = 40;
        c.gridx = 1;
        c.gridy = 4;
        this.fieldsPanel.add((Component)this.descriptionTextScroller, c);
        c.fill = 2;
        c.insets = new Insets(5, 0, 0, 5);
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.ipady = 0;
        c.gridx = 0;
        c.gridy = 5;
        this.fieldsPanel.add((Component)this.urlLabel, c);
        JPanel URLPanel = new JPanel(new GridBagLayout());
        GridBagConstraints urlc = new GridBagConstraints();
        urlc.fill = 2;
        urlc.weightx = 1.0;
        urlc.insets = new Insets(4, 0, 0, 6);
        URLPanel.add((Component)this.urlTextField, urlc);
        urlc.weightx = 0.0;
        urlc.gridx = 1;
        urlc.insets = new Insets(6, 0, 0, 0);
        URLPanel.add((Component)this.defaultURLButton, urlc);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 5;
        this.fieldsPanel.add((Component)URLPanel, c);
        c.insets = new Insets(5, 0, 0, 5);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 6;
        this.fieldsPanel.add((Component)this.userNameLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 6;
        this.fieldsPanel.add((Component)this.userNameTextField, c);
        c.insets = new Insets(5, 0, 0, 5);
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 7;
        this.fieldsPanel.add((Component)this.passWordLabel, c);
        c.insets = new Insets(5, 0, 0, 0);
        c.weightx = 0.5;
        c.gridx = 1;
        c.gridy = 7;
        this.fieldsPanel.add((Component)this.passWordTextField, c);
        this.setLayout(new GridBagLayout());
        c.anchor = 21;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.fieldsPanel, c);
    }

    private void postInit() {
        this.showDescription();
        this.setUrl();
        this.checkFields();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.urlTextField) {
            this.checkFields();
        } else if (ae.getSource() == this.defaultURLButton) {
            this.setUrl();
        } else if (ae.getSource() == this.userNameTextField) {
            this.checkFields();
        } else if (ae.getSource() == this.passWordTextField) {
            this.checkFields();
        }
    }

    private void checkFields() {
        if (!(this.urlTextField.getText().equals("") || this.userNameTextField.getText().equals("") || this.passWordTextField.getText().equals("") || this.nameField.getText().equals(""))) {
            this.multiPane.setButtonEnabled(1, true);
        } else {
            this.multiPane.setButtonEnabled(1, false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        this.showDescription();
        this.setUrl();
    }

    private void showDescription() {
        if (this.lexiconServiceClientFactories == null || this.lexiconServiceClientFactories.isEmpty()) {
            this.descriptionText.setText("");
        } else {
            this.descriptionText.setText(this.lexiconServiceClientFactories.get(this.lexiconTypeList.getSelectedItem()).getDescription());
        }
    }

    private void setUrl() {
        if (this.oldLink == null) {
            if (this.lexiconServiceClientFactories != null && this.lexiconServiceClientFactories.size() > 0) {
                this.urlTextField.setText(this.lexiconServiceClientFactories.get(this.lexiconTypeList.getSelectedItem()).getDefaultUrl());
            } else {
                this.urlTextField.setText("");
            }
        } else {
            this.urlTextField.setText(this.oldLink.getSrvcClient().getUrl());
        }
    }

    @Override
    public String getStepTitle() {
        return ElanLocale.getString("EditLexSrvcDialog.Title.Step1");
    }

    @Override
    public void enterStepForward() {
    }

    @Override
    public void enterStepBackward() {
        this.multiPane.setButtonEnabled(1, true);
        this.multiPane.setButtonEnabled(2, false);
    }

    @Override
    public boolean leaveStepForward() {
        Boolean nameExists = this.transcription.getLexiconLinks().containsKey(this.nameField.getText());
        if (this.oldLink == null && nameExists.booleanValue() || this.oldLink != null && nameExists.booleanValue() && !this.oldLink.getName().equals(this.nameField.getText())) {
            JOptionPane.showMessageDialog(this, ElanLocale.getString("EditLexSrvcDialog.Message.ServicenameExists"), ElanLocale.getString("Message.Warning"), 2);
            this.nameField.requestFocus();
        } else {
            try {
                LexiconServiceClient client = this.lexiconServiceClientFactories.get(this.lexiconTypeList.getSelectedItem()).createClient(this.urlTextField.getText(), this.userNameTextField.getText(), this.passWordTextField.getText());
                this.multiPane.putStepProperty("serviceClient", client);
                this.multiPane.putStepProperty("linkName", this.nameField.getText());
                ArrayList<LexiconIdentification> lexicaIds = client.getLexiconIdentifications();
                Collections.sort(lexicaIds);
                this.multiPane.putStepProperty("lexicaIds", lexicaIds);
                return true;
            }
            catch (LexiconServiceClientException ex) {
                String title = ElanLocale.getString("LexiconLink.Action.Error");
                String message = title + "\n" + ElanLocale.getString("LexiconServiceClientException.Cause") + " " + ex.getMessageLocale();
                JOptionPane.showMessageDialog(this, message, title, 0);
            }
        }
        return false;
    }

    @Override
    public boolean leaveStepBackward() {
        return true;
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent ae) {
        if (ae.getSource() == this.urlTextField) {
            this.checkFields();
        } else if (ae.getSource() == this.userNameTextField) {
            this.checkFields();
        } else if (ae.getSource() == this.passWordTextField) {
            this.checkFields();
        } else if (ae.getSource() == this.nameField) {
            this.checkFields();
        }
    }

    @Override
    public void keyTyped(KeyEvent ae) {
    }
}

