/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.linkedmedia;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JOptionPane;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.ViewerManager2;
import mpi.eudico.client.annotator.commands.ELANCommandFactory;
import mpi.eudico.client.annotator.player.CocoaQTMediaPlayer;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.EmptyMediaPlayer;
import mpi.eudico.client.annotator.player.JMFGraphicMediaPlayer;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.PlayerFactory;
import mpi.eudico.client.annotator.player.QTMediaPlayer;
import mpi.eudico.client.annotator.svg.SVGPrefs;
import mpi.eudico.client.annotator.util.FileExtension;
import mpi.eudico.client.annotator.util.FileUtility;
import mpi.eudico.client.annotator.util.SystemReporting;
import mpi.eudico.client.annotator.viewer.SignalViewer;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;

public class MediaDescriptorUtil {
    public static boolean checkLinkStatus(MediaDescriptor md) {
        if (md == null || md.mediaURL == null || md.mediaURL.length() < 5) {
            return false;
        }
        if (md.mediaURL.startsWith("rtsp")) {
            return true;
        }
        int colonPos = md.mediaURL.indexOf(58);
        String fileName = md.mediaURL.substring(colonPos + 1);
        File file = new File(fileName = fileName.replace('\\', '/'));
        return file.exists();
    }

    public static MediaDescriptor createMediaDescriptor(String filePath) {
        if (filePath == null || filePath.length() == 0) {
            return null;
        }
        String mediaURL = FileUtility.pathToURLString(filePath);
        if (mediaURL == null) {
            return null;
        }
        String mimeType = null;
        String mediaExtension = mediaURL.indexOf(46) > -1 ? mediaURL.substring(mediaURL.lastIndexOf(46) + 1) : mediaURL.substring(mediaURL.length() - 3);
        mimeType = MediaDescriptorUtil.mimeTypeForExtension(mediaExtension);
        MediaDescriptor md = new MediaDescriptor(mediaURL, mimeType);
        return md;
    }

    public static Vector createMediaDescriptors(Vector fileNames) {
        Vector<MediaDescriptor> mediaDescriptors = new Vector<MediaDescriptor>();
        if (fileNames == null) {
            return mediaDescriptors;
        }
        MediaDescriptor nextMD = null;
        block0: for (int i = 0; i < fileNames.size(); ++i) {
            String path = (String)fileNames.get(i);
            nextMD = MediaDescriptorUtil.createMediaDescriptor(path);
            if (nextMD == null) continue;
            for (int j = 0; j < mediaDescriptors.size(); ++j) {
                MediaDescriptor otherMD = (MediaDescriptor)mediaDescriptors.get(j);
                if (otherMD.mediaURL.equals(nextMD.mediaURL)) continue block0;
                if (nextMD.mimeType.equals("audio/x-wav") && MediaDescriptorUtil.isVideoType(otherMD) && FileUtility.sameNameIgnoreExtension(nextMD.mediaURL, otherMD.mediaURL)) {
                    nextMD.extractedFrom = otherMD.mediaURL;
                }
                if (!otherMD.mimeType.equals("audio/x-wav") || !MediaDescriptorUtil.isVideoType(nextMD) || !FileUtility.sameNameIgnoreExtension(nextMD.mediaURL, otherMD.mediaURL)) continue;
                otherMD.extractedFrom = nextMD.mediaURL;
            }
            mediaDescriptors.add(nextMD);
        }
        return mediaDescriptors;
    }

    public static String mimeTypeForExtension(String fileExtension) {
        int i;
        if (fileExtension == null || fileExtension.length() < 2) {
            return "unknown";
        }
        String lowExt = fileExtension.toLowerCase();
        for (i = 0; i < FileExtension.MPEG_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.MPEG_EXT[i])) continue;
            return "video/mpeg";
        }
        for (i = 0; i < FileExtension.MPEG4_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.MPEG4_EXT[i])) continue;
            return "video/mp4";
        }
        for (i = 0; i < FileExtension.WAV_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.WAV_EXT[i])) continue;
            return "audio/x-wav";
        }
        for (i = 0; i < FileExtension.QT_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.QT_EXT[i])) continue;
            return "video/quicktime";
        }
        for (i = 0; i < FileExtension.MISC_AUDIO_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.MISC_AUDIO_EXT[i])) continue;
            return "audio/*";
        }
        for (i = 0; i < FileExtension.MISC_VIDEO_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.MISC_VIDEO_EXT[i])) continue;
            return "video/*";
        }
        for (i = 0; i < FileExtension.IMAGE_MEDIA_EXT.length; ++i) {
            if (!lowExt.equals(FileExtension.IMAGE_MEDIA_EXT[i])) continue;
            if (lowExt.equals("jpg") || lowExt.equals("jpeg")) {
                return "image/jpeg";
            }
            return "image/" + lowExt;
        }
        return "unknown";
    }

    public static String[] extensionForMimeType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        if (mimeType.equals("video/mpeg")) {
            return FileExtension.MPEG_EXT;
        }
        if (mimeType.equals("video/mp4")) {
            return FileExtension.MPEG4_EXT;
        }
        if (mimeType.equals("audio/x-wav")) {
            return FileExtension.WAV_EXT;
        }
        if (mimeType.equals("video/quicktime")) {
            return FileExtension.QT_EXT;
        }
        if (mimeType.equals("image/jpeg") || mimeType.startsWith("image")) {
            return FileExtension.IMAGE_MEDIA_EXT;
        }
        return null;
    }

    public static boolean isVideoType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return mimeType.equals("video/*") || mimeType.equals("video/mpeg") || mimeType.equals("video/quicktime") || mimeType.equals("video/mp4");
    }

    public static boolean isVideoType(MediaDescriptor descriptor) {
        if (descriptor == null) {
            return false;
        }
        return MediaDescriptorUtil.isVideoType(descriptor.mimeType);
    }

    public static void updateMediaPlayers(TranscriptionImpl transcription, Vector descriptors) {
        MediaDescriptor md;
        int i;
        if (transcription == null || descriptors == null) {
            return;
        }
        long mediaTime = 0L;
        ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
        ElanLayoutManager layoutManager = ELANCommandFactory.getLayoutManager(transcription);
        SignalViewer signalViewer = layoutManager.getSignalViewer();
        if (viewerManager.getMasterMediaPlayer() != null && viewerManager.getMasterMediaPlayer().isPlaying()) {
            viewerManager.getMasterMediaPlayer().stop();
        }
        mediaTime = viewerManager.getMasterMediaPlayer().getMediaTime();
        if (layoutManager.getMode() == 0) {
            layoutManager.connectAllPlayers();
        }
        viewerManager.setMasterMediaPlayer(new EmptyMediaPlayer(Integer.MAX_VALUE));
        Vector slavePlayers = viewerManager.getSlaveMediaPlayers();
        Vector remPlayers = new Vector(slavePlayers.size());
        for (i = 0; i < slavePlayers.size(); ++i) {
            remPlayers.add(slavePlayers.get(i));
        }
        for (i = 0; i < remPlayers.size(); ++i) {
            ElanMediaPlayer slave = (ElanMediaPlayer)remPlayers.get(i);
            viewerManager.destroyMediaPlayer(slave);
            layoutManager.remove(slave);
        }
        if (signalViewer != null) {
            viewerManager.destroyViewer(signalViewer);
            layoutManager.remove(signalViewer);
        }
        if (System.getProperty("os.name").indexOf("Mac") > 0) {
            try {
                Thread.sleep(6000L);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        MediaDescriptorUtil.createMediaPlayers(transcription, descriptors);
        ArrayList<String> newAudioPaths = new ArrayList<String>(6);
        if (layoutManager.getSignalViewer() != null) {
            newAudioPaths.add(layoutManager.getSignalViewer().getMediaPath());
        }
        for (int i2 = 0; i2 < descriptors.size(); ++i2) {
            md = (MediaDescriptor)descriptors.get(i2);
            if (!md.mimeType.equals("audio/*") && !md.mimeType.equals("audio/x-wav") || newAudioPaths.contains(md.mediaURL)) continue;
            newAudioPaths.add(md.mediaURL);
        }
        if (viewerManager.getAudioRecognizerPanel() != null) {
            viewerManager.getAudioRecognizerPanel().setAudioFilePaths(newAudioPaths);
        }
        viewerManager.setAudioPaths(newAudioPaths);
        ArrayList<String> newVideoPaths = new ArrayList<String>(6);
        for (int i3 = 0; i3 < descriptors.size(); ++i3) {
            md = (MediaDescriptor)descriptors.get(i3);
            if (md.mimeType.equals("audio/*") || md.mimeType.equals("audio/x-wav") || newVideoPaths.contains(md.mediaURL)) continue;
            newVideoPaths.add(md.mediaURL);
        }
        if (viewerManager.getVideoRecognizerPanel() != null) {
            viewerManager.getVideoRecognizerPanel().setVideoFilePaths(newVideoPaths);
        }
        viewerManager.setVideoPaths(newVideoPaths);
        viewerManager.getMasterMediaPlayer().setMediaTime(mediaTime);
        transcription.setMediaDescriptors(descriptors);
        transcription.setChanged();
        layoutManager.doLayout();
    }

    public static void createMediaPlayers(TranscriptionImpl transcription, List descriptors) {
        if (transcription == null || descriptors == null) {
            return;
        }
        int numDesc = descriptors.size();
        try {
            SignalViewer newSignalViewer;
            ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
            ElanLayoutManager layoutManager = ELANCommandFactory.getLayoutManager(transcription);
            int nrOfPlayers = 0;
            int nrVisualPlayers = 0;
            String masterMediaURL = null;
            String signalSource = null;
            ElanMediaPlayer signalSourcePlayer = null;
            long signalOffset = 0L;
            long masterMediaOffset = 0L;
            boolean createSvgPlayer = false;
            if (transcription.getSVGFile() != null) {
                createSvgPlayer = true;
            }
            ArrayList<MediaDescriptor> failedPlayers = null;
            StringBuffer errors = new StringBuffer();
            for (int i = 0; i < numDesc; ++i) {
                MediaDescriptor curMD = (MediaDescriptor)descriptors.get(i);
                if (!MediaDescriptorUtil.checkLinkStatus(curMD)) continue;
                if (masterMediaURL != null && curMD.mimeType.equals("audio/x-wav") && masterMediaURL.equals(curMD.extractedFrom)) {
                    if (signalSourcePlayer != null) {
                        layoutManager.remove(signalSourcePlayer);
                        viewerManager.destroyMediaPlayer(signalSourcePlayer);
                    }
                    signalSource = curMD.mediaURL;
                    signalOffset = masterMediaOffset;
                    signalSourcePlayer = viewerManager.getMasterMediaPlayer();
                    viewerManager.setSignalSourcePlayer(viewerManager.getMasterMediaPlayer());
                    continue;
                }
                if (!curMD.mimeType.equals("audio/x-wav") && nrVisualPlayers == 4) continue;
                try {
                    ElanMediaPlayer player = null;
                    if (createSvgPlayer) {
                        String preferredMF = System.getProperty("PreferredMediaFramework");
                        if ("JMF".equals(preferredMF)) {
                            SVGPrefs.setUseSVG(true);
                            player = viewerManager.createMediaPlayer(curMD, "JMF");
                        } else {
                            player = viewerManager.createMediaPlayer(curMD, "QT");
                        }
                    } else if (curMD.mimeType.equals("video/quicktime")) {
                        player = SystemReporting.isMacOS() ? viewerManager.createMediaPlayer(curMD, "CocoaQT") : viewerManager.createMediaPlayer(curMD, "QT");
                    } else if (curMD.mimeType.equals("audio/x-wav")) {
                        if (signalSource == null) {
                            player = viewerManager.createMediaPlayer(curMD);
                        }
                    } else {
                        player = viewerManager.createMediaPlayer(curMD);
                    }
                    if (player == null) continue;
                    if (++nrOfPlayers == 1 && player != null) {
                        viewerManager.setMasterMediaPlayer(player);
                        masterMediaURL = curMD.mediaURL;
                        masterMediaOffset = curMD.timeOrigin;
                        if (curMD.mimeType.equals("audio/x-wav")) {
                            signalSource = curMD.mediaURL;
                            signalOffset = curMD.timeOrigin;
                            viewerManager.setSignalSourcePlayer(player);
                        }
                    } else if (curMD.mimeType.equals("audio/x-wav")) {
                        signalSource = curMD.mediaURL;
                        signalOffset = curMD.timeOrigin;
                        signalSourcePlayer = player;
                        viewerManager.setSignalSourcePlayer(player);
                    }
                    if (player.getVisualComponent() != null && !curMD.mimeType.equals("audio/x-wav")) {
                        ++nrVisualPlayers;
                    }
                    if (nrVisualPlayers > 4 && player.getVisualComponent() != null) continue;
                    layoutManager.add(player);
                    if (!(player instanceof CocoaQTMediaPlayer)) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    if (((CocoaQTMediaPlayer)player).isPlayerCreated()) continue;
                    errors.append("The Cocoa QT Player can not handle the file.\n");
                    player = PlayerFactory.createQTMediaPlayer(curMD);
                    continue;
                }
                catch (NoPlayerException npe) {
                    if (failedPlayers == null) {
                        failedPlayers = new ArrayList<MediaDescriptor>();
                    }
                    errors.append(npe.getMessage() + "\n");
                    failedPlayers.add(curMD);
                }
            }
            if (nrOfPlayers == 0) {
                if (viewerManager.getMasterMediaPlayer() instanceof EmptyMediaPlayer) {
                    ((EmptyMediaPlayer)viewerManager.getMasterMediaPlayer()).setMediaDuration(transcription.getLatestTime());
                } else {
                    viewerManager.setMasterMediaPlayer(new EmptyMediaPlayer(transcription.getLatestTime()));
                }
                layoutManager.add(viewerManager.getMasterMediaPlayer());
            }
            if (signalSource != null && (newSignalViewer = viewerManager.createSignalViewer(signalSource)) != null) {
                newSignalViewer.setOffset(signalOffset);
                newSignalViewer.preferencesChanged();
                layoutManager.add(newSignalViewer);
            }
            if (createSvgPlayer) {
                if (viewerManager.getMasterMediaPlayer() instanceof QTMediaPlayer) {
                    viewerManager.createQTSVGViewer();
                } else if (viewerManager.getMasterMediaPlayer() instanceof JMFGraphicMediaPlayer) {
                    viewerManager.createJMFSVGViewer();
                }
            }
            layoutManager.doLayout();
            if (failedPlayers != null && failedPlayers.size() > 0) {
                StringBuffer sb = new StringBuffer("No player could be created for:\n");
                for (int i = 0; i < failedPlayers.size(); ++i) {
                    sb.append("- " + ((MediaDescriptor)failedPlayers.get((int)i)).mediaURL + "\n");
                }
                sb.append(errors.toString());
                JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), sb.toString(), ElanLocale.getString("Message.Warning"), 2);
            }
        }
        catch (Exception rex) {
            rex.printStackTrace();
            JOptionPane.showMessageDialog(ELANCommandFactory.getRootFrame(transcription), "An error occurred while creating media players: " + rex.getMessage(), ElanLocale.getString("Message.Warning"), 2);
        }
    }

    public static ElanMediaPlayer createMediaPlayer(TranscriptionImpl transcription, MediaDescriptor curMD) {
        if (transcription == null || curMD == null) {
            return null;
        }
        if (!MediaDescriptorUtil.checkLinkStatus(curMD)) {
            return null;
        }
        ElanMediaPlayer player = null;
        boolean createSvgPlayer = false;
        try {
            ViewerManager2 viewerManager = ELANCommandFactory.getViewerManager(transcription);
            if (transcription.getSVGFile() != null) {
                createSvgPlayer = true;
            }
            player = createSvgPlayer ? viewerManager.createMediaPlayer(curMD, "QT") : (curMD.mimeType.equals("video/quicktime") && !SystemReporting.isMacOS() ? viewerManager.createMediaPlayer(curMD, "QT") : viewerManager.createMediaPlayer(curMD));
        }
        catch (NoPlayerException npe) {
            // empty catch block
        }
        return player;
    }
}

