/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.md.imdi.MDTable;
import mpi.eudico.client.annotator.md.spi.MDServiceProvider;
import mpi.eudico.client.annotator.md.spi.MDViewerComponent;

public class DefaultMDViewerComponent
extends JPanel
implements MDViewerComponent {
    protected MDServiceProvider provider;
    protected JTable mdTable;
    protected DefaultTableModel model;
    protected JScrollPane scrollPane;
    protected ResourceBundle bundle;
    protected String keyColumn = ElanLocale.getString("MetadataViewer.Key");
    protected String valColumn = ElanLocale.getString("MetadataViewer.Value");

    public DefaultMDViewerComponent() {
        this.initComponents();
    }

    public DefaultMDViewerComponent(MDServiceProvider provider) {
        this.setProvider(provider);
        this.initComponents();
    }

    protected void initComponents() {
        this.model = new DefaultTableModel(0, 2);
        this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
        this.mdTable = new JTable(this.model);
        this.scrollPane = new JScrollPane(this.mdTable);
        this.mdTable.setEnabled(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        this.add((Component)this.scrollPane, gbc);
    }

    @Override
    public void setProvider(MDServiceProvider provider) {
        this.provider = provider;
    }

    @Override
    public void setSelectedKeysAndValues(Map keysAndValuesMap) {
        if (keysAndValuesMap == null) {
            return;
        }
        if (this.model == null) {
            this.model = new DefaultTableModel(keysAndValuesMap.size(), 2);
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
        }
        int rowCount = this.model.getRowCount();
        for (int i = rowCount - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        for (Object key : keysAndValuesMap.keySet()) {
            Object val = keysAndValuesMap.get(key);
            this.model.addRow(new Object[]{key, val});
        }
        if (this.mdTable instanceof MDTable) {
            ((MDTable)this.mdTable).calculateRowHeights();
        }
    }

    @Override
    public void setResourceBundle(ResourceBundle bundle) {
        this.bundle = bundle;
        this.keyColumn = ElanLocale.getString("MetadataViewer.Key");
        this.valColumn = ElanLocale.getString("MetadataViewer.Value");
        if (this.model != null) {
            this.model.setColumnIdentifiers(new String[]{this.keyColumn, this.valColumn});
        }
    }
}

