/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.md.imdi;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import mpi.eudico.client.annotator.md.imdi.MDKVData;
import mpi.eudico.client.annotator.md.imdi.MDTree;

public class MDTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private final int MARGIN = 4;
    private final char NL = (char)10;
    private Font plainFont;
    private Font boldFont;
    private ImageIcon sessionIcon;
    private ImageIcon mediaIcon;
    private ImageIcon audioIcon;
    private ImageIcon videoIcon;
    private ImageIcon writtenIcon;
    private ImageIcon annIcon;
    private ImageIcon eafIcon;
    private JLabel keyLabel = new JLabel();
    private JTextArea valueArea;
    private Dimension preferredSize;
    private int expanderSize = 0;
    private final String HTML_B = "<html>";
    private final String HTML_E = "</html>";
    private final String B_B = "<b>";
    private final String B_E = "</b>";

    public MDTreeCellRenderer() {
        this.keyLabel.setOpaque(true);
        this.valueArea = new JTextArea();
        this.valueArea.setLineWrap(false);
        this.valueArea.setWrapStyleWord(false);
        this.valueArea.setOpaque(true);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.keyLabel, gbc);
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        this.add((Component)this.valueArea, gbc);
        this.preferredSize = new Dimension(500, 40);
        UIDefaults uid = UIManager.getDefaults();
        Enumeration enKey = uid.keys();
        while (enKey.hasMoreElements()) {
            Object obj = enKey.nextElement();
            if (!"Tree.expandedIcon".equals(obj)) continue;
            Icon expander = uid.getIcon(obj);
            if (expander != null) {
                this.expanderSize = expander.getIconWidth();
                break;
            }
            System.out.println("Tree: no expander icon: ");
            break;
        }
        try {
            this.sessionIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/session_color.png"));
        }
        catch (Throwable t) {
            this.sessionIcon = null;
        }
        try {
            this.mediaIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/mediafile.png"));
        }
        catch (Throwable t) {
            this.mediaIcon = null;
        }
        try {
            this.audioIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/audio.png"));
        }
        catch (Throwable t) {
            this.audioIcon = null;
        }
        try {
            this.videoIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/video.png"));
        }
        catch (Throwable t) {
            this.videoIcon = null;
        }
        try {
            this.writtenIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/writtenresource.png"));
        }
        catch (Throwable t) {
            this.writtenIcon = null;
        }
        try {
            this.annIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/annotation.png"));
        }
        catch (Throwable t) {
            this.annIcon = null;
        }
        try {
            this.eafIcon = new ImageIcon(this.getClass().getResource("/mpi/eudico/client/annotator/resources/ELAN16.png"));
        }
        catch (Throwable t) {
            this.eafIcon = null;
        }
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        int width = tree.getWidth();
        if (tree instanceof MDTree && ((MDTree)tree).getDisplayWidth() != 0) {
            width = ((MDTree)tree).getDisplayWidth() - 4;
        }
        if (width <= 0) {
            width = 600;
        }
        int rowIndent = 0;
        this.valueArea.setText("");
        if (!selected) {
            this.setBackground(tree.getBackground());
            this.keyLabel.setBackground(tree.getBackground());
            this.valueArea.setBackground(tree.getBackground());
        }
        if (this.plainFont != tree.getFont()) {
            this.setFont(tree.getFont());
        }
        if (value instanceof DefaultMutableTreeNode) {
            Object userObj = ((DefaultMutableTreeNode)value).getUserObject();
            int level = ((DefaultMutableTreeNode)value).getLevel();
            if (level > 0) {
                --level;
            }
            rowIndent = level * this.expanderSize;
            if (userObj instanceof MDKVData) {
                MDKVData mdkv = (MDKVData)userObj;
                String remains = this.setLabel(mdkv, width - rowIndent);
                if (remains != null) {
                    this.setText(remains, width - rowIndent);
                } else {
                    this.valueArea.setPreferredSize(new Dimension(0, 0));
                }
            } else if (userObj instanceof String) {
                this.keyLabel.setText((String)userObj);
                this.valueArea.setPreferredSize(new Dimension(0, 0));
            }
        }
        this.preferredSize = new Dimension(width - rowIndent + 4, this.keyLabel.getPreferredSize().height + this.valueArea.getPreferredSize().height);
        this.setPreferredSize(this.preferredSize);
        return this;
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.plainFont = font;
        if (font != null) {
            this.boldFont = font.deriveFont(1);
            if (this.keyLabel != null) {
                this.keyLabel.setFont(font);
            }
            if (this.valueArea != null) {
                this.valueArea.setFont(font);
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredSize);
    }

    private String setLabel(MDKVData mdkv, int availWidth) {
        if (this.sessionIcon != null && mdkv.key.endsWith("Session")) {
            this.keyLabel.setIcon(this.sessionIcon);
            availWidth -= this.sessionIcon.getIconWidth();
        } else if (this.mediaIcon != null && mdkv.key.endsWith("MediaFile")) {
            this.keyLabel.setIcon(this.mediaIcon);
            availWidth -= this.mediaIcon.getIconWidth();
        } else if (this.writtenIcon != null && mdkv.key.endsWith("WrittenResource")) {
            this.keyLabel.setIcon(this.writtenIcon);
            availWidth -= this.writtenIcon.getIconWidth();
        } else if (mdkv.key.equals("Type")) {
            if (mdkv.value != null) {
                String lower = mdkv.value.toLowerCase();
                if (lower.equals("video")) {
                    this.keyLabel.setIcon(this.videoIcon);
                } else if (lower.equals("audio")) {
                    this.keyLabel.setIcon(this.audioIcon);
                } else if (lower.equals("annotation")) {
                    this.keyLabel.setIcon(this.annIcon);
                } else {
                    this.keyLabel.setIcon(null);
                }
            } else {
                this.keyLabel.setIcon(null);
            }
        } else if (mdkv.key.equals("Format")) {
            if (mdkv.value != null && mdkv.value.equals("text/x-eaf+xml")) {
                this.keyLabel.setIcon(this.eafIcon);
            }
        } else {
            this.keyLabel.setIcon(null);
        }
        if (mdkv.value != null && mdkv.value.length() != 0) {
            String[] parts = this.splitValueText(mdkv, availWidth);
            this.keyLabel.setText(this.getHtmlString(mdkv.key, parts[0]));
            return parts[1];
        }
        this.keyLabel.setText(this.getHtmlString(mdkv.key, null));
        return null;
    }

    private void setText(MDKVData mdkv, int availWidth) {
        if (mdkv.value == null || mdkv.value.length() == 0) {
            this.valueArea.setText("");
            this.valueArea.setPreferredSize(new Dimension(0, 0));
            return;
        }
        this.setText(mdkv.value, availWidth);
    }

    private void setText(String value, int availWidth) {
        if (value == null || value.length() == 0) {
            this.valueArea.setText("");
            this.valueArea.setPreferredSize(new Dimension(0, 0));
            return;
        }
        FontMetrics fm = this.valueArea.getFontMetrics(this.plainFont);
        Graphics g = this.valueArea.getGraphics();
        StringBuilder builder = new StringBuilder(value);
        int beginIndex = 0;
        int endIndex = -1;
        int lastTestedEndIndex = 0;
        block0: for (int i = 0; i < builder.length(); ++i) {
            int k;
            int j;
            char[] seq;
            if (Character.isWhitespace(builder.charAt(i)) && ++endIndex > beginIndex) {
                seq = new char[endIndex - 1 - beginIndex];
                builder.getChars(beginIndex, endIndex - 1, seq, 0);
                if (fm.getStringBounds(seq, 0, seq.length, g).getWidth() > (double)availWidth) {
                    if (lastTestedEndIndex > beginIndex) {
                        this.valueArea.append(builder.substring(beginIndex, lastTestedEndIndex + 1) + '\n');
                        beginIndex = lastTestedEndIndex + 1;
                    } else {
                        j = seq.length - 1;
                        k = 1;
                        while (j > 0) {
                            if (fm.getStringBounds(seq, 0, seq.length - k, g).getWidth() < (double)availWidth) {
                                this.valueArea.append(new String(seq, 0, seq.length - k) + '\n');
                                lastTestedEndIndex = beginIndex = endIndex - k + 1;
                                break;
                            }
                            --j;
                            ++k;
                        }
                    }
                } else {
                    lastTestedEndIndex = endIndex;
                    if (builder.charAt(i) == '\n') {
                        this.valueArea.append(builder.substring(beginIndex, endIndex + 1));
                        beginIndex = endIndex + 1;
                    }
                }
            }
            if (i != builder.length() - 1 || endIndex <= beginIndex) continue;
            seq = new char[endIndex + 1 - beginIndex];
            builder.getChars(beginIndex, endIndex + 1, seq, 0);
            if (fm.getStringBounds(seq, 0, seq.length, g).getWidth() > (double)availWidth) {
                if (lastTestedEndIndex > beginIndex) {
                    this.valueArea.append(builder.substring(beginIndex, lastTestedEndIndex + 1) + '\n');
                    this.valueArea.append(builder.substring(lastTestedEndIndex + 1, endIndex + 1));
                    beginIndex = lastTestedEndIndex + 1;
                    continue;
                }
                j = seq.length - 1;
                k = 1;
                while (j > 0) {
                    if (fm.getStringBounds(seq, 0, seq.length - k, g).getWidth() <= (double)availWidth) {
                        this.valueArea.append(new String(seq, 0, seq.length - k) + '\n');
                        this.valueArea.append(new String(seq, seq.length - k, k));
                        continue block0;
                    }
                    --j;
                    ++k;
                }
                continue;
            }
            this.valueArea.append(builder.substring(beginIndex, endIndex + 1));
        }
        this.valueArea.setPreferredSize(new Dimension(availWidth + 4, this.valueArea.getLineCount() * fm.getHeight()));
    }

    private String[] splitValueText(MDKVData mdkv, int availWidth) {
        String[] parts = new String[2];
        FontMetrics boldMetrics = this.keyLabel.getFontMetrics(this.boldFont);
        int w = boldMetrics.stringWidth(mdkv.key + " ");
        if (w >= availWidth) {
            parts[0] = null;
            parts[1] = mdkv.value;
        } else {
            int valWidth = availWidth - w;
            FontMetrics pm = this.keyLabel.getFontMetrics(this.plainFont);
            StringBuilder builder = new StringBuilder(mdkv.value);
            int endIndex = -1;
            int lastTestedEndIndex = 0;
            for (int i = 0; i < builder.length(); ++i) {
                ++endIndex;
                if (Character.isWhitespace(builder.charAt(i))) {
                    char[] seq = new char[endIndex];
                    builder.getChars(0, endIndex, seq, 0);
                    if (pm.getStringBounds(seq, 0, seq.length, this.keyLabel.getGraphics()).getWidth() > (double)valWidth) {
                        if (lastTestedEndIndex == 0) {
                            parts[0] = null;
                            parts[1] = mdkv.value;
                        } else {
                            parts[0] = builder.substring(0, lastTestedEndIndex);
                            parts[1] = lastTestedEndIndex + 1 < builder.length() - 1 ? builder.substring(lastTestedEndIndex + 1) : null;
                        }
                        return parts;
                    }
                    lastTestedEndIndex = endIndex;
                    if (builder.charAt(i) == '\n') {
                        parts[0] = builder.substring(0, lastTestedEndIndex);
                        parts[1] = lastTestedEndIndex + 1 < builder.length() - 1 ? builder.substring(lastTestedEndIndex + 1) : null;
                        return parts;
                    }
                    if (endIndex != builder.length() - 1) continue;
                    parts[0] = mdkv.value;
                    parts[1] = null;
                    continue;
                }
                if (endIndex != builder.length() - 1) continue;
                if (pm.getStringBounds(mdkv.value, this.keyLabel.getGraphics()).getWidth() <= (double)valWidth) {
                    parts[0] = mdkv.value;
                    parts[1] = null;
                    continue;
                }
                if (lastTestedEndIndex > 0) {
                    parts[0] = builder.substring(0, lastTestedEndIndex);
                    if (lastTestedEndIndex + 1 < builder.length() - 1) {
                        parts[1] = builder.substring(lastTestedEndIndex + 1);
                        continue;
                    }
                    parts[1] = null;
                    continue;
                }
                parts[0] = null;
                parts[1] = mdkv.value;
            }
        }
        return parts;
    }

    private String getHtmlString(String key, String val) {
        if (key == null) {
            return null;
        }
        StringBuilder b = new StringBuilder("<html>");
        b.append("<b>");
        b.append(key);
        b.append("</b>");
        if (val != null) {
            b.append(" ");
            b.append(val);
        }
        b.append("</html>");
        return b.toString();
    }
}

