/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.scrub;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.gui.ClosableDialog;
import mpi.eudico.client.annotator.gui.ReportDialog;
import mpi.eudico.client.annotator.multiplefilesedit.scrub.TranscriptionScrubber;
import mpi.eudico.client.annotator.util.ProgressListener;
import mpi.eudico.server.corpora.util.ProcessReport;
import mpi.eudico.server.corpora.util.SimpleReport;

public class ScrubberConfigDialog
extends ClosableDialog
implements ActionListener,
ChangeListener,
ProgressListener {
    private JPanel optionsPanel;
    private JCheckBox newLineCB;
    private JCheckBox leadNewLineCB;
    private JCheckBox trailNewLineCB;
    private JCheckBox anyNewLineCB;
    private JCheckBox spaceCB;
    private JCheckBox leadSpacesCB;
    private JCheckBox trailSpacesCB;
    private JCheckBox multipleSpacesCB;
    private JCheckBox tabCB;
    private JCheckBox leadTabCB;
    private JCheckBox trailTabCB;
    private JCheckBox anyTabCB;
    private JPanel progressPanel;
    private JButton startStopButton;
    private JProgressBar bar;
    private JButton closeButton;
    private boolean isRunning = false;
    private List<File> files;
    private TranscriptionScrubber scrubber;

    public ScrubberConfigDialog(Frame owner, boolean modal, List<File> files) throws HeadlessException {
        super(owner, modal);
        this.files = files;
        this.initComponents();
        this.postInit();
    }

    private void postInit() {
        this.pack();
        this.setSize(this.getWidth() + 50, this.getHeight());
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        this.setTitle(ElanLocale.getString("MFE.Scrubber.Title"));
        this.getContentPane().setLayout(new GridBagLayout());
        Insets insets = new Insets(4, 6, 0, 6);
        Insets indent = new Insets(0, 26, 10, 6);
        Insets ins2 = new Insets(0, 6, 10, 0);
        this.optionsPanel = new JPanel(new GridBagLayout());
        this.optionsPanel.setBorder(new TitledBorder(ElanLocale.getString("TokenizeDialog.Label.Options")));
        JLabel infoLabel = new JLabel(ElanLocale.getString("MFE.Scrubber.Info"));
        this.newLineCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.NewLines"));
        this.newLineCB.setSelected(true);
        this.newLineCB.addChangeListener(this);
        this.leadNewLineCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Leading"));
        this.trailNewLineCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Trailing"));
        this.anyNewLineCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.All"));
        this.anyNewLineCB.setSelected(true);
        this.spaceCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Whitespaces"));
        this.spaceCB.setSelected(true);
        this.spaceCB.addChangeListener(this);
        this.leadSpacesCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Leading"));
        this.trailSpacesCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Trailing"));
        this.multipleSpacesCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Multiple"));
        this.multipleSpacesCB.setSelected(true);
        this.tabCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Tabs"));
        this.tabCB.addChangeListener(this);
        this.leadTabCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Leading"));
        this.leadTabCB.setEnabled(false);
        this.trailTabCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.Trailing"));
        this.trailTabCB.setEnabled(false);
        this.anyTabCB = new JCheckBox(ElanLocale.getString("MFE.Scrubber.All"));
        this.anyTabCB.setEnabled(false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 3;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(4, 6, 16, 6);
        this.optionsPanel.add((Component)infoLabel, gbc);
        gbc.insets = insets;
        gbc.gridy = 1;
        this.optionsPanel.add((Component)this.newLineCB, gbc);
        gbc.gridy = 3;
        this.optionsPanel.add((Component)this.tabCB, gbc);
        gbc.gridy = 5;
        this.optionsPanel.add((Component)this.spaceCB, gbc);
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridy = 2;
        gbc.insets = indent;
        gbc.gridwidth = 1;
        this.optionsPanel.add((Component)this.leadNewLineCB, gbc);
        gbc.gridx = 1;
        gbc.insets = ins2;
        this.optionsPanel.add((Component)this.trailNewLineCB, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.anyNewLineCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.insets = indent;
        this.optionsPanel.add((Component)this.leadTabCB, gbc);
        gbc.gridx = 1;
        gbc.insets = ins2;
        this.optionsPanel.add((Component)this.trailTabCB, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.anyTabCB, gbc);
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = indent;
        this.optionsPanel.add((Component)this.leadSpacesCB, gbc);
        gbc.gridx = 1;
        gbc.insets = ins2;
        this.optionsPanel.add((Component)this.trailSpacesCB, gbc);
        gbc.gridx = 2;
        this.optionsPanel.add((Component)this.multipleSpacesCB, gbc);
        this.progressPanel = new JPanel(new GridBagLayout());
        this.progressPanel.setBorder(new TitledBorder(ElanLocale.getString("MultipleFileSearch.FindReplace.Progress")));
        this.bar = new JProgressBar(0, 100);
        this.bar.setStringPainted(true);
        this.startStopButton = new JButton(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.startStopButton.addActionListener(this);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.progressPanel.add((Component)this.bar, gbc);
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        this.progressPanel.add((Component)this.startStopButton, gbc);
        this.closeButton = new JButton(ElanLocale.getString("Button.Close"));
        this.closeButton.addActionListener(this);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 1, 6, 2));
        buttonPanel.add(this.closeButton);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        this.getContentPane().add((Component)this.optionsPanel, gbc);
        gbc.gridy = 1;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.getContentPane().add((Component)this.progressPanel, gbc);
        gbc.anchor = 11;
        gbc.fill = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)buttonPanel, gbc);
    }

    private void reset() {
        this.bar.setValue(0);
        if (this.scrubber != null) {
            ProcessReport report = this.scrubber.getProcessReport();
            if (report != null) {
                ReportDialog dialog = new ReportDialog((Dialog)this, report);
                dialog.setVisible(true);
            }
            this.scrubber.removeProgressListener(this);
        }
        this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
        this.closeButton.setEnabled(true);
        this.isRunning = false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            if (!this.isRunning) {
                this.setVisible(false);
                this.dispose();
            }
        } else if (e.getSource() == this.startStopButton) {
            if (this.isRunning) {
                if (this.scrubber != null) {
                    this.scrubber.interrupt();
                } else {
                    this.startStopButton.setText(ElanLocale.getString("Recognizer.RecognizerPanel.Start"));
                    this.closeButton.setEnabled(true);
                    this.isRunning = false;
                }
            } else {
                this.closeButton.setEnabled(false);
                this.startStopButton.setText(ElanLocale.getString("Button.Cancel"));
                this.isRunning = true;
                this.scrubber = new TranscriptionScrubber();
                this.scrubber.addProgressListener(this);
                SimpleReport report = new SimpleReport();
                this.scrubber.setProcessReport(report);
                HashMap<Character, boolean[]> filters = new HashMap<Character, boolean[]>(3);
                boolean[] nlFlags = new boolean[3];
                if (this.newLineCB.isSelected()) {
                    nlFlags[0] = this.leadNewLineCB.isSelected();
                    nlFlags[1] = this.trailNewLineCB.isSelected();
                    nlFlags[2] = this.anyNewLineCB.isSelected();
                } else {
                    nlFlags[0] = false;
                    nlFlags[1] = false;
                    nlFlags[2] = false;
                }
                filters.put(Character.valueOf('\n'), nlFlags);
                boolean[] tabFlags = new boolean[3];
                if (this.tabCB.isSelected()) {
                    tabFlags[0] = this.leadTabCB.isSelected();
                    tabFlags[1] = this.trailTabCB.isSelected();
                    tabFlags[2] = this.anyTabCB.isSelected();
                } else {
                    tabFlags[0] = false;
                    tabFlags[1] = false;
                    tabFlags[2] = false;
                }
                filters.put(Character.valueOf('\t'), tabFlags);
                boolean[] wspFlags = new boolean[3];
                if (this.spaceCB.isSelected()) {
                    wspFlags[0] = this.leadSpacesCB.isSelected();
                    wspFlags[1] = this.trailSpacesCB.isSelected();
                    wspFlags[2] = this.multipleSpacesCB.isSelected();
                } else {
                    wspFlags[0] = false;
                    wspFlags[1] = false;
                    wspFlags[2] = false;
                }
                filters.put(Character.valueOf(' '), wspFlags);
                this.scrubber.scrubAndSave(this.files, filters);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.newLineCB) {
            this.leadNewLineCB.setEnabled(this.newLineCB.isSelected());
            this.trailNewLineCB.setEnabled(this.newLineCB.isSelected());
            this.anyNewLineCB.setEnabled(this.newLineCB.isSelected());
        } else if (e.getSource() == this.spaceCB) {
            this.leadSpacesCB.setEnabled(this.spaceCB.isSelected());
            this.trailSpacesCB.setEnabled(this.spaceCB.isSelected());
            this.multipleSpacesCB.setEnabled(this.spaceCB.isSelected());
        } else if (e.getSource() == this.tabCB) {
            this.leadTabCB.setEnabled(this.tabCB.isSelected());
            this.trailTabCB.setEnabled(this.tabCB.isSelected());
            this.anyTabCB.setEnabled(this.tabCB.isSelected());
        }
    }

    @Override
    public void progressCompleted(Object source, String message) {
        this.reset();
    }

    @Override
    public void progressInterrupted(Object source, String message) {
        this.reset();
    }

    @Override
    public void progressUpdated(Object source, int percent, String message) {
        this.bar.setValue(percent);
        if (message != null) {
            this.bar.setString(message);
        }
        if (percent >= 100) {
            this.progressCompleted(source, message);
        }
    }
}

