/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.multiplefilesedit.statistics;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;

public class StatisticsAnnotationsMF {
    public static final int NUM_ANN_COL = 9;
    private DecimalFormat format = new DecimalFormat("#0.######", new DecimalFormatSymbols(Locale.US));
    private DecimalFormat format2 = new DecimalFormat("#0.###", new DecimalFormatSymbols(Locale.US));
    public static final String EMPTY = "";
    private Map<String, AnStats> annotationStats;
    private String tierName;
    public int numAnnotations;
    public long minDur;
    public long maxDur;
    public long totalDur;
    public long latency;

    public StatisticsAnnotationsMF(TierImpl tier) {
        this.tierName = tier.getName();
        this.annotationStats = new HashMap<String, AnStats>();
        this.addTier(tier);
    }

    public String getTierName() {
        return this.tierName;
    }

    public void addTier(TierImpl tier) {
        if (tier != null) {
            if (this.tierName == null) {
                this.tierName = tier.getName();
            } else if (!this.tierName.equals(tier.getName())) {
                return;
            }
            this.numAnnotations += tier.getNumberOfAnnotations();
            this.extractAnnotations(tier);
        }
    }

    private void extractAnnotations(TierImpl tier) {
        if (tier == null) {
            return;
        }
        Vector annotations = tier.getAnnotations();
        if (annotations.size() == 0) {
            return;
        }
        if (annotations != null && annotations.size() > 0) {
            for (AbstractAnnotation ann : annotations) {
                AnStats stats;
                long bt = ann.getBeginTimeBoundary();
                long et = ann.getEndTimeBoundary();
                long dur = et - bt;
                if (ann.getValue() != null && ann.getValue().length() > 0) {
                    stats = this.annotationStats.get(ann.getValue());
                    if (stats == null) {
                        stats = new AnStats(ann.getValue());
                        this.annotationStats.put(ann.getValue(), stats);
                        stats.minDur = dur;
                        stats.maxDur = dur;
                        stats.latency = bt;
                    }
                } else {
                    stats = this.annotationStats.get(EMPTY);
                    if (stats == null) {
                        stats = new AnStats(EMPTY);
                        this.annotationStats.put(EMPTY, stats);
                        stats.minDur = dur;
                        stats.maxDur = dur;
                        stats.latency = bt;
                    }
                }
                ++stats.numOccur;
                stats.durations.add(dur);
                stats.totalDur += dur;
                if (dur < stats.minDur) {
                    stats.minDur = dur;
                }
                if (dur > stats.maxDur) {
                    stats.maxDur = dur;
                }
                if (bt >= stats.latency) continue;
                stats.latency = bt;
            }
        }
    }

    public List<String[]> getAnnotationStastitics() {
        if (this.annotationStats.size() == 0) {
            String[] row0 = new String[9];
            for (int i = 0; i < 9; ++i) {
                row0[i] = i == 0 ? this.tierName : "-";
            }
            ArrayList<String[]> asList = new ArrayList<String[]>(1);
            asList.add(row0);
            return asList;
        }
        ArrayList<String[]> asList = new ArrayList<String[]>(this.annotationStats.size());
        ArrayList<String> keyList = new ArrayList<String>(this.annotationStats.keySet());
        Collections.sort(keyList);
        Iterator keyIt = keyList.iterator();
        float mill = 1000.0f;
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            AnStats stats = this.annotationStats.get(key);
            String[] row = new String[9];
            block13: for (int i = 0; i < 9; ++i) {
                switch (i) {
                    case 0: {
                        row[i] = this.tierName;
                        continue block13;
                    }
                    case 1: {
                        row[i] = key;
                        continue block13;
                    }
                    case 2: {
                        row[i] = String.valueOf(stats.numOccur);
                        continue block13;
                    }
                    case 3: {
                        row[i] = this.format2.format((float)stats.minDur / mill);
                        continue block13;
                    }
                    case 4: {
                        row[i] = this.format2.format((float)stats.maxDur / mill);
                        continue block13;
                    }
                    case 5: {
                        float avg = (float)stats.totalDur / (float)stats.numOccur;
                        row[i] = this.format2.format(avg / mill);
                        continue block13;
                    }
                    case 6: {
                        float median = 0.0f;
                        int numDurs = stats.durations.size();
                        if (numDurs == 1) {
                            median = stats.durations.get(0).longValue();
                        } else {
                            Collections.sort(stats.durations);
                            if (numDurs % 2 != 0) {
                                median = stats.durations.get(numDurs / 2).longValue();
                            } else {
                                long h = stats.durations.get(numDurs / 2);
                                long l = stats.durations.get(numDurs / 2 - 1);
                                median = (h + l) / 2L;
                            }
                        }
                        row[i] = this.format2.format(median / mill);
                        continue block13;
                    }
                    case 7: {
                        row[i] = this.format2.format((float)stats.totalDur / mill);
                        continue block13;
                    }
                    case 8: {
                        row[i] = this.format2.format((float)stats.latency / mill);
                        continue block13;
                    }
                    default: {
                        row[i] = "-";
                    }
                }
            }
            asList.add(row);
        }
        return asList;
    }

    class AnStats {
        private String value;
        public List<Long> durations;
        public int numOccur;
        public long minDur;
        public long maxDur;
        public long totalDur;
        public long latency;

        public AnStats(String value) {
            this.value = value;
            this.durations = new ArrayList<Long>();
        }

        public String getValue() {
            return this.value;
        }
    }
}

