/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.client.annotator.player;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import mpi.eudico.client.annotator.ElanLayoutManager;
import mpi.eudico.client.annotator.ElanLocale;
import mpi.eudico.client.annotator.Preferences;
import mpi.eudico.client.annotator.export.ImageExporter;
import mpi.eudico.client.annotator.gui.FormattedMessageDlg;
import mpi.eudico.client.annotator.player.ElanMediaPlayer;
import mpi.eudico.client.annotator.player.MPEGVideoHeader;
import mpi.eudico.client.annotator.player.NoPlayerException;
import mpi.eudico.client.annotator.player.VideoFrameGrabber;
import mpi.eudico.client.annotator.util.ClientLogger;
import mpi.eudico.client.mediacontrol.Controller;
import mpi.eudico.client.mediacontrol.ControllerEvent;
import mpi.eudico.client.mediacontrol.ControllerListener;
import mpi.eudico.client.mediacontrol.ControllerManager;
import mpi.eudico.server.corpora.clomimpl.abstr.MediaDescriptor;
import mpi.eudico.util.TimeFormatter;
import player.JavaQTMoviePlayer;
import player.JavaQTMoviePlayerCreatedListener;
import player.NoCocoaPlayerException;

public class CocoaQTMediaPlayer
extends ControllerManager
implements ElanMediaPlayer,
ActionListener,
JavaQTMoviePlayerCreatedListener,
VideoFrameGrabber {
    private MediaDescriptor mediaDescriptor;
    private String filePath = null;
    private JavaQTMoviePlayer movie;
    private ElanLayoutManager layoutManager;
    private long offset = 0L;
    private boolean playerInited = false;
    private long curMediaTime = -1L;
    private float curRate = -1.0f;
    private float curVolume = -1.0f;
    private boolean isWavPlayer = false;
    private long stopTime = Long.MAX_VALUE;
    private float aspectRatio = -1.0f;
    private JPopupMenu popup;
    private boolean detached;
    private JMenuItem durationItem;
    private JMenuItem detachItem;
    private JMenuItem infoItem;
    private JMenuItem saveItem;
    private JMenuItem ratio_4_3_Item;
    private JMenuItem ratio_3_2_Item;
    private JMenuItem ratio_16_9_Item;
    private JMenuItem ratio_185_1_Item;
    private JMenuItem ratio_235_1_Item;
    private JMenuItem copyOrigTimeItem;
    private MouseHandler mouseHandler;
    private boolean frameStepsToFrameBegin = false;
    private long milliSecondsPerSample;
    private List<CocoaQTMediaPlayer> listeners;
    private JavaQTMoviePlayer master;
    private IntervalStopController intervalController;
    private EndController endController;
    private boolean firstInit = false;
    private int mpegImageWidth = 0;
    private int mpegImageHeight = 0;

    public CocoaQTMediaPlayer(MediaDescriptor mediaDescriptor) throws NoPlayerException {
        this.mediaDescriptor = mediaDescriptor;
        String cocoaComp = System.getProperty("com.apple.eawt.CocoaComponent.CompatibilityMode");
        if (cocoaComp == null) {
            System.setProperty("com.apple.eawt.CocoaComponent.CompatibilityMode", "false");
        }
        this.milliSecondsPerSample = 40L;
        this.offset = mediaDescriptor.timeOrigin;
        String URLString = mediaDescriptor.mediaURL;
        System.out.println("mediaURL = " + URLString);
        String fileString = URLString;
        if (URLString.startsWith("file:")) {
            fileString = URLString.substring(7);
            if ((URLString = URLString.toLowerCase()).endsWith("mpg") || URLString.endsWith("mpeg")) {
                MPEGVideoHeader mpegHeader = new MPEGVideoHeader(fileString);
                this.mpegImageWidth = mpegHeader.getWidth();
                this.mpegImageHeight = mpegHeader.getHeight();
            }
        }
        this.filePath = fileString;
        try {
            this.movie = new JavaQTMoviePlayer(this.filePath, 0L, 1.0f, 1.0f, (JavaQTMoviePlayerCreatedListener)this);
        }
        catch (UnsatisfiedLinkError ule) {
            System.out.println("library path: " + System.getProperty("java.library.path"));
            throw new NoPlayerException("Cocoa player could not be created: " + ule.getMessage());
        }
        catch (NoCocoaPlayerException ncpe) {
            throw new NoPlayerException(ncpe.getMessage());
        }
        catch (Throwable tr) {
            throw new NoPlayerException(tr.getMessage());
        }
        this.popup = new JPopupMenu();
        this.durationItem = new JMenuItem(ElanLocale.getString("Player.duration") + ":  ");
        this.durationItem.setEnabled(false);
        this.infoItem = new JMenuItem(ElanLocale.getString("Player.Info"));
        this.infoItem.addActionListener(this);
        this.saveItem = new JMenuItem(ElanLocale.getString("Player.SaveFrame"));
        this.saveItem.addActionListener(this);
        this.ratio_4_3_Item = new JMenuItem("4:3");
        this.ratio_4_3_Item.addActionListener(this);
        this.ratio_3_2_Item = new JMenuItem("3:2");
        this.ratio_3_2_Item.addActionListener(this);
        this.ratio_16_9_Item = new JMenuItem("16:9");
        this.ratio_16_9_Item.addActionListener(this);
        this.ratio_185_1_Item = new JMenuItem("1.85:1");
        this.ratio_185_1_Item.addActionListener(this);
        this.ratio_235_1_Item = new JMenuItem("2.35:1");
        this.ratio_235_1_Item.addActionListener(this);
        this.copyOrigTimeItem = new JMenuItem(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        this.copyOrigTimeItem.addActionListener(this);
        JMenu arMenu = new JMenu(ElanLocale.getString("Player.ForceAspectRatio"));
        arMenu.add(this.ratio_4_3_Item);
        arMenu.add(this.ratio_3_2_Item);
        arMenu.add(this.ratio_16_9_Item);
        arMenu.add(this.ratio_185_1_Item);
        arMenu.add(this.ratio_235_1_Item);
        this.popup.addSeparator();
        this.popup.add(this.saveItem);
        this.popup.add(this.infoItem);
        this.popup.add(arMenu);
        this.popup.add(this.durationItem);
        this.popup.add(this.copyOrigTimeItem);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.mouseHandler = new MouseHandler();
        this.movie.addMouseListener((MouseListener)this.mouseHandler);
        this.intervalController = new IntervalStopController();
        this.endController = new EndController(40L);
    }

    public boolean isPlayerCreated() {
        if (this.movie != null) {
            return this.movie.isMovieValid();
        }
        return false;
    }

    public void playerCreated(JavaQTMoviePlayer jqtPlayer) {
        if (jqtPlayer != this.movie) {
            ClientLogger.LOG.warning("Wrong player notified...!");
            return;
        }
        if (!this.movie.isMovieValid()) {
            ClientLogger.LOG.warning("Invalid movie: format not supported");
            return;
        }
        this.playerInited = true;
        if (this.offset != 0L) {
            this.movie.setOffset(this.offset);
        }
        if (this.curMediaTime > -1L) {
            this.setMediaTime(this.curMediaTime);
        } else {
            this.setMediaTime(0L);
        }
        if (this.curRate > -1.0f) {
            this.setRate(this.curRate);
        }
        if (this.master != null) {
            this.movie.setVolume(0.0f);
        } else if (this.curVolume > -1.0f) {
            this.movie.setVolume(this.curVolume);
        }
        if (!this.firstInit) {
            if (!this.movie.hasVideo()) {
                this.isWavPlayer = true;
            }
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            if (this.movie.getNaturalHeight() != 0.0f) {
                this.aspectRatio = this.movie.getNaturalWidth() / this.movie.getNaturalHeight();
            }
            if (!this.isWavPlayer) {
                this.milliSecondsPerSample = this.movie.getFrameDuration();
            }
            this.stopTime = this.getMediaDuration();
            this.endController.setEndTime(this.stopTime);
            this.addController(this.endController);
            this.firstInit = true;
            if (this.isWavPlayer) {
                this.aspectRatio = -1.0f;
            }
        } else {
            if (this.listeners != null) {
                for (CocoaQTMediaPlayer cpl : this.listeners) {
                    this.movie.addListener(cpl.getNativeMoviePlayer());
                    cpl.setMasterJavaQTMoviePlayer(this.movie);
                }
            }
            if (this.master != null) {
                this.master.addListener(this.movie);
            }
        }
    }

    @Override
    public void cleanUpOnClose() {
        if (this.movie != null) {
            if (this.isPlaying()) {
                this.stop();
            }
            this.movie.cleanUpOnClose();
        }
    }

    @Override
    public float getAspectRatio() {
        return this.aspectRatio;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    @Override
    public String getFrameworkDescription() {
        return "Cocoa QT Player";
    }

    public Dimension getMediaFileDimension() {
        if (this.mpegImageWidth > 0 && this.mpegImageHeight > 0) {
            return new Dimension(this.mpegImageWidth, this.mpegImageHeight);
        }
        return null;
    }

    @Override
    public MediaDescriptor getMediaDescriptor() {
        return this.mediaDescriptor;
    }

    @Override
    public long getMediaDuration() {
        if (this.movie != null) {
            return this.movie.getMediaDuration();
        }
        return 0L;
    }

    @Override
    public long getMediaTime() {
        if (!this.playerInited) {
            return 0L;
        }
        if (this.movie != null) {
            return this.movie.getMediaTime();
        }
        return 0L;
    }

    @Override
    public long getMilliSecondsPerSample() {
        if (this.playerInited && !this.isWavPlayer) {
            return this.movie.getFrameDuration();
        }
        return this.milliSecondsPerSample;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public float getRate() {
        if (!this.playerInited) {
            return 1.0f;
        }
        if (this.movie != null) {
            return this.movie.getRate();
        }
        return 1.0f;
    }

    @Override
    public int getSourceHeight() {
        if (this.isWavPlayer) {
            return 1;
        }
        if (!this.playerInited) {
            return 1;
        }
        if (this.movie != null) {
            return (int)this.movie.getNaturalHeight();
        }
        return 1;
    }

    @Override
    public int getSourceWidth() {
        if (this.isWavPlayer) {
            return 1;
        }
        if (!this.playerInited) {
            return 1;
        }
        if (this.movie != null) {
            return (int)this.movie.getNaturalWidth();
        }
        return 1;
    }

    @Override
    public Component getVisualComponent() {
        if (this.isWavPlayer) {
            return null;
        }
        if (this.movie != null) {
            return this.movie;
        }
        return null;
    }

    public synchronized Component createNewVisualComponent() {
        if (!this.firstInit && this.aspectRatio < 0.0f) {
            this.curMediaTime = this.movie.getMediaTime();
            this.curRate = this.movie.getRate();
            this.curVolume = this.movie.getVolume();
            this.movie.removeMouseListener((MouseListener)this.mouseHandler);
            if (this.listeners != null) {
                for (CocoaQTMediaPlayer cpl : this.listeners) {
                    this.movie.removeListener(cpl.getNativeMoviePlayer());
                    cpl.setMasterJavaQTMoviePlayer(null);
                }
            }
            if (this.master != null) {
                this.master.removeListener(this.movie);
            }
            this.movie.cleanUpOnClose();
            this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            this.detached = true;
        }
        try {
            this.movie = new JavaQTMoviePlayer(this.filePath, (JavaQTMoviePlayerCreatedListener)this);
        }
        catch (NoCocoaPlayerException npe) {
            ClientLogger.LOG.warning(npe.getMessage());
            return null;
        }
        this.movie.addMouseListener((MouseListener)this.mouseHandler);
        if (!this.firstInit && this.aspectRatio < 0.0f) {
            if (this.listeners != null) {
                for (CocoaQTMediaPlayer cpl : this.listeners) {
                    this.movie.addListener(cpl.getNativeMoviePlayer());
                    cpl.setMasterJavaQTMoviePlayer(this.movie);
                }
            }
            if (this.master != null) {
                this.master.addListener(this.movie);
            }
        }
        return this.movie;
    }

    @Override
    public float getVolume() {
        if (!this.playerInited) {
            return 1.0f;
        }
        if (this.movie != null) {
            return this.movie.getVolume();
        }
        return 1.0f;
    }

    @Override
    public boolean isFrameRateAutoDetected() {
        if (this.playerInited) {
            return this.movie.getFrameDuration() != 0L;
        }
        return false;
    }

    @Override
    public boolean isPlaying() {
        if (!this.playerInited) {
            return false;
        }
        if (this.movie != null) {
            return this.movie.isPlaying();
        }
        return false;
    }

    @Override
    public void nextFrame() {
        if (!this.playerInited || this.master != null) {
            return;
        }
        if (this.frameStepsToFrameBegin) {
            long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
            this.setMediaTime((curFrame + 1L) * this.milliSecondsPerSample);
        } else {
            this.setMediaTime(this.getMediaTime() + this.getMilliSecondsPerSample());
        }
    }

    @Override
    public void playInterval(long startTime, long stopTime) {
        if (!this.playerInited || this.master != null) {
            return;
        }
        if (this.movie != null && stopTime > startTime) {
            this.setMediaTime(startTime);
            this.setStopTime(stopTime);
            this.startControllers();
            this.intervalController.setStopTime(stopTime);
            this.intervalController.start();
            this.movie.playInterval(startTime, stopTime);
        }
    }

    @Override
    public void previousFrame() {
        if (!this.playerInited) {
            return;
        }
        if (this.movie != null) {
            if (this.frameStepsToFrameBegin) {
                long curFrame = this.getMediaTime() / this.milliSecondsPerSample;
                if (curFrame > 0L) {
                    this.setMediaTime((curFrame - 1L) * this.milliSecondsPerSample);
                } else {
                    this.setMediaTime(0L);
                }
            } else {
                this.setMediaTime(this.getMediaTime() - this.getMilliSecondsPerSample());
            }
        }
    }

    @Override
    public void setFrameStepsToFrameBegin(boolean stepsToFrameBegin) {
        this.frameStepsToFrameBegin = stepsToFrameBegin;
    }

    @Override
    public void setLayoutManager(ElanLayoutManager layoutManager) {
        if (!(this.layoutManager != null || this.playerInited && this.isWavPlayer)) {
            this.detachItem = new JMenuItem(ElanLocale.getString("Detachable.detach"));
            this.detachItem.addActionListener(this);
            this.popup.insert(this.detachItem, 0);
        }
        this.layoutManager = layoutManager;
        if (this.playerInited && this.isWavPlayer) {
            layoutManager.remove(this.movie);
        }
    }

    @Override
    public void setMediaTime(long time) {
        if (!this.playerInited) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        if (this.movie != null) {
            this.movie.setMediaTime(time);
            try {
                long et = System.currentTimeMillis() + 150L;
                while (this.movie.getMediaTime() != time && System.currentTimeMillis() < et) {
                    Thread.sleep(20L);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.setControllersMediaTime(time);
        }
    }

    @Override
    public void setMilliSecondsPerSample(long milliSeconds) {
        if (!this.isFrameRateAutoDetected()) {
            this.milliSecondsPerSample = milliSeconds;
        }
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
        this.mediaDescriptor.timeOrigin = offset;
        if (this.playerInited && this.movie != null) {
            this.movie.setOffset(offset);
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
            if (this.endController != null) {
                this.endController.setEndTime(this.getMediaDuration());
            }
        }
    }

    @Override
    public void setRate(float rate) {
        if (!this.playerInited) {
            return;
        }
        if (this.isPlaying()) {
            this.stop();
        }
        if (this.movie != null) {
            this.movie.setRate(rate);
        }
    }

    @Override
    public void setStopTime(long stopTime) {
        if (!this.playerInited) {
            return;
        }
        this.stopTime = stopTime;
    }

    @Override
    public void setVolume(float level) {
        if (!this.playerInited) {
            return;
        }
        if (this.movie != null) {
            if (this.master == null) {
                this.movie.setVolume(level);
            } else {
                this.movie.setVolume(0.0f);
            }
        }
    }

    @Override
    public void start() {
        if (!this.playerInited) {
            return;
        }
        if (this.getMediaDuration() - this.getMediaTime() < 40L) {
            this.setMediaTime(0L);
        }
        if (this.movie != null) {
            this.startControllers();
            this.movie.start();
        }
    }

    @Override
    public void stop() {
        if (!this.playerInited) {
            return;
        }
        if (this.movie != null) {
            this.movie.stop();
            this.stopControllers();
            this.setControllersMediaTime(this.getMediaTime());
        }
    }

    @Override
    public void updateLocale() {
        if (this.infoItem != null) {
            this.infoItem.setText(ElanLocale.getString("Player.Info"));
        }
        if (this.durationItem != null) {
            this.durationItem.setText(ElanLocale.getString("Player.duration") + ":  " + TimeFormatter.toString(this.getMediaDuration()));
        }
        if (this.saveItem != null) {
            this.saveItem.setText(ElanLocale.getString("Player.SaveFrame"));
        }
        if (this.detachItem != null) {
            if (this.detached) {
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
            } else {
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
            }
        }
        if (this.copyOrigTimeItem != null) {
            this.copyOrigTimeItem.setText(ElanLocale.getString("Player.CopyTimeIgnoringOffset"));
        }
    }

    private void copyToClipboard(String text) {
        if (text == null) {
            return;
        }
        if (System.getSecurityManager() != null) {
            try {
                System.getSecurityManager().checkSystemClipboardAccess();
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (SecurityException se) {
            }
            catch (IllegalStateException ise) {}
        } else {
            try {
                StringSelection ssVal = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ssVal, null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public Image getCurrentFrameImage() {
        return this.getFrameImageForTime(this.getMediaTime());
    }

    @Override
    public Image getFrameImageForTime(long time) {
        int w = 352;
        int h = 288;
        if (this.mpegImageWidth > 0 && this.mpegImageHeight > 0) {
            w = this.mpegImageWidth;
            h = this.mpegImageHeight;
        } else {
            w = (int)this.movie.getNaturalWidth();
            h = (int)this.movie.getNaturalHeight();
        }
        byte[] bytes = this.movie.getFrame(time, (int)this.movie.getNaturalWidth(), (int)this.movie.getNaturalHeight());
        try {
            MemoryCacheImageInputStream mci = new MemoryCacheImageInputStream(new ByteArrayInputStream(bytes, 0, bytes.length));
            BufferedImage bi = ImageIO.read(mci);
            return bi;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.detachItem) && this.layoutManager != null) {
            if (this.detached) {
                if (this.movie.isPlaying()) {
                    this.movie.stop();
                }
                this.curMediaTime = this.movie.getMediaTime();
                this.curRate = this.movie.getRate();
                this.curVolume = this.movie.getVolume();
                this.movie.removeMouseListener((MouseListener)this.mouseHandler);
                this.playerInited = false;
                if (this.listeners != null) {
                    for (CocoaQTMediaPlayer cpl : this.listeners) {
                        this.movie.removeListener(cpl.getNativeMoviePlayer());
                        cpl.setMasterJavaQTMoviePlayer(null);
                    }
                }
                if (this.master != null) {
                    this.master.removeListener(this.movie);
                }
                this.movie.cleanUpOnClose();
                this.layoutManager.attach(this.movie);
                this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                this.detached = false;
            } else {
                if (this.movie.isPlaying()) {
                    this.movie.stop();
                }
                this.curMediaTime = this.movie.getMediaTime();
                this.curRate = this.movie.getRate();
                this.curVolume = this.movie.getVolume();
                this.movie.removeMouseListener((MouseListener)this.mouseHandler);
                this.playerInited = false;
                if (this.listeners != null) {
                    for (CocoaQTMediaPlayer cpl : this.listeners) {
                        this.movie.removeListener(cpl.getNativeMoviePlayer());
                        cpl.setMasterJavaQTMoviePlayer(null);
                    }
                }
                if (this.master != null) {
                    this.master.removeListener(this.movie);
                }
                this.movie.cleanUpOnClose();
                this.layoutManager.detach(this.movie);
                this.detachItem.setText(ElanLocale.getString("Detachable.attach"));
                this.detached = true;
            }
        } else if (e.getSource() == this.infoItem) {
            new FormattedMessageDlg(this);
        } else if (e.getSource() == this.saveItem) {
            ImageExporter export = new ImageExporter(this.layoutManager.getElanFrame());
            export.exportImage(this.getCurrentFrameImage());
        } else if (e.getSource() == this.ratio_4_3_Item) {
            this.aspectRatio = 1.33f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_3_2_Item) {
            this.aspectRatio = 1.66f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_16_9_Item) {
            this.aspectRatio = 1.78f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_185_1_Item) {
            this.aspectRatio = 1.85f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.ratio_235_1_Item) {
            this.aspectRatio = 2.35f;
            this.layoutManager.doLayout();
            this.layoutManager.setPreference("AspectRatio(" + this.mediaDescriptor.mediaURL + ")", new Float(this.aspectRatio), this.layoutManager.getViewerManager().getTranscription());
        } else if (e.getSource() == this.copyOrigTimeItem) {
            long t = this.getMediaTime() + this.offset;
            Object val = Preferences.get("CurrentTime.Copy.TimeFormat", null);
            String timeFormat = null;
            String currentTime = null;
            currentTime = val instanceof String ? ((timeFormat = val.toString()).equals("hh:mm:ss.ms") ? TimeFormatter.toString(t) : (timeFormat.equals("ss.ms") ? TimeFormatter.toSSMSString(t) : (timeFormat.equals("NTSC") ? TimeFormatter.toTimecodeNTSC(t) : (timeFormat.equals("PAL") ? TimeFormatter.toTimecodePAL(t) : Long.toString(t))))) : Long.toString(t);
            this.copyToClipboard(currentTime);
        }
    }

    @Override
    public synchronized void addController(Controller controller) {
        if (controller instanceof CocoaQTMediaPlayer) {
            this.movie.addListener(((CocoaQTMediaPlayer)controller).getNativeMoviePlayer());
            if (this.listeners == null) {
                this.listeners = new ArrayList<CocoaQTMediaPlayer>(5);
            }
            this.listeners.add((CocoaQTMediaPlayer)controller);
            ((CocoaQTMediaPlayer)controller).setMasterJavaQTMoviePlayer(this.movie);
            this.master = null;
            return;
        }
        super.addController(controller);
    }

    void setMasterJavaQTMoviePlayer(JavaQTMoviePlayer master) {
        this.removeController(this.endController);
        this.movie.setVolume(0.0f);
        this.master = master;
    }

    @Override
    public synchronized void removeController(Controller controller) {
        if (controller instanceof CocoaQTMediaPlayer) {
            this.movie.removeListener(((CocoaQTMediaPlayer)controller).getNativeMoviePlayer());
            if (this.listeners != null) {
                this.listeners.remove((CocoaQTMediaPlayer)controller);
            }
            return;
        }
        super.removeController(controller);
    }

    public JavaQTMoviePlayer getNativeMoviePlayer() {
        return this.movie;
    }

    private class EndController
    extends IntervalStopController {
        long endTime;

        public EndController() {
            this.endTime = 0L;
        }

        public EndController(long period) {
            super(period);
            this.endTime = 0L;
        }

        @Override
        public void setStopTime(long time) {
        }

        public void setEndTime(long time) {
            this.endTime = time;
        }

        @Override
        public void run() {
            this.state = 0;
            while (this.state == 0) {
                if (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(this.period);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (CocoaQTMediaPlayer.this.getMediaTime() < this.endTime) continue;
                CocoaQTMediaPlayer.this.stopControllers();
                if (CocoaQTMediaPlayer.this.isPlaying()) {
                    this.stop();
                }
                this.state = 1;
                break;
            }
        }
    }

    private class IntervalStopController
    implements Controller,
    Runnable {
        final int STARTED = 0;
        final int STOPPED = 1;
        long period = 40L;
        Thread thread;
        volatile int state;
        long stopTime = 0L;

        public IntervalStopController() {
            this.state = 1;
        }

        public IntervalStopController(long period) {
            this.period = period;
            this.state = 1;
        }

        @Override
        public void start() {
            if (this.state == 0) {
                return;
            }
            this.state = 0;
            this.thread = new Thread((Runnable)this, "StopController");
            this.thread.start();
        }

        @Override
        public void addControllerListener(ControllerListener listener) {
        }

        @Override
        public int getNrOfConnectedListeners() {
            return 0;
        }

        @Override
        public void postEvent(ControllerEvent event) {
        }

        @Override
        public void removeControllerListener(ControllerListener listener) {
        }

        @Override
        public void setMediaTime(long time) {
        }

        @Override
        public void setRate(float rate) {
        }

        @Override
        public void setStopTime(long time) {
            this.stopTime = time;
        }

        @Override
        public void stop() {
            if (this.state == 1) {
                return;
            }
            this.state = 1;
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void run() {
            this.state = 0;
            long lastMediaTime = 0L;
            long curTime = 0L;
            int numRepeats = 0;
            while (this.state == 0) {
                if (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(this.period);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if ((curTime = CocoaQTMediaPlayer.this.getMediaTime()) >= this.stopTime) {
                    if (CocoaQTMediaPlayer.this.isPlaying()) {
                        CocoaQTMediaPlayer.this.stop();
                    } else {
                        CocoaQTMediaPlayer.this.stopControllers();
                    }
                    this.state = 1;
                    break;
                }
                if (curTime == lastMediaTime) {
                    if (++numRepeats <= 5) continue;
                    if (CocoaQTMediaPlayer.this.isPlaying()) {
                        CocoaQTMediaPlayer.this.stop();
                        if (this.state != 1 && this.stopTime - CocoaQTMediaPlayer.this.getMediaTime() <= 10L) {
                            CocoaQTMediaPlayer.this.setMediaTime(this.stopTime);
                        }
                    } else {
                        CocoaQTMediaPlayer.this.stopControllers();
                    }
                    this.state = 1;
                    break;
                }
                lastMediaTime = curTime;
                numRepeats = 0;
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter {
        private final DecimalFormat format = new DecimalFormat("#.###");

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                if (CocoaQTMediaPlayer.this.layoutManager != null && CocoaQTMediaPlayer.this.layoutManager.isAttached(CocoaQTMediaPlayer.this) && CocoaQTMediaPlayer.this.detached) {
                    CocoaQTMediaPlayer.this.detached = false;
                    CocoaQTMediaPlayer.this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                }
                CocoaQTMediaPlayer.this.popup.show(CocoaQTMediaPlayer.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                if (CocoaQTMediaPlayer.this.layoutManager != null) {
                    CocoaQTMediaPlayer.this.layoutManager.setFirstPlayer(CocoaQTMediaPlayer.this);
                }
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) || e.isPopupTrigger()) {
                JPopupMenu.setDefaultLightWeightPopupEnabled(false);
                if (CocoaQTMediaPlayer.this.layoutManager != null && CocoaQTMediaPlayer.this.layoutManager.isAttached(CocoaQTMediaPlayer.this) && CocoaQTMediaPlayer.this.detached) {
                    CocoaQTMediaPlayer.this.detached = false;
                    CocoaQTMediaPlayer.this.detachItem.setText(ElanLocale.getString("Detachable.detach"));
                }
                CocoaQTMediaPlayer.this.popup.show(CocoaQTMediaPlayer.this.getVisualComponent(), e.getPoint().x, e.getPoint().y);
                return;
            }
            try {
                if (e.isAltDown()) {
                    CocoaQTMediaPlayer.this.copyToClipboard(this.format.format((float)e.getX() / (float)CocoaQTMediaPlayer.this.movie.getWidth()) + "," + this.format.format((float)e.getY() / (float)CocoaQTMediaPlayer.this.movie.getHeight()));
                } else if (e.isShiftDown()) {
                    CocoaQTMediaPlayer.this.copyToClipboard("" + (int)((float)CocoaQTMediaPlayer.this.movie.getWidth() / (float)CocoaQTMediaPlayer.this.movie.getWidth() * (float)e.getX()) + "," + (int)((float)CocoaQTMediaPlayer.this.movie.getHeight() / (float)CocoaQTMediaPlayer.this.movie.getHeight() * (float)e.getY()));
                } else {
                    CocoaQTMediaPlayer.this.copyToClipboard("" + (int)((float)CocoaQTMediaPlayer.this.movie.getWidth() / (float)CocoaQTMediaPlayer.this.movie.getWidth() * (float)e.getX()) + "," + (int)((float)CocoaQTMediaPlayer.this.movie.getHeight() / (float)CocoaQTMediaPlayer.this.movie.getHeight() * (float)e.getY()) + " [" + CocoaQTMediaPlayer.this.movie.getWidth() + "," + CocoaQTMediaPlayer.this.movie.getHeight() + "]");
                }
            }
            catch (Exception exep) {
                exep.printStackTrace();
            }
        }
    }
}

